/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.ant;

import java.io.File;
import java.net.URL;
import oracle.ide.Ide;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFactory;
import oracle.jdeveloper.ant.AntBuildfile;
import oracle.jdeveloper.ant.AntGenerator;
import oracle.jdeveloper.deploy.dt.DeploymentOptions;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class OJDeployTaskGenerator
implements AntGenerator {
    static final String OJDEPLOY_TASK_NAMESPACE = "oraclelib:OJDeployAntTask";
    static final String PARAM_WORKSPACE_PATH = "oracle.jdeveloper.workspace.path";
    static final String PARAM_PROJECT_NAME = "oracle.jdeveloper.project.name";
    static final String PARAM_PROFILE_NAME = "oracle.jdeveloper.deploy.profile.name";
    static final String PARAM_OUTPUT_FILE = "oracle.jdeveloper.deploy.outputfile";
    static final String PARAM_ANT_CLASSPATH = "oracle.jdeveloper.ant.library";
    static final String PARAM_OJDEPLOY_PATH = "oracle.jdeveloper.ojdeploy.path";
    static final String PARAM_OJDEPLOY_BUILDSCRIPT = "oracle.jdeveloper.ojdeploy.buildscript";
    static final String PARAM_DEPLOYDIR = "oracle.jdeveloper.deploy.dir";
    static final String ANT_LIBRARY = "/lib/ant-jdeveloper.jar";
    static final String OJDEPLOY = "/bin/ojdeploy";
    static final String BUILDSCRIPT = "ojdeploy-build.xml";
    static final String STATUSLOG = "ojdeploy-statuslog.xml";
    static final String OJDEPLOY_ANT_TASK_CLASS = "oracle.jdeveloper.deploy.ant.OJDeployAntTask";

    /*
     * Unable to fully structure code
     */
    public void generate(Project project, AntBuildfile buildfile) {
        deployTarget = buildfile.getTarget("deploy");
        if (deployTarget != null) ** GOTO lbl6
        return;
lbl-1000:
        // 1 sources

        {
            deployTarget.removeChild(node);
lbl6:
            // 2 sources

            ** while ((node = deployTarget.getFirstChild()) != null)
        }
lbl7:
        // 1 sources

        buildfile.addGlobalProperty("oracle.jdeveloper.deploy.dir", this.urlToPath(this.getDeployDirURL(project)));
        buildfile.addGlobalProperty("oracle.jdeveloper.ojdeploy.path", this.getOJDeployPath());
        buildfile.addGlobalProperty("oracle.jdeveloper.ant.library", Ide.getProductHomeDirectory() + "/lib/ant-jdeveloper.jar");
        document = buildfile.getDocument();
        taskDef = document.createElementNS(null, "taskdef");
        taskDef.setAttributeNS(null, "name", "ojdeploy");
        taskDef.setAttributeNS(null, "classname", "oracle.jdeveloper.deploy.ant.OJDeployAntTask");
        taskDef.setAttributeNS(null, "uri", "oraclelib:OJDeployAntTask");
        taskDef.setAttributeNS(null, "classpath", buildfile.createPropertyReference("oracle.jdeveloper.ant.library"));
        deployTarget.appendChild(taskDef);
        ojDeployElem = document.createElementNS("oraclelib:OJDeployAntTask", "ora:ojdeploy");
        ojDeployElem.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:ora", "oraclelib:OJDeployAntTask");
        ojDeployElem.setAttributeNS(null, "executable", buildfile.createPropertyReference("oracle.jdeveloper.ojdeploy.path"));
        ojDeployElem.setAttributeNS("oraclelib:OJDeployAntTask", "ora:buildscript", buildfile.createPropertyReference("oracle.jdeveloper.deploy.dir") + "ojdeploy-build.xml");
        ojDeployElem.setAttributeNS("oraclelib:OJDeployAntTask", "ora:statuslog", buildfile.createPropertyReference("oracle.jdeveloper.deploy.dir") + "ojdeploy-statuslog.xml");
        deployTarget.appendChild(ojDeployElem);
        deployElem = document.createElementNS("oraclelib:OJDeployAntTask", "ora:deploy");
        ojDeployElem.appendChild(deployElem);
        buildfile.addGlobalProperty("oracle.jdeveloper.workspace.path", this.getWorkspacePath());
        deployElem.appendChild(this.newParameter(document, "workspace", buildfile.createPropertyReference("oracle.jdeveloper.workspace.path")));
        buildfile.addGlobalProperty("oracle.jdeveloper.project.name", this.getProjectName(project));
        deployElem.appendChild(this.newParameter(document, "project", buildfile.createPropertyReference("oracle.jdeveloper.project.name")));
        buildfile.addGlobalProperty("oracle.jdeveloper.deploy.profile.name", "*");
        deployElem.appendChild(this.newParameter(document, "profile", buildfile.createPropertyReference("oracle.jdeveloper.deploy.profile.name")));
        val = false;
        compileTarget = buildfile.getTarget("compile");
        if (compileTarget != null) {
            buildfile.addDependency("deploy", "compile");
            val = true;
        }
        deployElem.appendChild(this.newParameter(document, "nocompile", Boolean.toString(val)));
        buildfile.addGlobalProperty("oracle.jdeveloper.deploy.outputfile", this.getOutputFile(project));
        deployElem.appendChild(this.newParameter(document, "outputfile", buildfile.createPropertyReference("oracle.jdeveloper.deploy.outputfile")));
    }

    private Element newParameter(Document document, String name, String value) {
        Element parameterElem = document.createElementNS(OJDEPLOY_TASK_NAMESPACE, "ora:parameter");
        parameterElem.setAttributeNS(OJDEPLOY_TASK_NAMESPACE, "name", name);
        parameterElem.setAttributeNS(OJDEPLOY_TASK_NAMESPACE, "value", value);
        return parameterElem;
    }

    private String getProjectName(Project project) {
        return project.getShortLabel().split("\\.")[0];
    }

    private URL getDeployDirURL(Project project) {
        DeploymentOptions options = (DeploymentOptions)((Object)Ide.getSettings().getData("deployment-options"));
        URL deployOutputURL = null;
        if (options != null) {
            deployOutputURL = options.getDeployOutputURL();
        }
        if (deployOutputURL == null) {
            deployOutputURL = URLFactory.newDirURL((URL)project.getURL(), (String)"../deploy");
        }
        return deployOutputURL;
    }

    private String getOutputFile(Project project) {
        return this.urlToPath(this.getDeployDirURL(project)) + "${profile.name}";
    }

    private String getWorkspacePath() {
        Workspace workspace = Ide.getActiveWorkspace();
        if (workspace == null) {
            return "<path to the JDeveloper Workspace (.jws)>";
        }
        return this.urlToPath(workspace.getURL());
    }

    private String urlToPath(URL url) {
        File f = new File(url.getPath());
        return f.getPath();
    }

    private String getOJDeployPath() {
        String productHome = Ide.getProductHomeDirectory();
        String osName = System.getProperty("os.name").toUpperCase();
        String relPath = osName.startsWith("WINDOWS") ? "/bin/ojdeploy.exe" : OJDEPLOY;
        File f = new File(productHome + relPath);
        return f.getPath();
    }
}

