/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.common;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.text.Document;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.help.HelpUtils;
import oracle.ide.controls.GridBagConstants;
import oracle.ide.controls.tree.CustomJTree;
import oracle.ide.controls.tree.JMutableTreeNode;
import oracle.ide.controls.tree.JTreeCellData;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.net.PackageClassChooser;
import oracle.ide.net.URLPath;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.Assert;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.Namespace;
import oracle.ide.util.ResourceUtils;
import oracle.jdeveloper.deploy.common.CdaFilter;
import oracle.jdeveloper.deploy.common.CdaFilters;
import oracle.jdeveloper.deploy.common.CdaSettings;
import oracle.jdeveloper.deploy.common.ProjectFileGroup;
import oracle.jdevimpl.deploy.common.CommonEditor;
import oracle.jdevimpl.deploy.common.FileGroupsEditor;
import oracle.jdevimpl.deploy.res.CommonArb;

public class CdaFiltersPanel
extends DefaultTraversablePanel
implements GridBagConstants,
ActionListener,
TreeSelectionListener,
TreeWillExpandListener,
ItemListener,
DocumentListener {
    private FilterPanel filterPanel;
    private JButton btnAdd;
    private JScrollPane jScrollPane1;
    private JButton btnRemove;
    private WhenNode beforeNode;
    private WhenNode duringNode;
    private WhenNode afterNode;
    private NoneNode beforeNoneNode;
    private NoneNode duringNoneNode;
    private NoneNode afterNoneNode;
    private final JMutableTreeNode _rootNode;
    private final DefaultTreeModel _treeModel;
    private final DefaultTreeSelectionModel _selModel;
    private final CustomJTree _tree;
    private int _curWhen;
    private FilterNode _curNode;
    private transient URLPath _classPath;
    private static final int BEFORE_CDA = 0;
    private static final int DURING_CDA = 1;
    private static final int AFTER_CDA = 2;

    private void $init$() {
        this.filterPanel = new FilterPanel();
        this.btnAdd = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.btnRemove = new JButton();
        this.beforeNode = new WhenNode(CommonArb.getString(71));
        this.duringNode = new WhenNode(CommonArb.getString(106), 10);
        this.afterNode = new WhenNode(CommonArb.getString(131), 10);
        this.beforeNoneNode = new NoneNode();
        this.duringNoneNode = new NoneNode();
        this.afterNoneNode = new NoneNode();
        this._rootNode = new JMutableTreeNode();
    }

    public CdaFiltersPanel() {
        this.$init$();
        this._rootNode.add((MutableTreeNode)((Object)this.beforeNode));
        this._rootNode.add((MutableTreeNode)((Object)this.duringNode));
        this._rootNode.add((MutableTreeNode)((Object)this.afterNode));
        this._treeModel = new DefaultTreeModel((TreeNode)this._rootNode);
        this._tree = new CustomJTree((TreeModel)this._treeModel, false);
        this._selModel = new DefaultTreeSelectionModel();
        this._selModel.setSelectionMode(1);
        this._tree.setSelectionModel((TreeSelectionModel)this._selModel);
        this._tree.setRootVisible(false);
        this._tree.setShowsRootHandles(false);
        this._tree.addTreeSelectionListener((TreeSelectionListener)this);
        this._tree.addTreeWillExpandListener((TreeWillExpandListener)this);
        this._tree.setRowHeight(0);
        Document doc = this.filterPanel.tfName.getDocument();
        doc.addDocumentListener(this);
        JLabel lblFilters = new JLabel();
        ResourceUtils.resLabel((JLabel)lblFilters, (Component)this._tree, (String)CommonArb.getString(44));
        this.filterPanel.setBorder(BorderFactory.createTitledBorder(CommonArb.getString(36)));
        this.filterPanel.cbType.addItemListener(this);
        ResourceUtils.resButton((AbstractButton)this.btnAdd, (String)CommonArb.getString(86));
        this.btnAdd.addActionListener(this);
        ResourceUtils.resButton((AbstractButton)this.btnRemove, (String)CommonArb.getString(101));
        this.btnRemove.addActionListener(this);
        Dimension dimAdd = this.btnAdd.getPreferredSize();
        Dimension dimRemove = this.btnRemove.getPreferredSize();
        if (dimRemove.width > dimAdd.width) {
            this.btnAdd.setPreferredSize(dimRemove);
        } else {
            this.btnRemove.setPreferredSize(dimAdd);
        }
        this.jScrollPane1.getViewport().add((Component)this._tree, null);
        Insets in5555 = new Insets(5, 5, 5, 5);
        this.setLayout(new GridBagLayout());
        this.add(lblFilters, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.add(this.jScrollPane1, new GridBagConstraints(0, 1, 1, 2, 1.0, 1.0, 18, 1, in5555, 0, 0));
        this.add(this.btnAdd, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 18, 2, in5555, 0, 0));
        this.add(this.btnRemove, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 18, 2, in5555, 0, 0));
        this.add(this.filterPanel, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 17, 2, in5555, 0, 0));
        this.setHelpID("f1_depfgdafilter_html");
    }

    public void onEntry(TraversableContext tc) {
        this._classPath = CommonEditor.getClassPath((Namespace)tc);
        this.filterPanel.setClassPath(this._classPath);
        CdaSettings cdas = CdaFiltersPanel.findCdaSettings(tc);
        CdaFilters beforeFilters = cdas.getBeforeFilters();
        this.loadImpl(this.beforeNode, beforeFilters, this.beforeNoneNode);
        CdaFilters duringFilters = cdas.getDuringFilters();
        this.loadImpl(this.duringNode, duringFilters, this.duringNoneNode);
        CdaFilters afterFilters = cdas.getAfterFilters();
        this.loadImpl(this.afterNode, afterFilters, this.afterNoneNode);
        IdeUtil.expandAllTreeRows((JTree)this._tree);
        this.update(this._tree.getLeadSelectionPath());
    }

    public void onExit(TraversableContext tc) {
        CdaSettings cdas = CdaFiltersPanel.findCdaSettings(tc);
        CdaFilters beforeFilters = cdas.getBeforeFilters();
        cdas.setBeforeFilters(CdaFiltersPanel.commitImpl(this.beforeNode, beforeFilters));
        CdaFilters duringFilters = cdas.getDuringFilters();
        cdas.setDuringFilters(CdaFiltersPanel.commitImpl(this.duringNode, duringFilters));
        CdaFilters afterFilters = cdas.getAfterFilters();
        cdas.setAfterFilters(CdaFiltersPanel.commitImpl(this.afterNode, afterFilters));
    }

    private static CdaSettings findCdaSettings(TraversableContext tc) {
        ProjectFileGroup pfg = FileGroupsEditor.getProjectFileGroup((Namespace)tc);
        return pfg.getFilters();
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.btnAdd) {
            FilterPanel panel = new FilterPanel();
            panel.setClassPath(this._classPath);
            this.setWhenText(panel, (TreeNode)((Object)this.getWhenNode()));
            CdaFilter newFilter = panel.showDialog((Component)((Object)this));
            if (newFilter != null) {
                FilterNode newNode = new FilterNode(newFilter);
                this.addNode(this.getWhenNode(), newNode);
            }
        } else if (source == this.btnRemove && this._curNode != null) {
            int[] rows = this._tree.getSelectionRows();
            this.removeNode(this._curNode);
            int numRows = this._tree.getRowCount();
            int row0 = rows[0];
            int row = row0 < numRows ? row0 : numRows - 1;
            TreePath tp = this._tree.getPathForRow(row);
            Object node = tp.getLastPathComponent();
            if (node == this.afterNode || node == this.duringNode) {
                --row;
            }
            this._tree.setSelectionRow(row);
        }
    }

    public void itemStateChanged(ItemEvent e) {
        if (this._curNode != null && e.getSource() == this.filterPanel.cbType) {
            this._curNode.filter.setType(this.filterPanel.getType());
            this._curNode.filter.setScope(this.filterPanel.getScope());
            this._treeModel.nodeChanged((TreeNode)((Object)this._curNode));
            this.filterPanel.tfName.requestFocus();
            this.filterPanel.tfName.selectAll();
        }
    }

    public void insertUpdate(DocumentEvent e) {
        this.updateField();
    }

    public void removeUpdate(DocumentEvent e) {
        this.updateField();
    }

    public void changedUpdate(DocumentEvent e) {
    }

    private void updateField() {
        if (this._curNode != null) {
            this._curNode.filter.setName(this.filterPanel.tfName.getText());
            SwingUtilities.invokeLater(new 1());
        }
    }

    public void valueChanged(TreeSelectionEvent e) {
        TreePath tp = e.getNewLeadSelectionPath();
        if (tp != null) {
            Object node = tp.getLastPathComponent();
            this._curNode = node instanceof FilterNode ? (FilterNode)node : null;
            SwingUtilities.invokeLater(new 2(this, tp));
        }
    }

    public void treeWillExpand(TreeExpansionEvent e) {
    }

    public void treeWillCollapse(TreeExpansionEvent e) throws ExpandVetoException {
        throw new ExpandVetoException(e);
    }

    private void enableUI(boolean enabled) {
        this.btnRemove.setEnabled(enabled);
        this.filterPanel.enableUI(enabled);
    }

    private void update(TreePath tp) {
        if (tp == null) {
            this.enableUI(false);
            this.btnAdd.setEnabled(false);
            return;
        }
        Object node = tp.getLastPathComponent();
        if (node instanceof WhenNode) {
            this.enableUI(false);
            this.btnAdd.setEnabled(true);
            this.filterPanel.tfName.setText(null);
            this.setWhenText(this.filterPanel, (TreeNode)((Object)((WhenNode)((Object)node))));
        } else if (node instanceof NoneNode) {
            TreeNode parent = ((NoneNode)((Object)node)).getParent();
            this.selectNode((DefaultMutableTreeNode)parent);
        } else {
            this.btnAdd.setEnabled(true);
            this.enableUI(true);
            FilterNode filterNode = (FilterNode)node;
            CdaFilter filter = filterNode.filter;
            this.setWhenText(this.filterPanel, filterNode.getParent());
            this.filterPanel.cbType.setSelectedIndex(CdaFiltersPanel.toTypeIndex(filter));
            this.filterPanel.tfName.setText(filter.getName());
            this.filterPanel.tfName.requestFocus();
        }
    }

    private void addNode(WhenNode parent, FilterNode child) {
        this.removeNoneNode(parent);
        parent.add((MutableTreeNode)((Object)child));
        this._treeModel.nodeStructureChanged((TreeNode)((Object)parent));
        this.selectNode((DefaultMutableTreeNode)((Object)child));
    }

    private void removeNode(FilterNode node) {
        TreeNode parent = node.getParent();
        node.removeFromParent();
        if (parent.getChildCount() == 0) {
            this.addNoneNode((WhenNode)((Object)parent));
        }
        this._treeModel.nodeStructureChanged(parent);
    }

    private void addNoneNode(WhenNode parent) {
        if (parent == this.beforeNode) {
            parent.insert((MutableTreeNode)((Object)this.beforeNoneNode), 0);
        } else if (parent == this.duringNode) {
            parent.insert((MutableTreeNode)((Object)this.duringNoneNode), 0);
        } else if (parent == this.afterNode) {
            parent.insert((MutableTreeNode)((Object)this.afterNoneNode), 0);
        }
    }

    private void removeNoneNode(WhenNode parent) {
        if (parent == this.beforeNode) {
            this.beforeNoneNode.removeFromParent();
        } else if (parent == this.duringNode) {
            this.duringNoneNode.removeFromParent();
        } else if (parent == this.afterNode) {
            this.afterNoneNode.removeFromParent();
        }
    }

    private void selectNode(DefaultMutableTreeNode node) {
        TreePath tp = new TreePath(node.getPath());
        this._tree.setLeadSelectionPath(tp);
        this._selModel.setSelectionPath(tp);
    }

    private WhenNode getWhenNode() {
        switch (this._curWhen) {
            case 0: {
                return this.beforeNode;
            }
            case 1: {
                return this.duringNode;
            }
            case 2: {
                return this.afterNode;
            }
        }
        return null;
    }

    private void setWhenText(FilterPanel panel, TreeNode parent) {
        if (parent == this.beforeNode) {
            panel.setWhenText(CommonArb.getString(83));
            this._curWhen = 0;
        } else if (parent == this.duringNode) {
            panel.setWhenText(CommonArb.getString(4));
            this._curWhen = 1;
        } else if (parent == this.afterNode) {
            panel.setWhenText(CommonArb.getString(55));
            this._curWhen = 2;
        }
    }

    private static int toTypeIndex(CdaFilter filter) {
        int type = filter.getType();
        int scope = filter.getScope();
        if (type == 0) {
            switch (scope) {
                case 0: {
                    return 0;
                }
                case 2: {
                    return 1;
                }
                case 4: {
                    return 2;
                }
            }
        } else {
            switch (scope) {
                case 0: {
                    return 3;
                }
                case 2: {
                    return 4;
                }
                case 4: {
                    return 5;
                }
            }
        }
        return 0;
    }

    private void loadImpl(WhenNode parent, CdaFilters cdaf, NoneNode noneNode) {
        if (cdaf == null) {
            parent.removeAllChildren();
            parent.insert((MutableTreeNode)((Object)noneNode), 0);
        } else {
            this.loadImpl(parent, cdaf.getFilters(), noneNode);
        }
        this._treeModel.nodeStructureChanged((TreeNode)((Object)parent));
    }

    private void loadImpl(WhenNode parent, CdaFilter[] filters, NoneNode noneNode) {
        parent.removeAllChildren();
        if (filters == null) {
            parent.insert((MutableTreeNode)((Object)noneNode), 0);
            this._treeModel.nodeStructureChanged((TreeNode)((Object)parent));
        } else {
            int n = filters.length;
            int i = 0;
            while (i < n) {
                CdaFilter filter = filters[i];
                FilterNode node = new FilterNode(filter);
                parent.add((MutableTreeNode)((Object)node));
                ++i;
            }
        }
    }

    private static CdaFilters commitImpl(WhenNode parent, CdaFilters cdaf) {
        ArrayList<CdaFilter> filterList = new ArrayList<CdaFilter>(parent.getChildCount());
        Enumeration en = parent.children();
        while (en.hasMoreElements()) {
            CdaFilter filter;
            String name;
            Object childObj = en.nextElement();
            if (!(childObj instanceof FilterNode) || (name = (filter = ((FilterNode)childObj).filter).getName()) == null || name.length() <= 0) continue;
            filterList.add(filter);
        }
        if (filterList.size() > 0) {
            CdaFilter[] filters = filterList.toArray(new CdaFilter[0]);
            CdaFilters cdaFilters = cdaf != null ? cdaf : new CdaFilters();
            cdaFilters.setFilters(filters);
            return cdaFilters;
        }
        return null;
    }

    static void mav$update(CdaFiltersPanel cdaFiltersPanel, TreePath treePath) {
        cdaFiltersPanel.update(treePath);
    }

    static DefaultTreeModel ra$_treeModel(CdaFiltersPanel cdaFiltersPanel) {
        return cdaFiltersPanel._treeModel;
    }

    static FilterNode ra$_curNode(CdaFiltersPanel cdaFiltersPanel) {
        return cdaFiltersPanel._curNode;
    }

    final class 1
    implements Runnable {
        public void run() {
            CdaFiltersPanel.ra$_treeModel(CdaFiltersPanel.this).nodeChanged((TreeNode)((Object)CdaFiltersPanel.ra$_curNode(CdaFiltersPanel.this)));
        }
    }

    final class 2
    implements Runnable {
        private final /* synthetic */ TreePath v$tp;
        final /* synthetic */ CdaFiltersPanel this$0;

        public void run() {
            CdaFiltersPanel.mav$update(this.this$0, this.v$tp);
        }

        public 2(CdaFiltersPanel cdaFiltersPanel, TreePath treePath) {
            this.v$tp = treePath;
            this.this$0 = cdaFiltersPanel;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class WhenNode
    extends JMutableTreeNode {
        private Vector _children;

        private void $init$() {
            this._children = new Vector();
        }

        WhenNode(String text) {
            super(text);
            this.$init$();
        }

        WhenNode(String text, int heightAdj) {
            super(text);
            this.$init$();
            JTreeCellData model = this.getModel();
            model.setHeightAdjustment(heightAdj);
        }

        public Enumeration children() {
            return new Vector(this._children).elements();
        }

        public boolean getAllowsChildren() {
            return true;
        }

        public TreeNode getChildAt(int childIndex) {
            return (TreeNode)this._children.get(childIndex);
        }

        public int getChildCount() {
            return this._children.size();
        }

        public int getIndex(TreeNode node) {
            return this._children.indexOf(node);
        }

        public boolean isLeaf() {
            return false;
        }

        public void insert(MutableTreeNode child, int index) {
            if (index < 0) {
                Assert.println((String)CommonArb.getString(69));
                index = 0;
            }
            this._children.insertElementAt(child, index);
            child.setParent((MutableTreeNode)((Object)this));
        }

        public void remove(int index) {
            this._children.remove(index);
        }

        public void remove(MutableTreeNode node) {
            this._children.remove(node);
        }

        boolean sort() {
            Vector copy = new Vector(this._children);
            Collections.sort(this._children);
            return copy.equals(this._children) ^ true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NoneNode
    extends JMutableTreeNode {
        NoneNode() {
            super(CommonArb.getString(28));
            this.getModel().setEnabled(false);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FilterNode
    extends JMutableTreeNode
    implements Comparable {
        final CdaFilter filter;

        FilterNode(CdaFilter filter) {
            super((JTreeCellData)new Data(filter));
            this.filter = filter;
        }

        public int compareTo(Object o) {
            return this.filter.compareTo(((FilterNode)o).filter);
        }

        public boolean equals(Object o) {
            if (o == null || o.getClass() != this.getClass()) {
                return false;
            }
            return this.filter.equals(((FilterNode)o).filter);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class Data
        extends JTreeCellData {
            private final CdaFilter _filter;

            Data(CdaFilter filter) {
                super(null);
                this._filter = filter;
            }

            public String getText() {
                return this._filter.toString();
            }
        }
    }

    private static class FilterPanel
    extends JPanel
    implements GridBagConstants,
    ActionListener {
        private JLabel labelWhen;
        private final JLabel lblWhen;
        JComboBox cbType;
        JTextField tfName;
        private JButton btnBrowse;
        private URLPath _classPath;

        private void $init$() {
            this.labelWhen = new JLabel(CommonArb.getString(87));
            this.lblWhen = new JLabel();
            this.cbType = new JComboBox<String>(new String[]{CommonArb.getString(10), CommonArb.getString(109), CommonArb.getString(130), CommonArb.getString(29), CommonArb.getString(30), CommonArb.getString(113)});
            this.tfName = new JTextField();
            this.btnBrowse = new JButton();
        }

        FilterPanel() {
            this.$init$();
            this.lblWhen.setEnabled(true);
            JLabel lblType = new JLabel();
            ResourceUtils.resLabel((JLabel)lblType, (Component)this.cbType, (String)CommonArb.getString(90));
            JLabel lblName = new JLabel();
            ResourceUtils.resLabel((JLabel)lblName, (Component)this.tfName, (String)CommonArb.getString(118));
            ResourceUtils.resButton((AbstractButton)this.btnBrowse, (String)CommonArb.getString(115));
            this.btnBrowse.addActionListener(this);
            this.setClassPath(null);
            Insets in5555 = new Insets(5, 5, 5, 5);
            this.setLayout(new GridBagLayout());
            this.add((Component)this.labelWhen, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, in5555, 0, 0));
            this.add((Component)this.lblWhen, new GridBagConstraints(1, 0, 2, 1, 0.0, 0.0, 17, 2, in5555, 0, 0));
            this.add((Component)lblType, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, in5555, 0, 0));
            this.add((Component)this.cbType, new GridBagConstraints(1, 1, 2, 1, 0.0, 0.0, 17, 2, in5555, 0, 0));
            this.add((Component)lblName, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, in5555, 0, 0));
            this.add((Component)this.tfName, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, in5555, 0, 0));
            this.add((Component)this.btnBrowse, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 2, in5555, 0, 0));
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.btnBrowse) {
                int scope = this.getScope();
                int pccScope = scope == 4 ? 1 : 0;
                PackageClassChooser pcc = new PackageClassChooser(pccScope, this._classPath);
                pcc.setSelection(this.tfName.getText());
                int result = pcc.showDialog((Component)this);
                if (result == 0) {
                    this.tfName.setText(pcc.getSelection());
                }
            }
        }

        void setClassPath(URLPath classPath) {
            this._classPath = classPath;
            this.btnBrowse.setEnabled(this._classPath != null);
        }

        void enableUI(boolean enabled) {
            this.cbType.setEnabled(enabled);
            this.tfName.setEnabled(enabled);
            this.lblWhen.setEnabled(enabled);
            this.btnBrowse.setEnabled(enabled);
        }

        void setWhenText(String whenText) {
            this.lblWhen.setText(whenText);
        }

        int getType() {
            int index = this.cbType.getSelectedIndex();
            return index <= 2 ? 0 : 1;
        }

        int getScope() {
            int index = this.cbType.getSelectedIndex();
            switch (index) {
                case 0: 
                case 3: {
                    return 0;
                }
                case 1: 
                case 4: {
                    return 2;
                }
                case 2: 
                case 5: {
                    return 4;
                }
            }
            return 0;
        }

        private CdaFilter getFilter() {
            int type = this.getType();
            int scope = this.getScope();
            String name = this.tfName.getText();
            return new CdaFilter(type, scope, name);
        }

        CdaFilter showDialog(Component parent) {
            Frame frame = IdeUtil.findFrame((Component)parent);
            JEWTDialog dialog = new JEWTDialog(frame, CommonArb.getString(15), 7);
            dialog.setResizable(true);
            HelpUtils.setHelpID((JComponent)this, (String)"f1_depfgdlgdafilter_html");
            dialog.setContent((Component)this);
            dialog.pack();
            dialog.setInitialFocus((Component)this.tfName);
            boolean result = WizardLauncher.runDialog((JDialog)dialog);
            return result ? this.getFilter() : null;
        }
    }
}

