/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.common;

import java.net.URL;
import java.util.Arrays;
import java.util.Iterator;
import oracle.ide.model.Element;
import oracle.ide.model.Folder;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.Assert;
import oracle.javatools.data.HashStructure;
import oracle.jdeveloper.deploy.common.ArchiveElement;
import oracle.jdeveloper.deploy.common.NodeDependable;
import oracle.jdeveloper.deploy.dt.AbstractHashDependable;

public class DefaultNodeDependable
extends AbstractHashDependable
implements NodeDependable,
ArchiveElement {
    protected Node source_;
    protected Folder owner_;

    public DefaultNodeDependable(Node source, Folder owner) {
        this.source_ = source;
        this.owner_ = owner;
        this._hash.putURL("sourceURL", source.getURL());
        if (owner instanceof Locatable) {
            this._hash.putURL("ownerURL", ((Locatable)owner).getURL());
        }
        this.setReload(false);
    }

    public DefaultNodeDependable(HashStructure hash) {
        super(hash);
    }

    public URL getNodeURL() {
        return this._hash.getURL("sourceURL");
    }

    public Iterator getDependencies() {
        return Arrays.asList(new Object[0]).iterator();
    }

    public Node getNode() {
        return (Node)this.getSource();
    }

    public boolean doesExist() {
        if (this.source_ != null && NodeFactory.find((URL)this.source_.getURL()) != null) {
            return true;
        }
        return URLFileSystem.exists((URL)this.getNodeURL());
    }

    @Deprecated
    public String getPathInArchive() {
        return this._hash.getString("pathInEar");
    }

    @Deprecated
    public void setPathInArchive(String path) {
        this._hash.putString("pathInEar", path);
    }

    public boolean cache() {
        this.cacheImpl();
        if (this.source_ == null || this.owner_ == null) {
            Assert.println((String)"DefaultNodeDependable():Source or Owner could not be loaded");
            return false;
        }
        return true;
    }

    protected Element getSourceImpl() {
        return this.source_;
    }

    protected Folder getSourceOwnerImpl() {
        return this.owner_;
    }

    protected void cacheImpl() {
        try {
            URL sourceURL = this._hash.getURL("sourceURL");
            URL ownerURL = this._hash.getURL("ownerURL");
            this.owner_ = (Folder)NodeFactory.find((URL)ownerURL);
            this.source_ = NodeFactory.find((URL)sourceURL);
        }
        catch (Exception e) {
            this.source_ = null;
            this.owner_ = null;
            Assert.printStackTrace((Throwable)e);
        }
    }
}

