/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.common;

import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import oracle.ide.model.DataContainer;
import oracle.ide.model.Dependable;
import oracle.ide.model.Folder;
import oracle.ide.model.NodeFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.Assert;
import oracle.ide.util.ModelUtil;
import oracle.javatools.data.HashStructure;
import oracle.jdeveloper.deploy.common.ArchiveElement;
import oracle.jdeveloper.deploy.common.ProfileDependable;
import oracle.jdeveloper.deploy.dt.AbstractHashDependable;
import oracle.jdeveloper.deploy.dt.DeploymentProfiles;
import oracle.jdeveloper.deploy.dt.Profile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultProfileDependable
extends AbstractHashDependable
implements ProfileDependable,
ArchiveElement {
    public static final String PROFILE_NAME_KEY = "profileName";
    Profile profile_;

    public DefaultProfileDependable(Profile profile) {
        Assert.precondition((boolean)ModelUtil.hasLength((String)profile.getName()), (String)"A Dependency can only be created to a named Profile");
        this.setProfileName(profile.getName());
        this.setFolderURL(profile.getDataContainer().getURL());
        this.profile_ = profile;
        this.setReload(false);
    }

    public DefaultProfileDependable(HashStructure hash) {
        super(hash);
    }

    @Override
    public Profile getProfile() {
        return (Profile)this.getSource();
    }

    @Override
    public Profile getSourceImpl() {
        return this.profile_;
    }

    @Override
    public Folder getSourceOwnerImpl() {
        Profile profile = this.getProfile();
        if (profile != null) {
            return profile.getDataContainer();
        }
        return null;
    }

    @Override
    public boolean cache() {
        String profileName = this._hash.getString(PROFILE_NAME_KEY);
        URL folderURL = this._hash.getURL("ownerURL");
        Assert.check((profileName != null ? 1 : 0) != 0, (String)"Profile name could not be found in dependable");
        Assert.check((folderURL != null ? 1 : 0) != 0, (String)"Folder not set in dependable");
        this.profile_ = null;
        if (URLFileSystem.exists((URL)folderURL)) {
            try {
                DataContainer folder_ = (DataContainer)NodeFactory.findOrCreate(DataContainer.class, (URL)folderURL);
                Assert.check((boolean)(folder_ instanceof DataContainer), (String)"Profile should be contained in a datacontainer");
                this.profile_ = DeploymentProfiles.getInstance(folder_).getProfileByName(profileName);
                boolean bl = true;
                return bl;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    void setProfileName(String name) {
        String oldName = this._hash.getString(PROFILE_NAME_KEY);
        this._hash.putString(PROFILE_NAME_KEY, name);
        this.maybeSetReload(name, oldName);
    }

    void setFolderURL(URL url) {
        URL oldurl = this._hash.getURL("ownerURL");
        this._hash.putURL("ownerURL", url);
        this.maybeSetReload(url, oldurl);
    }

    @Override
    public Iterator<Dependable> getDependencies() {
        Profile profile = this.getProfile();
        if (profile == null) {
            return new ArrayList().iterator();
        }
        return profile.getDependencies();
    }

    @Override
    public <T> T getProfile(Class<T> clazz) {
        Profile profile = this.getProfile();
        return (T)(clazz.isAssignableFrom(profile.getClass()) ? profile : null);
    }

    @Override
    public DataContainer getDataContainer() {
        return (DataContainer)this.getSourceOwner();
    }

    @Override
    public boolean doesExist() {
        return this.getSource() != null;
    }

    @Override
    @Deprecated
    public String getPathInArchive() {
        return this._hash.getString("pathInEar");
    }

    @Override
    @Deprecated
    public void setPathInArchive(String path) {
        this._hash.putString("pathInEar", path);
    }
}

