/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.common;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.ide.model.Dependable;
import oracle.ide.util.Assert;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.ListStructure;
import oracle.jdeveloper.deploy.common.Interdependency;
import oracle.jdeveloper.deploy.dt.AbstractHashDependable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependableContainer
extends HashStructureAdapter
implements Interdependency {
    private List _dependencyList;
    public static String DEPENDENCY_KEY = "dependencyList";

    public DependableContainer() {
        this(HashStructure.newInstance());
    }

    public DependableContainer(HashStructure hash) {
        super(hash);
        this.initDependencyList();
    }

    private void initDependencyList() {
        ListStructure list = this._hash.getListStructure(DEPENDENCY_KEY);
        this._dependencyList = new ArrayList();
        if (list != null) {
            int n = list.size();
            int i = 0;
            while (i < n) {
                HashStructure dependableHash = (HashStructure)list.get(i);
                try {
                    Dependable dependable = AbstractHashDependable.createDependable(dependableHash);
                    this._dependencyList.add(dependable);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++i;
            }
        }
    }

    @Override
    public Iterator<Dependable> getDependencies() {
        return this._dependencyList.iterator();
    }

    @Override
    public void addDependency(Dependable dependable) {
        Assert.check((boolean)(dependable instanceof AbstractHashDependable), (String)"The dependable is not an instance of AbstractHashDependable and is therefore not supported by this DependableContainer.");
        if (this._dependencyList.contains(dependable)) {
            this.removeDependency(dependable);
        }
        ListStructure list = this._hash.getOrCreateListStructure(DEPENDENCY_KEY);
        list.add((Object)((AbstractHashDependable)dependable).getHashStructure());
        this._dependencyList.add(dependable);
    }

    private int getDependableIndex(Dependable dependable) {
        return this._dependencyList.indexOf(dependable);
    }

    @Override
    public Dependable removeDependency(Dependable dependable) {
        ListStructure list = this._hash.getListStructure(DEPENDENCY_KEY);
        int index = this.getDependableIndex(dependable);
        if (index != -1) {
            list.remove(index);
            this._dependencyList.remove(index);
        }
        return dependable;
    }
}

