/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.common;

import java.util.Iterator;
import java.util.NoSuchElementException;
import oracle.ide.model.Dependable;
import oracle.ide.model.DependencyConfiguration;
import oracle.ide.model.Element;
import oracle.ide.model.Folder;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.model.XMLDataNode;
import oracle.jdeveloper.deploy.dt.Deployment;

public class DependencyIterator {
    private final Iterator _iter;
    private Boolean _hasNext;
    private boolean _isOwnerWorkspace;
    private Project _project;
    private XMLDataNode _profile;

    public DependencyIterator(Project project) {
        this._iter = DependencyConfiguration.getInstance((Project)project).getDependencies();
    }

    public boolean hasNext() {
        this.maybePrepareNext();
        return this._hasNext;
    }

    public void next() {
        this.maybePrepareNext();
        this.checkHasNext();
        this._hasNext = null;
    }

    public boolean isOwnerWorkspace() {
        return this._isOwnerWorkspace;
    }

    public Project getProject() {
        return this._project;
    }

    public XMLDataNode getProfile() {
        return this._profile;
    }

    private void maybePrepareNext() {
        if (this._hasNext == null) {
            this.prepareNext();
        }
    }

    private void checkHasNext() {
        if (!Boolean.TRUE.equals(this._hasNext)) {
            throw new NoSuchElementException();
        }
    }

    private void prepareNext() {
        while (this._iter.hasNext()) {
            Folder depSourceOwner;
            Dependable dep = (Dependable)this._iter.next();
            Element depSource = dep.getSource();
            if (depSource instanceof XMLDataNode) {
                Folder depSourceOwner2 = dep.getSourceOwner();
                if (!(depSourceOwner2 instanceof Project)) continue;
                Project depSourceProject = (Project)depSourceOwner2;
                XMLDataNode depNode = (XMLDataNode)depSource;
                if (!Deployment.isDeploymentProfile((Node)depNode)) continue;
                this._hasNext = Boolean.TRUE;
                this._isOwnerWorkspace = false;
                this._project = depSourceProject;
                this._profile = depNode;
                return;
            }
            if (!(depSource instanceof Project) || (depSourceOwner = dep.getSourceOwner()) != null && !(depSourceOwner instanceof Workspace)) continue;
            this._hasNext = Boolean.TRUE;
            this._isOwnerWorkspace = true;
            this._project = (Project)depSource;
            this._profile = null;
            return;
        }
        this._hasNext = Boolean.FALSE;
        this._isOwnerWorkspace = false;
        this._project = null;
        this._profile = null;
    }
}

