/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.common;

import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import oracle.ide.model.DataContainer;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.model.XMLDataNode;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLPath;
import oracle.ide.util.Assert;
import oracle.ide.util.Namespace;
import oracle.ide.util.VersionNumber;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.deploy.common.Contributor;
import oracle.jdeveloper.deploy.common.FileGroup;
import oracle.jdeveloper.deploy.common.FileGroups;
import oracle.jdeveloper.deploy.common.LibraryFileGroup;
import oracle.jdeveloper.deploy.common.PackagingFileGroup;
import oracle.jdeveloper.deploy.common.ProjectFileGroup;
import oracle.jdeveloper.deploy.jar.ArchiveProfile;
import oracle.jdeveloper.deploy.jar.JarPackaging;
import oracle.jdeveloper.library.JLibrary;
import oracle.jdeveloper.library.JLibraryDefinition;
import oracle.jdeveloper.library.JLibraryManager;
import oracle.jdeveloper.library.JProjectLibraryList;
import oracle.jdeveloper.model.ApplicationContent;
import oracle.jdeveloper.model.J2eeSettings;
import oracle.jdeveloper.model.JProjectLibraries;
import oracle.jdeveloper.model.JavaProject;
import oracle.jdeveloper.model.PathsConfiguration;
import oracle.jdevimpl.config.JProjectPaths;
import oracle.jdevimpl.deploy.common.DependencyIterator;

public class FileGroupsEditor {
    private static final String FILE_GROUPS_KEY = "file-groups";
    public static final String FILE_GROUP_KEY = "file-group";

    public static FileGroups getFileGroups(Namespace data) {
        return (FileGroups)data.find(FILE_GROUPS_KEY);
    }

    public static void setFileGroups(FileGroups fileGroups, Namespace data) {
        data.findAndReplace(FILE_GROUPS_KEY, (Object)fileGroups);
    }

    public static FileGroup getFileGroup(Namespace data) {
        return (FileGroup)data.find(FILE_GROUP_KEY);
    }

    public static void setFileGroup(FileGroup fileGroup, Namespace data) {
        data.findAndReplace(FILE_GROUP_KEY, (Object)fileGroup);
    }

    public static PackagingFileGroup getPackagingFileGroup(Namespace data) {
        return (PackagingFileGroup)data.find(FILE_GROUP_KEY);
    }

    public static void setPackagingFileGroup(PackagingFileGroup packagingFileGroup, Namespace data) {
        data.findAndReplace(FILE_GROUP_KEY, (Object)packagingFileGroup);
    }

    public static ProjectFileGroup getProjectFileGroup(Namespace data) {
        return (ProjectFileGroup)data.find(FILE_GROUP_KEY);
    }

    public static void setProjectFileGroup(ProjectFileGroup projectFileGroup, Namespace data) {
        data.findAndReplace(FILE_GROUP_KEY, (Object)projectFileGroup);
    }

    public static LibraryFileGroup getLibraryFileGroup(Namespace data) {
        return (LibraryFileGroup)data.find(FILE_GROUP_KEY);
    }

    public static void setLibraryFileGroup(LibraryFileGroup libraryFileGroup, Namespace data) {
        data.findAndReplace(FILE_GROUP_KEY, (Object)libraryFileGroup);
    }

    public static URLPath getContribPath(PackagingFileGroup group, DataContainer container) {
        URLPath contribPath = new URLPath();
        Contributor[] contributors = group.getContributors();
        if (contributors != null) {
            int n = contributors.length;
            int i = 0;
            while (i < n) {
                Contributor contrib = contributors[i];
                if (contrib != null) {
                    switch (contrib.getType()) {
                        case 1: {
                            contribPath.add(contrib.getLocation());
                            break;
                        }
                        case 2: {
                            Assert.check((boolean)(container instanceof Project), (String)"Project output directory only available for Project-profiles");
                            contribPath.add(JavaProject.getInstance((Project)((Project)container)).getOutputDirectory());
                            break;
                        }
                        case 3: {
                            Assert.check((boolean)(container instanceof Project), (String)"Project output directory only available for Project-profiles");
                            contribPath.add(JProjectPaths.getInstance((PropertyStorage)((Project)container)).getAdditionalClassPath());
                            break;
                        }
                        case 4: {
                            Assert.check((boolean)(container instanceof Project), (String)"Project output directory only available for Project-profiles");
                            contribPath.add(contrib.getLocation());
                            break;
                        }
                        case 5: {
                            Assert.check((boolean)(container instanceof Project), (String)"Project output directory only available for Project-profiles");
                            contribPath.add(J2eeSettings.getInstance((Project)container).getHtmlRootDirectory());
                            break;
                        }
                        case 6: {
                            contribPath.add(PathsConfiguration.getInstance((Project)((Project)container)).getProjectSourcePath());
                            break;
                        }
                        case 7: {
                            FileGroupsEditor.addProjectDependencies(contribPath, (Project)container);
                            break;
                        }
                        case 8: {
                            FileGroupsEditor.addProfileDependencies(contribPath, (Project)container, null);
                            break;
                        }
                        case 9: {
                            contribPath.add(ApplicationContent.getInstance((Workspace)((Workspace)container)).getSourceURL());
                            break;
                        }
                        case 10: {
                            contribPath.add(ApplicationContent.getInstance((Workspace)((Workspace)container)).getADFSourceURL());
                            break;
                        }
                    }
                }
                ++i;
            }
        }
        return contribPath;
    }

    public static URLPath getContribPath(LibraryFileGroup group, Project project) {
        ArrayList<JLibrary> deployedLibs = new ArrayList<JLibrary>();
        JProjectLibraries projectLibs = JProjectLibraries.getInstance((PropertyStorage)project);
        VersionNumber jdkVer = projectLibs.getJdkVersionNumber();
        JLibrary[] projectLibraries = projectLibs.getLibraries();
        if (projectLibraries != null) {
            int i = 0;
            while (i < projectLibraries.length) {
                JLibrary lib = projectLibraries[i];
                if (lib != null && Boolean.TRUE.equals(lib.getDeployedByDefault())) {
                    deployedLibs.add(lib);
                }
                ++i;
            }
        }
        FileGroupsEditor.getDeployedLibraries(project, group.getSelectedLibraries(), deployedLibs);
        URLPath contribPath = new URLPath();
        Iterator iter = deployedLibs.iterator();
        boolean asFiles = group.getSelectionMode() == 0;
        while (iter.hasNext()) {
            URL[] entries;
            URLPath cp;
            JLibrary lib = (JLibrary)iter.next();
            JLibraryDefinition libDef = lib.getLibraryDefinition(jdkVer);
            if (libDef == null || (cp = libDef.getClassPath()) == null || (entries = cp.getEntries()) == null) continue;
            int n = entries.length;
            int i = 0;
            while (i < n) {
                URL entry = entries[i];
                URL contrib = asFiles ? JarUtil.getJarFileURL((URL)entry) : entry;
                contribPath.add(contrib);
                ++i;
            }
        }
        return contribPath;
    }

    private static void getDeployedLibraries(Project project, Object[] libNames, ArrayList deployedLibs) {
        if (libNames != null) {
            JProjectLibraryList projectLibList = JProjectLibraries.getInstance((PropertyStorage)project).getProjectLibraryList();
            int n = libNames.length;
            int i = 0;
            while (i < n) {
                Object libName = libNames[i];
                JLibrary lib = JLibraryManager.findLibrary((Object)libName);
                if (lib == null) {
                    lib = projectLibList.findLibrary(libName);
                }
                if (lib != null) {
                    deployedLibs.add(lib);
                }
                ++i;
            }
        }
    }

    private static void addProjectDependencies(URLPath contribPath, Project jProject) {
        DependencyIterator iter = new DependencyIterator(jProject);
        while (iter.hasNext()) {
            Object profileObj;
            iter.next();
            if (iter.isOwnerWorkspace()) {
                Project project = iter.getProject();
                if (project == null) continue;
                contribPath.add(JavaProject.getInstance((Project)project).getOutputDirectory());
                continue;
            }
            XMLDataNode profileNode = iter.getProfile();
            if (profileNode == null || !((profileObj = profileNode.getData()) instanceof ArchiveProfile)) continue;
            ArchiveProfile profile = (ArchiveProfile)profileObj;
            contribPath.add(URLFactory.newJarURL((URL)profile.getJarURL(), null));
        }
    }

    private static void addProfileDependencies(URLPath contribPath, Project project, JarPackaging profile) {
    }
}

