/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.common;

import java.util.List;
import oracle.ide.model.Element;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.jdevimpl.xml.DescriptorNode;

public abstract class JProjectSelectionFilter {
    private Project _project;

    public abstract boolean canBeSelected(Element var1);

    protected Project getProject() {
        return this._project;
    }

    protected void setProject(Project project) {
        this._project = project;
    }

    public static final boolean canBeSelected0(Object object) {
        Node node;
        if (object instanceof Node && (node = (Node)object).getAttributes().isSet(ElementAttributes.DEPLOYABLE)) {
            if (node instanceof DescriptorNode) {
                DescriptorNode dnode = (DescriptorNode)node;
                if (dnode.getPackagingLevel() != 1) {
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    public static final boolean canBeSelected(Object object, JProjectSelectionFilter[] psfs) {
        if (!JProjectSelectionFilter.canBeSelected0(object)) {
            return false;
        }
        Element element = (Element)object;
        if (psfs != null) {
            int n = psfs.length;
            int i = 0;
            while (i < n) {
                if (!psfs[i].canBeSelected(element)) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public static final boolean canBeSelected(Object object, List psfs) {
        if (!JProjectSelectionFilter.canBeSelected0(object)) {
            return false;
        }
        Element element = (Element)object;
        if (psfs != null) {
            for (JProjectSelectionFilter psf : psfs) {
                if (psf.canBeSelected(element)) continue;
                return false;
            }
        }
        return true;
    }

    public static final JProjectSelectionFilter createFilter(Class filterClass, Project project) {
        try {
            JProjectSelectionFilter filter = (JProjectSelectionFilter)filterClass.newInstance();
            filter.setProject(project);
            JProjectSelectionFilter jProjectSelectionFilter = filter;
            return jProjectSelectionFilter;
        }
        catch (Exception e) {
            JProjectSelectionFilter jProjectSelectionFilter = null;
            return jProjectSelectionFilter;
        }
    }

    public static final JProjectSelectionFilter[] createFilters(Class[] filterClasses, Project project) {
        if (filterClasses == null || filterClasses.length <= 0) {
            return null;
        }
        int n = filterClasses.length;
        JProjectSelectionFilter[] filters = new JProjectSelectionFilter[n];
        int i = 0;
        while (i < n) {
            filters[i] = JProjectSelectionFilter.createFilter(filterClasses[i], project);
            ++i;
        }
        return filters;
    }

    public static final JProjectSelectionFilter[] createFilters(List list) {
        if (list == null) {
            return null;
        }
        int n = list.size();
        JProjectSelectionFilter[] filters = new JProjectSelectionFilter[n];
        list.toArray(filters);
        return filters;
    }
}

