/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.common;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import oracle.ide.controls.tree.CustomJTree;
import oracle.ide.controls.tree.JMutableTreeNode;
import oracle.ide.controls.tree.JTreeCellData;
import oracle.ide.model.Project;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.resource.ModelArb;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.Namespace;
import oracle.ide.util.ResourceUtils;
import oracle.ide.util.TriStateBoolean;
import oracle.jdeveloper.deploy.common.LibraryFileGroup;
import oracle.jdeveloper.library.JLibrary;
import oracle.jdeveloper.library.Library;
import oracle.jdevimpl.deploy.common.CommonEditor;
import oracle.jdevimpl.deploy.common.FileGroupsEditor;
import oracle.jdevimpl.deploy.common.LibraryIterator;
import oracle.jdevimpl.deploy.res.CommonArb;

public class LibraryContributorsPanel
extends DefaultTraversablePanel {
    private final JScrollPane spTree;
    private final CustomJTree tree;

    private void $init$() {
        this.spTree = new JScrollPane();
        this.tree = new CustomJTree();
    }

    public LibraryContributorsPanel() {
        this.$init$();
        this.setLayout(new GridBagLayout());
        JLabel lblTree = new JLabel();
        ResourceUtils.resLabel((JLabel)lblTree, (Component)this.tree, (String)CommonArb.getString(125));
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(false);
        this.spTree.getViewport().add((Component)this.tree, null);
        this.add(lblTree, this.gbc(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5)));
        this.add(this.spTree, this.gbc(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 5, 5, 5)));
        this.setHelpID("f1_depfglibcont_html");
    }

    public void onEntry(TraversableContext tc) {
        Project project = (Project)CommonEditor.getProject((Namespace)tc);
        LibraryFileGroup lfg = FileGroupsEditor.getLibraryFileGroup((Namespace)tc);
        Object[] selLibs = lfg.getSelectedLibraries();
        this.load(project, Arrays.asList(selLibs != null ? selLibs : new Object[]{}));
    }

    public void onExit(TraversableContext tc) {
        LibraryFileGroup lfg = FileGroupsEditor.getLibraryFileGroup((Namespace)tc);
        lfg.setSelectedLibraries(this.commit());
    }

    private void load(Project project, List selLibs) {
        JMutableTreeNode root = new JMutableTreeNode();
        LibraryContributorsPanel.addActiveConfigLibs(root, project, selLibs);
        this.tree.setModel((TreeModel)new DefaultTreeModel((TreeNode)root));
        IdeUtil.expandAllTreeRows((JTree)this.tree);
        root.descendingUpdateNodes();
    }

    private static void addActiveConfigLibs(JMutableTreeNode root, Project project, List selLibs) {
        if (project != null) {
            Icon libIcon = ModelArb.getIcon((int)8);
            LibraryIterator iter = new LibraryIterator(project);
            while (iter.hasNext()) {
                JLibrary lib = iter.next();
                if (lib == null) continue;
                Object libID = lib.getID();
                JTreeCellData libCellData = new JTreeCellData(libIcon, lib.getName(), true);
                libCellData.setUserObject((Object)lib);
                if (Boolean.TRUE.equals(lib.getDeployedByDefault())) {
                    libCellData.setCheckBoxState(true);
                    libCellData.setCheckBoxSelectable(false);
                    libCellData.setCheckBoxEnabled(false);
                } else {
                    libCellData.setCheckBoxState(selLibs.contains(libID));
                }
                JMutableTreeNode libNode = new JMutableTreeNode(libCellData);
                root.add((MutableTreeNode)libNode);
            }
        }
    }

    private Object[] commit() {
        ArrayList<Object> resultList = new ArrayList<Object>();
        JMutableTreeNode root = (JMutableTreeNode)this.tree.getModel().getRoot();
        Enumeration en = root.preorderEnumeration();
        while (en.hasMoreElements()) {
            Object userObj;
            JMutableTreeNode node = (JMutableTreeNode)en.nextElement();
            JTreeCellData data = node.getModel();
            if (data == null || !((userObj = data.getUserObject()) instanceof Library) || data.getCheckBoxState() != TriStateBoolean.TRUE || !data.isCheckBoxEnabled()) continue;
            resultList.add(((Library)userObj).getID());
        }
        return resultList.toArray(new Object[resultList.size()]);
    }
}

