/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.common;

import java.awt.BorderLayout;
import java.awt.Component;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import oracle.ide.controls.tree.CustomJTree;
import oracle.ide.controls.tree.JMutableTreeNode;
import oracle.ide.controls.tree.JTreeCellData;
import oracle.ide.model.Project;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.resource.ModelArb;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.Namespace;
import oracle.ide.util.TriStateBoolean;
import oracle.ide.util.VersionNumber;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.icons.OracleIcons;
import oracle.jdeveloper.deploy.common.CdaSettings;
import oracle.jdeveloper.deploy.common.ProjectFileGroup;
import oracle.jdeveloper.deploy.common.SelectedArchives;
import oracle.jdeveloper.library.JLibrary;
import oracle.jdeveloper.library.JLibraryDefinition;
import oracle.jdeveloper.model.JProjectLibraries;
import oracle.jdevimpl.deploy.common.CommonEditor;
import oracle.jdevimpl.deploy.common.FileGroupsEditor;
import oracle.jdevimpl.deploy.res.CommonArb;

public class LibrarySelectionPanel
extends DefaultTraversablePanel {
    private final JScrollPane jScrollPane1;
    private final CustomJTree tree;

    private void $init$() {
        this.jScrollPane1 = new JScrollPane();
        this.tree = new CustomJTree();
    }

    public LibrarySelectionPanel() {
        this.$init$();
        this.setLayout(new BorderLayout());
        this.add(this.jScrollPane1, "Center");
        this.jScrollPane1.getViewport().add((Component)this.tree, null);
    }

    public void onEntry(TraversableContext tc) {
        Project project = (Project)CommonEditor.getProject((Namespace)tc);
        SelectedArchives selArchs = LibrarySelectionPanel.findSelectedArchives(tc);
        URL[] archiveURLs = selArchs != null ? selArchs.getArchives() : null;
        this.load(project, archiveURLs);
    }

    public void onExit(TraversableContext tc) {
        SelectedArchives selArchs = LibrarySelectionPanel.findSelectedArchives(tc);
        selArchs.setArchives(this.commit());
    }

    private static SelectedArchives findSelectedArchives(TraversableContext tc) {
        CdaSettings filters;
        ProjectFileGroup pfg = FileGroupsEditor.getProjectFileGroup((Namespace)tc);
        if (pfg != null && (filters = pfg.getFilters()) != null) {
            return filters.getSelectedArchives();
        }
        return CommonEditor.getSelectedArchives((Namespace)tc);
    }

    Component getLabelFor() {
        return this.tree;
    }

    private void load(Project project, URL[] archiveURLs) {
        List<URL> archivesList = Arrays.asList(archiveURLs != null ? archiveURLs : new URL[]{});
        JMutableTreeNode root = new JMutableTreeNode(CommonArb.getString(8));
        LibrarySelectionPanel.addActiveConfigLibs(root, project, archivesList);
        this.tree.setModel((TreeModel)new DefaultTreeModel((TreeNode)root));
        IdeUtil.expandAllTreeRows((JTree)this.tree);
        root.descendingUpdateNodes();
    }

    private URL[] commit() {
        ArrayList<Object> resultList = new ArrayList<Object>();
        JMutableTreeNode root = (JMutableTreeNode)this.tree.getModel().getRoot();
        Enumeration en = root.preorderEnumeration();
        while (en.hasMoreElements()) {
            Object userObj;
            JMutableTreeNode node = (JMutableTreeNode)en.nextElement();
            JTreeCellData data = node.getModel();
            if (data == null || !((userObj = data.getUserObject()) instanceof URL) || data.getCheckBoxState() != TriStateBoolean.TRUE) continue;
            resultList.add(userObj);
        }
        return resultList.toArray(new URL[resultList.size()]);
    }

    private static void addActiveConfigLibs(JMutableTreeNode root, Project project, List archivesList) {
        if (project == null) {
            return;
        }
        JProjectLibraries jLibs = JProjectLibraries.getInstance((PropertyStorage)project);
        VersionNumber jdkVer = jLibs.getJdkVersionNumber();
        JLibrary[] libs = jLibs.getLibraries();
        LibrarySelectionPanel.addLibraryNodes(root, jLibs, jdkVer, libs, archivesList);
    }

    private static void addLibraryNodes(JMutableTreeNode configNode, JProjectLibraries jLibs, VersionNumber jdkVer, JLibrary[] libs, List archivesList) {
        Icon libIcon = ModelArb.getIcon((int)8);
        if (libs != null) {
            int n = libs.length;
            int i = 0;
            while (i < n) {
                URLPath classPath;
                JLibraryDefinition libDef;
                JLibrary lib = libs[i];
                JTreeCellData libCellData = new JTreeCellData(libIcon, lib.getName(), true);
                libCellData.setUserObject((Object)lib);
                JMutableTreeNode libNode = new JMutableTreeNode(libCellData);
                configNode.add((MutableTreeNode)libNode);
                if (lib != null && (libDef = lib.getLibraryDefinition(jdkVer)) != null && (classPath = libDef.getClassPath()) != null) {
                    LibrarySelectionPanel.addArchiveNodes(libNode, classPath, archivesList);
                }
                ++i;
            }
        }
    }

    private static void addArchiveNodes(JMutableTreeNode libNode, URLPath classPath, List archivesList) {
        Icon jarIcon = OracleIcons.getIcon((String)"archivefile.png");
        URL[] entries = classPath.getEntries();
        int n = entries.length;
        int i = 0;
        while (i < n) {
            URL entry = entries[i];
            String name = URLFileSystem.getFileName((URL)entry);
            JTreeCellData archCellData = new JTreeCellData(jarIcon, name, true);
            archCellData.setUserObject((Object)entry);
            archCellData.setCheckBoxState(archivesList.contains(entry));
            JMutableTreeNode archNode = new JMutableTreeNode(archCellData);
            libNode.add((MutableTreeNode)archNode);
            ++i;
        }
    }
}

