/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.common;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import oracle.ide.Context;
import oracle.ide.compiler.Compiler;
import oracle.ide.model.DataContainer;
import oracle.ide.model.Dependable;
import oracle.ide.model.Element;
import oracle.ide.model.Folder;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.util.Assert;
import oracle.jdeveloper.deploy.DeployException;
import oracle.jdeveloper.deploy.DeployShell;
import oracle.jdeveloper.deploy.DeployShellFactory;
import oracle.jdeveloper.deploy.DeployUtil;
import oracle.jdeveloper.deploy.DeploymentConstants;
import oracle.jdeveloper.deploy.DeploymentManager;
import oracle.jdeveloper.deploy.dt.Profile;
import oracle.jdeveloper.deploy.res.DeployArb;
import oracle.jdevimpl.deploy.common.DependencyGraph;
import oracle.jdevimpl.deploy.res.LogArb;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModulePackagerImpl {
    private DependencyGraph _graph;

    public ModulePackagerImpl(int deploySequenceId, DeployShell shell) {
    }

    public void compileDependents(DeployShell dsh) throws DeployException {
        DataContainer[] containersToBuild;
        PrintWriter log = dsh.getLog();
        boolean needToCompile = dsh.getFlag("isCompileBeforeDeploy");
        if (needToCompile && !ModulePackagerImpl.buildAll((Node[])(containersToBuild = this.getBuildDataContainers()), dsh)) {
            log.println(LogArb.getString(14));
            log.println(LogArb.getString(10));
            throw new DeployException(LogArb.getString(14));
        }
    }

    public void createDependencyGraph(DeployShell dsh) throws DeployException {
        PrintWriter log = dsh.getLog();
        if (Boolean.TRUE.equals(dsh.get("ignoreDependencies"))) {
            return;
        }
        try {
            log.println(DeployArb.getString(88));
            this._graph = new DependencyGraph(DeployUtil.getProfile(dsh));
            this.printDependencyGraphErrors(dsh);
        }
        catch (IllegalAccessException e) {
            throw new DeployException(e);
        }
        catch (InstantiationException e) {
            throw new DeployException(e);
        }
    }

    public Profile[] getProfilesFromGraph(DeployShell shell) {
        boolean ignoreDependencies = Boolean.TRUE.equals(shell.get("ignoreDependencies"));
        Profile[] profiles = ignoreDependencies ? new Profile[]{DeployUtil.getProfile(shell)} : this.getDependencyGraph().getProfiles();
        return profiles;
    }

    public void deployProfiles(Profile[] profiles, DeployShell shell) throws DeployException {
        DeployShellFactory shellFactory = shell.getDeployShellFactory();
        Assert.check((profiles.length != 0 ? 1 : 0) != 0, (String)"No Profiles to deploy");
        Profile[] profileArray = profiles;
        int n = 0;
        while (n < profileArray.length) {
            Profile profile = profileArray[n];
            int deploySequence = DeploymentConstants.DEFAULT_SEQUENCE;
            Context context = new Context(shell.getContext());
            DeployUtil.setProfile(context, profile);
            DeployShell childShell = shellFactory.create(deploySequence, context, shell);
            try {
                DeploymentManager.deploy(deploySequence, childShell);
            }
            catch (DeployException e) {
                throw e;
            }
            catch (Exception e) {
                throw new DeployException(e);
            }
            ++n;
        }
    }

    protected DependencyGraph getDependencyGraph() {
        return this._graph;
    }

    private static boolean buildAll(Node[] containers, DeployShell dsh) throws DeployException {
        if (containers == null || containers.length <= 0) {
            return true;
        }
        try {
            dsh.getLog().println(DeployArb.getString(44));
            Context buildContext = ModulePackagerImpl.newContext(containers[0], dsh);
            buildContext.setSelection((Element[])containers);
            boolean shouldClean = dsh.getFlag("isCleanBeforeCompile");
            if (shouldClean) {
                Compiler.getCompiler().clean(buildContext, true, (OutputStream)System.out, (OutputStream)System.err);
            }
            boolean bl = Compiler.getCompiler().compile(buildContext, false, true, true);
            return bl;
        }
        catch (Exception e) {
            throw new DeployException(e);
        }
    }

    private static Context newContext(Node container, DeployShell dsh) {
        Context buildContext = new Context(container);
        if (container instanceof Project) {
            buildContext.setProject((Project)container);
        } else if (container instanceof Workspace) {
            buildContext.setWorkspace((Workspace)container);
        }
        if (dsh.getFlag("isAssembly")) {
            buildContext.setProperty("is-j2ee-application-assembly", (Object)Boolean.TRUE);
        }
        buildContext.setProperty("deploy-context-log", (Object)dsh.getLog());
        return buildContext;
    }

    protected DataContainer[] getBuildDataContainers() {
        Dependable[] allDependables = this._graph.getAllDependables();
        ArrayList<URL> seen = new ArrayList<URL>();
        ArrayList<DataContainer> containers = new ArrayList<DataContainer>();
        Dependable[] dependableArray = allDependables;
        int n = 0;
        while (n < dependableArray.length) {
            DataContainer dc;
            Dependable dep = dependableArray[n];
            Element source = dep.getSource();
            Folder owner = dep.getSourceOwner();
            Object elementToAdd = null;
            if (source instanceof DataContainer) {
                elementToAdd = owner instanceof DataContainer && !seen.contains(((DataContainer)owner).getURL()) ? owner : source;
            } else if (owner instanceof DataContainer) {
                elementToAdd = owner;
            }
            if (elementToAdd != null && !seen.contains((dc = (DataContainer)elementToAdd).getURL())) {
                containers.add(dc);
                seen.add(dc.getURL());
            }
            ++n;
        }
        ArrayList<DataContainer> dc = ModulePackagerImpl.sanitizeBuildDataContainers(containers, true);
        return dc.toArray(new DataContainer[dc.size()]);
    }

    protected void printDependencyGraphErrors(DeployShell shell) {
        PrintWriter log = shell.getLog();
        Exception[] exceptionArray = this._graph.getExceptions();
        int n = 0;
        while (n < exceptionArray.length) {
            Exception e = exceptionArray[n];
            if (e instanceof DependencyGraph.DependencyCycleException) {
                log.println(e.getMessage());
            } else {
                e.printStackTrace(log);
            }
            ++n;
        }
    }

    private static ArrayList<DataContainer> sanitizeBuildDataContainers(ArrayList<DataContainer> containers, boolean removeWorkspace) {
        ArrayList<URL> seen = new ArrayList<URL>();
        ArrayList<DataContainer> newList = new ArrayList<DataContainer>();
        for (DataContainer dc : containers) {
            if (dc instanceof Workspace && !removeWorkspace) {
                Workspace ws = (Workspace)dc;
                Iterator iter = ws.getChildren();
                while (iter.hasNext()) {
                    Object o = iter.next();
                    if (!(o instanceof Project) || seen.contains(((DataContainer)o).getURL())) continue;
                    newList.add((DataContainer)o);
                    seen.add(((DataContainer)o).getURL());
                }
                continue;
            }
            if (!(dc instanceof Project) || seen.contains(dc.getURL())) continue;
            newList.add(dc);
            seen.add(dc.getURL());
        }
        return newList;
    }
}

