/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.common;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.net.URL;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controls.GridBagConstants;
import oracle.ide.controls.JWrappedLabel;
import oracle.ide.controls.tree.CustomJTree;
import oracle.ide.controls.tree.JMutableTreeNode;
import oracle.ide.controls.tree.JTreeCellData;
import oracle.ide.index.Index;
import oracle.ide.index.IndexManager;
import oracle.ide.index.QueryCriteria;
import oracle.ide.index.task.BackgroundTask;
import oracle.ide.model.DataContainer;
import oracle.ide.model.Dependable;
import oracle.ide.model.Element;
import oracle.ide.model.Folder;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.Namespace;
import oracle.ide.util.ResourceUtils;
import oracle.ide.util.SwingWorker;
import oracle.ide.util.TriStateBoolean;
import oracle.javatools.data.HashStructure;
import oracle.javatools.dialogs.progress.IndeterminateProgressMonitor;
import oracle.javatools.icons.OracleIcons;
import oracle.jdeveloper.deploy.DeployUtil;
import oracle.jdeveloper.deploy.common.Interdependency;
import oracle.jdeveloper.deploy.dt.AbstractHashDependable;
import oracle.jdeveloper.deploy.dt.Deployment;
import oracle.jdeveloper.deploy.dt.DeploymentProfiles;
import oracle.jdeveloper.deploy.dt.Profile;
import oracle.jdeveloper.deploy.jar.ArchiveProfile;
import oracle.jdevimpl.deploy.common.CommonEditor;
import oracle.jdevimpl.deploy.res.CommonArb;
import oracle.jdevimpl.jar.JarNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ProfileDepsPanel
extends DefaultTraversablePanel
implements GridBagConstants {
    protected final JMutableTreeNode _root;
    protected final CustomJTree _tree;

    private void $init$() {
        this._root = new JMutableTreeNode(new JTreeCellData(""));
        this._tree = new CustomJTree((TreeModel)new DefaultTreeModel((TreeNode)this._root));
    }

    public ProfileDepsPanel(String prompt) {
        this.$init$();
        this._tree.setRootVisible(false);
        JWrappedLabel promptTree = new JWrappedLabel(prompt);
        JLabel lblTree = new JLabel();
        ResourceUtils.resLabel((JLabel)lblTree, (Component)this._tree, (String)CommonArb.getString(54));
        JScrollPane spTree = new JScrollPane();
        spTree.setMinimumSize(new Dimension(10, 10));
        spTree.setPreferredSize(new Dimension(10, 10));
        this._tree.setMinimumSize(new Dimension(10, 10));
        spTree.getViewport().add((Component)this._tree, null);
        this.setLayout(new GridBagLayout());
        Insets in5555 = new Insets(5, 5, 5, 5);
        this.add((Component)promptTree, this.gbc(0, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 5, 5)));
        this.add(lblTree, this.gbc(0, 1, 1, 1, 0.0, 0.0, 18, 2, new Insets(10, 5, 0, 5)));
        this.add(spTree, this.gbc(0, 2, 1, 1, 1.0, 1.0, 18, 1, in5555));
    }

    public void onEntry(TraversableContext tc) {
        Dependable[] dependables = this.getDependables(tc);
        ArrayList<Dependable> dependableList = new ArrayList<Dependable>();
        if (dependables != null) {
            dependableList.addAll(Arrays.asList(dependables));
        }
        this._root.removeAllChildren();
        this._tree.setModel((TreeModel)new DefaultTreeModel((TreeNode)this._root));
        IdeUtil.expandAllTreeRows((JTree)this._tree);
        this._root.descendingUpdateNodes();
        DataContainer dc = this.getProfile(tc).getDataContainer();
        if (dc instanceof Workspace) {
            Workspace ws = (Workspace)dc;
            this._root.getModel().setUserObject((Object)ws);
            URL workspaceURL = ws.getURL();
            this.addChildren(tc, dependableList, workspaceURL, (Element)ws, this._root);
        }
        IndeterminateProgressMonitor progressMonitor = new IndeterminateProgressMonitor((Component)Ide.getMainWindow(), CommonArb.getString(32));
        progressMonitor.setMillisToPopup(1000);
        progressMonitor.setCancellable(true);
        progressMonitor.setCloseOnFinish(true);
        progressMonitor.start();
        1 swingWorker = new 1(this, tc, progressMonitor, dependableList);
        swingWorker.start();
    }

    protected Dependable getDependableFromList(Dependable dependable, ArrayList<Dependable> dependableList) {
        for (Dependable dep : dependableList) {
            if (dep instanceof AbstractHashDependable) {
                HashStructure hsFromFactory = ((AbstractHashDependable)dependable).getHashStructure().copyTo(null);
                HashStructure hsFromProfile = ((AbstractHashDependable)dep).getHashStructure().copyTo(null);
                hsFromProfile.remove("pathInEar");
                hsFromFactory.remove("pathInEar");
                if (!hsFromFactory.equals((Object)hsFromProfile)) continue;
                return dep;
            }
            if (!dep.equals(dependable)) continue;
            return dep;
        }
        return null;
    }

    private void addElementDependables(Element elem, DataContainer container, List dependableList) {
        Iterator children = elem.getChildren();
        while (children != null && children.hasNext()) {
            Element child = (Element)children.next();
            Dependable dependable = this.getDependable(child, container);
            if (dependable == null) continue;
            dependableList.add(dependable);
        }
    }

    private void addJarNodeDependables(DataContainer container, List dependableList) {
        block11: {
            if (container instanceof Project) {
                Index index = IndexManager.getIndexManager().getIndex((Project)container);
                QueryCriteria criteria = new QueryCriteria();
                criteria.put((Object)"file.extension", (Object)".jar|.war|.mar|.rar");
                BackgroundTask query = index.query(criteria);
                try {
                    try {
                        URL[] results;
                        URL[] uRLArray = results = (URL[])query.get();
                        int n = 0;
                        while (n < uRLArray.length) {
                            URL url = uRLArray[n];
                            try {
                                Dependable dependable;
                                Node node = NodeFactory.findOrCreate((URL)url);
                                if (node instanceof Element && (dependable = this.getDependable((Element)node, container)) != null) {
                                    dependableList.add(dependable);
                                }
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                            ++n;
                        }
                        break block11;
                    }
                    catch (Exception e) {
                        index.release();
                        return;
                    }
                }
                finally {
                    index.release();
                }
            }
            this.addElementDependables((Element)container, container, dependableList);
        }
    }

    private Iterator getIterator(Element elem) {
        if (elem.mayHaveChildren()) {
            ArrayList dependableList = new ArrayList();
            if (elem instanceof DataContainer) {
                DataContainer container = (DataContainer)elem;
                DeploymentProfiles deploymentProfiles = DeploymentProfiles.getInstance(container);
                this.addElementDependables(deploymentProfiles, container, dependableList);
                this.addJarNodeDependables(container, dependableList);
            } else if (elem instanceof Profile) {
                Profile containerProfile = (Profile)elem;
                this.addElementDependables(elem, containerProfile.getDataContainer(), dependableList);
            }
            return dependableList.iterator();
        }
        return null;
    }

    protected void addChildren(TraversableContext tc, ArrayList<Dependable> dependableList, URL containerURL, Element parentElem, JMutableTreeNode parentTreeNode) {
        ArrayList<JMutableTreeNode> childrenToAdd = new ArrayList<JMutableTreeNode>();
        Object data = parentElem.getData();
        if (data instanceof DataContainer || data instanceof Profile) {
            Element parent = (Element)data;
            Iterator profileIter = this.getIterator(parent);
            while (profileIter != null && profileIter.hasNext()) {
                Dependable dependable = (Dependable)profileIter.next();
                JTreeCellData cellData = this.getTreeCellData(tc, parentElem, dependable.getSource());
                if (cellData == null) continue;
                Dependable dep = this.getDependableFromList(dependable, dependableList);
                if (dep != null) {
                    cellData.setCheckBoxState(true);
                } else {
                    dep = dependable;
                }
                cellData.setUserObject((Object)dep);
                JMutableTreeNode childTreeNode = new JMutableTreeNode(cellData);
                this.addChildren(tc, dependableList, containerURL, dependable.getSource(), childTreeNode);
                if (!cellData.getHasCheckBox() && childTreeNode.getChildCount() <= 0) continue;
                childrenToAdd.add(childTreeNode);
            }
        }
        if (childrenToAdd.size() > 0) {
            Collections.sort(childrenToAdd, new JMTNComparator());
            Iterator addIter = childrenToAdd.iterator();
            while (addIter.hasNext()) {
                parentTreeNode.add((MutableTreeNode)((JMutableTreeNode)addIter.next()));
            }
        }
    }

    public void onExit(TraversableContext tc) {
        Dependable[] dependables = this.gatherCheckedDependables(this._root);
        this.setDependables(tc, dependables);
    }

    private Dependable[] gatherCheckedDependables(JMutableTreeNode node) {
        ArrayList<Dependable> deps = new ArrayList<Dependable>();
        if (this.isCheckableNode(node)) {
            if (this.isChecked(node)) {
                deps.add(this.getDependable(node));
            }
        } else {
            Enumeration en = node.children();
            while (en.hasMoreElements()) {
                JMutableTreeNode childTreeNode = (JMutableTreeNode)en.nextElement();
                deps.addAll(Arrays.asList(this.gatherCheckedDependables(childTreeNode)));
            }
        }
        return deps.toArray(new Dependable[deps.size()]);
    }

    private Dependable getDependable(Element elem, DataContainer container) {
        try {
            Dependable dependable = Deployment.getDependableFactory().findOrCreate(elem, (Folder)container);
            return dependable;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        return null;
    }

    protected final Dependable getDependable(JMutableTreeNode profileNode) {
        JTreeCellData cellData = profileNode.getModel();
        return (Dependable)cellData.getUserObject();
    }

    protected final JMutableTreeNode getContainerNode(JMutableTreeNode profileNode) {
        JMutableTreeNode containerNode = (JMutableTreeNode)profileNode.getParent();
        while (containerNode != null && !(containerNode.getModel().getUserObject() instanceof DataContainer)) {
            containerNode = (JMutableTreeNode)containerNode.getParent();
        }
        return containerNode;
    }

    protected final URL getContainerURL(JMutableTreeNode node) {
        JTreeCellData cellData;
        Object userObject;
        Object nodeInfo = node.getUserObject();
        if (nodeInfo instanceof JTreeCellData && (userObject = (cellData = (JTreeCellData)nodeInfo).getUserObject()) instanceof DataContainer) {
            return ((DataContainer)userObject).getURL();
        }
        throw new RuntimeException("not a container node");
    }

    protected final URL getProfileURL(JMutableTreeNode profileNode) {
        JMutableTreeNode containerNode = this.getContainerNode(profileNode);
        URL containerURL = this.getContainerURL(containerNode);
        return this.getProfileURL(containerURL, profileNode);
    }

    protected final URL getProfileURL(URL containerURL, JMutableTreeNode profileNode) {
        JTreeCellData profileCellData = profileNode.getModel();
        Object userObject = profileCellData.getUserObject();
        if (userObject instanceof Profile) {
            Profile profile = (Profile)userObject;
            JMutableTreeNode containerNode = (JMutableTreeNode)profileNode.getParent();
            Object parent = containerNode.getModel().getUserObject();
            return DeployUtil.getProfileURL(containerURL, profile);
        }
        if (userObject instanceof Locatable) {
            return ((Locatable)userObject).getURL();
        }
        return null;
    }

    protected final boolean isCheckableNode(JMutableTreeNode node) {
        JTreeCellData cellData = node.getModel();
        return cellData.getHasCheckBox();
    }

    protected final boolean isChecked(JMutableTreeNode node) {
        JTreeCellData cellData = node.getModel();
        return cellData.getCheckBoxState() == TriStateBoolean.TRUE;
    }

    protected final void setCheck(JMutableTreeNode node, boolean checked) {
        JTreeCellData cellData = node.getModel();
        cellData.setCheckBoxState(checked);
    }

    protected final DataContainer dereferenceContainerNode(JMutableTreeNode node) {
        JTreeCellData cellData = node.getModel();
        return (DataContainer)cellData.getUserObject();
    }

    protected final Profile dereferenceProfileNode(JMutableTreeNode node) {
        JTreeCellData cellData = node.getModel();
        return (Profile)cellData.getUserObject();
    }

    protected final Dependable getSelectedDependable() {
        JMutableTreeNode node = (JMutableTreeNode)this._tree.getLastSelectedPathComponent();
        if (node == null) {
            return null;
        }
        if (this.isCheckableNode(node)) {
            return this.getDependable(node);
        }
        return null;
    }

    protected final boolean isSelectedProfileChecked() {
        JMutableTreeNode node = (JMutableTreeNode)this._tree.getLastSelectedPathComponent();
        if (node == null) {
            return false;
        }
        return this.isCheckableNode(node) && this.isChecked(node);
    }

    protected JTreeCellData createJTreeCellData(Element elem, boolean hasCheckBox) {
        JTreeCellData treeCellData = new JTreeCellData(elem.getIcon(), elem.getShortLabel(), hasCheckBox);
        treeCellData.setToolTipText(elem.getToolTipText());
        return treeCellData;
    }

    protected JTreeCellData getTreeCellData(TraversableContext tc, Element parentElem, Element elem) {
        if (this.isSelectableData(tc, parentElem, elem)) {
            return this.createJTreeCellData(elem, true);
        }
        if (Deployment.isDeploymentContainerProfile(elem)) {
            return this.createJTreeCellData(elem, false);
        }
        return null;
    }

    protected boolean isSelf(TraversableContext tc, Element parentElem, Element elem) {
        if (elem instanceof Profile) {
            Context context = CommonEditor.getContext((Namespace)tc);
            Profile editedProfile = (Profile)context.getProperty("edited-profile");
            return editedProfile.equals((Profile)elem);
        }
        return false;
    }

    protected static boolean isPlainJar(Object data) {
        if (data instanceof ArchiveProfile) {
            ArchiveProfile profile = (ArchiveProfile)data;
            return profile.isClasspathJar();
        }
        if (data instanceof JarNode) {
            JarNode jarNode = (JarNode)data;
            URL jarURL = jarNode.getURL();
            String suffix = URLFileSystem.getSuffix((URL)jarURL);
            return ".jar".equals(suffix);
        }
        return false;
    }

    protected abstract boolean isSelectableData(TraversableContext var1, Element var2, Element var3);

    protected Dependable[] getDependables(TraversableContext tc) {
        Profile profile = this.getProfile(tc);
        return DeployUtil.getDependables((Interdependency)profile, Dependable.class);
    }

    protected void setDependables(TraversableContext tc, Dependable[] dependables) {
        Profile profile = this.getProfile(tc);
        DeployUtil.setDependencies(profile, dependables);
    }

    protected abstract Profile getProfile(TraversableContext var1);

    final class oracle.jdevimpl.deploy.common.ProfileDepsPanel$1
    extends SwingWorker {
        private final /* synthetic */ TraversableContext v$tc;
        private final /* synthetic */ IndeterminateProgressMonitor v$progressMonitor;
        private final /* synthetic */ ArrayList v$dependableList;
        final /* synthetic */ ProfileDepsPanel this$0;

        public Object construct() {
            Project tcProject = (Project)CommonEditor.getProject((Namespace)this.v$tc);
            Node workspace = CommonEditor.getWorkspace((Namespace)this.v$tc);
            if (workspace != null) {
                Iterator wspIter = workspace.getChildren();
                Icon projIcon = OracleIcons.getIcon((String)"project.png");
                while (wspIter.hasNext() && !this.v$progressMonitor.isCancelled()) {
                    Node project = (Node)wspIter.next();
                    if (tcProject != null && ModelUtil.areEqual((Object)project.getURL(), (Object)tcProject.getURL())) {
                        project = tcProject;
                    }
                    Project currentProject = (Project)project;
                    URL projectURL = project.getURL();
                    JTreeCellData projData = new JTreeCellData(projIcon, project.getShortLabel(), false);
                    projData.setToolTipText(project.getToolTipText());
                    projData.setUserObject((Object)project);
                    JMutableTreeNode projNode = new JMutableTreeNode(projData);
                    this.this$0._root.add((MutableTreeNode)projNode);
                    EventQueue.invokeLater(new 1(this, currentProject));
                    this.this$0.addChildren(this.v$tc, this.v$dependableList, projectURL, (Element)project, projNode);
                }
            }
            return null;
        }

        public void finished() {
            this.v$progressMonitor.close();
            this.this$0._tree.setModel((TreeModel)new DefaultTreeModel((TreeNode)this.this$0._root));
            IdeUtil.expandAllTreeRows((JTree)this.this$0._tree);
            this.this$0._root.descendingUpdateNodes();
        }

        public oracle.jdevimpl.deploy.common.ProfileDepsPanel$1(ProfileDepsPanel profileDepsPanel, TraversableContext traversableContext, IndeterminateProgressMonitor indeterminateProgressMonitor, ArrayList arrayList) {
            this.v$dependableList = arrayList;
            this.v$progressMonitor = indeterminateProgressMonitor;
            this.v$tc = traversableContext;
            this.this$0 = profileDepsPanel;
        }

        static IndeterminateProgressMonitor ra$v$progressMonitor(oracle.jdevimpl.deploy.common.ProfileDepsPanel$1 var0) {
            return var0.v$progressMonitor;
        }

        final class 1
        implements Runnable {
            private final /* synthetic */ Project v$currentProject;
            final /* synthetic */ oracle.jdevimpl.deploy.common.ProfileDepsPanel$1 this$0;

            public void run() {
                oracle.jdevimpl.deploy.common.ProfileDepsPanel$1.ra$v$progressMonitor(this.this$0).getPanel().setNote(CommonArb.getString(40) + " " + this.v$currentProject.getShortLabel());
            }

            public 1(oracle.jdevimpl.deploy.common.ProfileDepsPanel$1 var1_1, Project project) {
                this.v$currentProject = project;
                this.this$0 = var1_1;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class JMTNComparator
    implements Comparator {
        private final Collator _collator;

        private void $init$() {
            this._collator = Collator.getInstance();
        }

        public int compare(Object o1, Object o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            JMutableTreeNode node1 = (JMutableTreeNode)o1;
            JMutableTreeNode node2 = (JMutableTreeNode)o2;
            return this._collator.compare(node1.getModel().getText(), node2.getModel().getText());
        }

        @Override
        public boolean equals(Object o) {
            return o != null && o.getClass() == this.getClass();
        }

        protected JMTNComparator() {
            this.$init$();
        }
    }
}

