/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.common;

import java.awt.Font;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Namespace;
import oracle.ide.util.ResourceUtils;
import oracle.jdeveloper.deploy.common.FileGroup;
import oracle.jdeveloper.deploy.common.LibraryFileGroup;
import oracle.jdeveloper.deploy.common.PackagingFileGroup;
import oracle.jdeveloper.deploy.common.SelectionRule;
import oracle.jdeveloper.deploy.common.SelectionRules;
import oracle.jdevimpl.deploy.common.FileGroupsEditor;
import oracle.jdevimpl.deploy.res.CommonArb;
import oracle.jdevimpl.deploy.res.WarArb;
import oracle.jdevimpl.xml.ArrayElementList;
import oracle.jdevimpl.xml.DetailPanel;
import oracle.jdevimpl.xml.MasterPanel;

public class SelectionRulesPanel
extends MasterPanel {
    private int lastRuleType;
    private transient ArrayElementList _ruleList;

    private void $init$() {
        this.lastRuleType = 0;
    }

    public SelectionRulesPanel() {
        super(CommonArb.getString(5), "f1_depfgpkgpatternfilter_html", true);
        this.$init$();
        this.setListFont(new Font("Monospaced", 0, 12));
    }

    protected void onEntryImpl(TraversableContext tc) {
        SelectionRules selectionRules;
        FileGroup fg = FileGroupsEditor.getFileGroup((Namespace)tc);
        switch (fg.type()) {
            case 1: {
                PackagingFileGroup pfg = (PackagingFileGroup)fg;
                selectionRules = pfg.getFilters();
                break;
            }
            case 3: {
                LibraryFileGroup lfg = (LibraryFileGroup)fg;
                selectionRules = lfg.getFilters();
                break;
            }
            default: {
                SelectionRulesPanel.dumpUnknownFileGroupTypeException(fg);
                selectionRules = new SelectionRules();
                break;
            }
        }
        Object[] rules = selectionRules.getRules();
        this._ruleList = new ArrayElementList(SelectionRule.class, rules);
        this.setElementList(this._ruleList);
    }

    protected void onExitImpl(TraversableContext tc) {
        SelectionRules selectionRules;
        FileGroup fg = FileGroupsEditor.getFileGroup((Namespace)tc);
        switch (fg.type()) {
            case 1: {
                PackagingFileGroup pfg = (PackagingFileGroup)fg;
                selectionRules = pfg.getFilters();
                break;
            }
            case 3: {
                LibraryFileGroup lfg = (LibraryFileGroup)fg;
                selectionRules = lfg.getFilters();
                break;
            }
            default: {
                SelectionRulesPanel.dumpUnknownFileGroupTypeException(fg);
                selectionRules = new SelectionRules();
            }
        }
        selectionRules.setRules((SelectionRule[])this._ruleList.getData());
    }

    protected String getElementListItemKey() {
        return "selection-rule";
    }

    protected DetailPanel newCreatePanel() {
        return new Details(true);
    }

    protected boolean prependNewItems() {
        return true;
    }

    protected Traversable newDetailPanel() {
        return new Details(false);
    }

    protected String getDisplayName(Object data) {
        return data != null ? data.toString() : CommonArb.getString(102);
    }

    protected boolean showUpDownButtons() {
        return true;
    }

    static void dumpUnknownFileGroupTypeException(FileGroup fg) {
        new Exception(CommonArb.format(85, Integer.toString(fg.type()))).printStackTrace();
    }

    static int ra$lastRuleType(SelectionRulesPanel selectionRulesPanel) {
        return selectionRulesPanel.lastRuleType;
    }

    private class Details
    extends DetailPanel {
        private final JRadioButton rbInclude;
        private final JRadioButton rbExclude;
        private final ButtonGroup group;
        private final JTextField tfPattern;
        private transient SelectionRule _curRule;

        private void $init$() {
            this.rbInclude = new JRadioButton();
            this.rbExclude = new JRadioButton();
            this.group = new ButtonGroup();
        }

        Details(boolean isForDialog) {
            super(isForDialog, "f1_depfgdlgselpat_html");
            this.$init$();
            ResourceUtils.resButton((AbstractButton)this.rbInclude, (String)CommonArb.getString(94));
            ResourceUtils.resButton((AbstractButton)this.rbExclude, (String)CommonArb.getString(17));
            this.group.add(this.rbInclude);
            this.group.add(this.rbExclude);
            if (isForDialog) {
                switch (SelectionRulesPanel.ra$lastRuleType(SelectionRulesPanel.this)) {
                    case 1: {
                        this.rbExclude.setSelected(true);
                        break;
                    }
                    default: {
                        this.rbInclude.setSelected(true);
                        break;
                    }
                }
            }
            this.addLabeledPanel(CommonArb.getString(6), new JRadioButton[]{this.rbInclude, this.rbExclude});
            this.tfPattern = this.addWatchedTextField(WarArb.getString(135));
            this.tfPattern.setFont(new Font("Monospaced", 0, 12));
        }

        protected void onEntryImpl(TraversableContext tc, Object data) {
            this._curRule = (SelectionRule)data;
            int ruleType = this._curRule.getType();
            switch (ruleType) {
                case 1: {
                    this.rbExclude.setSelected(true);
                    break;
                }
                default: {
                    this.rbInclude.setSelected(true);
                    break;
                }
            }
            this.tfPattern.setText(this._curRule.getPattern());
            this.tieTextComponentToMasterList(this.tfPattern, tc);
            this.tieItemSelectableToMasterList(this.rbInclude, tc);
            this.tieItemSelectableToMasterList(this.rbExclude, tc);
        }

        protected void onExitImpl(TraversableContext tc, Object data) throws TraversalException {
            this.untieItemSelectableFromMasterList(this.rbInclude);
            this.untieItemSelectableFromMasterList(this.rbExclude);
            this.untieTextComponentFromMasterList(this.tfPattern);
            SelectionRule rule = (SelectionRule)data;
            rule.setType(this.getSelectedType());
            rule.setPattern(this.tfPattern.getText());
        }

        private int getSelectedType() {
            return this.rbExclude.isSelected() ? 1 : 0;
        }

        protected String getDialogTitle() {
            return WarArb.getString(63);
        }

        protected void flushPrimaryTextComponent() {
            this._curRule.setType(this.getSelectedType());
            this._curRule.setPattern(this.tfPattern.getText());
        }
    }
}

