/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.common;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.controls.GridBagConstants;
import oracle.ide.controls.JWrappedLabel;
import oracle.ide.controls.WaitCursor;
import oracle.ide.controls.tree.CustomJTree;
import oracle.ide.controls.tree.JMutableTreeNode;
import oracle.ide.controls.tree.JTreeCellData;
import oracle.ide.controls.tree.TreeCellCheckedEvent;
import oracle.ide.controls.tree.TreeCellCheckedListener;
import oracle.ide.model.Project;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.Namespace;
import oracle.ide.util.SwingWorker;
import oracle.ide.util.TriStateBoolean;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.deploy.DeployUtil;
import oracle.jdeveloper.deploy.common.Contributor;
import oracle.jdeveloper.deploy.common.FileGroup;
import oracle.jdeveloper.deploy.common.FileGroupPackager;
import oracle.jdeveloper.deploy.common.LibraryFileGroup;
import oracle.jdeveloper.deploy.common.PackagingFileGroup;
import oracle.jdeveloper.deploy.common.SelectionRules;
import oracle.jdevimpl.deploy.common.CommonEditor;
import oracle.jdevimpl.deploy.common.FileGroupsEditor;
import oracle.jdevimpl.deploy.common.SelectionRulesPanel;
import oracle.jdevimpl.deploy.common.URLNodeComparator;
import oracle.jdevimpl.deploy.res.CommonArb;

public class SelectionRulesTreePanel
extends DefaultTraversablePanel
implements GridBagConstants,
TreeWillExpandListener,
TreeCellCheckedListener,
ActionListener {
    private final JWrappedLabel _hintText;
    private final JScrollPane _spFiles;
    private final JMutableTreeNode _root;
    private final DefaultTreeModel _treeModel;
    private final CustomJTree _dirTree;
    private final URLNodeComparator _urlComparator;
    private SelectionRules _selectionRules;
    private URLNode _rootURLNode;
    private JButton _expandBtn;
    private JButton _collapseBtn;
    private transient URLPath _contribPath;
    private transient boolean _isLibraryFileGroup;
    private static final String CONTRIB_URLPATH = "contrib-URLPath";

    private void $init$() {
        this._hintText = new JWrappedLabel();
        this._spFiles = new JScrollPane();
        this._root = new JMutableTreeNode();
        this._treeModel = new DefaultTreeModel((TreeNode)this._root, true);
        this._dirTree = new CustomJTree((TreeModel)this._treeModel);
        this._urlComparator = new URLNodeComparator();
    }

    public SelectionRulesTreePanel() {
        this.$init$();
        this._hintText.setText(CommonArb.getString(81));
        this._hintText.setForeground(Color.blue);
        this._spFiles.getViewport().add((Component)this._dirTree, null);
        this._dirTree.setRootVisible(false);
        this._dirTree.addTreeCellCheckedListener((TreeCellCheckedListener)this);
        this._dirTree.addTreeWillExpandListener((TreeWillExpandListener)this);
        this._dirTree.enableToolTips(true);
        this.setLayout(new GridBagLayout());
        Insets in5555 = new Insets(5, 5, 5, 5);
        this.add((Component)this._hintText, this.gbc(0, 0, 2, 1, 1.0, 0.0, 18, 2, in5555));
        this.add(this._spFiles, this.gbc(0, 1, 2, 1, 1.0, 1.0, 18, 1, in5555));
        this.setHelpID("f1_depfgpkgfilefilter_html");
        String text = CommonArb.getString(42);
        this._expandBtn = new JButton(StringUtils.stripMnemonic((String)text));
        this._expandBtn.setMnemonic(StringUtils.getMnemonicKeyCode((String)text));
        this._expandBtn.addActionListener(this);
        this.add(this._expandBtn, this.gbc(0, 2, 1, 1, 1.0, 0.0, 10, 0, in5555));
        text = CommonArb.getString(1);
        this._collapseBtn = new JButton(StringUtils.stripMnemonic((String)text));
        this._collapseBtn.setMnemonic(StringUtils.getMnemonicKeyCode((String)text));
        this._collapseBtn.addActionListener(this);
        this.add(this._collapseBtn, this.gbc(1, 2, 1, 1, 1.0, 0.0, 10, 0, in5555));
    }

    public void onEntry(TraversableContext tc) {
        Context context = CommonEditor.getContext((Namespace)tc);
        Object container = context != null ? DeployUtil.getProfileDataContainer(context) : (Project)CommonEditor.getProject((Namespace)tc);
        FileGroup fg = FileGroupsEditor.getFileGroup((Namespace)tc);
        switch (fg.type()) {
            case 1: {
                PackagingFileGroup pfg = (PackagingFileGroup)fg;
                this.updateHintTextVisibility(pfg);
                this._selectionRules = pfg.getFilters();
                this._contribPath = FileGroupsEditor.getContribPath(pfg, container);
                break;
            }
            case 3: {
                this._hintText.setVisible(false);
                LibraryFileGroup lfg = (LibraryFileGroup)fg;
                this._selectionRules = lfg.getFilters();
                this._contribPath = FileGroupsEditor.getContribPath(lfg, (Project)container);
                break;
            }
            default: {
                SelectionRulesPanel.dumpUnknownFileGroupTypeException(fg);
                this._selectionRules = new SelectionRules();
                this._contribPath = new URLPath();
                break;
            }
        }
        URLPath contribPath = (URLPath)tc.find(CONTRIB_URLPATH);
        if (this._contribPath != null && ModelUtil.areEqual((Object)this._contribPath, (Object)contribPath)) {
            this.updateCheckedStates(this._rootURLNode);
            return;
        }
        tc.put(CONTRIB_URLPATH, (Object)this._contribPath);
        this._isLibraryFileGroup = fg.type() == 3;
        this._rootURLNode = new URLNode();
        this._root.removeAllChildren();
        this._root.add((MutableTreeNode)((Object)this._rootURLNode));
        this._treeModel.nodeStructureChanged((TreeNode)this._root);
        IdeUtil.expandTreeToDepth((JTree)this._dirTree, (int)3);
        this.updateCheckedStates(this._rootURLNode);
    }

    public void onExit(TraversableContext tc) {
        FileGroup fg = FileGroupsEditor.getFileGroup((Namespace)tc);
        switch (fg.type()) {
            case 1: {
                PackagingFileGroup pfg = (PackagingFileGroup)fg;
                pfg.setFilters(this._selectionRules);
                break;
            }
            case 3: {
                LibraryFileGroup lfg = (LibraryFileGroup)fg;
                lfg.setFilters(this._selectionRules);
                break;
            }
        }
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource().equals(this._expandBtn)) {
            this._dirTree.expandAllRows();
        } else if (evt.getSource().equals(this._collapseBtn)) {
            int i = this._dirTree.getRowCount() - 1;
            while (i >= 0) {
                this._dirTree.collapseRow(i);
                --i;
            }
        }
    }

    public void treeWillExpand(TreeExpansionEvent e) {
        TreePath tp = e.getPath();
        URLNode node = (URLNode)((Object)tp.getLastPathComponent());
        node.maybeLoad();
    }

    public void treeWillCollapse(TreeExpansionEvent e) {
    }

    public void cellChecked(TreeCellCheckedEvent e) {
        this.handleCheck(e, true);
    }

    public void cellUnchecked(TreeCellCheckedEvent e) {
        this.handleCheck(e, false);
    }

    private void handleCheck(TreeCellCheckedEvent e, boolean isInclude) {
        URLNode node = (URLNode)((Object)e.getSource());
        String name = URLNode.mav$isRootPath(node) ? "**" : this.toRelativePath(node.getURL());
        if (name != null) {
            if (this._selectionRules == null) {
                this._selectionRules = new SelectionRules();
            }
            if (isInclude) {
                this._selectionRules.addInclude(name, true);
            } else {
                this._selectionRules.addExclude(name, true);
            }
        }
    }

    private void updateHintTextVisibility(PackagingFileGroup pfg) {
        Contributor[] contributors = pfg.getContributors();
        if (contributors != null) {
            int n = contributors.length;
            int i = 0;
            while (i < n) {
                Contributor contrib = contributors[i];
                if (contrib != null && contrib.getType() == 2) {
                    this._hintText.setVisible(true);
                    return;
                }
                ++i;
            }
        }
        this._hintText.setVisible(false);
    }

    private void updateCheckedStates(URLNode node) {
        URL url = node.getURL();
        if (node.isLeaf()) {
            node.getModel().setCheckBoxState(this.isSelected(URLNode.ra$_path(node)));
            return;
        }
        if (node.isLoaded()) {
            Enumeration en = node.children();
            while (en.hasMoreElements()) {
                URLNode childNode = (URLNode)((Object)en.nextElement());
                if (childNode == null) continue;
                this.updateCheckedStates(childNode);
            }
            node.updateNodes();
        } else {
            TriStateBoolean checkBoxState = TriStateBoolean.FALSE;
            if (this._selectionRules != null) {
                checkBoxState = this._selectionRules.inferFromRules(this._contribPath.toRelativePath(url), true);
            }
            node.getModel().setCheckBoxState(checkBoxState);
        }
    }

    private String toRelativePath(URL url) {
        if (this._isLibraryFileGroup) {
            return this._contribPath.contains(url) ? URLFileSystem.getFileName((URL)url) : null;
        }
        return this._contribPath.toRelativePath(url);
    }

    private boolean isSelected(String relPath) {
        return this._selectionRules != null ? this._selectionRules.isIncluded(relPath) : false;
    }

    private TriStateBoolean isInitiallySelected(String relPath) {
        return this._selectionRules != null ? this._selectionRules.inferFromRules(relPath, true) : TriStateBoolean.FALSE;
    }

    private static String getLabel(String path) {
        if (path != null) {
            if (path.endsWith("/")) {
                int dirSlash = path.lastIndexOf(47);
                if (dirSlash > 0) {
                    int lastSlash = path.lastIndexOf(47, dirSlash - 1);
                    return path.substring(lastSlash >= 0 ? lastSlash + 1 : 0, dirSlash);
                }
            } else {
                int lastSlash = path.lastIndexOf("/");
                if (lastSlash >= 0) {
                    return path.substring(lastSlash + 1);
                }
            }
        }
        return path;
    }

    private static JTreeCellData newJTreeCellData(String path, URL url, String label) {
        String urlStr;
        JTreeCellData cellData = new JTreeCellData(label);
        if (url != null && ModelUtil.hasLength((String)(urlStr = URLFileSystem.getPlatformPathName((URL)url)))) {
            cellData.setToolTipText(urlStr);
        }
        return cellData;
    }

    static JTreeCellData maS$newJTreeCellData(String string, URL uRL, String string2) {
        return SelectionRulesTreePanel.newJTreeCellData(string, uRL, string2);
    }

    static TriStateBoolean mav$isInitiallySelected(SelectionRulesTreePanel selectionRulesTreePanel, String string) {
        return selectionRulesTreePanel.isInitiallySelected(string);
    }

    static String maS$getLabel(String string) {
        return SelectionRulesTreePanel.getLabel(string);
    }

    static String mav$toRelativePath(SelectionRulesTreePanel selectionRulesTreePanel, URL uRL) {
        return selectionRulesTreePanel.toRelativePath(uRL);
    }

    static DefaultTreeModel ra$_treeModel(SelectionRulesTreePanel selectionRulesTreePanel) {
        return selectionRulesTreePanel._treeModel;
    }

    static URLPath ra$_contribPath(SelectionRulesTreePanel selectionRulesTreePanel) {
        return selectionRulesTreePanel._contribPath;
    }

    static URLNodeComparator ra$_urlComparator(SelectionRulesTreePanel selectionRulesTreePanel) {
        return selectionRulesTreePanel._urlComparator;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class URLNode
    extends JMutableTreeNode {
        private final String _path;
        private final URL _url;
        private final boolean _isLeaf;
        private boolean _isLoaded;

        URLNode() {
            this("", null, CommonArb.getString(114));
        }

        URLNode(String path, URL url) {
            this(path, url, SelectionRulesTreePanel.maS$getLabel(path));
        }

        private URLNode(String path, URL url, String label) {
            super(SelectionRulesTreePanel.maS$newJTreeCellData(path, url, label));
            this._path = path;
            this._url = url;
            this._isLeaf = !this.isRootPath() && !URLFileSystem.isDirectoryPath((URL)this._url);
            this._treeCellData.setIcon(this._isLeaf ? UIManager.getIcon("FileView.fileIcon") : UIManager.getIcon("FileView.directoryIcon"));
            this._treeCellData.setCheckBoxState(SelectionRulesTreePanel.mav$isInitiallySelected(SelectionRulesTreePanel.this, path));
            this._treeCellData.setHasCheckBox(true);
        }

        private boolean isRootPath() {
            return "".equals(this._path);
        }

        public boolean getAllowsChildren() {
            return this._isLeaf ^ true;
        }

        public boolean isLeaf() {
            return this._isLeaf;
        }

        boolean isLoaded() {
            return this._isLoaded;
        }

        URL getURL() {
            return this._url;
        }

        void maybeLoad() {
            if (this._isLoaded || this._url == null && !this.isRootPath()) {
                return;
            }
            WaitCursor waitCursor = new WaitCursor((Component)((Object)SelectionRulesTreePanel.this));
            1 worker = new 1(this, waitCursor);
            waitCursor.show(400);
            this._isLoaded = true;
            worker.construct();
            worker.finished();
        }

        static String ra$_path(URLNode uRLNode) {
            return uRLNode._path;
        }

        static boolean mav$isRootPath(URLNode uRLNode) {
            return uRLNode.isRootPath();
        }

        final class 1
        extends SwingWorker {
            private URL[] _children;
            private URLPath _contribs;
            private final /* synthetic */ WaitCursor v$waitCursor;
            final /* synthetic */ URLNode this$0;

            public Object construct() {
                URLPath regularFiles;
                if (URLNode.mav$isRootPath(this.this$0)) {
                    this._contribs = new URLPath(SelectionRulesTreePanel.ra$_contribPath(this.this$0.SelectionRulesTreePanel.this));
                    regularFiles = FileGroupPackager.stripRegularFiles(this._contribs);
                } else {
                    this._contribs = SelectionRulesTreePanel.ra$_contribPath(this.this$0.SelectionRulesTreePanel.this);
                    regularFiles = null;
                }
                List children = this._contribs.getFilesAndDirectories(URLNode.ra$_path(this.this$0), true);
                if (regularFiles != null) {
                    children.addAll(Arrays.asList(regularFiles.getEntries()));
                }
                this._children = children.toArray(new URL[children.size()]);
                Arrays.sort(this._children, SelectionRulesTreePanel.ra$_urlComparator(this.this$0.SelectionRulesTreePanel.this));
                return null;
            }

            public void finished() {
                if (this._children != null) {
                    ArrayList<String> seenPaths = new ArrayList<String>();
                    int n = this._children.length;
                    int i = 0;
                    while (i < n) {
                        URL childURL = this._children[i];
                        String childPath = SelectionRulesTreePanel.mav$toRelativePath(this.this$0.SelectionRulesTreePanel.this, childURL);
                        if (!seenPaths.contains(childPath)) {
                            seenPaths.add(childPath);
                            URLNode child = new URLNode(childPath, childURL);
                            this.this$0.add((MutableTreeNode)((Object)child));
                        }
                        ++i;
                    }
                    SelectionRulesTreePanel.ra$_treeModel(this.this$0.SelectionRulesTreePanel.this).nodeStructureChanged((TreeNode)((Object)this.this$0));
                }
                this.this$0.updateNodes();
                this.v$waitCursor.hide();
            }

            public 1(URLNode uRLNode, WaitCursor waitCursor) {
                this.v$waitCursor = waitCursor;
                this.this$0 = uRLNode;
            }
        }
    }
}

