/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.fwk;

import oracle.javatools.util.Copyable;
import oracle.jdeveloper.deploy.DeployShell;
import oracle.jdeveloper.deploy.Deployer;
import oracle.jdeveloper.deploy.DeployerFactory;
import oracle.jdeveloper.deploy.meta.MetadataException;
import oracle.jdeveloper.deploy.meta.pattern.ChainOfR;
import oracle.jdevimpl.deploy.fwk.UpgradableDeployerFactory;
import oracle.jdevimpl.deploy.res.FwkArb;

public class DeployerFactoryStore
implements Copyable {
    ChainOfR<Class, DeployerFactory, RequestProperties> impl_;

    public void addFactory(Class clazz, Class parentClazz, DeployerFactory factory) throws MetadataException {
        try {
            this.impl_.add(clazz, parentClazz, new UpgradableDeployerFactory(factory));
        }
        catch (ChainOfR.DuplicateIndexException e) {
            throw new MetadataException(FwkArb.format(5, clazz.getName()));
        }
        catch (ChainOfR.IndexNotFoundException e) {
            throw new MetadataException(FwkArb.format(9, e.getMessage()));
        }
    }

    public void upgradeFactory(Class clazz, DeployerFactory factory) throws MetadataException {
        try {
            UpgradableDeployerFactory currentFactory = (UpgradableDeployerFactory)this.impl_.get(clazz);
            currentFactory.upgradeFactory(factory);
        }
        catch (ChainOfR.IndexNotFoundException e) {
            throw new MetadataException(FwkArb.format(0, clazz.getName()));
        }
    }

    public Deployer findDeployer(Class clazz, int deploySequenceId, DeployShell shell) throws Exception {
        RequestProperties reqProps = new RequestProperties(deploySequenceId, shell);
        try {
            if (this.impl_.handle(clazz, reqProps)) {
                Deployer deployer = reqProps.deployer_;
                return deployer;
            }
        }
        catch (ChainOfR.IndexNotFoundException e) {
            throw new MetadataException(FwkArb.getString(8));
        }
        return null;
    }

    public Class getParentClass(Class clazz) throws MetadataException {
        try {
            Class clazz2 = this.impl_.getParentLabel(clazz);
            return clazz2;
        }
        catch (ChainOfR.IndexNotFoundException e) {
            throw new MetadataException(FwkArb.format(0, clazz.getName()));
        }
    }

    public Deployer findDeployerFromParent(Class clazz, int deploySequenceId, DeployShell shell) throws Exception {
        Class parent = this.impl_.getParentLabel(clazz);
        if (parent == null) {
            return null;
        }
        return this.findDeployer(clazz, deploySequenceId, shell);
    }

    public DeployerFactoryStore copyTo(Object target) {
        if (target == null) {
            target = new DeployerFactoryStore();
        }
        return this.copyToImpl(target);
    }

    protected DeployerFactoryStore copyToImpl(Object target) {
        DeployerFactoryStore copy = (DeployerFactoryStore)target;
        this.impl_.copyTo(copy.impl_);
        return copy;
    }

    public void reset() {
        this.impl_.purge();
    }

    private void $init$() {
        this.impl_ = new ChainOfR(new DeployerFactoryFinder(null));
    }

    public DeployerFactoryStore() {
        this.$init$();
    }

    private static class RequestProperties {
        String request_;
        Deployer deployer_;
        int deploySequenceId_;
        DeployShell shell_;

        private void $init$() {
            this.deployer_ = null;
        }

        RequestProperties(int deploySequenceId, DeployShell shell) {
            this.$init$();
            this.deploySequenceId_ = deploySequenceId;
            this.shell_ = shell;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DeployerFactoryFinder
    implements ChainOfR.RequestHandler<DeployerFactory, RequestProperties> {
        @Override
        public boolean handle(DeployerFactory factory, RequestProperties reqDep) {
            reqDep.deployer_ = factory.newDeployer(reqDep.deploySequenceId_, reqDep.shell_);
            return reqDep.deployer_ != null;
        }

        private DeployerFactoryFinder() {
        }

        DeployerFactoryFinder(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }
}

