/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.fwk;

import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import oracle.ide.Context;
import oracle.ide.model.Element;
import oracle.ide.util.Assert;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.deploy.DefaultDeployShellFactory;
import oracle.jdeveloper.deploy.DefaultDeployerListener;
import oracle.jdeveloper.deploy.DeployEvent;
import oracle.jdeveloper.deploy.DeployException;
import oracle.jdeveloper.deploy.DeployShell;
import oracle.jdeveloper.deploy.DeployShellFactory;
import oracle.jdeveloper.deploy.DeployUtil;
import oracle.jdeveloper.deploy.Deployer;
import oracle.jdeveloper.deploy.DeployerFactory;
import oracle.jdeveloper.deploy.DeployerListener;
import oracle.jdeveloper.deploy.DeploymentConstants;
import oracle.jdeveloper.deploy.DeploymentManager;
import oracle.jdeveloper.deploy.DeploymentModuleFactory;
import oracle.jdeveloper.deploy.ListenerCondition;
import oracle.jdeveloper.deploy.ModuleDeploymentListener;
import oracle.jdeveloper.deploy.common.BatchDeployer;
import oracle.jdeveloper.deploy.common.DynamicDeployer;
import oracle.jdeveloper.deploy.jar.ArchiveProfile;
import oracle.jdeveloper.deploy.meta.MetadataException;
import oracle.jdeveloper.deploy.meta.Platform;
import oracle.jdeveloper.deploy.meta.PlatformType;
import oracle.jdeveloper.deploy.res.DeployMessages;
import oracle.jdevimpl.deploy.fwk.DeployerFactoryStore;
import oracle.jdevimpl.deploy.fwk.ListenerSupport;
import oracle.jdevimpl.deploy.fwk.ModuleDeploymentListenerAdapter;
import oracle.jdevimpl.deploy.fwk.SuperDeployer;
import oracle.jdevimpl.deploy.fwk.WrappedDeployer;
import oracle.jdevimpl.deploy.res.DtArb;
import oracle.jdevimpl.deploy.res.FwkArb;
import oracle.jdevimpl.deploy.stripe.DeploymentModuleFactoryStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentManagerImpl {
    private Map<String, Integer> deploymentSequences;
    private int lastSequenceId;
    final ListenerSupport listenerSupport_;
    private Map<Class<?>, Class<? extends ModuleDeploymentListenerAdapter>> listenerAdapterClasses_;
    Map<ModuleDeploymentListener, ModuleDeploymentListenerAdapter> listenerAdapters_;
    final DeployerFactoryStore factoryStore_;
    private final DeploymentModuleFactoryStore deployModuleFactoryStore_;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDeploymentSequenceId(String sequence) {
        Integer number = this.deploymentSequences.get(sequence);
        if (number == null) {
            Map<String, Integer> map = this.deploymentSequences;
            synchronized (map) {
                number = new Integer(++this.lastSequenceId);
                this.deploymentSequences.put(sequence, this.lastSequenceId);
                Assert.check((boolean)DeploymentManager.printDebug("deployment.sequence.id", "<id>" + number + "</id>" + "<name>" + sequence + "</name>"));
            }
        }
        return number;
    }

    public String getDeploymentSequenceName(int id) {
        String ret = null;
        for (Map.Entry<String, Integer> entry : this.deploymentSequences.entrySet()) {
            if (!entry.getValue().equals(id)) continue;
            ret = entry.getKey();
            break;
        }
        Assert.check((ret != null ? 1 : 0) != 0, (String)("Invalid sequence id " + id));
        return ret;
    }

    private void $init$() {
        this.deploymentSequences = new HashMap<String, Integer>();
        this.lastSequenceId = 0;
        this.listenerSupport_ = new ListenerSupport();
        this.listenerAdapterClasses_ = new HashMap();
        this.listenerAdapters_ = new HashMap<ModuleDeploymentListener, ModuleDeploymentListenerAdapter>();
        this.factoryStore_ = new DeployerFactoryStore();
        this.deployModuleFactoryStore_ = new DeploymentModuleFactoryStore();
    }

    public ListenerSupport getProfileListenerSupport() {
        return this.listenerSupport_;
    }

    public void addDeployerListener(ListenerCondition condition, DeployerListener listener, double priority) {
        this.listenerSupport_.addListener(condition, listener, priority);
    }

    public void removeDeployerListener(DeployerListener listener) {
        this.listenerSupport_.removeListener(listener);
    }

    public boolean removeDeployerListener(ListenerCondition condition, DeployerListener listener) {
        return this.listenerSupport_.removeListener(listener, condition);
    }

    public void registerModuleDeploymentListenerAdapter(Class<?> profileClass, Class<? extends ModuleDeploymentListenerAdapter> adapterClass) {
        this.listenerAdapterClasses_.put(profileClass, adapterClass);
    }

    public void addDeploymentListener(Class<? extends ArchiveProfile> profileClass, PlatformType type, ModuleDeploymentListener<? extends ArchiveProfile> listener, double priority) {
        Class<? extends ModuleDeploymentListenerAdapter> clazz = this.listenerAdapterClasses_.get(profileClass);
        Assert.check((clazz != null ? 1 : 0) != 0, (String)"No listener adapters registered for this Profile");
        try {
            ModuleDeploymentListenerAdapter adapter = clazz.newInstance();
            adapter.register(profileClass, type, listener, priority);
            this.listenerAdapters_.put(listener, adapter);
        }
        catch (IllegalAccessException e) {
        }
        catch (InstantiationException e) {
            // empty catch block
        }
    }

    public void removeDeploymentListener(ModuleDeploymentListener<? extends ArchiveProfile> listener) {
        ModuleDeploymentListenerAdapter adapter = this.listenerAdapters_.remove(listener);
        Assert.check((adapter != null ? 1 : 0) != 0, (String)"Trying to remove a non-existent Listener adapter");
        adapter.unregister(listener);
    }

    public DeployerFactoryStore getDeployerFactoryStore() {
        return this.factoryStore_;
    }

    public void deploy(int deploySequenceId) throws Exception {
        Context context = new Context();
        DeployShell shell = this.getDefaultDeployShell(deploySequenceId, context);
        this.deploy(deploySequenceId, shell);
    }

    public void deploy(int deploySequence, Context context, DeployShellFactory factory) throws Exception {
        DeployShell shell = this.createDeployShell(deploySequence, context, factory);
        this.deploy(deploySequence, shell);
    }

    public void deploy(int deploySequence, Context context, DeployShellFactory factory, Object lock) {
        DeployShell shell = this.createDeployShell(deploySequence, context, factory);
        this.deploy(deploySequence, shell, lock);
    }

    private DeployShell createDeployShell(int sequence, Context context, DeployShellFactory factory) {
        DeployShell defaultShell = this.getDefaultDeployShell(sequence, context);
        DeployShell shell = factory.create(sequence, context, defaultShell);
        return shell;
    }

    public void deploy(int deploySequence, DeployShell shell, Object obj) {
        Object lock = obj == null ? shell.getContext() : obj;
        Assert.check((boolean)DeploymentManager.printDebug("deployment.deploy.lock.object", "<class>" + lock.getClass() + "</class>" + "<object>" + lock + "</object>"));
        1 t = new 1(this, "Deployment" + new Random().nextInt(), lock, deploySequence, shell);
        t.start();
    }

    private void printUnwrappedExceptionMessage(Throwable e, PrintWriter writer) {
        Throwable t = e.getCause();
        if (t != null && t != e) {
            if (ModelUtil.hasLength((String)e.getMessage())) {
                writer.println(e.getMessage());
            }
            this.printUnwrappedExceptionMessage(t, writer);
        } else {
            Object o;
            StringBuffer s = new StringBuffer();
            if (e instanceof DeployException && (o = ((DeployException)e).getSource()) != null) {
                String name = null;
                try {
                    Method getName = o.getClass().getMethod("getName", null);
                    Object ret = getName.invoke(o, null);
                    if (ret != null) {
                        name = ret.toString();
                    }
                }
                catch (Exception ex) {
                    Assert.printStackTrace((Throwable)ex);
                }
                name = name == null ? o.getClass().getName() : name;
                s.append(" (");
                s.append(name);
                s.append(")");
            }
            writer.println(e.getMessage() + s.toString());
        }
    }

    public void deploy(int deploySequenceId, DeployShell shell) throws Exception {
        DeployShellFactory shellFactory = shell.getDeployShellFactory();
        Assert.check((shellFactory != null ? 1 : 0) != 0, (String)"Shell should have a reference to its factory");
        Object elementToDeploy = DeployUtil.getProfile(shell);
        if (elementToDeploy == null) {
            Element element = shell.getContext().getElement();
            if (element == null) {
                throw new DeployException("Nothing to deploy");
            }
            if (element.getData() == null) {
                Assert.printStackTrace((boolean)false, (String)"Warning: Element.getData() returns null");
                elementToDeploy = element;
            } else {
                elementToDeploy = element.getData();
            }
        }
        Class<?> elementClass = elementToDeploy.getClass();
        Assert.check((boolean)DeploymentManager.printDebug("deployment.deploy.element", "<class>" + elementClass.getName() + "</class>" + "<element>" + elementToDeploy + "</element>"));
        Deployer deployer = this.resolveDeployer(deploySequenceId, new DynamicDeployer(deploySequenceId), elementClass, shell);
        if (deploySequenceId != DeploymentConstants.DEFAULT_SEQUENCE) {
            deployer = new WrappedDeployer(DeploymentConstants.DEPLOYMENT_SEQUENCE, deployer);
        }
        int stackLen = shell.getSequenceStack().getLength();
        try {
            try {
                deployer.prepare(deploySequenceId, shell);
                Assert.check((shell.getSequenceStack().getLength() == stackLen ? 1 : 0) != 0, (String)("Sequence stack error: missing pop() in prepare: " + shell.getSequenceStack().getLength()));
                shell.put("Deployment.STATUS", (Object)DeployConsoleLogger.DEPLOYMENT_STATUS.PREPARED);
                deployer.deploy(deploySequenceId, shell);
                Assert.check((shell.getSequenceStack().getLength() == stackLen ? 1 : 0) != 0, (String)("Sequence stack error: missing pop() in deploy: " + shell.getSequenceStack().getLength()));
                shell.put("Deployment.STATUS", (Object)DeployConsoleLogger.DEPLOYMENT_STATUS.DEPLOYED);
            }
            catch (DeployException e) {
                shell.setDeployException(e);
                deployer.cancel(deploySequenceId, shell);
                shell.put("Deployment.STATUS", (Object)DeployConsoleLogger.DEPLOYMENT_STATUS.CANCELLED);
                throw e;
            }
        }
        finally {
            deployer.finish(deploySequenceId, shell);
            shell.put("Deployment.STATUS", (Object)DeployConsoleLogger.DEPLOYMENT_STATUS.FINISHED);
        }
    }

    private Deployer resolveDeployer(int deploySequence, Deployer deployer, Class current, DeployShell shell) throws Exception {
        if (deployer == null) {
            this.assertNotNullDeployer(deployer, deploySequence);
        }
        if (deployer instanceof SuperDeployer) {
            Class parent = this.factoryStore_.getParentClass(current);
            if (parent == null) {
                throw new MetadataException(FwkArb.format(6, this.getDeploymentSequenceName(deploySequence)));
            }
            int newSequence = ((SuperDeployer)deployer).getSequenceId();
            Assert.check((boolean)DeploymentManager.printDebug("deployment.resolve.find.begin", "<find label=\"" + parent + "\" sequence=\"" + this.getDeploymentSequenceName(newSequence) + "\" />"));
            deployer = this.factoryStore_.findDeployer(parent, newSequence, shell);
            Assert.check((boolean)DeploymentManager.printDebug("deployment.resolve.find.end", "<result><deployer>" + deployer + "</deployer></result>"));
            deployer = this.resolveDeployer(newSequence, deployer, parent, shell);
        } else if (deployer instanceof DynamicDeployer) {
            int newSequence = ((DynamicDeployer)deployer).getSequenceId();
            Assert.check((boolean)DeploymentManager.printDebug("deployment.resolve.find.begin", "<find label=\"" + current + "\" sequence=\"" + this.getDeploymentSequenceName(newSequence) + "\" />"));
            deployer = this.factoryStore_.findDeployer(current, newSequence, shell);
            Assert.check((boolean)DeploymentManager.printDebug("deployment.resolve.find.end", "<result><deployer>" + deployer + "</deployer></result>"));
            deployer = this.resolveDeployer(newSequence, deployer, current, shell);
        } else if (deployer instanceof BatchDeployer) {
            int newSequence = ((BatchDeployer)deployer).getSequenceId();
            deployer = this.resolveBatchDeployer(newSequence, (BatchDeployer)deployer, current, shell);
        }
        if (!deployer.canDeploy(deploySequence)) {
            deployer = new WrappedDeployer(deploySequence, deployer);
        }
        return deployer;
    }

    private Deployer resolveBatchDeployer(int deploySequence, Deployer deployer, Class current, DeployShell shell) throws Exception {
        Deployer[] deployers = ((BatchDeployer)deployer).getDeployers();
        int i = 0;
        while (i < deployers.length) {
            if (deployers[i] instanceof SuperDeployer) {
                deployers[i] = this.resolveDeployer(deploySequence, deployers[i], current, shell);
            } else if (deployers[i] instanceof DynamicDeployer) {
                DynamicDeployer dyn = (DynamicDeployer)deployers[i];
                deployers[i] = this.resolveDeployer(dyn.getSequenceId(), dyn, current, shell);
            } else if (deployers[i] instanceof BatchDeployer) {
                BatchDeployer batch = (BatchDeployer)deployers[i];
                deployers[i] = this.resolveBatchDeployer(batch.getSequenceId(), (BatchDeployer)deployers[i], current, shell);
            }
            ++i;
        }
        if (!deployer.canDeploy(deploySequence)) {
            deployer = new WrappedDeployer(deploySequence, deployer);
        }
        return deployer;
    }

    private void assertNotNullDeployer(Deployer deployer, int sequenceId) throws MetadataException {
        if (deployer == null) {
            throw new MetadataException(FwkArb.format(4, this.getDeploymentSequenceName(sequenceId)));
        }
    }

    public DeployShell getDefaultDeployShell(int deploySequence, Context context) {
        return new DefaultDeployShellFactory().create(deploySequence, context, null);
    }

    public void setDeploymentInfo(DeployShell shell) {
        shell.setDeploymentModuleFactory(this.deployModuleFactoryStore_);
    }

    public void registerDeployerFactory(Class clazz, Class parentClazz, DeployerFactory factory) throws MetadataException {
        this.factoryStore_.addFactory(clazz, parentClazz, factory);
    }

    public void upgradeDeployerFactory(Class clazz, DeployerFactory factory) throws MetadataException {
        this.factoryStore_.upgradeFactory(clazz, factory);
    }

    public void registerDeploymentModuleFactory(Class<?> elementClass, DeploymentModuleFactory factory) throws MetadataException {
        this.deployModuleFactoryStore_.addFactory(elementClass, factory);
    }

    public void upgradeDeploymentModuleFactory(Class<?> elementClass, DeploymentModuleFactory factory) throws MetadataException {
        this.deployModuleFactoryStore_.upgradeFactory(elementClass, factory);
    }

    public DeploymentManagerImpl() {
        this.$init$();
    }

    static void mav$printUnwrappedExceptionMessage(DeploymentManagerImpl deploymentManagerImpl, Throwable throwable, PrintWriter printWriter) {
        deploymentManagerImpl.printUnwrappedExceptionMessage(throwable, printWriter);
    }

    final class 1
    extends Thread {
        private final /* synthetic */ Object v$lock;
        private final /* synthetic */ int v$deploySequence;
        private final /* synthetic */ DeployShell v$shell;
        final /* synthetic */ DeploymentManagerImpl this$0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = this.v$lock;
            synchronized (object) {
                try {
                    try {
                        this.this$0.deploy(this.v$deploySequence, this.v$shell);
                    }
                    catch (Exception e) {
                        DeploymentManagerImpl.mav$printUnwrappedExceptionMessage(this.this$0, e, this.v$shell.getLog());
                        Assert.printStackTrace((Throwable)e);
                    }
                }
                finally {
                    this.v$lock.notifyAll();
                }
            }
        }

        public 1(DeploymentManagerImpl deploymentManagerImpl, String string, Object object, int n, DeployShell deployShell) {
            this.v$shell = deployShell;
            this.v$deploySequence = n;
            this.v$lock = object;
            this.this$0 = deploymentManagerImpl;
            super(string);
        }
    }

    public static class DeployConsoleLogger
    extends DefaultDeployerListener
    implements ListenerCondition {
        static final String DEPLOYMENT_STATUS_KEY = "Deployment.STATUS";
        long start_;

        public void willPrepare(DeployEvent event) {
            this.start_ = System.currentTimeMillis();
            if (event.getShell().getPrintTimeMessages()) {
                event.getShell().getLog().println(DeployMessages.deploymentStarted());
                this.printTargetPlatform(event.getShell());
            }
        }

        public void finished(DeployEvent event) {
            if (event.getShell().getPrintTimeMessages()) {
                if (DEPLOYMENT_STATUS.DEPLOYED.equals(event.getShell().get(DEPLOYMENT_STATUS_KEY))) {
                    long end = System.currentTimeMillis();
                    PrintWriter log = event.getShell().getLog();
                    log.println(DeployMessages.deploymentElapsed(end - this.start_));
                    log.println(DeployMessages.deploymentFinished());
                } else {
                    event.getShell().getLog().println(DeployMessages.deploymentIncomplete());
                }
            }
        }

        public void cancelled(DeployEvent event) {
        }

        private void printTargetPlatform(DeployShell dsh) {
            Platform platform = DeployUtil.getPlatform(dsh);
            PrintWriter log = dsh.getLog();
            if (platform != null) {
                log.println(DtArb.format(49, "", platform.getLongLabel()));
                return;
            }
            log.println(DtArb.getString(2));
        }

        public boolean shouldFire(DeployEvent event) {
            return event.getCurrentSequence() == DeploymentConstants.DEPLOYMENT_SEQUENCE;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static final class DEPLOYMENT_STATUS
        extends Enum<DEPLOYMENT_STATUS> {
            private static final /* synthetic */ DEPLOYMENT_STATUS[] $v;
            public static final /* enum */ DEPLOYMENT_STATUS PREPARED;
            public static final /* enum */ DEPLOYMENT_STATUS DEPLOYED;
            public static final /* enum */ DEPLOYMENT_STATUS CANCELLED;
            public static final /* enum */ DEPLOYMENT_STATUS FINISHED;

            public static DEPLOYMENT_STATUS valueOf(String string) {
                return Enum.valueOf(DEPLOYMENT_STATUS.class, string);
            }

            public static final DEPLOYMENT_STATUS[] values() {
                return (DEPLOYMENT_STATUS[])$v.clone();
            }

            static {
                DEPLOYMENT_STATUS[] dEPLOYMENT_STATUSArray = new DEPLOYMENT_STATUS[4];
                dEPLOYMENT_STATUSArray[3] = FINISHED = new DEPLOYMENT_STATUS("FINISHED", 3);
                dEPLOYMENT_STATUSArray[2] = CANCELLED = new DEPLOYMENT_STATUS("CANCELLED", 2);
                dEPLOYMENT_STATUSArray[1] = DEPLOYED = new DEPLOYMENT_STATUS("DEPLOYED", 1);
                dEPLOYMENT_STATUSArray[0] = PREPARED = new DEPLOYMENT_STATUS("PREPARED", 0);
                $v = dEPLOYMENT_STATUSArray;
            }

            private DEPLOYMENT_STATUS(String string2, int n2) {
            }
        }
    }
}

