/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.fwk;

import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import oracle.ide.net.JarIndex;
import oracle.ide.net.JarIndexEntry;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLFileSystem;
import oracle.ide.nulls.NullPrintWriter;
import oracle.jdeveloper.deploy.Archive;
import oracle.jdeveloper.deploy.ArchiveEntry;
import oracle.jdevimpl.deploy.fwk.ArchiveIO;
import oracle.jdevimpl.deploy.res.UtilArb;

public class JarIO
extends ArchiveIO {
    private static final int BUFFER_SIZE = 8192;
    private boolean compressed_;

    public JarIO() {
        this(false);
    }

    public JarIO(boolean compressed) {
        this.compressed_ = compressed;
    }

    public void setCompressed(boolean compressed) {
        this.compressed_ = compressed;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void write(Archive archive, URL outputURL, PrintWriter printWriter, boolean forceRewrite) throws IOException {
        if (!forceRewrite && !this.needToWriteArchive(archive, outputURL, printWriter)) {
            return;
        }
        this.removeArchive(outputURL);
        BufferedOutputStream outputStream = null;
        JarOutputStream jos = null;
        try {
            if (printWriter == null) {
                printWriter = new NullPrintWriter();
            }
            outputStream = new BufferedOutputStream(URLFileSystem.openOutputStream((URL)outputURL));
            jos = new JarOutputStream(outputStream);
            if (archive.isIncludeManifest()) {
                ZipEntry manifestEntry = new ZipEntry("META-INF/MANIFEST.MF");
                jos.putNextEntry(manifestEntry);
                archive.getManifest().write(new BufferedOutputStream(jos));
                jos.closeEntry();
            }
            jos.setMethod(this.compressed_ ? 8 : 0);
            Iterator<ArchiveEntry> iter = archive.getArchiveEntries();
            byte[] buffer = new byte[8192];
            while (iter.hasNext()) {
                ArchiveEntry entry = null;
                try {
                    while (iter.hasNext()) {
                        long lastModified;
                        entry = iter.next();
                        if (!this.canAddEntry(entry)) continue;
                        JarEntry jarEntry = new JarEntry(entry.getName());
                        long expectedSize = -1;
                        if (!this.compressed_) {
                            this.initStoredZipEntry(entry, jarEntry, -1, printWriter);
                        }
                        if ((lastModified = URLFileSystem.lastModified((URL)entry.getURL())) >= 0L) {
                            jarEntry.setTime(URLFileSystem.lastModified((URL)entry.getURL()));
                        }
                        jos.putNextEntry(jarEntry);
                        InputStream in = null;
                        try {
                            int bytesRead;
                            in = this.openInputStream(entry);
                            int totalSize = 0;
                            while ((bytesRead = in.read(buffer, 0, 8192)) >= 0) {
                                jos.write(buffer, 0, bytesRead);
                                totalSize += bytesRead;
                            }
                        }
                        finally {
                            if (in != null) {
                                try {
                                    in.close();
                                }
                                catch (Exception e) {
                                    e.printStackTrace(printWriter);
                                }
                            }
                        }
                    }
                }
                catch (FileNotFoundException e) {
                    JarIO.dumpArchiveEntryException(e, entry, printWriter);
                }
                catch (Exception e) {
                    e.printStackTrace(printWriter);
                    JarIO.dumpArchiveEntryException(e, entry, printWriter);
                }
            }
        }
        catch (Throwable throwable) {
            if (jos != null) {
                JarIO.forceClose(jos, printWriter);
                throw throwable;
            }
            if (outputStream == null) throw throwable;
            JarIO.forceClose(outputStream, printWriter);
            throw throwable;
        }
        if (jos != null) {
            JarIO.forceClose(jos, printWriter);
            return;
        }
        if (outputStream == null) return;
        JarIO.forceClose(outputStream, printWriter);
    }

    protected InputStream openInputStream(ArchiveEntry entry) throws IOException {
        return URLFileSystem.openInputStream((URL)entry.getURL());
    }

    protected boolean canAddEntry(ArchiveEntry entry) {
        return entry != null && entry.getURL() != null;
    }

    private boolean needToWriteArchive(Archive archive, URL outputURL, PrintWriter printWriter) {
        block16: {
            if (URLFileSystem.exists((URL)outputURL)) {
                try {
                    boolean curHasManifest;
                    JarIndex jarIndex = JarUtil.getJarIndex((URL)outputURL);
                    if (jarIndex == null) break block16;
                    Iterator<ArchiveEntry> iter = archive.getArchiveEntries();
                    HashSet<String> entryNames = new HashSet<String>();
                    while (iter.hasNext()) {
                        ArchiveEntry entry = iter.next();
                        if (entry == null || entry.getURL() == null || entry.getName() == null || entry.getName().equals("connections.xml") || entry.getName().equals("WEB-INF/classes/connections.xml")) continue;
                        int index = jarIndex.entryIndex(entry.getName());
                        if (index < 0) {
                            boolean bl = true;
                            return bl;
                        }
                        long timestampInJar = jarIndex.getTimestamp(index);
                        long timestampOnDisk = URLFileSystem.lastModified((URL)entry.getURL());
                        if (timestampOnDisk > timestampInJar) {
                            boolean bl = true;
                            return bl;
                        }
                        entryNames.add(entry.getName());
                    }
                    int curNumEntries = jarIndex.getNumEntries();
                    int i = 0;
                    while (i < curNumEntries) {
                        String curEntryName = jarIndex.getEntryNameAt(i);
                        if (!entryNames.contains(curEntryName) && !curEntryName.equals("META-INF/MANIFEST.MF")) {
                            boolean bl = true;
                            return bl;
                        }
                        ++i;
                    }
                    int n = 3;
                    int i2 = 0;
                    while (i2 < curNumEntries && i2 < n) {
                        boolean isCurEntryCompressed;
                        JarIndexEntry indexEntry = jarIndex.getEntryAt(i2);
                        boolean bl = isCurEntryCompressed = indexEntry.getCompressedSize() < indexEntry.getSize();
                        if (this.compressed_ != isCurEntryCompressed) {
                            if (!"META-INF/MANIFEST.MF".equals(indexEntry.getName())) {
                                boolean bl2 = true;
                                return bl2;
                            }
                            ++n;
                        }
                        ++i2;
                    }
                    boolean bl = curHasManifest = jarIndex.entryIndex("META-INF/MANIFEST.MF") >= 0;
                    if (archive.isIncludeManifest() != curHasManifest) {
                        boolean bl3 = true;
                        return bl3;
                    }
                    if (archive.isIncludeManifest()) {
                        try {
                            Manifest curManifest = new Manifest(jarIndex.openInputStream("META-INF/MANIFEST.MF"));
                            if (!archive.getManifest().equals(curManifest)) {
                                boolean bl4 = true;
                                return bl4;
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace(printWriter);
                            boolean bl5 = true;
                            return bl5;
                        }
                    }
                    boolean bl6 = false;
                    return bl6;
                }
                catch (IOException e) {
                    printWriter.println(UtilArb.format(7, e.getLocalizedMessage()));
                }
            }
        }
        return true;
    }

    private static void dumpArchiveEntryException(Exception e, ArchiveEntry entry, PrintWriter printWriter) {
        if (entry == null) {
            printWriter.println(UtilArb.format(16, e.getClass()));
        } else if (entry.getURL() != null) {
            printWriter.println(UtilArb.format(1, e.getClass(), entry.getURL()));
        } else if (entry.getName() != null) {
            printWriter.println(UtilArb.format(11, entry.getName()));
        } else {
            printWriter.println(UtilArb.format(16, e.getClass()));
        }
    }

    private void initStoredZipEntry(ArchiveEntry entry, ZipEntry zipEntry, long expectedSize, PrintWriter log) throws IOException {
        InputStream in = null;
        try {
            int bytesRead;
            in = this.openInputStream(entry);
            byte[] bytes = new byte[8192];
            CRC32 crc32 = new CRC32();
            long totalSize = 0L;
            while ((bytesRead = in.read(bytes, 0, 8192)) >= 0) {
                crc32.update(bytes, 0, bytesRead);
                if (expectedSize < 0L || (totalSize += (long)bytesRead) < expectedSize) continue;
            }
            long crc = crc32.getValue();
            zipEntry.setCrc(crc);
            zipEntry.setSize(totalSize);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {
                    e.printStackTrace(log);
                }
            }
        }
    }

    private static void forceClose(OutputStream out, PrintWriter printWriter) {
        if (out != null) {
            try {
                out.close();
            }
            catch (Exception e) {
                e.printStackTrace(printWriter);
            }
        }
    }
}

