/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.fwk;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import oracle.ide.util.Assert;
import oracle.jdeveloper.deploy.DeployEvent;
import oracle.jdeveloper.deploy.DeployException;
import oracle.jdeveloper.deploy.DeployerListener;
import oracle.jdeveloper.deploy.DeploymentManager;
import oracle.jdeveloper.deploy.ListenerCondition;

public class ListenerSupport {
    private final List<ListenerHolder> allListeners_;

    private void $init$() {
        this.allListeners_ = Collections.synchronizedList(new ArrayList());
    }

    void addListener(ListenerCondition condition, DeployerListener listener, double priority) {
        this.allListeners_.add(new ListenerHolder(condition, priority, listener));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeListener(DeployerListener listener) {
        List<ListenerHolder> list = this.allListeners_;
        synchronized (list) {
            Iterator<ListenerHolder> iter = this.allListeners_.iterator();
            while (iter.hasNext()) {
                if (iter.next().listener_ != listener) continue;
                iter.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeListener(DeployerListener listener, ListenerCondition condition) {
        int existing = 0;
        int removed = 0;
        List<ListenerHolder> list = this.allListeners_;
        synchronized (list) {
            Iterator<ListenerHolder> iter = this.allListeners_.iterator();
            while (iter.hasNext()) {
                ListenerHolder holder = iter.next();
                if (holder.condition_ != condition) continue;
                ++existing;
                if (holder.listener_ != listener) continue;
                iter.remove();
                ++removed;
            }
        }
        return existing == removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DeployerListener[] getListeners(DeployEvent event) {
        List<ListenerHolder> list = this.allListeners_;
        synchronized (list) {
            ArrayList<ListenerHolder> sortedListeners = new ArrayList<ListenerHolder>();
            for (ListenerHolder holder : this.allListeners_) {
                Assert.check((boolean)DeploymentManager.printDebug("listener.shouldFire.begin", "<condition>" + holder.condition_.toString() + "</condition>" + event.toString()));
                if (holder.condition_.shouldFire(event)) {
                    sortedListeners.add(holder);
                    Assert.check((boolean)DeploymentManager.printDebug("listener.shouldFire.end", "<condition>" + holder.condition_.toString() + "</condition>" + "<response>yes</response>"));
                    continue;
                }
                Assert.check((boolean)DeploymentManager.printDebug("listener.shouldFire.end", "<condition>" + holder.condition_.toString() + "</condition>" + "<response>no</response>"));
            }
            Collections.sort(sortedListeners, new 1());
            DeployerListener[] listeners = new DeployerListener[sortedListeners.size()];
            int i = 0;
            for (ListenerHolder holder : sortedListeners) {
                listeners[i++] = holder.listener_;
            }
            DeployerListener[] deployerListenerArray = listeners;
            return deployerListenerArray;
        }
    }

    public void fireWillPrepare(DeployEvent event) throws DeployException {
        DeployerListener[] listeners;
        DeployerListener[] deployerListenerArray = listeners = this.getListeners(event);
        int n = 0;
        while (n < deployerListenerArray.length) {
            DeployerListener listener = deployerListenerArray[n];
            Assert.check((boolean)DeploymentManager.printDebug("listener.willPrepare.begin", listener.toString()));
            try {
                listener.willPrepare(event);
            }
            catch (DeployException e) {
                e.setSource(listener);
                throw e;
            }
            Assert.check((boolean)DeploymentManager.printDebug("listener.willPrepare.end", listener.toString()));
            ++n;
        }
    }

    public void firePrepared(DeployEvent event) throws DeployException {
        DeployerListener[] listeners = this.getListeners(event);
        int i = listeners.length - 1;
        while (i >= 0) {
            DeployerListener listener = listeners[i];
            Assert.check((boolean)DeploymentManager.printDebug("listener.prepared.begin", listener.toString()));
            try {
                listener.prepared(event);
            }
            catch (DeployException e) {
                e.setSource(listener);
                throw e;
            }
            Assert.check((boolean)DeploymentManager.printDebug("listener.prepared.end", listener.toString()));
            --i;
        }
    }

    public void fireWillDeploy(DeployEvent event) throws DeployException {
        DeployerListener[] listeners;
        DeployerListener[] deployerListenerArray = listeners = this.getListeners(event);
        int n = 0;
        while (n < deployerListenerArray.length) {
            DeployerListener listener = deployerListenerArray[n];
            Assert.check((boolean)DeploymentManager.printDebug("listener.willDeploy.begin", listener.toString()));
            try {
                listener.willDeploy(event);
            }
            catch (DeployException e) {
                e.setSource(e);
                throw e;
            }
            Assert.check((boolean)DeploymentManager.printDebug("listener.willDeploy.end", listener.toString()));
            ++n;
        }
    }

    public void fireDeployed(DeployEvent event) {
        DeployerListener[] listeners = this.getListeners(event);
        int i = listeners.length - 1;
        while (i >= 0) {
            DeployerListener listener = listeners[i];
            Assert.check((boolean)DeploymentManager.printDebug("listener.deployed.begin", listener.toString()));
            listener.deployed(event);
            Assert.check((boolean)DeploymentManager.printDebug("listener.deployed.end", listener.toString()));
            --i;
        }
    }

    public void fireWillFinish(DeployEvent event) {
        DeployerListener[] listeners;
        DeployerListener[] deployerListenerArray = listeners = this.getListeners(event);
        int n = 0;
        while (n < deployerListenerArray.length) {
            DeployerListener listener = deployerListenerArray[n];
            Assert.check((boolean)DeploymentManager.printDebug("listener.willFinish.begin", listener.toString()));
            listener.willFinish(event);
            Assert.check((boolean)DeploymentManager.printDebug("listener.willFinish.end", listener.toString()));
            ++n;
        }
    }

    public void fireFinished(DeployEvent event) {
        DeployerListener[] listeners = this.getListeners(event);
        int i = listeners.length - 1;
        while (i >= 0) {
            DeployerListener listener = listeners[i];
            Assert.check((boolean)DeploymentManager.printDebug("listener.finished.begin", listener.toString()));
            listener.finished(event);
            Assert.check((boolean)DeploymentManager.printDebug("listener.finished.end", listener.toString()));
            --i;
        }
    }

    public void fireWillCancel(DeployEvent event) {
        DeployerListener[] listeners;
        DeployerListener[] deployerListenerArray = listeners = this.getListeners(event);
        int n = 0;
        while (n < deployerListenerArray.length) {
            DeployerListener listener = deployerListenerArray[n];
            Assert.check((boolean)DeploymentManager.printDebug("listener.willCancel.begin", listener.toString()));
            listener.willCancel(event);
            Assert.check((boolean)DeploymentManager.printDebug("listener.willCancel.end", listener.toString()));
            ++n;
        }
    }

    public void fireCancelled(DeployEvent event) {
        DeployerListener[] listeners = this.getListeners(event);
        int i = listeners.length - 1;
        while (i >= 0) {
            DeployerListener listener = listeners[i];
            Assert.check((boolean)DeploymentManager.printDebug("listener.cancelled.begin", listener.toString()));
            listener.cancelled(event);
            Assert.check((boolean)DeploymentManager.printDebug("listener.cancelled.end", listener.toString()));
            --i;
        }
    }

    public ListenerSupport() {
        this.$init$();
    }

    final class 1
    implements Comparator {
        public int compare(ListenerHolder lhs, ListenerHolder rhs) {
            return lhs.priority_ > rhs.priority_ ? -1 : (lhs.priority_ == rhs.priority_ ? 0 : 1);
        }
    }

    private static class ListenerHolder {
        final ListenerCondition condition_;
        final double priority_;
        final DeployerListener listener_;

        ListenerHolder(ListenerCondition condition, double priority, DeployerListener listener) {
            this.condition_ = condition;
            this.listener_ = listener;
            this.priority_ = priority;
        }
    }
}

