/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.jar;

import oracle.ide.Context;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.net.URLChooserInit;
import oracle.ide.panels.Navigable;
import oracle.ide.util.Namespace;
import oracle.jdeveloper.deploy.jar.ArchiveOptions;
import oracle.jdeveloper.deploy.jar.ArchiveProfile;
import oracle.jdevimpl.deploy.common.CommonEditor;
import oracle.jdevimpl.deploy.common.FileGroupsEditor;
import oracle.jdevimpl.deploy.common.FileGroupsNavigable;
import oracle.jdevimpl.deploy.jar.ArchiveDepsPanel;
import oracle.jdevimpl.deploy.jar.ArchiveOptionsPanel;
import oracle.jdevimpl.deploy.res.JarArb;
import oracle.jdevimpl.xml.ModalEditor;

public class ArchiveEditor
extends ModalEditor {
    private static final String ARCHIVE_PROFILE_DATA_KEY = "archive-profile";
    private static final String ARCHIVE_OPTIONS_DATA_KEY = "archive-options";
    private static final String URLCHOOSER_INIT_KEY = "urlchooser-init";
    private final String _title;
    private final Context _context;

    public ArchiveEditor(String title, ArchiveProfile profile, Context context) {
        super(profile, true, true);
        this._title = title;
        this._context = context;
    }

    protected String getTitle() {
        return this._title;
    }

    protected Navigable[] getNavigables() {
        return new Navigable[]{new Navigable(JarArb.getString(42), ArchiveOptionsPanel.class), new FileGroupsNavigable(), new Navigable(JarArb.getString(11), ArchiveDepsPanel.class)};
    }

    protected String getDataKey() {
        return ARCHIVE_PROFILE_DATA_KEY;
    }

    protected void scatterData(Namespace ns) {
        CommonEditor.putContext(this._context, ns);
        ArchiveEditor.setURLChooserInit(DialogUtil.getURLChooserInit((Context)this._context), ns);
        CommonEditor.putWorkspace((Node)this._context.getWorkspace(), ns);
        CommonEditor.putProfile(ArchiveEditor.getArchiveProfile(ns), ns);
        ArchiveProfile profile = ArchiveEditor.getArchiveProfile(ns);
        Project project = this._context.getProject();
        ArchiveEditor.scatterArchiveProfile(profile, (Node)project, ns);
    }

    protected void gatherData(Namespace ns) {
        ArchiveEditor.gatherArchiveProfile(ArchiveEditor.getArchiveProfile(ns), ns);
    }

    public static void scatterArchiveProfile(ArchiveProfile profile, Node project, Namespace data) {
        ArchiveEditor.setArchiveOptions(profile.getArchiveOptions(), data);
        FileGroupsEditor.setFileGroups(profile.getFileGroups(), data);
        CommonEditor.putProject(project, data);
    }

    public static void gatherArchiveProfile(ArchiveProfile profile, Namespace data) {
        profile.setArchiveOptions(ArchiveEditor.getArchiveOptions(data));
        profile.setFileGroups(FileGroupsEditor.getFileGroups(data));
    }

    public static ArchiveProfile getArchiveProfile(Namespace data) {
        return (ArchiveProfile)data.find(ARCHIVE_PROFILE_DATA_KEY);
    }

    public static void setArchiveProfile(ArchiveProfile profile, Namespace data) {
        data.findAndReplace(ARCHIVE_PROFILE_DATA_KEY, (Object)profile);
    }

    public static ArchiveOptions getArchiveOptions(Namespace data) {
        return (ArchiveOptions)data.find(ARCHIVE_OPTIONS_DATA_KEY);
    }

    public static void setArchiveOptions(ArchiveOptions opts, Namespace data) {
        data.findAndReplace(ARCHIVE_OPTIONS_DATA_KEY, (Object)opts);
    }

    public static URLChooserInit getURLChooserInit(Namespace data) {
        return (URLChooserInit)data.find(URLCHOOSER_INIT_KEY);
    }

    public static void setURLChooserInit(URLChooserInit urlChooserInit, Namespace data) {
        data.findAndReplace(URLCHOOSER_INIT_KEY, (Object)urlChooserInit);
    }
}

