/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.stripe;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.ide.util.Assert;
import oracle.jdeveloper.deploy.ArchiveEntry;
import oracle.jdeveloper.deploy.DeploymentModule;
import oracle.jdeveloper.deploy.DeploymentModuleIO;
import oracle.jdevimpl.deploy.res.FwkArb;
import oracle.jdevimpl.deploy.stripe.InputStreamProvider;
import oracle.jdevimpl.deploy.stripe.MonitoredStream;
import oracle.jdevimpl.deploy.stripe.OutputStreamProvider;
import oracle.jdevimpl.deploy.stripe.StreamProvider;
import oracle.jdevimpl.deploy.stripe.StreamProviderFactory;
import oracle.jdevimpl.deploy.stripe.URLStreamProviderFactory;

public abstract class AbstractModuleIO
implements DeploymentModuleIO {
    protected URL url_;
    protected DeploymentModule archive_;
    protected StreamProviderFactory providerFactory_;
    HashSet<OutputStreamProvider> openedOutputStreamProviders_;
    HashMap<String, OutputStreamProvider> modifiedEntries_;
    HashMap<OutputStreamProvider, ArrayList<InputStreamProvider>> pinnedProviders_;

    private void $init$() {
        this.openedOutputStreamProviders_ = new HashSet();
        this.modifiedEntries_ = new HashMap();
        this.pinnedProviders_ = new HashMap();
    }

    public AbstractModuleIO() {
        this(new URLStreamProviderFactory());
    }

    public AbstractModuleIO(StreamProviderFactory streamProviderFactory) {
        this.$init$();
        this.setStreamProviderFactory(streamProviderFactory);
    }

    public void setArchive(DeploymentModule archive) throws IOException {
        this.rollback();
        this.archive_ = archive;
    }

    public DeploymentModule getArchive() {
        return this.archive_;
    }

    public void commit() throws IOException {
        try {
            this.commitImpl();
            Assert.println((String)("Archive committed. " + this.getURL()));
        }
        finally {
            this.invalidateOpenOutputStreams();
        }
    }

    protected boolean isModified(ArchiveEntry entry) {
        return this.modifiedEntries_.get(entry.getName()) != null;
    }

    protected void invalidateOpenOutputStreams() {
        this.openedOutputStreamProviders_.clear();
    }

    public abstract void commitImpl() throws IOException;

    public abstract void rollback() throws IOException;

    public abstract boolean isArchiveReadOnly();

    OutputStreamProvider getOutputStreamProvider(ArchiveEntry entry) {
        StreamProviderFactory factory = this.getStreamProviderFactory();
        return factory.createTempOutputProvider(entry);
    }

    InputStreamProvider getInputStreamProvider(OutputStreamProvider provider) {
        StreamProviderFactory factory = this.getStreamProviderFactory();
        return factory.createInputProvider(provider);
    }

    OutputStreamProvider getInputOnlyStreamProvider(ArchiveEntry entry) {
        StreamProviderFactory factory = this.getStreamProviderFactory();
        return factory.createOriginalReadOnlyProvider(entry);
    }

    public StreamProviderFactory getStreamProviderFactory() {
        return this.providerFactory_;
    }

    public void setStreamProviderFactory(StreamProviderFactory factory) {
        this.providerFactory_ = factory;
    }

    OutputStream openOutputStream(ArchiveEntry entry) throws IOException {
        OutputStreamProvider provider = this.getOutputStreamProvider(entry);
        this.openedOutputStreamProviders_.add(provider);
        provider.addChangeListener(new StreamCloseListener(provider));
        return provider.getOutputStream();
    }

    synchronized void outputStreamClosed(OutputStreamProvider output) throws IOException {
        String entryName = output.getEntry().getName();
        if (output.isDirty()) {
            if (!this.openedOutputStreamProviders_.contains(output)) {
                output.release();
                throw new IOException(FwkArb.getString(7));
            }
            OutputStreamProvider oldProvider = this.modifiedEntries_.get(entryName);
            if (oldProvider != null && this.pinnedProviders_.get(oldProvider) == null) {
                oldProvider.release();
            }
            Assert.check((output.getStatus() == 3 ? 1 : 0) != 0);
            this.modifiedEntries_.put(entryName, output);
        } else {
            output.release();
        }
        this.openedOutputStreamProviders_.remove(output);
    }

    synchronized InputStream openInputStream(ArchiveEntry entry) throws IOException {
        OutputStreamProvider provider = this.modifiedEntries_.get(entry.getName());
        if (provider == null) {
            provider = this.getInputOnlyStreamProvider(entry);
        }
        InputStreamProvider newProvider = this.getInputStreamProvider(provider);
        ArrayList<InputStreamProvider> currentStreams = this.pinnedProviders_.get(provider);
        if (currentStreams == null) {
            currentStreams = new ArrayList();
            this.pinnedProviders_.put(provider, currentStreams);
        }
        currentStreams.add(newProvider);
        newProvider.addChangeListener(new StreamCloseListener(newProvider, provider));
        return newProvider.getInputStream();
    }

    synchronized void inputStreamClosed(StreamProvider inputProvider, StreamProvider outputProvider) throws IOException {
        ArrayList<InputStreamProvider> streams = this.pinnedProviders_.get(outputProvider);
        streams.remove(inputProvider);
        if (streams.size() == 0) {
            this.pinnedProviders_.remove(outputProvider);
            String entryName = outputProvider.getEntry().getName();
            if (this.modifiedEntries_.get(entryName) != outputProvider) {
                outputProvider.release();
            }
        }
        inputProvider.release();
    }

    public URL getURL() {
        return this.url_;
    }

    public void setURL(URL url) {
        this.url_ = url;
    }

    public void load() throws IOException {
        this.load(this.getURL());
    }

    public void load(URL url) throws IOException {
        this.rollback();
    }

    public OutputStream getOutputStream(ArchiveEntry entry) throws IOException {
        if (this.isArchiveReadOnly()) {
            throw new IOException(FwkArb.format(1, this.getURL()));
        }
        return this.openOutputStream(entry);
    }

    public InputStream getInputStream(ArchiveEntry entry) throws IOException {
        return this.openInputStream(entry);
    }

    public void release() throws IOException {
        IOException e = null;
        try {
            for (OutputStreamProvider key : this.pinnedProviders_.keySet()) {
                for (InputStreamProvider inStreamProvider : this.pinnedProviders_.get(key)) {
                    try {
                        inStreamProvider.getInputStream().close();
                    }
                    catch (IOException exc) {
                        IOException iOException = e = e == null ? exc : e;
                    }
                }
            }
            Assert.check((this.pinnedProviders_.size() == 0 ? 1 : 0) != 0, (String)("Output streams still open: " + this.pinnedProviders_.size()));
            for (OutputStreamProvider provider : this.modifiedEntries_.values()) {
                try {
                    Assert.check((provider.getStatus() == 3 ? 1 : 0) != 0, (String)"Expected output stream to be closed");
                    provider.release();
                }
                catch (IOException exc) {
                    IOException iOException = e = e == null ? exc : e;
                }
            }
            for (OutputStreamProvider provider : this.openedOutputStreamProviders_) {
                try {
                    provider.getOutputStream().close();
                }
                catch (IOException exc) {
                    IOException iOException = e = e == null ? exc : e;
                }
            }
        }
        finally {
            if (e != null) {
                throw e;
            }
        }
    }

    class StreamCloseListener
    implements ChangeListener {
        OutputStreamProvider output_;
        InputStreamProvider input_;

        StreamCloseListener(OutputStreamProvider output) {
            this.output_ = output;
            this.input_ = null;
        }

        StreamCloseListener(InputStreamProvider input, OutputStreamProvider output) {
            this.output_ = output;
            this.input_ = input;
        }

        public void stateChanged(ChangeEvent e) {
            MonitoredStream st = (MonitoredStream)e.getSource();
            if (st.getStatus() == 3) {
                try {
                    if (this.input_ != null) {
                        AbstractModuleIO.this.inputStreamClosed(this.input_, this.output_);
                    } else {
                        AbstractModuleIO.this.outputStreamClosed(this.output_);
                    }
                }
                catch (IOException exc) {
                    throw new CouchedException(exc);
                }
            }
        }
    }

    static class CouchedException
    extends RuntimeException {
        CouchedException(Exception e) {
            super(e);
        }
    }
}

