/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.stripe;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.event.EventListenerList;
import oracle.ide.nulls.NullPrintWriter;
import oracle.ide.util.Assert;
import oracle.javatools.data.HashStructure;
import oracle.jdeveloper.deploy.Archive;
import oracle.jdeveloper.deploy.ArchiveEntry;
import oracle.jdeveloper.deploy.DeployException;
import oracle.jdeveloper.deploy.DeploymentModule;
import oracle.jdeveloper.deploy.DeploymentModuleEvent;
import oracle.jdeveloper.deploy.DeploymentModuleIO;
import oracle.jdeveloper.deploy.DeploymentModuleIOFactory;
import oracle.jdeveloper.deploy.DeploymentModuleListener;

public class DeploymentModuleImpl
extends DeploymentModule {
    DeploymentModuleIO io_;
    PrintWriter printWriter_;
    TagSupport tagSupport_;
    HashStructure properties_;
    static final EventListenerList listeners_ = new EventListenerList();
    static DefaultModuleIOFactoryImpl defaultModuleIOFactory_ = new DefaultModuleIOFactoryImpl();

    private void $init$() {
        this.tagSupport_ = new TagSupport();
        this.properties_ = HashStructure.newInstance();
    }

    private DeploymentModuleImpl() {
        this.$init$();
    }

    public DeploymentModuleImpl(Archive archive, DeploymentModuleIO moduleIO, PrintWriter printWriter, Object[] initialTags) {
        this.$init$();
        this.printWriter_ = printWriter == null ? new NullPrintWriter() : printWriter;
        this.io_ = moduleIO;
        try {
            this.io_.setArchive(this);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.fireModuleCreated();
        if (archive != null) {
            archive.copyTo(this);
        }
        this.tagSupport_.add(initialTags);
    }

    public void addContents(ArchiveEntry cdaPacket) {
        super.addContents(cdaPacket);
        this.fireEntryAdded(cdaPacket);
    }

    public ArchiveEntry removeEntry(String entryName) {
        ArchiveEntry entry = super.removeEntry(entryName);
        if (entry != null) {
            this.fireEntryRemoved(entry);
        }
        return entry;
    }

    public ArchiveEntry renameEntry(String fromName, String toName) {
        int READ_BLOCK_SIZE = 2048;
        if (fromName.equals(toName)) {
            return null;
        }
        ArchiveEntry from = this.getEntryByName(fromName);
        if (from == null) {
            return null;
        }
        ArchiveEntry to = new ArchiveEntry(toName, null);
        InputStream in = null;
        OutputStream out = null;
        try {
            int r;
            this.addContents(to);
            in = this.openInputStream(from);
            out = this.openOutputStream(to);
            byte[] buffer = new byte[2048];
            do {
                if ((r = in.read(buffer)) < 0) continue;
                out.write(buffer, 0, r);
            } while (r >= 0);
        }
        catch (IOException e) {
            this.removeEntry(toName);
            ArchiveEntry archiveEntry = null;
            DeploymentModule.close(in, out);
            try {
                return archiveEntry;
            }
            catch (Throwable throwable) {
                DeploymentModule.close(in, out);
                throw throwable;
            }
        }
        DeploymentModule.close(in, out);
        this.removeEntry(fromName);
        return to;
    }

    @Deprecated
    public static DeploymentModuleImpl create(String moduleIO) {
        return DeploymentModuleImpl.create(null, moduleIO, null, null);
    }

    public static DeploymentModuleImpl create(Archive archive, String ioModule, PrintWriter printWriter, Object[] initialTags) {
        DeploymentModuleIOFactory factory = DeploymentModuleImpl.getModuleIOFactory();
        Assert.check((factory != null ? 1 : 0) != 0, (String)"Could not find any I/O modules for this deployment");
        return new DeploymentModuleImpl(archive, factory.create(ioModule), printWriter, initialTags);
    }

    public void commit() throws DeployException {
        this.fireModuleWillCommit();
        try {
            this.io_.commit();
        }
        catch (IOException e) {
            throw new DeployException(e);
        }
        this.fireModuleCommitted();
    }

    public void rollback() throws DeployException {
        this.fireModuleWillRollback();
        try {
            this.io_.rollback();
        }
        catch (IOException e) {
            throw new DeployException(e);
        }
        this.fireModuleRolledback();
    }

    public void load() throws IOException {
        this.io_.load();
    }

    public OutputStream openOutputStream(ArchiveEntry entry) throws IOException {
        return this.io_.getOutputStream(entry);
    }

    public InputStream openInputStream(ArchiveEntry entry) throws IOException {
        return this.io_.getInputStream(entry);
    }

    public PrintWriter getPrintWriter() {
        return this.printWriter_;
    }

    public DeploymentModule[] getContainedModules() {
        return new DeploymentModule[0];
    }

    public static void close(Throwable throwable, Object[] streams) throws Throwable {
        int i = 0;
        while (i < streams.length) {
            Object obj = streams[i];
            if (obj instanceof InputStream) {
                try {
                    ((InputStream)obj).close();
                }
                catch (IOException e) {}
            } else if (obj instanceof OutputStream) {
                try {
                    ((OutputStream)obj).close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            ++i;
        }
        if (throwable != null) {
            throw throwable;
        }
    }

    public static void close(Object[] streams) {
        try {
            DeploymentModuleImpl.close(null, streams);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addChangeListenerImpl(DeploymentModuleListener listener) {
        EventListenerList eventListenerList = listeners_;
        synchronized (eventListenerList) {
            listeners_.add(DeploymentModuleListener.class, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeChangeListenerImpl(DeploymentModuleListener listener) {
        EventListenerList eventListenerList = listeners_;
        synchronized (eventListenerList) {
            listeners_.remove(DeploymentModuleListener.class, listener);
        }
    }

    void fireModuleCreated() {
        DeploymentModuleEvent event = new DeploymentModuleEvent(this, 1);
        this.fireEvent(event);
    }

    void fireModuleWillCommit() {
        DeploymentModuleEvent event = new DeploymentModuleEvent(this, 2);
        this.fireEvent(event);
    }

    void fireModuleCommitted() {
        DeploymentModuleEvent event = new DeploymentModuleEvent(this, 5);
        this.fireEvent(event);
    }

    void fireModuleWillRollback() {
        DeploymentModuleEvent event = new DeploymentModuleEvent(this, 3);
        this.fireEvent(event);
    }

    void fireModuleRolledback() {
        DeploymentModuleEvent event = new DeploymentModuleEvent(this, 4);
        this.fireEvent(event);
    }

    void fireEntryAdded(ArchiveEntry entry) {
        DeploymentModuleEvent event = new DeploymentModuleEvent((DeploymentModule)this, 6, entry);
        this.fireEvent(event);
    }

    void fireEntryRemoved(ArchiveEntry entry) {
        DeploymentModuleEvent event = new DeploymentModuleEvent((DeploymentModule)this, 7, entry);
        this.fireEvent(event);
    }

    void fireTagAdded(Object tag) {
        DeploymentModuleEvent event = new DeploymentModuleEvent((DeploymentModule)this, 8, tag);
        this.fireEvent(event);
    }

    void fireTagRemoved(Object tag) {
        DeploymentModuleEvent event = new DeploymentModuleEvent((DeploymentModule)this, 9, tag);
        this.fireEvent(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireEvent(DeploymentModuleEvent event) {
        EventListenerList eventListenerList = listeners_;
        synchronized (eventListenerList) {
            DeploymentModuleListener[] deploymentModuleListenerArray = (DeploymentModuleListener[])listeners_.getListeners(DeploymentModuleListener.class);
            int n = 0;
            while (n < deploymentModuleListenerArray.length) {
                DeploymentModuleListener listener = deploymentModuleListenerArray[n];
                listener.moduleChanged(event);
                ++n;
            }
        }
    }

    public static void addModuleIOFactoryImpl(DeploymentModuleIOFactory factory) {
        defaultModuleIOFactory_.add(factory);
    }

    public static DeploymentModuleIOFactory getModuleIOFactory() {
        return defaultModuleIOFactory_;
    }

    public void release() throws DeployException {
        try {
            this.io_.release();
        }
        catch (IOException e) {
            throw new DeployException(e);
        }
    }

    public URL getURL() {
        return this.io_.getURL();
    }

    public void setURL(URL targetURL) throws IOException {
        this.io_.setURL(targetURL);
    }

    public void setModuleIO(String ioModule) {
        DeploymentModuleIOFactory factory = DeploymentModuleImpl.getModuleIOFactory();
        Assert.check((factory != null ? 1 : 0) != 0, (String)"Could not find any I/O modules for this deployment");
        this.io_ = factory.create(ioModule);
        Assert.check((this.io_ != null ? 1 : 0) != 0, (String)"Could not find any I/O modules for this deployment");
        try {
            this.io_.setArchive(this);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void addTag(Object tag) {
        this.tagSupport_.add(tag);
    }

    public Object[] getTags() {
        return this.tagSupport_.getTags();
    }

    public Object removeTag(Object tag) {
        return this.tagSupport_.remove(tag);
    }

    public HashStructure getProperties() {
        return this.properties_;
    }

    public Object copyTo(Object target) {
        DeploymentModuleImpl copy = target != null ? (DeploymentModuleImpl)target : new DeploymentModuleImpl();
        this.copyToImpl(copy);
        return copy;
    }

    protected void copyToImpl(DeploymentModuleImpl copy) {
        super.copyTo(copy);
        copy.properties_ = this.properties_.copyTo(null);
        this.tagSupport_.copyTo(copy.tagSupport_);
        copy.printWriter_ = this.printWriter_;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DefaultModuleIOFactoryImpl
    extends ArrayList<DeploymentModuleIOFactory>
    implements DeploymentModuleIOFactory {
        @Override
        public DeploymentModuleIO create(String moduleIO) {
            int i = this.size() - 1;
            while (i >= 0) {
                DeploymentModuleIO io = ((DeploymentModuleIOFactory)this.get(i)).create(moduleIO);
                if (io != null) {
                    return io;
                }
                --i;
            }
            return null;
        }

        DefaultModuleIOFactoryImpl() {
        }
    }

    class TagSupport {
        TreeSet<Object> tags_;

        private void $init$() {
            this.tags_ = new TreeSet();
        }

        TagSupport() {
            this.$init$();
        }

        TagSupport(TagSupport t) {
            this.$init$();
            for (Object o : t.tags_) {
                this.add(o);
            }
        }

        void add(Object tag) {
            this.tags_.add(tag);
            DeploymentModuleImpl.this.fireTagAdded(tag);
        }

        void add(Object[] tags) {
            if (tags == null) {
                return;
            }
            Object[] objectArray = tags;
            int n = 0;
            while (n < objectArray.length) {
                Object tag = objectArray[n];
                this.add(tag);
                ++n;
            }
        }

        Object[] getTags() {
            return this.tags_.toArray();
        }

        Object remove(Object tag) {
            boolean removed = this.tags_.remove(tag);
            if (removed) {
                DeploymentModuleImpl.this.fireTagRemoved(tag);
                return tag;
            }
            return null;
        }

        public Object copyTo(Object o) {
            TagSupport copy = o == null ? new TagSupport() : (TagSupport)o;
            this.copyToImpl(copy);
            return copy;
        }

        protected void copyToImpl(TagSupport t) {
            t.tags_ = new TreeSet<Object>((SortedSet<Object>)this.tags_);
        }
    }
}

