/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.stripe;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Iterator;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.jdeveloper.deploy.Archive;
import oracle.jdeveloper.deploy.ArchiveEntry;
import oracle.jdeveloper.deploy.DeploymentModuleIO;
import oracle.jdeveloper.deploy.DeploymentModuleIOFactory;
import oracle.jdevimpl.deploy.fwk.ArchiveIO;
import oracle.jdevimpl.deploy.stripe.AbstractModuleIO;

public class DirectoryModuleIO
extends AbstractModuleIO {
    public void commitImpl() throws IOException {
        DeploymentModuleDirectoryIO io_ = new DeploymentModuleDirectoryIO(this);
        io_.write(this.archive_, this.getURL(), this.archive_.getPrintWriter());
    }

    public void rollback() {
    }

    public boolean isArchiveReadOnly() {
        return false;
    }

    public static class DeploymentModuleDirectoryIO
    extends ArchiveIO {
        protected AbstractModuleIO moduleIO_;

        public DeploymentModuleDirectoryIO(AbstractModuleIO moduleIO) {
            this.moduleIO_ = moduleIO;
        }

        public void write(Archive archive, URL outputURL, PrintWriter printWriter, boolean forceRewrite) throws IOException {
            URL baseDirURL = URLFactory.newDirURL((URL)outputURL, (String)"");
            this.removeArchive(outputURL);
            URLFileSystem.mkdir((URL)baseDirURL);
            Iterator<ArchiveEntry> iter = archive.getArchiveEntries();
            while (iter.hasNext()) {
                ArchiveEntry entry = iter.next();
                String entryName = entry.getName();
                if (entryName.endsWith("/") || entryName.endsWith("\\")) {
                    URL dirURL = URLFactory.newDirURL((URL)baseDirURL, (String)entryName);
                    URLFileSystem.mkdir((URL)dirURL);
                    continue;
                }
                URL fileURL = URLFactory.newURL((URL)baseDirURL, (String)entryName);
                this.persistFileEntry(archive, entry, fileURL);
            }
        }

        protected void persistFileEntry(Archive archive, ArchiveEntry entry, URL fileURL) throws IOException {
            URL entryURL = entry.getURL();
            if (entryURL != null && URLFileSystem.exists((URL)entryURL) && URLFileSystem.isDirectory((URL)entryURL)) {
                this.copyDirToUrl(entry, fileURL);
            } else {
                InputStream in = null;
                try {
                    in = this.moduleIO_.getInputStream(entry);
                    this.copyStreamToUrl(in, fileURL);
                }
                finally {
                    if (in != null) {
                        in.close();
                    }
                }
            }
        }

        protected void copyDirToUrl(ArchiveEntry ent, URL fileURL) {
        }

        protected void copyStreamToUrl(InputStream in, URL fileURL) throws IOException {
            URLFileSystem.copy((InputStream)in, (URL)fileURL);
        }
    }

    public static class DirectoryModuleIOFactory
    implements DeploymentModuleIOFactory {
        public DeploymentModuleIO create(String moduleIO) {
            if ("Persistence.DIRECTORY".equals(moduleIO)) {
                return new DirectoryModuleIO();
            }
            return null;
        }
    }
}

