/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.stripe;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.event.ChangeListener;
import oracle.ide.util.Assert;
import oracle.jdevimpl.deploy.stripe.MonitoredStream;

class MonitoredInputStream
extends FilterInputStream
implements MonitoredStream {
    MonitoredStream.ListenerSupport listenerSupport;
    MonitoredStream.StatusSupport status_;
    boolean dirty_;

    private void $init$() {
        this.listenerSupport = new MonitoredStream.ListenerSupport();
        this.status_ = new MonitoredStream.StatusSupport(this.listenerSupport, this);
    }

    MonitoredInputStream(InputStream in) {
        super(in);
        this.$init$();
        this.dirty_ = false;
        this.status_.setStatus(1);
    }

    MonitoredInputStream() {
        this(null);
        this.status_.setStatus(0);
    }

    public void setStreamAndStatus(InputStream in, int status) {
        Assert.check((status != 0 ? 1 : 0) != 0, (String)"Cannot set UNDEFINED status on initial stream");
        this.in = in;
        this.status_.setStatus(status);
    }

    public void addChangeListener(ChangeListener listener) {
        this.listenerSupport.addListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.listenerSupport.removeListener(listener);
    }

    public int getStatus() {
        return this.status_.getStatus();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (!this.dirty_) {
            this.dirty_ = true;
        }
        return super.read(b, off, len);
    }

    public synchronized void reset() throws IOException {
        if (!this.dirty_) {
            this.dirty_ = true;
        }
        super.reset();
    }

    public int read(byte[] b) throws IOException {
        if (!this.dirty_) {
            this.dirty_ = true;
        }
        return super.read(b);
    }

    public int read() throws IOException {
        if (!this.dirty_) {
            this.dirty_ = true;
        }
        return super.read();
    }

    public long skip(long n) throws IOException {
        if (!this.dirty_) {
            this.dirty_ = true;
        }
        return super.skip(n);
    }

    public void close() throws IOException {
        super.close();
        this.status_.setStatus(3);
    }

    public boolean isDirty() {
        return this.dirty_;
    }
}

