/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.stripe;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.event.ChangeListener;
import oracle.jdevimpl.deploy.stripe.AbstractModuleIO;
import oracle.jdevimpl.deploy.stripe.MonitoredStream;

class MonitoredOutputStream
extends FilterOutputStream
implements MonitoredStream {
    MonitoredStream.ListenerSupport listenerSupport;
    MonitoredStream.StatusSupport status_;
    boolean dirty_;

    private void $init$() {
        this.listenerSupport = new MonitoredStream.ListenerSupport();
        this.status_ = new MonitoredStream.StatusSupport(this.listenerSupport, this);
    }

    MonitoredOutputStream(OutputStream out) {
        super(out);
        this.$init$();
        this.dirty_ = false;
        this.status_.setStatus(1);
    }

    MonitoredOutputStream() {
        this(null);
        this.status_.setStatus(0);
    }

    public void setStreamAndStatus(OutputStream out, int status) {
        this.out = out;
        this.status_.setStatus(status);
    }

    public void addChangeListener(ChangeListener listener) {
        this.listenerSupport.addListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.listenerSupport.removeListener(listener);
    }

    public int getStatus() {
        return this.status_.getStatus();
    }

    public void write(int b) throws IOException {
        if (!this.dirty_) {
            this.dirty_ = true;
        }
        super.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (!this.dirty_) {
            this.dirty_ = true;
        }
        super.write(b, off, len);
    }

    public void write(byte[] b) throws IOException {
        if (!this.dirty_) {
            this.dirty_ = true;
        }
        super.write(b);
    }

    public void flush() throws IOException {
        if (!this.dirty_) {
            this.dirty_ = true;
        }
        super.flush();
    }

    public void close() throws IOException {
        super.close();
        try {
            this.status_.setStatus(3);
        }
        catch (AbstractModuleIO.CouchedException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw e;
        }
    }

    public boolean isDirty() {
        return this.dirty_;
    }
}

