/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.stripe;

import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

interface MonitoredStream {
    public static final int UNDEFINED = 0;
    public static final int OPEN = 1;
    public static final int CLOSED = 3;

    public int getStatus();

    public boolean isDirty();

    public void addChangeListener(ChangeListener var1);

    public void removeChangeListener(ChangeListener var1);

    public static class ListenerSupport {
        EventListenerList list;

        private void $init$() {
            this.list = new EventListenerList();
        }

        void addListener(ChangeListener listener) {
            this.list.add(ChangeListener.class, listener);
        }

        void removeListener(ChangeListener listener) {
            this.list.remove(ChangeListener.class, listener);
        }

        void fireChangeListeners(MonitoredStream stream) {
            ChangeEvent event = new ChangeEvent(stream);
            ChangeListener[] changeListenerArray = (ChangeListener[])this.list.getListeners(ChangeListener.class);
            int n = 0;
            while (n < changeListenerArray.length) {
                ChangeListener listener = changeListenerArray[n];
                listener.stateChanged(event);
                ++n;
            }
        }

        public ListenerSupport() {
            this.$init$();
        }
    }

    public static class StatusSupport {
        final ListenerSupport listeners_;
        final MonitoredStream source_;
        int status;

        private void $init$() {
            this.status = 0;
        }

        StatusSupport(ListenerSupport listeners, MonitoredStream stream) {
            this.$init$();
            this.listeners_ = listeners;
            this.source_ = stream;
        }

        void setStatus(int newStatus) {
            if (newStatus != this.status) {
                this.status = newStatus;
                this.listeners_.fireChangeListeners(this.source_);
            }
        }

        int getStatus() {
            return this.status;
        }
    }
}

