/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.stripe;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.Assert;
import oracle.jdeveloper.deploy.ArchiveEntry;
import oracle.jdeveloper.deploy.DefaultArchive;
import oracle.jdeveloper.deploy.DeploymentModuleIO;
import oracle.jdeveloper.deploy.DeploymentModuleIOFactory;
import oracle.jdevimpl.deploy.fwk.ArchiveIO;
import oracle.jdevimpl.deploy.stripe.AbstractModuleIO;
import oracle.jdevimpl.deploy.stripe.DirectoryModuleIO;
import oracle.jdevimpl.deploy.stripe.JarModuleIO;

public class PackingListIO
extends AbstractModuleIO {
    static final String PACKINGLIST_ENTRY_NAME = "packingList.xml";
    protected final String xmlHead;
    final ArchiveIO impl_;
    final OutputType outputType_;

    private void $init$() {
        this.xmlHead = "<?xml version=\"1.0\" ?>\n<archive xmlns=\"http://xmlns.oracle.com/jdeveloper/1013/jdev-deployment/packinglist\">";
    }

    protected String getPackingListEntryName() {
        return PACKINGLIST_ENTRY_NAME;
    }

    public PackingListIO(OutputType outputType) {
        this.$init$();
        this.outputType_ = outputType;
        switch (1.$sm$oracle$jdevimpl$deploy$stripe$PackingListIO$OutputType[outputType.ordinal()]) {
            case 1: {
                this.impl_ = new JarModuleIO.DeploymentModuleJarIO(this);
                break;
            }
            case 2: {
                this.impl_ = new DirectoryModuleIO.DeploymentModuleDirectoryIO(this);
                break;
            }
            default: {
                throw new IllegalArgumentException("Should specify a valid OutputType");
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void commitImpl() throws IOException {
        block13: {
            outputLocation = this.getURL();
            persistedOutputLocation = null;
            packingListEntryName = this.getPackingListEntryName();
            modifiedFiles = new ArrayList<URL>();
            try {
                persistedOutputLocation = URLFileSystem.createTempFile((String)(URLFileSystem.getName((URL)outputLocation) + "_contents"), (String)".tmp", (URL)URLFileSystem.getParent((URL)outputLocation));
                ArchiveIO.recursiveDelete(persistedOutputLocation);
                persistedOutputLocation = URLFactory.newDirURL((URL)persistedOutputLocation, (String)"");
                URLFileSystem.mkdirs((URL)persistedOutputLocation);
                packingListURL = URLFileSystem.createTempFile((String)"_packingList", (String)".xml", (URL)persistedOutputLocation);
                modifiedFiles.add(packingListURL);
                p = new PrintWriter(URLFileSystem.openOutputStream((URL)packingListURL));
                p.println("<?xml version=\"1.0\" ?>\n<archive xmlns=\"http://xmlns.oracle.com/jdeveloper/1013/jdev-deployment/packinglist\">");
                packingListArchive = DefaultArchive.create(this.archive_.isIncludeManifest(), false);
                iter = this.archive_.getArchiveEntries();
                while (iter.hasNext()) {
                    packingListEntry = entry = iter.next();
                    if (this.isModified(entry)) {
                        fileURL = URLFactory.newURL((URL)persistedOutputLocation, (String)entry.getName());
                        modifiedFiles.add(fileURL);
                        in = this.archive_.openInputStream(entry);
                        URLFileSystem.copy((InputStream)in, (URL)fileURL);
                        packingListArchive.addContents(new ArchiveEntry(entry.getName(), fileURL));
                        packingListEntryURL = null;
                        packingListEntryURL = this.outputType_ == OutputType.JAR_PACKING_LIST ? URLFactory.newJarURL((URL)outputLocation, (String)entry.getName()) : URLFactory.newURL((URL)outputLocation, (String)entry.getName());
                        packingListEntry = new ArchiveEntry(entry.getName(), packingListEntryURL);
                    } else if (entry.getURL() == null) {
                        this.archive_.getPrintWriter().println("Warning: Skipping entry " + entry.getName() + ". No content.");
                        continue;
                    }
                    p.println("  <entry>");
                    p.println("    <name>" + packingListEntry.getName() + "</name>");
                    p.println("    <url>" + packingListEntry.getURL().toExternalForm() + "</url>");
                    p.println("  </entry>");
                }
                p.println("</archive>");
                p.close();
                this.archive_.addContents(new ArchiveEntry(packingListEntryName, packingListURL));
                packingListArchive.addContents(new ArchiveEntry(packingListEntryName, packingListURL));
                this.impl_.write(packingListArchive, outputLocation, this.archive_.getPrintWriter());
                Assert.println((String)("Packing list archive commited to " + outputLocation));
            }
            finally {
                if (this.outputType_ != OutputType.JAR_PACKING_LIST) break block13;
                ** for (url : modifiedFiles)
            }
lbl-1000:
            // 1 sources

            {
                try {
                    URLFileSystem.deleteEx((URL)url);
                }
                catch (Throwable t) {
                    this.archive_.getPrintWriter().println("Could not remove " + url.toString() + ":" + t.getMessage());
                }
                continue;
            }
        }
        if (persistedOutputLocation != null) {
            ArchiveIO.recursiveDelete(persistedOutputLocation);
        }
    }

    protected ArchiveEntry copyToOutputLocation(ArchiveEntry entry, URL directory) throws IOException {
        InputStream in = this.getInputStream(entry);
        URL newUrl = URLFactory.newURL((URL)directory, (String)entry.getName());
        URLFileSystem.copy((InputStream)in, (URL)newUrl);
        return new ArchiveEntry(entry.getName(), newUrl);
    }

    public void rollback() {
    }

    public boolean isArchiveReadOnly() {
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class OutputType
    extends Enum<OutputType> {
        private static final /* synthetic */ OutputType[] $v;
        public static final /* enum */ OutputType JAR_PACKING_LIST;
        public static final /* enum */ OutputType DIRECTORY_PACKING_LIST;

        public static OutputType valueOf(String string) {
            return Enum.valueOf(OutputType.class, string);
        }

        public static final OutputType[] values() {
            return (OutputType[])$v.clone();
        }

        static {
            OutputType[] outputTypeArray = new OutputType[2];
            outputTypeArray[1] = DIRECTORY_PACKING_LIST = new OutputType("DIRECTORY_PACKING_LIST", 1);
            outputTypeArray[0] = JAR_PACKING_LIST = new OutputType("JAR_PACKING_LIST", 0);
            $v = outputTypeArray;
        }

        private OutputType(String string2, int n2) {
        }
    }

    public static class PackingListIOFactory
    implements DeploymentModuleIOFactory {
        public DeploymentModuleIO create(String moduleIO) {
            if ("Persistence.PackingList.FILE".equals(moduleIO)) {
                return new PackingListIO(OutputType.JAR_PACKING_LIST);
            }
            if ("Persistence.PackingList.DIRECTORY".equals(moduleIO)) {
                return new PackingListIO(OutputType.DIRECTORY_PACKING_LIST);
            }
            return null;
        }
    }

    static class 1 {
        static final /* synthetic */ int[] $sm$oracle$jdevimpl$deploy$stripe$PackingListIO$OutputType;

        static {
            int[] nArray = new int[OutputType.values().length];
            $sm$oracle$jdevimpl$deploy$stripe$PackingListIO$OutputType = nArray;
            try {
                nArray[OutputType.JAR_PACKING_LIST.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$sm$oracle$jdevimpl$deploy$stripe$PackingListIO$OutputType[OutputType.DIRECTORY_PACKING_LIST.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
        }
    }
}

