/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.stripe;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.event.ChangeListener;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.Assert;
import oracle.jdeveloper.deploy.ArchiveEntry;
import oracle.jdevimpl.deploy.res.FwkArb;
import oracle.jdevimpl.deploy.stripe.InputStreamProvider;
import oracle.jdevimpl.deploy.stripe.MonitoredInputStream;
import oracle.jdevimpl.deploy.stripe.MonitoredOutputStream;
import oracle.jdevimpl.deploy.stripe.MonitoredStream;
import oracle.jdevimpl.deploy.stripe.OutputStreamProvider;
import oracle.jdevimpl.deploy.stripe.StreamProvider;
import oracle.jdevimpl.deploy.stripe.StreamProviderFactory;
import oracle.jdevimpl.deploy.stripe.URLInputStreamProvider;
import oracle.jdevimpl.deploy.stripe.URLOutputStreamProvider;

public class URLStreamProviderFactory
extends StreamProviderFactory {
    InputStreamProvider createInputProvider(OutputStreamProvider provider) {
        if (provider instanceof URLOutputStreamProvider) {
            URLOutputStreamProvider output = (URLOutputStreamProvider)provider;
            return new FileInputStreamProvider(output);
        }
        return super.createInputProvider(provider);
    }

    OutputStreamProvider createTempOutputProvider(ArchiveEntry entry) {
        return new FileOutputStreamProvider(entry);
    }

    OutputStreamProvider createOriginalReadOnlyProvider(ArchiveEntry entry) {
        return new ReadOnlyOutputStreamProvider(entry);
    }

    static abstract class AbstractStreamProvider
    implements StreamProvider {
        protected final ArchiveEntry entry_;

        AbstractStreamProvider(ArchiveEntry entry) {
            this.entry_ = entry;
        }

        public ArchiveEntry getEntry() {
            return this.entry_;
        }

        public void release() throws IOException {
            this.releaseImpl();
        }

        protected void releaseImpl() throws IOException {
            this.closeStream();
        }

        public int getStatus() {
            return this.getStream().getStatus();
        }

        public void addChangeListener(ChangeListener listener) {
            this.getStream().addChangeListener(listener);
        }

        public void removeChangeListener(ChangeListener listener) {
            this.getStream().removeChangeListener(listener);
        }

        abstract MonitoredStream getStream();

        abstract void closeStream() throws IOException;
    }

    static abstract class AbstractInputStreamProvider
    extends AbstractStreamProvider
    implements InputStreamProvider {
        protected final OutputStreamProvider output_;
        protected final MonitoredInputStream stream_;

        AbstractInputStreamProvider(OutputStreamProvider output) {
            super(output.getEntry());
            this.output_ = output;
            this.stream_ = new MonitoredInputStream();
        }

        MonitoredStream getStream() {
            return this.stream_;
        }

        public boolean isDirty() {
            return this.stream_.isDirty();
        }
    }

    static abstract class AbstractOutputStreamProvider
    extends AbstractStreamProvider
    implements OutputStreamProvider {
        protected final MonitoredOutputStream stream_ = new MonitoredOutputStream();

        AbstractOutputStreamProvider(ArchiveEntry entry) {
            super(entry);
        }

        MonitoredStream getStream() {
            return this.stream_;
        }

        public boolean isDirty() {
            return this.stream_.isDirty();
        }
    }

    static class FileInputStreamProvider
    extends AbstractInputStreamProvider
    implements URLInputStreamProvider {
        FileInputStreamProvider(URLOutputStreamProvider output) {
            super(output);
        }

        public MonitoredInputStream getInputStream() throws IOException {
            if (this.stream_.getStatus() == 0) {
                InputStream input = this.output_.getRawInputStream();
                this.stream_.setStreamAndStatus(input, 1);
            }
            return this.stream_;
        }

        public URL getURL() {
            return ((URLOutputStreamProvider)this.output_).getURL();
        }

        public void copyTo(URL url) throws IOException {
            URLFileSystem.copy((URL)this.getURL(), (URL)url);
        }

        void closeStream() throws IOException {
            this.stream_.close();
        }
    }

    static class FileOutputStreamProvider
    extends AbstractOutputStreamProvider
    implements URLOutputStreamProvider {
        URL fileURL_;
        final boolean deleteOnRelease_;

        private void $init$() {
            this.fileURL_ = null;
        }

        FileOutputStreamProvider(ArchiveEntry entry) {
            this(entry, null, true);
        }

        FileOutputStreamProvider(ArchiveEntry entry, URL url, boolean deleteOnRelease) {
            super(entry);
            this.$init$();
            this.deleteOnRelease_ = deleteOnRelease;
            this.fileURL_ = url;
        }

        public MonitoredOutputStream getOutputStream() throws IOException {
            if (this.stream_.getStatus() == 0) {
                if (this.fileURL_ == null) {
                    String entryName = this.getEntry().getName();
                    String prefix = entryName.replaceAll("\\/", "_").replaceAll("\\.", "_");
                    this.fileURL_ = URLFileSystem.createTempFile((String)prefix, (String)".tmp", null);
                    Assert.println((String)("Temporary file created " + this.fileURL_.toExternalForm()));
                }
                this.stream_.setStreamAndStatus(URLFileSystem.openOutputStream((URL)this.fileURL_), 1);
            }
            return this.stream_;
        }

        public InputStream getRawInputStream() throws IOException {
            if (this.fileURL_ != null) {
                return URLFileSystem.openInputStream((URL)this.fileURL_);
            }
            return new NullInputStream();
        }

        public void releaseImpl() throws IOException {
            Assert.println((String)("OutputStream released. URL:" + (this.fileURL_ != null ? this.fileURL_.toExternalForm() : "null")));
            if (this.fileURL_ != null && this.deleteOnRelease_) {
                if (URLFileSystem.delete((URL)this.fileURL_)) {
                    Assert.println((String)("Deleted " + this.fileURL_.toExternalForm()));
                    this.fileURL_ = null;
                } else {
                    Assert.println((String)("File could not be deleted. " + this.fileURL_.toExternalForm()));
                }
            }
        }

        public URL getURL() {
            Assert.check((this.fileURL_ != null ? 1 : 0) != 0, (String)"Cannot determine URL, OutputStream not opened yet");
            return this.fileURL_;
        }

        public void copyTo(URL url) throws IOException {
            if (this.fileURL_ == null) {
                throw new MalformedURLException(FwkArb.getString(3));
            }
            URLFileSystem.copy((URL)this.fileURL_, (URL)url);
        }

        void closeStream() throws IOException {
            this.stream_.close();
        }
    }

    static class ReadOnlyOutputStreamProvider
    extends FileOutputStreamProvider {
        ReadOnlyOutputStreamProvider(ArchiveEntry entry) {
            super(entry, entry.getURL(), false);
        }

        public MonitoredOutputStream getOutputStream() throws IOException {
            throw new IOException(FwkArb.getString(2));
        }
    }

    static class NullInputStream
    extends ByteArrayInputStream {
        NullInputStream() {
            super(new byte[0], 0, 0);
        }
    }
}

