/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.inspector.extension;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.VetoableChangeListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.bali.ewt.spinBox.NumericSpinBox;
import oracle.ide.controls.JavaColorChooserPane;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.ResourceUtils;
import oracle.jdevimpl.inspector.extension.Res;

final class BorderCustomEditor
extends JPanel
implements ListSelectionListener,
VetoableChangeListener {
    private static final String BEVEL = "BevelBorder";
    private static final String EMPTY = "EmptyBorder";
    private static final String ETCHED = "EtchedBorder";
    private static final String LINE = "LineBorder";
    private static final String TITLED = "TitledBorder";
    private static boolean bTitle;
    private PropertyChangeSupport support;
    private JSplitPane mainPane;
    private BorderLayout mainLayout;
    private JScrollPane borderScroll;
    private JList borderList;
    private DefaultListModel borderModel;
    private JScrollPane optionsScroll;
    private JPanel optionsPanel;
    private CardLayout optionsLayout;
    private JPanel bevelPanel;
    private GridBagLayout bevelLayout;
    private ButtonGroup bevelGroup;
    private JRadioButton raisedRadio;
    private JRadioButton loweredRadio;
    private JPanel emptyPanel;
    private GridBagLayout emptyLayout;
    private JLabel topLabel;
    private JLabel leftLabel;
    private JLabel bottomLabel;
    private JLabel rightLabel;
    private NumericSpinBox topSpin;
    private NumericSpinBox leftSpin;
    private NumericSpinBox bottomSpin;
    private NumericSpinBox rightSpin;
    private JPanel linePanel;
    private GridBagLayout lineLayout;
    private JavaColorChooserPane colorPane;
    private JLabel thicknessLabel;
    private NumericSpinBox thicknessSpin;
    private JPanel titledPanel;
    private GridBagLayout titiledLayout;
    private JLabel titleLabel;
    private JTextField titleField;

    private void $init$() {
        this.support = new PropertyChangeSupport(this);
        this.mainPane = new JSplitPane();
        this.mainLayout = new BorderLayout();
        this.borderScroll = new JScrollPane();
        this.borderList = new JList();
        this.borderModel = new DefaultListModel();
        this.optionsScroll = new JScrollPane();
        this.optionsPanel = new JPanel();
        this.optionsLayout = new CardLayout();
        this.bevelPanel = new JPanel();
        this.bevelLayout = new GridBagLayout();
        this.bevelGroup = new ButtonGroup();
        this.raisedRadio = new JRadioButton();
        this.loweredRadio = new JRadioButton();
        this.emptyPanel = new JPanel();
        this.emptyLayout = new GridBagLayout();
        this.topLabel = new JLabel();
        this.leftLabel = new JLabel();
        this.bottomLabel = new JLabel();
        this.rightLabel = new JLabel();
        this.topSpin = new NumericSpinBox(0, 0x7FFFFFFE);
        this.leftSpin = new NumericSpinBox(0, 0x7FFFFFFE);
        this.bottomSpin = new NumericSpinBox(0, 0x7FFFFFFE);
        this.rightSpin = new NumericSpinBox(0, 0x7FFFFFFE);
        this.linePanel = new JPanel();
        this.lineLayout = new GridBagLayout();
        this.colorPane = new JavaColorChooserPane(Color.black);
        this.thicknessLabel = new JLabel();
        this.thicknessSpin = new NumericSpinBox(1, 0x7FFFFFFE);
        this.titledPanel = new JPanel();
        this.titiledLayout = new GridBagLayout();
        this.titleLabel = new JLabel();
        this.titleField = new JTextField();
    }

    public BorderCustomEditor() {
        this.$init$();
        try {
            this.jbInit();
            HelpSystem.getHelpSystem().registerTopic((JComponent)this, "f1_guipropedborder_html");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.borderModel.addElement(BEVEL);
        this.borderModel.addElement(EMPTY);
        this.borderModel.addElement(ETCHED);
        this.borderModel.addElement(LINE);
        this.borderModel.addElement(TITLED);
        this.borderList.setModel(this.borderModel);
        this.borderList.setSelectionMode(0);
        this.bevelGroup.add(this.raisedRadio);
        this.bevelGroup.add(this.loweredRadio);
        ResourceUtils.resButton((AbstractButton)this.raisedRadio, (String)Res.getString(16));
        ResourceUtils.resButton((AbstractButton)this.loweredRadio, (String)Res.getString(8));
        ResourceUtils.resLabel((JLabel)this.topLabel, (Component)this.topSpin, (String)Res.getString(13));
        ResourceUtils.resLabel((JLabel)this.leftLabel, (Component)this.leftSpin, (String)Res.getString(9));
        ResourceUtils.resLabel((JLabel)this.bottomLabel, (Component)this.bottomSpin, (String)Res.getString(6));
        ResourceUtils.resLabel((JLabel)this.rightLabel, (Component)this.rightSpin, (String)Res.getString(7));
        ResourceUtils.resLabel((JLabel)this.thicknessLabel, (Component)this.thicknessSpin, (String)Res.getString(14));
        ResourceUtils.resLabel((JLabel)this.titleLabel, (Component)this.titleField, (String)Res.getString(11));
        this.bevelPanel.setLayout(this.bevelLayout);
        this.bevelPanel.add((Component)this.raisedRadio, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.bevelPanel.add((Component)this.loweredRadio, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.emptyPanel.setLayout(this.emptyLayout);
        this.emptyPanel.add((Component)this.topLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.emptyPanel.add((Component)this.leftLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.emptyPanel.add((Component)this.bottomLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.emptyPanel.add((Component)this.rightLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 1.0, 11, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.emptyPanel.add((Component)this.topSpin, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.emptyPanel.add((Component)this.leftSpin, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.emptyPanel.add((Component)this.bottomSpin, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.emptyPanel.add((Component)this.rightSpin, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 18, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.linePanel.setLayout(this.lineLayout);
        this.linePanel.add((Component)this.colorPane, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.linePanel.add((Component)this.thicknessLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.linePanel.add((Component)this.thicknessSpin, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.titledPanel.setLayout(this.titiledLayout);
        this.titledPanel.add((Component)this.titleLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.titledPanel.add((Component)this.titleField, new GridBagConstraints(1, 0, 0, 1, 1.0, 1.0, 11, 2, new Insets(5, 0, 5, 5), 0, 0));
        this.optionsPanel.setLayout(this.optionsLayout);
        this.optionsPanel.add((Component)this.bevelPanel, BEVEL);
        this.optionsPanel.add((Component)this.emptyPanel, EMPTY);
        this.optionsPanel.add((Component)this.linePanel, LINE);
        this.optionsPanel.add((Component)this.titledPanel, TITLED);
        this.borderScroll.getViewport().add(this.borderList);
        this.optionsScroll.getViewport().add(this.optionsPanel);
        this.mainPane.add((Component)this.borderScroll, "left");
        this.mainPane.add((Component)this.optionsScroll, "right");
        this.setLayout(this.mainLayout);
        this.add((Component)this.mainPane, "Center");
        this.borderList.addListSelectionListener(this);
    }

    public Border getValue() {
        String type = (String)this.borderList.getSelectedValue();
        if (BEVEL.equals(type)) {
            return BorderFactory.createBevelBorder(this.raisedRadio.isSelected() ? 0 : 1);
        }
        if (EMPTY.equals(type)) {
            return BorderFactory.createEmptyBorder(this.topSpin.getIntValue(), this.leftSpin.getIntValue(), this.bottomSpin.getIntValue(), this.rightSpin.getIntValue());
        }
        if (ETCHED.equals(type)) {
            return BorderFactory.createEtchedBorder(this.raisedRadio.isSelected() ? 0 : 1);
        }
        if (LINE.equals(type)) {
            return BorderFactory.createLineBorder(this.colorPane.getColor(), this.thicknessSpin.getIntValue());
        }
        if (TITLED.equals(type)) {
            return BorderFactory.createTitledBorder(this.titleField.getText());
        }
        return null;
    }

    public void setValue(Object border) {
        bTitle = false;
        if (border instanceof BevelBorder) {
            if (((BevelBorder)border).getBevelType() == 0) {
                this.raisedRadio.setSelected(true);
            } else {
                this.loweredRadio.setSelected(true);
            }
            this.borderList.setSelectedValue(BEVEL, true);
        } else if (border instanceof EmptyBorder) {
            Insets insets = ((EmptyBorder)border).getBorderInsets();
            this.topSpin.setIntValue(insets.top);
            this.leftSpin.setIntValue(insets.left);
            this.bottomSpin.setIntValue(insets.bottom);
            this.rightSpin.setIntValue(insets.right);
            this.borderList.setSelectedValue(EMPTY, true);
        } else if (border instanceof EtchedBorder) {
            if (((EtchedBorder)border).getEtchType() == 0) {
                this.raisedRadio.setSelected(true);
            } else {
                this.loweredRadio.setSelected(true);
            }
            this.borderList.setSelectedValue(ETCHED, true);
        } else if (border instanceof LineBorder) {
            this.colorPane.setColor(((LineBorder)border).getLineColor());
            this.thicknessSpin.setIntValue(((LineBorder)border).getThickness());
            this.borderList.setSelectedValue(LINE, true);
        } else if (border instanceof TitledBorder) {
            this.titleField.setText(((TitledBorder)border).getTitle());
            this.borderList.setSelectedValue(TITLED, true);
            bTitle = true;
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        String item = (String)this.borderList.getSelectedValue();
        if (ETCHED.equals(item)) {
            item = BEVEL;
        }
        if (!bTitle) {
            this.titleField.setText(null);
        }
        this.optionsLayout.show(this.optionsPanel, item);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.support.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.support.removePropertyChangeListener(l);
    }

    public void vetoableChange(PropertyChangeEvent e) {
        this.support.firePropertyChange(null, null, this.getValue());
    }
}

