/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.inspector.extension;

import java.awt.Component;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import oracle.ideimpl.inspector.AbstractInlineExtension;
import oracle.jdevimpl.inspector.extension.BorderCustomEditor;
import oracle.jdevimpl.propertyeditor.ColorEditor;

public final class BorderExtension
extends AbstractInlineExtension {
    private static final String[] TAGS = new String[]{"Swing Border..."};
    private static final Class[] CLASSES = new Class[]{BevelBorder.class, EmptyBorder.class, EtchedBorder.class, LineBorder.class, TitledBorder.class};
    private BorderCustomEditor editor;

    private void $init$() {
        this.editor = null;
    }

    public String getJavaInitializationString() {
        if (this.value instanceof BevelBorder) {
            if (((BevelBorder)this.value).getBevelType() == 0) {
                return "javax.swing.BorderFactory.createBevelBorder(javax.swing.border.BevelBorder.RAISED)";
            }
            return "javax.swing.BorderFactory.createBevelBorder(javax.swing.border.BevelBorder.LOWERED)";
        }
        if (this.value instanceof EmptyBorder) {
            Insets insets = ((EmptyBorder)this.value).getBorderInsets();
            return "javax.swing.BorderFactory.createEmptyBorder(" + insets.top + ", " + insets.left + ", " + insets.bottom + ", " + insets.right + ")";
        }
        if (this.value instanceof EtchedBorder) {
            if (((EtchedBorder)this.value).getEtchType() == 0) {
                return "javax.swing.BorderFactory.createEtchedBorder(javax.swing.border.EtchedBorder.RAISED)";
            }
            return "javax.swing.BorderFactory.createEtchedBorder(javax.swing.border.EtchedBorder.LOWERED)";
        }
        if (this.value instanceof LineBorder) {
            ColorEditor colorEditor = new ColorEditor();
            colorEditor.setValue(((LineBorder)this.value).getLineColor());
            return "javax.swing.BorderFactory.createLineBorder(" + colorEditor.getJavaInitializationString() + ", " + ((LineBorder)this.value).getThickness() + ")";
        }
        if (this.value instanceof TitledBorder) {
            String title = "\"" + ((TitledBorder)this.value).getTitle() + "\"";
            return "javax.swing.BorderFactory.createTitledBorder(" + title + ")";
        }
        return "null";
    }

    public String[] getTags() {
        return TAGS;
    }

    public void setSelectedTag(String tag) {
        ((BorderCustomEditor)this.getCustomEditor()).setValue(new EmptyBorder(0, 0, 0, 0));
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Component getCustomEditor() {
        if (this.editor == null) {
            this.editor = new BorderCustomEditor();
            this.editor.addPropertyChangeListener(new 1());
        }
        this.editor.setValue(this.value);
        return this.editor;
    }

    public void setValue(Object value) {
        if (this.editor != null) {
            this.editor.setValue(value);
        }
        super.setValue(value);
    }

    public Class[] getImplementationClasses() {
        return CLASSES;
    }

    protected boolean isValid(Object value) {
        return value == null || value instanceof Border;
    }

    public BorderExtension() {
        this.$init$();
    }

    final class 1
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent e) {
            BorderExtension.this.setValue(e.getNewValue());
        }
    }
}

