/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.inspector.extension;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.ResourceUtils;
import oracle.jdevimpl.inspector.extension.Res;

final class BoundedRangeModelCustomEditor
extends JPanel
implements VetoableChangeListener {
    private BoundedRangeModel value;
    private JLabel minLabel;
    private JLabel valueLabel;
    private JLabel extentLabel;
    private JLabel maxLabel;
    private JTextField valueText;
    private JTextField extentText;
    private JTextField minText;
    private JTextField maxText;
    private PropertyChangeSupport support;
    private KeyListener listener;

    private void $init$() {
        this.value = null;
        this.minLabel = new JLabel();
        this.valueLabel = new JLabel();
        this.extentLabel = new JLabel();
        this.maxLabel = new JLabel();
        this.valueText = new JTextField();
        this.extentText = new JTextField();
        this.minText = new JTextField();
        this.maxText = new JTextField();
        this.support = new PropertyChangeSupport(this);
        this.listener = new 1();
    }

    BoundedRangeModelCustomEditor() {
        this.$init$();
        try {
            this.jbInit();
            HelpSystem.getHelpSystem().registerTopic((JComponent)this, "f1_guipropedbrange_html");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object model) {
        BoundedRangeModel newValue;
        this.value = newValue = (BoundedRangeModel)model;
        if (newValue == null) {
            newValue = new DefaultBoundedRangeModel();
        }
        this.minText.setText("" + newValue.getMinimum());
        this.valueText.setText("" + newValue.getValue());
        this.extentText.setText("" + newValue.getExtent());
        this.maxText.setText("" + newValue.getMaximum());
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.support.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.support.removePropertyChangeListener(l);
    }

    public void vetoableChange(PropertyChangeEvent e) throws PropertyVetoException {
        if ("closed".equals(e.getPropertyName()) && ((Boolean)e.getNewValue()).booleanValue()) {
            String min = this.minText.getText().trim();
            String val = this.valueText.getText().trim();
            String extent = this.extentText.getText().trim();
            String max = this.maxText.getText().trim();
            if (min.length() == 0) {
                min = "0";
            }
            if (val.length() == 0) {
                val = "0";
            }
            if (extent.length() == 0) {
                extent = "0";
            }
            if (max.length() == 0) {
                max = "0";
            }
            try {
                int iMin = Integer.parseInt(min);
                int iValue = Integer.parseInt(val);
                int iExtent = Integer.parseInt(extent);
                int iMax = Integer.parseInt(max);
                this.value = new DefaultBoundedRangeModel(iValue, iExtent, iMin, iMax);
                this.support.firePropertyChange(null, null, this.value);
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, Res.format(0, new String[]{StringUtils.stripMnemonic((String)Res.getString(1)), StringUtils.stripMnemonic((String)Res.getString(2)), StringUtils.stripMnemonic((String)Res.getString(2)), StringUtils.stripMnemonic((String)Res.getString(10)), StringUtils.stripMnemonic((String)Res.getString(5))}), Res.getString(3), 0);
                throw new PropertyVetoException(ex.getLocalizedMessage(), e);
            }
        }
    }

    private void jbInit() throws Exception {
        ResourceUtils.resLabel((JLabel)this.minLabel, (Component)this.minText, (String)Res.getString(1));
        ResourceUtils.resLabel((JLabel)this.valueLabel, (Component)this.valueText, (String)Res.getString(2));
        ResourceUtils.resLabel((JLabel)this.extentLabel, (Component)this.extentText, (String)Res.getString(10));
        ResourceUtils.resLabel((JLabel)this.maxLabel, (Component)this.maxText, (String)Res.getString(5));
        this.minText.addKeyListener(this.listener);
        this.valueText.addKeyListener(this.listener);
        this.extentText.addKeyListener(this.listener);
        this.maxText.addKeyListener(this.listener);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.minLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this.minText, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 0, 5), 0, 0));
        this.add((Component)this.valueLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this.valueText, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 0, 5), 0, 0));
        this.add((Component)this.extentLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this.extentText, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 0, 5), 0, 0));
        this.add((Component)this.maxLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this.maxText, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 0, 5), 0, 0));
    }

    final class 1
    implements KeyListener {
        public void keyTyped(KeyEvent e) {
            char ch = e.getKeyChar();
            if (!Character.isISOControl(ch) && ch != '.' && ch != '-' && !Character.isDigit(ch)) {
                Toolkit.getDefaultToolkit().beep();
                e.consume();
            }
        }

        public void keyPressed(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
        }
    }
}

