/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.jar;

import java.awt.Component;
import java.io.IOException;
import java.net.URL;
import javax.accessibility.Accessible;
import oracle.ide.Context;
import oracle.ide.editor.Editor;
import oracle.ide.help.HelpInfo;
import oracle.ide.model.Element;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.AccessibleUtils;
import oracle.ide.util.Assert;
import oracle.jdeveloper.resource.ViewersArb;
import oracle.jdevimpl.jar.JarNode;
import oracle.jdevimpl.jar.JarViewerContentPanel;

public class JarViewer
extends Editor {
    private JarViewerContentPanel view;

    public void open() {
        if (this.view != null) {
            this.view.requestFocus();
        }
    }

    public synchronized void setContext(Context context) {
        block2: {
            Element element;
            if (context == null || !((element = context.getElement()) instanceof JarNode)) break block2;
            super.setContext(context);
            JarNode jarNode = (JarNode)element;
            try {
                jarNode.open();
            }
            catch (IOException e) {
                Assert.printStackTrace((Throwable)e);
            }
            this.view = new JarViewerContentPanel();
            URL nodeURL = context.getNode().getURL();
            URL parentURL = URLFileSystem.getParent((URL)nodeURL);
            String nodeFilename = URLFileSystem.getFileName((URL)nodeURL);
            String nodeDirectory = URLFileSystem.getPlatformPathName((URL)parentURL);
            String accessibleName = ViewersArb.format((int)0, (Object)nodeFilename, (Object)nodeDirectory);
            AccessibleUtils.updateAccessibleName((Accessible)this.view, (String)accessibleName, (boolean)true);
            this.view.setNode(jarNode);
        }
    }

    public Object getEditorAttribute(String attribute) {
        if (attribute == "old_editor") {
            return Boolean.TRUE;
        }
        return super.getEditorAttribute(attribute);
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_idearchiveviewer_html");
    }

    public void deactivate() {
    }

    public Component getGUI() {
        if (this.view == null) {
            Assert.println((String)"JarViewer.getGUI() view is (null)");
        }
        return this.view;
    }

    public void update(Object observed, UpdateMessage change) {
    }
}

