/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.jar;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.net.URL;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import oracle.ide.editor.EditorManager;
import oracle.ide.net.JarIndex;
import oracle.ide.net.JarIndexEntry;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLFactory;
import oracle.ide.util.SwingWorker;
import oracle.javatools.controls.nicetable.NiceTable;
import oracle.javatools.controls.nicetable.NiceTableCellRenderer;
import oracle.jdeveloper.resource.ViewersArb;
import oracle.jdevimpl.jar.JarFileTableModel;
import oracle.jdevimpl.jar.JarNode;

class JarViewerContentPanel
extends JPanel {
    private final JLabel _lblHeader;
    private final JarFileTableModel _model;
    private final NiceTable _table;
    private final JScrollPane _spTable;
    private JarNode _jarNode;
    private static final NumberFormat TWO_DP_FORMAT = NumberFormat.getInstance();

    private void $init$() {
        this._lblHeader = new JLabel();
        this._model = new JarFileTableModel();
        this._table = new NiceTable((TableModel)this._model);
        this._spTable = new JScrollPane((Component)this._table);
        this._jarNode = null;
    }

    static {
        TWO_DP_FORMAT.setMaximumFractionDigits(2);
        TWO_DP_FORMAT.setMinimumFractionDigits(2);
        TWO_DP_FORMAT.setParseIntegerOnly(false);
    }

    JarViewerContentPanel() {
        this.$init$();
        this._lblHeader.setHorizontalAlignment(0);
        this._lblHeader.setText(ViewersArb.getString((int)1));
        this._spTable.setBorder(null);
        this._table.setAutoResizeMode(0);
        this._table.setDefaultRenderer(Date.class, (TableCellRenderer)((Object)new DateRenderer(null)));
        this._table.setDefaultRenderer(Integer.class, (TableCellRenderer)((Object)new SizeRenderer(null)));
        this._table.setSorted(true);
        this._table.addMouseListener((MouseListener)new 1());
        this.setLayout(new BorderLayout());
        this.add((Component)this._lblHeader, "Center");
    }

    void setNode(JarNode jarNode) {
        if (this._jarNode != jarNode) {
            if (this._jarNode != null) {
                JarUtil.releaseJarIndex((URL)this._jarNode.getURL());
            }
            this._jarNode = jarNode;
            this.updateTable();
        }
    }

    private void updateTable() {
        JarNode jarNode = this._jarNode;
        2 worker = new 2(this, jarNode);
        worker.start();
    }

    private static String getDisplaySize(long bytes) {
        StringBuffer buffer = new StringBuffer();
        if (bytes < 1024L) {
            buffer.append(TWO_DP_FORMAT.format(bytes));
            buffer.append(" bytes");
        } else if (bytes >= 1024L && bytes < 0x100000L) {
            buffer.append(TWO_DP_FORMAT.format((double)bytes / 1024.0));
            buffer.append(" KB");
        } else if (bytes >= 0x100000L && bytes < 0x40000000L) {
            buffer.append(TWO_DP_FORMAT.format((double)bytes / 1048567.0));
            buffer.append(" MB");
        } else {
            buffer.append(TWO_DP_FORMAT.format((double)bytes / 1.073741824E9));
            buffer.append(" GB");
        }
        return buffer.toString();
    }

    static String maS$getDisplaySize(long l) {
        return JarViewerContentPanel.getDisplaySize(l);
    }

    static JarFileTableModel ra$_model(JarViewerContentPanel jarViewerContentPanel) {
        return jarViewerContentPanel._model;
    }

    static JScrollPane ra$_spTable(JarViewerContentPanel jarViewerContentPanel) {
        return jarViewerContentPanel._spTable;
    }

    static NiceTable ra$_table(JarViewerContentPanel jarViewerContentPanel) {
        return jarViewerContentPanel._table;
    }

    static JLabel ra$_lblHeader(JarViewerContentPanel jarViewerContentPanel) {
        return jarViewerContentPanel._lblHeader;
    }

    static JarNode ra$_jarNode(JarViewerContentPanel jarViewerContentPanel) {
        return jarViewerContentPanel._jarNode;
    }

    final class 1
    extends MouseAdapter {
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                URL jarFileURL = URLFactory.newFileURL((File)JarViewerContentPanel.ra$_jarNode(JarViewerContentPanel.this).getFile());
                String entryName = (String)JarViewerContentPanel.ra$_table(JarViewerContentPanel.this).getModel().getValueAt(JarViewerContentPanel.ra$_table(JarViewerContentPanel.this).getSelectedRow(), 0);
                URL url = URLFactory.newJarURL((URL)jarFileURL, (String)entryName);
                EditorManager.getEditorManager().openDefaultEditorInFrame(url);
                e.consume();
            }
        }
    }

    final class 2
    extends SwingWorker {
        private final /* synthetic */ JarNode v$jarNode;
        final /* synthetic */ JarViewerContentPanel this$0;

        public Object construct() {
            return this.getTableData(this.v$jarNode);
        }

        public void finished() {
            JarViewerContentPanel panel = this.this$0;
            ArrayList rows = (ArrayList)this.get();
            JarViewerContentPanel.ra$_model(this.this$0).setData(rows);
            JarViewerContentPanel.ra$_spTable(this.this$0).setSize(panel.getSize());
            JarViewerContentPanel.ra$_table(this.this$0).autoSizeColumnsToFit();
            this.this$0.remove(JarViewerContentPanel.ra$_lblHeader(this.this$0));
            this.this$0.add((Component)JarViewerContentPanel.ra$_spTable(this.this$0), "Center");
        }

        private ArrayList getTableData(JarNode jarNode) {
            try {
                ArrayList rows = new ArrayList();
                URL jarFileURL = URLFactory.newFileURL((File)jarNode.getFile());
                JarIndex jarIndex = JarUtil.getJarIndex((URL)jarFileURL);
                int n = jarIndex.getNumEntries();
                int i = 0;
                while (i < n) {
                    JarIndexEntry entry = jarIndex.getEntryAt(i);
                    String entryName = entry.getName();
                    if (!entryName.endsWith("/")) {
                        ArrayList<Object> row = new ArrayList<Object>();
                        row.add(entryName);
                        row.add(entry.getTime());
                        row.add(new Integer(entry.getSize()));
                        row.add(new Integer(entry.getCompressedSize()));
                        rows.add(row);
                    }
                    ++i;
                }
                ArrayList arrayList = rows;
                return arrayList;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                ArrayList arrayList = null;
                return arrayList;
            }
        }

        public 2(JarViewerContentPanel jarViewerContentPanel, JarNode jarNode) {
            this.v$jarNode = jarNode;
            this.this$0 = jarViewerContentPanel;
        }
    }

    private class SizeRenderer
    extends NiceTableCellRenderer {
        NumberFormat _defaultFormat;

        private void $init$() {
            this._defaultFormat = NumberFormat.getInstance();
        }

        public Component getTableCellRendererComponent(JTable t, Object value, boolean selected, boolean focus, int column, int row) {
            Component c = super.getTableCellRendererComponent(t, value, selected, focus, column, row);
            int i = (Integer)value;
            if (i < 1024) {
                this.setText(this._defaultFormat.format(i));
            } else {
                this.setText(JarViewerContentPanel.maS$getDisplaySize(((Integer)value).intValue()));
            }
            return c;
        }

        private SizeRenderer() {
            this.$init$();
        }

        SizeRenderer(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class DateRenderer
    extends NiceTableCellRenderer {
        final SimpleDateFormat _sdf;

        private void $init$() {
            this._sdf = new SimpleDateFormat();
        }

        public Component getTableCellRendererComponent(JTable t, Object value, boolean selected, boolean focus, int column, int row) {
            Component c = super.getTableCellRendererComponent(t, value, selected, focus, column, row);
            if (value != null) {
                this.setText(this._sdf.format((Date)value));
            }
            return c;
        }

        private DateRenderer() {
            this.$init$();
        }

        DateRenderer(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

