/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.util.concurrent.CancellationException;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.ide.Context;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.model.Observer;
import oracle.ide.model.Project;
import oracle.ide.model.UpdateMessage;
import oracle.ide.util.Assert;
import oracle.javatools.buffer.ExpiredTextBufferException;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.util.AsyncScheduler;
import oracle.javatools.parser.util.AsyncTask;
import oracle.javatools.util.CopyOnWriteList;
import oracle.javatools.util.Log;
import oracle.javatools.util.UnexpectedExceptionError;
import oracle.jdeveloper.java.CacheSupport;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.model.JavaSourceNode;
import oracle.jdevimpl.java.JavaProjectIndexer;

public final class JavaParserPlugin
implements ActionListener,
DocumentListener,
EditorPlugin,
FocusListener,
Observer {
    private JavaSourceNode javaNode;
    private Project project;
    private static final Log LOG;
    private static final boolean DEBUG_VERBOSE = false;
    static final /* synthetic */ boolean $assertionsDisabled;
    private static final int SMALL_FILE_SIZE = 20000;
    private static final int LARGE_FILE_SIZE = 100000;
    private static final int SMALL_FILE_DELAY;
    private static final int LARGE_FILE_DELAY;
    private CopyOnWriteList helperList;
    private static final String PLUGIN_KEY;
    private static final int LONG_TIMER_DELAY = 2000;
    private volatile int _lastDelayUsed;
    private BasicEditorPane editor;
    private Timer updateTimer;
    private SemanticTask smTask;
    private JavaManager smJavaManager;
    private SourceFile smTaskSourceFile;
    private int smTaskChangeId;
    private static AsyncScheduler smScheduler;

    public JavaParserPlugin() {
        this.$init$();
    }

    static {
        int large;
        int small;
        $assertionsDisabled = JavaParserPlugin.class.desiredAssertionStatus() ^ true;
        LOG = new Log("parser", "editor");
        int SMALL_MIN = 100;
        int SMALL_DEFAULT = 300;
        int SMALL_MAX = 50000;
        String smallProperty = System.getProperty("ceditor.java.parse.small");
        try {
            small = Integer.parseInt(smallProperty);
            small = Math.min(small, 50000);
            small = Math.max(small, 100);
        }
        catch (NumberFormatException e) {
            small = 300;
        }
        SMALL_FILE_DELAY = small;
        int LARGE_MIN = 500;
        int LARGE_DEFAULT = 1500;
        int LARGE_MAX = 50000;
        String largeProperty = System.getProperty("ceditor.java.parse.large");
        try {
            large = Integer.parseInt(largeProperty);
            large = Math.min(large, 50000);
            large = Math.max(large, 500);
        }
        catch (NumberFormatException e) {
            large = 1500;
        }
        LARGE_FILE_DELAY = large;
        PLUGIN_KEY = JavaParserPlugin.class.getName();
        smScheduler = new AsyncScheduler("SemanticChecker", 30000);
    }

    private static final void verbosePrintln(String message) {
        if (!$assertionsDisabled && !LOG.trace(message)) {
            throw new AssertionError();
        }
    }

    private static final void verbosePrintTiming(long time, String message, String indent) {
        if (!$assertionsDisabled && !LOG.trace("[{0}ms]{1}", time, (Object)message)) {
            throw new AssertionError();
        }
    }

    private static int getCompileDelay(int fileSize) {
        if (fileSize <= 20000) {
            return SMALL_FILE_DELAY;
        }
        if (fileSize >= 100000) {
            return LARGE_FILE_DELAY;
        }
        int delayToUse = (LARGE_FILE_DELAY - SMALL_FILE_DELAY) * (fileSize - 20000) / 80000;
        return delayToUse += SMALL_FILE_DELAY;
    }

    private void $init$() {
        this.helperList = new CopyOnWriteList();
        this._lastDelayUsed = SMALL_FILE_DELAY;
        this.smTask = null;
        this.smJavaManager = null;
        this.smTaskSourceFile = null;
        this.smTaskChangeId = -1;
    }

    private void notifyCompileScheduled() {
        JavaParserPlugin.verbosePrintln("CompilerHelper: notify scheduled");
        for (HelperClient client : this.helperList) {
            try {
                client.notifyCompileScheduled();
            }
            catch (RuntimeException e) {
                Assert.println((String)("HelperClient notify exception occurred: " + e.toString()));
                Assert.printStackTrace((Throwable)e);
                FeedbackManager.reportException((String)"HelperClient notify exception occurred: ", (Throwable)e);
            }
        }
    }

    private void notifyParseFinished(JavaManager javaManager, SourceFile sourceFile, int changeId, int parseTime) {
        int elapsedDelay = this._lastDelayUsed + parseTime;
        JavaParserPlugin.verbosePrintTiming(parseTime, "CompilerHelper: notify parse finished, changeId: " + changeId, "");
        for (HelperClient client : this.helperList) {
            try {
                client.notifyParseFinished(javaManager, sourceFile, changeId, elapsedDelay);
            }
            catch (RuntimeException e) {
                Assert.println((String)("HelperClient notify exception occurred: " + e.toString()));
                Assert.printStackTrace((Throwable)e);
                FeedbackManager.reportException((String)"HelperClient notify exception occurred: ", (Throwable)e);
            }
        }
    }

    private void notifyCompileFinished(JavaManager javaManager, SourceFile sourceFile, int changeId, int compileTime) {
        int elapsedDelay = this._lastDelayUsed + compileTime;
        JavaParserPlugin.verbosePrintTiming(compileTime, "CompilerHelper: notify finished, changeId: " + changeId, "");
        for (HelperClient client : this.helperList) {
            try {
                client.notifyCompileFinished(javaManager, sourceFile, changeId, elapsedDelay);
            }
            catch (RuntimeException e) {
                Assert.println((String)("HelperClient notify exception occurred: " + e.toString()));
                Assert.printStackTrace((Throwable)e);
                FeedbackManager.reportException((String)"HelperClient notify exception occurred: ", (Throwable)e);
            }
        }
    }

    public static void attachHelperClient(BasicEditorPane editor, HelperClient client) {
        JavaParserPlugin.verbosePrintln("CompilerHelper: attaching helper client");
        JavaParserPlugin plugin = JavaParserPlugin.lookupOrCreatePlugin(editor);
        plugin.helperList.addIfAbsent((Object)client);
    }

    public static void detachHelperClient(BasicEditorPane editor, HelperClient client) {
        JavaParserPlugin.verbosePrintln("CompilerHelper: detaching helper client");
        JavaParserPlugin plugin = JavaParserPlugin.lookupPlugin(editor);
        if (plugin != null) {
            plugin.helperList.remove((Object)client);
        }
    }

    public static void ensureCompileScheduled(BasicEditorPane editor) {
        JavaParserPlugin plugin = (JavaParserPlugin)editor.getProperty(PLUGIN_KEY);
        if (plugin != null) {
            plugin.ensureCompileScheduled();
        }
    }

    private void detachAllClients() {
        JavaParserPlugin.verbosePrintln("CompilerHelper: detaching all client");
        this.helperList.clear();
    }

    private static synchronized JavaParserPlugin lookupPlugin(BasicEditorPane editor) {
        return (JavaParserPlugin)editor.getProperty(PLUGIN_KEY);
    }

    private static synchronized JavaParserPlugin lookupOrCreatePlugin(BasicEditorPane editor) {
        JavaParserPlugin plugin = JavaParserPlugin.lookupPlugin(editor);
        if (plugin == null) {
            JavaParserPlugin.verbosePrintln("CompilerHelper: installing new helper");
            plugin = new JavaParserPlugin();
            editor.installPlugin((EditorPlugin)plugin);
        }
        return plugin;
    }

    public void install(BasicEditorPane editor) {
        this.editor = editor;
        editor.addFocusListener((FocusListener)this);
        BasicDocument document = this.getDocument();
        document.addDocumentListener((DocumentListener)this);
        this.updateTimer = new Timer(2000, this);
        this.updateTimer.setRepeats(false);
        this.restartTimer();
        editor.putProperty(PLUGIN_KEY, (Object)this);
        Context context = CodeEditor.getContext((BasicEditorPane)editor);
        if (context == null) {
            throw new IllegalStateException("Unexpected null context");
        }
        this.updateContext(context);
    }

    private void updateContext(Context newContext) {
        if (this.project != null) {
            this.project.detach((Observer)this);
            this.project = null;
        }
        this.javaNode = null;
        if (newContext != null) {
            this.javaNode = (JavaSourceNode)newContext.getNode();
            this.project = newContext.getProject();
            LOG.trace("updating context of {0} to {1}", (Object)this, (Object)newContext);
            if (this.project != null) {
                this.project.attach((Observer)this);
            }
        }
    }

    public void deinstall(BasicEditorPane editor) {
        editor.putProperty(PLUGIN_KEY, null);
        this.cancelSemantic();
        this.updateContext(null);
        if (this.updateTimer != null) {
            this.updateTimer.stop();
            this.updateTimer = null;
        }
        this.detachAllClients();
        BasicDocument document = this.getDocument();
        if (document != null) {
            document.removeDocumentListener((DocumentListener)this);
        }
        editor.removeFocusListener((FocusListener)this);
        this.editor = null;
    }

    public void focusGained(FocusEvent event) {
        JavaParserPlugin.verbosePrintln("CompilerHelper: focus gained, restarting");
        this.restartTimer();
    }

    public void focusLost(FocusEvent event) {
        JavaParserPlugin.verbosePrintln("CompilerHelper: focus lost");
        this.stopTimer();
    }

    public void update(Object observed, UpdateMessage change) {
        if (observed instanceof Project) {
            int messageId = change.getMessageID();
            if (messageId == UpdateMessage.OBJECT_RELOADED || messageId == UpdateMessage.PROPERTY_SET) {
                JavaParserPlugin.verbosePrintln("CompilerHelper: property updated");
                this.restartTimer(true);
            } else if (messageId == UpdateMessage.ATTRIBUTE_CHANGED) {
                // empty if block
            }
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        String propertyName = event.getPropertyName();
        if (propertyName.equals("editor-ide-context")) {
            JavaParserPlugin.verbosePrintln("CompilerHelper: editor context changed");
            this.cancelSemantic();
            Context newContext = CodeEditor.getContext((BasicEditorPane)this.editor);
            this.updateContext(newContext);
            this.restartTimer(true);
        } else if ("ancestor".equals(propertyName)) {
            if (event.getNewValue() != null) {
                this.ensureCompileScheduled();
            } else {
                this.cancelSemantic();
            }
        }
    }

    public void insertUpdate(DocumentEvent event) {
        JavaParserPlugin.verbosePrintln("CompilerHelper: document modified");
        this.restartTimer();
    }

    public void removeUpdate(DocumentEvent event) {
        JavaParserPlugin.verbosePrintln("CompilerHelper: document modified");
        this.restartTimer();
    }

    public void changedUpdate(DocumentEvent event) {
    }

    private void restartTimer() {
        this.restartTimer(false);
    }

    private void restartTimer(boolean forceLong) {
        try {
            if (!this.editor.isShowing()) {
                return;
            }
            int fileSize = this.getDocument().getLength();
            int compileDelay = JavaParserPlugin.getCompileDelay(fileSize);
            if (forceLong) {
                compileDelay = Math.max(compileDelay, 2000);
            }
            this._lastDelayUsed = compileDelay;
            this.restartTimer(compileDelay);
        }
        catch (ExpiredTextBufferException e) {
            // empty catch block
        }
    }

    private void restartTimer(int delayToUse) {
        this.notifyCompileScheduled();
        this.cancelSemantic();
        this.updateTimer.setInitialDelay(delayToUse);
        this.updateTimer.restart();
        JavaParserPlugin.verbosePrintln("CompilerHelper: timer restarted: " + delayToUse);
    }

    private void stopTimer() {
        this.updateTimer.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureCompileScheduled() {
        JavaParserPlugin javaParserPlugin = this;
        synchronized (javaParserPlugin) {
            if (this.updateTimer != null && !this.updateTimer.isRunning() && this.smTask == null) {
                this.restartTimer();
            }
        }
    }

    public void actionPerformed(ActionEvent event) {
        JavaParserPlugin.verbosePrintln("CompilerHelper: timer triggered");
        this.scheduleSemantic();
    }

    private BasicDocument getDocument() {
        return (BasicDocument)this.editor.getDocument();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleSemantic() {
        JavaParserPlugin.verbosePrintln("CompilerHelper: scheduling new task");
        SemanticTask task = new SemanticTask(null);
        JavaParserPlugin javaParserPlugin = this;
        synchronized (javaParserPlugin) {
            if (this.smTask != null) {
                JavaParserPlugin.verbosePrintln("CompilerHelper: cancelled in progress");
                smScheduler.cancelTask((AsyncTask)this.smTask);
            }
            this.smTask = task;
        }
        smScheduler.scheduleTask((AsyncTask)task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelSemantic() {
        SemanticTask pendingTask;
        JavaParserPlugin javaParserPlugin = this;
        synchronized (javaParserPlugin) {
            pendingTask = this.smTask;
            this.smTask = null;
        }
        if (pendingTask != null) {
            JavaParserPlugin.verbosePrintln("CompilerHelper: cancelling task");
            smScheduler.cancelTask((AsyncTask)pendingTask);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishSemantic(SemanticTask task) {
        JavaParserPlugin javaParserPlugin = this;
        synchronized (javaParserPlugin) {
            if (this.smTask == task) {
                JavaParserPlugin.verbosePrintln("CompilerHelper: finishing task");
                this.smTask = null;
            }
        }
    }

    static void maS$verbosePrintln(String string) {
        JavaParserPlugin.verbosePrintln(string);
    }

    static void mav$finishSemantic(JavaParserPlugin javaParserPlugin, SemanticTask semanticTask) {
        javaParserPlugin.finishSemantic(semanticTask);
    }

    static JavaManager ra$smJavaManager(JavaParserPlugin javaParserPlugin) {
        return javaParserPlugin.smJavaManager;
    }

    static void wa$smJavaManager(JavaParserPlugin javaParserPlugin, JavaManager javaManager) {
        javaParserPlugin.smJavaManager = javaManager;
    }

    static JavaSourceNode ra$javaNode(JavaParserPlugin javaParserPlugin) {
        return javaParserPlugin.javaNode;
    }

    static Log ra$LOG() {
        return LOG;
    }

    static int ra$smTaskChangeId(JavaParserPlugin javaParserPlugin) {
        return javaParserPlugin.smTaskChangeId;
    }

    static SourceFile ra$smTaskSourceFile(JavaParserPlugin javaParserPlugin) {
        return javaParserPlugin.smTaskSourceFile;
    }

    static void wa$smTaskChangeId(JavaParserPlugin javaParserPlugin, int n) {
        javaParserPlugin.smTaskChangeId = n;
    }

    static void wa$smTaskSourceFile(JavaParserPlugin javaParserPlugin, SourceFile sourceFile) {
        javaParserPlugin.smTaskSourceFile = sourceFile;
    }

    static Project ra$project(JavaParserPlugin javaParserPlugin) {
        return javaParserPlugin.project;
    }

    static void mav$notifyParseFinished(JavaParserPlugin javaParserPlugin, JavaManager javaManager, SourceFile sourceFile, int n, int n2) {
        javaParserPlugin.notifyParseFinished(javaManager, sourceFile, n, n2);
    }

    static void mav$ensureCompileScheduled(JavaParserPlugin javaParserPlugin) {
        javaParserPlugin.ensureCompileScheduled();
    }

    static void mav$notifyCompileFinished(JavaParserPlugin javaParserPlugin, JavaManager javaManager, SourceFile sourceFile, int n, int n2) {
        javaParserPlugin.notifyCompileFinished(javaManager, sourceFile, n, n2);
    }

    public static interface HelperClient {
        public void notifyCompileScheduled();

        public void notifyParseFinished(JavaManager var1, SourceFile var2, int var3, int var4);

        public void notifyCompileFinished(JavaManager var1, SourceFile var2, int var3, int var4);
    }

    private final class SemanticTask
    extends AsyncTask {
        private Project smProject;
        private JavaSourceNode smNode;
        private boolean smCancelled;
        private volatile boolean waitingOnIndex;
        private Object waitingLock;

        private void $init$() {
            this.waitingLock = new Object();
        }

        private SemanticTask() {
            this.$init$();
            this.smProject = JavaParserPlugin.ra$project(JavaParserPlugin.this);
            this.smNode = JavaParserPlugin.ra$javaNode(JavaParserPlugin.this);
            this.smCancelled = false;
        }

        protected void requestCancelImpl() {
            JavaParserPlugin.maS$verbosePrintln("requesting cancel");
            this.smCancelled = true;
            SourceFile file = JavaParserPlugin.ra$smTaskSourceFile(JavaParserPlugin.this);
            if (file != null) {
                file.cancelCompile();
            }
        }

        protected boolean isCancelledImpl() {
            return this.smCancelled;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Object runImpl() throws AsyncTask.CancelledException {
            long compileStart = System.currentTimeMillis();
            try {
                int changeId;
                TextBuffer textBuffer;
                JavaParserPlugin.maS$verbosePrintln("CompilerHelper: task entry");
                if (!this.smNode.isOpen()) {
                    Object var18_2 = null;
                    return var18_2;
                }
                if (JavaParserPlugin.ra$smJavaManager(JavaParserPlugin.this) == null) {
                    JavaParserPlugin.wa$smJavaManager(JavaParserPlugin.this, JavaManager.getJavaManager((Project)this.smProject));
                }
                if ((textBuffer = this.smNode.acquireTextBuffer()) == null) {
                    Object var19_4 = null;
                    return var19_4;
                }
                this.bailIfCancelled();
                JavaParserPlugin.maS$verbosePrintln("CompilerHelper: parse start");
                SourceFile sourceFile = null;
                textBuffer.readLock();
                try {
                    changeId = textBuffer.getChangeId();
                    textBuffer.readLock();
                    try {
                        sourceFile = JavaParserPlugin.ra$smJavaManager(JavaParserPlugin.this).getSourceFile(textBuffer);
                        if (sourceFile == null) {
                            Object var20_7 = null;
                            return var20_7;
                        }
                        sourceFile.setURL(JavaParserPlugin.ra$javaNode(JavaParserPlugin.this).getURL());
                    }
                    finally {
                        textBuffer.readUnlock();
                    }
                    JavaParserPlugin.ra$LOG().trace("new source file {2} id {0}; old source file {3} id {1}", changeId, JavaParserPlugin.ra$smTaskChangeId(JavaParserPlugin.this), (Object)sourceFile, (Object)JavaParserPlugin.ra$smTaskSourceFile(JavaParserPlugin.this));
                    JavaParserPlugin.wa$smTaskChangeId(JavaParserPlugin.this, changeId);
                    JavaParserPlugin.wa$smTaskSourceFile(JavaParserPlugin.this, sourceFile);
                }
                finally {
                    textBuffer.readUnlock();
                }
                this.bailIfCancelled();
                int passChangeId = changeId;
                SourceFile passSourceFile = sourceFile;
                1 notifier = new 1(this, compileStart, passSourceFile, passChangeId);
                SwingUtilities.invokeLater(notifier);
                JavaParserPlugin.maS$verbosePrintln("CompilerHelper: semantic compile start");
                CacheSupport cacheSupport = JavaParserPlugin.ra$smJavaManager(JavaParserPlugin.this).getCacheSupport();
                try {
                    try {
                        cacheSupport.beginCacheUse();
                        JavaParserPlugin.ra$LOG().trace("compiling, isCompiled {0}", sourceFile.isCompiled());
                        sourceFile.compile();
                        this.bailIfCancelled();
                    }
                    catch (CancellationException e) {
                        JavaParserPlugin.maS$verbosePrintln("cancelled during semantic");
                        throw e;
                    }
                    catch (AsyncTask.CancelledException e) {
                        JavaParserPlugin.maS$verbosePrintln("cancelled during semantic");
                        throw e;
                    }
                    catch (ExpiredTextBufferException e) {
                        JavaParserPlugin.maS$verbosePrintln("expired during semantic");
                        throw e;
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        JavaParserPlugin.maS$verbosePrintln("exception during semantic: " + e);
                        throw new UnexpectedExceptionError(e);
                    }
                }
                finally {
                    cacheSupport.endCacheUse();
                }
                JavaProjectIndexer indexer = JavaProjectIndexer.getJavaProjectIndexer();
                if (this.smProject.isOpen() && !indexer.isIndexed(this.smProject)) {
                    Object object = this.waitingLock;
                    synchronized (object) {
                        if (!this.waitingOnIndex) {
                            this.waitingOnIndex = true;
                            JavaParserPlugin.maS$verbosePrintln("CompilerHelper: begin wait for index");
                            Project project = this.smProject;
                            2 thread = new 2(this, "ProjectIndexWait-" + this.smProject.getShortLabel(), indexer, project);
                            thread.start();
                        }
                    }
                }
                JavaParserPlugin.maS$verbosePrintln("CompilerHelper: scheduling notify");
                3 compileNotifier = new 3(this, compileStart, passSourceFile, passChangeId);
                SwingUtilities.invokeLater(compileNotifier);
                Object var25_24 = null;
                return var25_24;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                JavaParserPlugin.mav$finishSemantic(JavaParserPlugin.this, this);
            }
        }

        SemanticTask(3 var2_2) {
            this();
        }

        static Object ra$waitingLock(SemanticTask semanticTask) {
            return semanticTask.waitingLock;
        }

        static void wa$waitingOnIndex(SemanticTask semanticTask, boolean bl) {
            semanticTask.waitingOnIndex = bl;
        }

        final class 1
        implements Runnable {
            private final /* synthetic */ long v$compileStart;
            private final /* synthetic */ SourceFile v$passSourceFile;
            private final /* synthetic */ int v$passChangeId;
            final /* synthetic */ SemanticTask this$0;

            public void run() {
                long compileTotal = System.currentTimeMillis() - this.v$compileStart;
                if (!this.this$0.isCancelledImpl()) {
                    JavaParserPlugin.maS$verbosePrintln("CompilerHelper: performing notify");
                    JavaParserPlugin.mav$notifyParseFinished(this.this$0.JavaParserPlugin.this, JavaParserPlugin.ra$smJavaManager(this.this$0.JavaParserPlugin.this), this.v$passSourceFile, this.v$passChangeId, (int)compileTotal);
                }
            }

            public 1(SemanticTask semanticTask, long l, SourceFile sourceFile, int n) {
                this.v$passChangeId = n;
                this.v$passSourceFile = sourceFile;
                this.v$compileStart = l;
                this.this$0 = semanticTask;
            }
        }

        final class 2
        extends Thread {
            private final /* synthetic */ JavaProjectIndexer v$indexer;
            private final /* synthetic */ Project v$project;
            final /* synthetic */ SemanticTask this$0;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                this.v$indexer.waitUntilIndexed(this.v$project);
                Object object = SemanticTask.ra$waitingLock(this.this$0);
                synchronized (object) {
                    SemanticTask.wa$waitingOnIndex(this.this$0, false);
                }
                JavaParserPlugin.maS$verbosePrintln("CompilerHelper: indexing completed");
                JavaParserPlugin.mav$ensureCompileScheduled(this.this$0.JavaParserPlugin.this);
            }

            public 2(SemanticTask semanticTask, String string, JavaProjectIndexer javaProjectIndexer, Project project) {
                this.v$project = project;
                this.v$indexer = javaProjectIndexer;
                this.this$0 = semanticTask;
                super(string);
            }
        }

        final class 3
        implements Runnable {
            private final /* synthetic */ long v$compileStart;
            private final /* synthetic */ SourceFile v$passSourceFile;
            private final /* synthetic */ int v$passChangeId;
            final /* synthetic */ SemanticTask this$0;

            public void run() {
                long compileTotal = System.currentTimeMillis() - this.v$compileStart;
                if (!this.this$0.isCancelledImpl()) {
                    JavaParserPlugin.maS$verbosePrintln("CompilerHelper: performing notify");
                    JavaParserPlugin.mav$notifyCompileFinished(this.this$0.JavaParserPlugin.this, JavaParserPlugin.ra$smJavaManager(this.this$0.JavaParserPlugin.this), this.v$passSourceFile, this.v$passChangeId, (int)compileTotal);
                }
            }

            public 3(SemanticTask semanticTask, long l, SourceFile sourceFile, int n) {
                this.v$passChangeId = n;
                this.v$passSourceFile = sourceFile;
                this.v$compileStart = l;
                this.this$0 = semanticTask;
            }
        }
    }
}

