/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RejectedExecutionException;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Ide;
import oracle.ide.IdeAdapter;
import oracle.ide.IdeEvent;
import oracle.ide.IdeListener;
import oracle.ide.config.ClientSetting;
import oracle.ide.controls.ProgressTrackedTask;
import oracle.ide.controls.ProgressTracker;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.index.Index;
import oracle.ide.index.IndexManager;
import oracle.ide.index.task.BackgroundTask;
import oracle.ide.migration.NodeMigrator;
import oracle.ide.model.Node;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.NodeListener;
import oracle.ide.model.Observer;
import oracle.ide.model.Project;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.WorkspaceMigrator;
import oracle.ide.util.Assert;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.parser.util.AsyncScheduler;
import oracle.javatools.parser.util.AsyncTask;
import oracle.javatools.util.Copyable;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdevimpl.java.JavaArb;
import oracle.jdevimpl.java.editing.JavaOptions;

public final class JavaProjectIndexer
implements Observer {
    private static JavaProjectIndexer _indexer = new JavaProjectIndexer();
    private static AsyncScheduler INDEX_SCHEDULER = new AsyncScheduler("JavaProjectIndex", 5, 1);
    private Set _indexedSet;
    private int DISPLAY_DELAY;
    private int SUBSEQUENT_DELAY;
    private List<IndexTask> _taskList;
    private boolean _trackerRunning;

    public static JavaProjectIndexer getJavaProjectIndexer() {
        return _indexer;
    }

    private JavaProjectIndexer() {
        this.$init$();
    }

    private void projectOpened(Project project) {
        if (project != null && !this.isIndexed(project)) {
            project.attach((Observer)this);
            this.projectChanged(project);
        }
    }

    private void projectChanged(Project project) {
        if (project != null && !this.isMigrating()) {
            this.indexProject(project);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void projectClosed(Project project) {
        if (project != null) {
            project.detach((Observer)this);
            List<IndexTask> list = this._taskList;
            synchronized (list) {
                Iterator<IndexTask> iterator = this._taskList.iterator();
                while (iterator.hasNext()) {
                    IndexTask task = iterator.next();
                    if (task.getProject() != project) continue;
                    INDEX_SCHEDULER.cancelTask((AsyncTask)task);
                    iterator.remove();
                }
            }
            this.clearIndexed(project);
        }
    }

    private boolean isMigrating() {
        NodeMigrator migrator = NodeMigrator.getNodeMigrator((String)WorkspaceMigrator.MIGRATOR_NAME);
        return migrator != null && migrator.getTraversableContext() != null;
    }

    public void update(Object observed, UpdateMessage change) {
        int id = change.getMessageID();
        if (observed instanceof Project) {
            Project project = (Project)observed;
            if (id == UpdateMessage.OBJECT_RELOADED) {
                this.projectChanged(project);
            } else if (id == UpdateMessage.PROPERTY_SET && (change.containsProperty("classPath") || change.containsProperty("sourcePath"))) {
                this.projectChanged(project);
            }
        }
    }

    void initialize() {
        Ide.addIdeListener((IdeListener)new 1());
    }

    private void attachToProjects() {
        2 projectListener = new 2();
        Node.addNodeListenerForType(Project.class, (NodeListener)projectListener);
        3 task = new 3();
        INDEX_SCHEDULER.scheduleTask((AsyncTask)task);
    }

    private void indexProject(Project project) {
        LocatorTask locatorTask = this.locatorIndexProject(project);
        KeywordTask keywordTask = this.keywordIndexProject(project);
        this.trackIndex(locatorTask);
        this.trackIndex(keywordTask);
    }

    private LocatorTask locatorIndexProject(Project project) {
        this.clearIndexed(project);
        LocatorTask task = new LocatorTask(project);
        INDEX_SCHEDULER.scheduleTask((AsyncTask)task);
        return task;
    }

    private KeywordTask keywordIndexProject(Project project) {
        KeywordTask task = new KeywordTask(project);
        INDEX_SCHEDULER.scheduleTask((AsyncTask)task);
        return task;
    }

    private static void sleep(int ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isIndexed(Project project) {
        JavaProjectIndexer javaProjectIndexer = this;
        synchronized (javaProjectIndexer) {
            boolean bl = this._indexedSet.contains(project);
            return bl;
        }
    }

    public boolean waitUntilIndexed(Project project) {
        if (this.isIndexed(project)) {
            return true;
        }
        if (!project.isOpen()) {
            return false;
        }
        this.locatorIndexProject(project);
        while (!this.isIndexed(project)) {
            JavaProjectIndexer.sleep(50);
        }
        return true;
    }

    private void markIndexed(Project project) {
        project.runUnderReadLock((Runnable)new 4(this, project));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearIndexed(Project project) {
        JavaProjectIndexer javaProjectIndexer = this;
        synchronized (javaProjectIndexer) {
            this._indexedSet.remove(project);
        }
    }

    private void $init$() {
        this._indexedSet = new HashSet(50);
        this.DISPLAY_DELAY = 6000;
        this.SUBSEQUENT_DELAY = 2000;
        this._taskList = new ArrayList<IndexTask>();
        this._trackerRunning = false;
    }

    private boolean getShowIndexerDialog() {
        ClientSetting settings = ClientSetting.findOrCreate((String)"oracle.jdeveloper");
        JavaOptions javaOptions = (JavaOptions)settings.getData("JavaEditingOptions");
        if (javaOptions == null) {
            javaOptions = new JavaOptions();
        }
        return javaOptions.getShowIndexerDialog();
    }

    private void setShowIndexerDialog(boolean show) {
        ClientSetting settings = ClientSetting.findOrCreate((String)"oracle.jdeveloper");
        JavaOptions javaOptions = (JavaOptions)settings.getData("JavaEditingOptions");
        if (javaOptions == null) {
            javaOptions = new JavaOptions();
        }
        javaOptions.setShowIndexerDialog(show);
        settings.putData("JavaEditingOptions", (Copyable)javaOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trackIndex(IndexTask task) {
        boolean showDialog = this.getShowIndexerDialog();
        List<IndexTask> list = this._taskList;
        synchronized (list) {
            this._taskList.add(task);
            if (showDialog) {
                this.trackProgress();
            }
        }
    }

    private void trackProgress() {
        if (this._trackerRunning) {
            return;
        }
        this._trackerRunning = true;
        ProgressDialog dialog = new ProgressDialog(null);
        boolean[] bail = new boolean[]{false};
        5 displayRunnable = new 5(this, dialog, bail);
        6 updaterRunnable = new 6(this, displayRunnable, bail, dialog);
        Thread updater = new Thread((Runnable)updaterRunnable, "Project Indexer Progress");
        updater.start();
    }

    static List ra$_taskList(JavaProjectIndexer javaProjectIndexer) {
        return javaProjectIndexer._taskList;
    }

    static void mav$markIndexed(JavaProjectIndexer javaProjectIndexer, Project project) {
        javaProjectIndexer.markIndexed(project);
    }

    static void mav$setShowIndexerDialog(JavaProjectIndexer javaProjectIndexer, boolean bl) {
        javaProjectIndexer.setShowIndexerDialog(bl);
    }

    static int ra$DISPLAY_DELAY(JavaProjectIndexer javaProjectIndexer) {
        return javaProjectIndexer.DISPLAY_DELAY;
    }

    static int ra$SUBSEQUENT_DELAY(JavaProjectIndexer javaProjectIndexer) {
        return javaProjectIndexer.SUBSEQUENT_DELAY;
    }

    static void wa$DISPLAY_DELAY(JavaProjectIndexer javaProjectIndexer, int n) {
        javaProjectIndexer.DISPLAY_DELAY = n;
    }

    static void wa$_trackerRunning(JavaProjectIndexer javaProjectIndexer, boolean bl) {
        javaProjectIndexer._trackerRunning = bl;
    }

    static Set ra$_indexedSet(JavaProjectIndexer javaProjectIndexer) {
        return javaProjectIndexer._indexedSet;
    }

    static void mav$projectClosed(JavaProjectIndexer javaProjectIndexer, Project project) {
        javaProjectIndexer.projectClosed(project);
    }

    static void mav$projectOpened(JavaProjectIndexer javaProjectIndexer, Project project) {
        javaProjectIndexer.projectOpened(project);
    }

    static void mav$attachToProjects(JavaProjectIndexer javaProjectIndexer) {
        javaProjectIndexer.attachToProjects();
    }

    final class 1
    extends IdeAdapter {
        public void mainWindowOpened(IdeEvent e) {
            JavaProjectIndexer.mav$attachToProjects(JavaProjectIndexer.this);
            Ide.removeIdeListener((IdeListener)this);
        }
    }

    final class 2
    extends NodeListener {
        public void nodeOpened(NodeEvent e) {
            if (e.getNode() instanceof Project) {
                JavaProjectIndexer.mav$projectOpened(JavaProjectIndexer.this, (Project)e.getNode());
            }
        }

        public void nodeClosed(NodeEvent e) {
            if (e.getNode() instanceof Project) {
                JavaProjectIndexer.mav$projectClosed(JavaProjectIndexer.this, (Project)e.getNode());
            }
        }
    }

    final class 3
    extends AsyncTask {
        protected Object runImpl() {
            Iterator iterator = NodeFactory.getOpenNodes();
            while (iterator.hasNext()) {
                Object object = iterator.next();
                if (!(object instanceof Project)) continue;
                JavaProjectIndexer.mav$projectOpened(JavaProjectIndexer.this, (Project)object);
            }
            return null;
        }

        protected void requestCancelImpl() {
        }

        protected boolean isCancelledImpl() {
            return false;
        }
    }

    final class 4
    implements Runnable {
        private final /* synthetic */ Project v$project;
        final /* synthetic */ JavaProjectIndexer this$0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            4 var1_1 = this;
            synchronized (var1_1) {
                if (this.v$project.isOpen()) {
                    JavaProjectIndexer.ra$_indexedSet(this.this$0).add(this.v$project);
                }
            }
        }

        public 4(JavaProjectIndexer javaProjectIndexer, Project project) {
            this.v$project = project;
            this.this$0 = javaProjectIndexer;
        }
    }

    private abstract class IndexTask
    extends AsyncTask {
        private Project _project;

        public IndexTask(Project project) {
            this._project = project;
        }

        public Project getProject() {
            return this._project;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Object runImpl() {
            if (this._project != null && this._project.isOpenUnsafe()) {
                ProgressTrackedTask trackedTask = this.getProgressTrackedTask(this._project);
                ProgressTracker tracker = Ide.getStatusBar().getProgressTracker();
                1 addTrackerOnUIThread = new 1(this, tracker, trackedTask);
                SwingUtilities.invokeLater(addTrackerOnUIThread);
                String statusText = this.getStatusBarText(this._project);
                if (statusText != null && statusText.length() > 0) {
                    Ide.getStatusBar().setText(statusText);
                }
                try {
                    this.buildIndex(this._project);
                }
                catch (Throwable throwable) {
                    if (statusText != null && statusText.equals(Ide.getStatusBar().getText())) {
                        Ide.getStatusBar().setText("");
                    }
                    List list = JavaProjectIndexer.ra$_taskList(JavaProjectIndexer.this);
                    synchronized (list) {
                        JavaProjectIndexer.ra$_taskList(JavaProjectIndexer.this).remove((Object)this);
                    }
                    throw throwable;
                }
                if (statusText != null && statusText.equals(Ide.getStatusBar().getText())) {
                    Ide.getStatusBar().setText("");
                }
                List list = JavaProjectIndexer.ra$_taskList(JavaProjectIndexer.this);
                synchronized (list) {
                    JavaProjectIndexer.ra$_taskList(JavaProjectIndexer.this).remove((Object)this);
                }
            }
            return Boolean.TRUE;
        }

        protected abstract ProgressTrackedTask getProgressTrackedTask(Project var1);

        protected abstract void buildIndex(Project var1);

        protected abstract String getStatusBarText(Project var1);

        protected abstract String getProgressBarText(Project var1);

        protected abstract String getProgressBarTooltipText(Project var1);

        protected void requestCancelImpl() {
        }

        protected boolean isCancelledImpl() {
            return false;
        }

        final class 1
        implements Runnable {
            private final /* synthetic */ ProgressTracker v$tracker;
            private final /* synthetic */ ProgressTrackedTask v$trackedTask;
            final /* synthetic */ IndexTask this$0;

            public void run() {
                this.v$tracker.addTask(this.v$trackedTask, "BackgroundKeywordIndexer");
            }

            public 1(IndexTask indexTask, ProgressTracker progressTracker, ProgressTrackedTask progressTrackedTask) {
                this.v$trackedTask = progressTrackedTask;
                this.v$tracker = progressTracker;
                this.this$0 = indexTask;
            }
        }
    }

    private class LocatorTask
    extends IndexTask {
        public LocatorTask(Project project) {
            super(project);
        }

        protected ProgressTrackedTask getProgressTrackedTask(Project project) {
            return new 1(this, project);
        }

        protected void buildIndex(Project project) {
            if (!JavaProjectIndexer.this.isIndexed(project)) {
                JavaManager jm = JavaManager.getJavaManager((Project)project);
                jm.getJavaClassLocator().buildIndex();
                JavaProjectIndexer.mav$markIndexed(JavaProjectIndexer.this, project);
            }
        }

        protected String getStatusBarText(Project project) {
            String projectName = project.getShortLabel();
            String statusText = JavaArb.format(227, projectName);
            return statusText;
        }

        protected String getProgressBarText(Project project) {
            return JavaArb.getString(185);
        }

        protected String getProgressBarTooltipText(Project project) {
            return this.getStatusBarText(project);
        }

        static void maS$sleep(int n) {
            AsyncTask.sleep((int)n);
        }

        final class 1
        implements ProgressTrackedTask {
            private final /* synthetic */ Project v$project;
            final /* synthetic */ LocatorTask this$0;

            public boolean isIndeterminate() {
                return true;
            }

            public int getCurrentValue() {
                return 0;
            }

            public int getMinimum() {
                return 0;
            }

            public int getMaximum() {
                return 100;
            }

            public String getCurrentText() {
                return this.v$project != null ? this.this$0.getProgressBarText(this.v$project) : "";
            }

            public String getTaskDescription() {
                return this.v$project != null ? this.this$0.getProgressBarTooltipText(this.v$project) : "";
            }

            public void run() {
                while (!this.this$0.isFinished()) {
                    LocatorTask.maS$sleep(100);
                }
            }

            public 1(LocatorTask locatorTask, Project project) {
                this.v$project = project;
                this.this$0 = locatorTask;
            }
        }
    }

    private class KeywordTask
    extends IndexTask {
        private BackgroundTask task;
        private boolean cancelled;
        private boolean finished;

        public KeywordTask(Project project) {
            super(project);
        }

        protected ProgressTrackedTask getProgressTrackedTask(Project project) {
            return new 1(this, project);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void buildIndex(Project project) {
            IndexManager manager = IndexManager.getIndexManager();
            Index index = manager.getIndex(project);
            try {
                KeywordTask keywordTask = this;
                synchronized (keywordTask) {
                    if (this.cancelled) {
                        // MONITOREXIT @DISABLED, blocks:[0, 1, 18, 6] lbl8 : MonitorExitStatement: MONITOREXIT : var7_4
                        index.release();
                        KeywordTask keywordTask2 = this;
                        synchronized (keywordTask2) {
                            this.finished = true;
                            this.notifyAll();
                        }
                        return;
                    }
                    this.task = index.build();
                }
                try {
                    this.task.get();
                }
                catch (RejectedExecutionException ree) {
                }
                catch (InterruptedException ie) {
                    Assert.println((String)("Unable to index " + project.getShortLabel()));
                    Assert.printStackTrace((Throwable)ie);
                }
                catch (ExecutionException ee) {
                    Assert.println((String)("Unable to index " + project.getShortLabel()));
                    Assert.printStackTrace((Throwable)ee);
                }
            }
            catch (Throwable throwable) {
                index.release();
                KeywordTask keywordTask = this;
                synchronized (keywordTask) {
                    this.finished = true;
                    this.notifyAll();
                }
                throw throwable;
            }
            index.release();
            KeywordTask keywordTask = this;
            synchronized (keywordTask) {
                this.finished = true;
                this.notifyAll();
            }
        }

        protected String getStatusBarText(Project project) {
            String projectName = project.getShortLabel();
            String statusText = JavaArb.format(26, projectName);
            return statusText;
        }

        protected String getProgressBarText(Project project) {
            return JavaArb.getString(131);
        }

        protected String getProgressBarTooltipText(Project project) {
            return this.getProgressBarText(project);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void requestCancelImpl() {
            KeywordTask keywordTask = this;
            synchronized (keywordTask) {
                this.cancelled = true;
                if (this.task != null) {
                    this.task.cancel(true);
                }
            }
        }

        protected boolean isCancelledImpl() {
            return this.cancelled;
        }

        static boolean ra$finished(KeywordTask keywordTask) {
            return keywordTask.finished;
        }

        static boolean ra$cancelled(KeywordTask keywordTask) {
            return keywordTask.cancelled;
        }

        static BackgroundTask ra$task(KeywordTask keywordTask) {
            return keywordTask.task;
        }

        final class 1
        implements ProgressTrackedTask {
            private final /* synthetic */ Project v$project;
            final /* synthetic */ KeywordTask this$0;

            public boolean isIndeterminate() {
                return false;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public int getCurrentValue() {
                KeywordTask keywordTask = this.this$0;
                synchronized (keywordTask) {
                    int n = KeywordTask.ra$task(this.this$0) != null ? KeywordTask.ra$task(this.this$0).getProgress() : 0;
                    return n;
                }
            }

            public int getMinimum() {
                return 0;
            }

            public int getMaximum() {
                return 100;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public String getCurrentText() {
                KeywordTask keywordTask = this.this$0;
                synchronized (keywordTask) {
                    String string = KeywordTask.ra$task(this.this$0) != null ? KeywordTask.ra$task(this.this$0).getProgressText() : this.this$0.getProgressBarText(this.v$project);
                    return string;
                }
            }

            public String getTaskDescription() {
                return this.this$0.getProgressBarTooltipText(this.v$project);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                KeywordTask keywordTask = this.this$0;
                synchronized (keywordTask) {
                    try {
                        while (!KeywordTask.ra$finished(this.this$0) && !KeywordTask.ra$cancelled(this.this$0)) {
                            this.this$0.wait();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }

            public 1(KeywordTask keywordTask, Project project) {
                this.v$project = project;
                this.this$0 = keywordTask;
            }
        }
    }

    final class 5
    implements Runnable {
        private final /* synthetic */ ProgressDialog v$dialog;
        private final /* synthetic */ boolean[] v$bail;
        final /* synthetic */ JavaProjectIndexer this$0;

        public void run() {
            this.v$dialog.pack();
            WizardLauncher.runDialog((JDialog)((Object)this.v$dialog));
            boolean show = ProgressDialog.ra$cb_alwaysBackground(this.v$dialog).isSelected() ^ true;
            JavaProjectIndexer.mav$setShowIndexerDialog(this.this$0, show);
            this.v$bail[0] = true;
        }

        public 5(JavaProjectIndexer javaProjectIndexer, ProgressDialog progressDialog, boolean[] blArray) {
            this.v$bail = blArray;
            this.v$dialog = progressDialog;
            this.this$0 = javaProjectIndexer;
        }
    }

    final class 6
    implements Runnable {
        private final /* synthetic */ Runnable v$displayRunnable;
        private final /* synthetic */ boolean[] v$bail;
        private final /* synthetic */ ProgressDialog v$dialog;
        final /* synthetic */ JavaProjectIndexer this$0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public void run() {
            try {
                Thread.sleep(JavaProjectIndexer.ra$DISPLAY_DELAY(this.this$0));
            }
            catch (InterruptedException var1_1) {
                // empty catch block
            }
            JavaProjectIndexer.wa$DISPLAY_DELAY(this.this$0, JavaProjectIndexer.ra$SUBSEQUENT_DELAY(this.this$0));
            showing = false;
            block10: while (true) {
                var10_9 = JavaProjectIndexer.ra$_taskList(this.this$0);
                synchronized (var10_9) {
                    if (JavaProjectIndexer.ra$_taskList(this.this$0).size() > 0) {
                        task = (IndexTask)JavaProjectIndexer.ra$_taskList(this.this$0).remove(0);
                        if (task.isFinished()) {
                            continue;
                        }
                    } else {
                        JavaProjectIndexer.wa$_trackerRunning(this.this$0, false);
                        break;
                    }
                }
                if (!showing) {
                    showing = true;
                    SwingUtilities.invokeLater(this.v$displayRunnable);
                }
                while (true) {
                    if (!task.isFinished()) ** break;
                    continue block10;
                    if (this.v$bail[0]) {
                        var11_10 = JavaProjectIndexer.ra$_taskList(this.this$0);
                        synchronized (var11_10) {
                            JavaProjectIndexer.ra$_taskList(this.this$0).add(0, task);
                            JavaProjectIndexer.wa$_trackerRunning(this.this$0, false);
                        }
                        return;
                    }
                    project = task.getProject();
                    if (project != null) {
                        description = task.getStatusBarText(project);
                        progressText = task.getProgressBarTooltipText(project);
                        uiupdaterRunnable = new 1(this, description, progressText);
                        SwingUtilities.invokeLater(uiupdaterRunnable);
                    }
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                break;
            }
            if (showing) {
                canceluiRunnable = new 2();
                SwingUtilities.invokeLater(canceluiRunnable);
            }
        }

        public 6(JavaProjectIndexer javaProjectIndexer, Runnable runnable, boolean[] blArray, ProgressDialog progressDialog) {
            this.v$dialog = progressDialog;
            this.v$bail = blArray;
            this.v$displayRunnable = runnable;
            this.this$0 = javaProjectIndexer;
        }

        static ProgressDialog ra$v$dialog(6 var0) {
            return var0.v$dialog;
        }

        final class 1
        implements Runnable {
            private final /* synthetic */ String v$description;
            private final /* synthetic */ String v$progressText;
            final /* synthetic */ 6 this$0;

            public void run() {
                ProgressDialog.ra$label_description(6.ra$v$dialog(this.this$0)).setText(this.v$description);
                ProgressDialog.ra$label_taskProgress(6.ra$v$dialog(this.this$0)).setText(this.v$progressText);
            }

            public 1(6 var1_1, String string, String string2) {
                this.v$progressText = string2;
                this.v$description = string;
                this.this$0 = var1_1;
            }
        }

        final class 2
        implements Runnable {
            public void run() {
                ProgressDialog.mav$bail(6.ra$v$dialog(6.this));
            }
        }
    }

    private static class ProgressDialog
    extends JEWTDialog {
        private JLabel label_description = new JLabel(JavaArb.getString(168));
        private JProgressBar pb_taskProgress = new JProgressBar(0, 100);
        private JLabel label_taskProgress;
        private JCheckBox cb_alwaysBackground;
        private JPanel panel_progress;

        private void bail() {
            this.dismissDialog(false);
        }

        private ProgressDialog() {
            super((Frame)Ide.getMainWindow(), JavaArb.getString(265), 1);
            this.pb_taskProgress.setIndeterminate(true);
            this.label_taskProgress = new JLabel("");
            this.cb_alwaysBackground = new JCheckBox();
            String alwaysText = JavaArb.getString(47);
            ResourceUtils.resButton((AbstractButton)this.cb_alwaysBackground, (String)alwaysText);
            this.panel_progress = new JPanel(new GridBagLayout());
            Insets defaultInsets = new Insets(2, 5, 2, 5);
            GridBagConstraints constraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, defaultInsets, 0, 0);
            this.panel_progress.add((Component)this.label_description, constraints);
            constraints = new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, defaultInsets, 0, 0);
            this.panel_progress.add((Component)this.pb_taskProgress, constraints);
            constraints = new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 2, defaultInsets, 0, 0);
            this.panel_progress.add((Component)this.label_taskProgress, constraints);
            constraints = new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 2, defaultInsets, 0, 0);
            this.panel_progress.add(Box.createRigidArea(new Dimension(400, 5)), constraints);
            constraints = new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 17, 2, defaultInsets, 0, 0);
            this.panel_progress.add((Component)this.cb_alwaysBackground, constraints);
            constraints = new GridBagConstraints(0, 5, 1, 1, 1.0, 0.0, 17, 2, defaultInsets, 0, 0);
            this.panel_progress.add(Box.createVerticalStrut(1), constraints);
            constraints = new GridBagConstraints(0, 6, 1, 1, 1.0, 1.0, 17, 1, defaultInsets, 0, 0);
            this.panel_progress.add(Box.createGlue(), constraints);
            this.setContent(this.panel_progress);
            this.setDefaultButton(1);
            String backgroundText = JavaArb.getString(285);
            this.setOKButtonText(StringUtils.stripMnemonic((String)backgroundText));
            this.setOKButtonMnemonic(StringUtils.getMnemonicKeyCode((String)backgroundText));
        }

        ProgressDialog(1 var1_1) {
            this();
        }

        static JCheckBox ra$cb_alwaysBackground(ProgressDialog progressDialog) {
            return progressDialog.cb_alwaysBackground;
        }

        static JLabel ra$label_description(ProgressDialog progressDialog) {
            return progressDialog.label_description;
        }

        static JLabel ra$label_taskProgress(ProgressDialog progressDialog) {
            return progressDialog.label_taskProgress;
        }

        static void mav$bail(ProgressDialog progressDialog) {
            progressDialog.bail();
        }

        public final class 1 {
        }
    }
}

