/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.browse;

import java.awt.Component;
import javax.swing.JMenuItem;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.CodeMenuConstants;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.IdeActions;
import oracle.ide.controls.ToggleAction;
import oracle.ide.help.HelpInfo;
import oracle.ide.help.Helpable;
import oracle.ide.help.HelpableProvider;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.model.Node;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ide.view.View;
import oracle.jdeveloper.JDeveloperMenuConstants;
import oracle.jdevimpl.java.JavaArb;
import oracle.jdevimpl.java.browse.BrowseAddin;
import oracle.jdevimpl.java.browse.BrowseSupport;
import oracle.jdevimpl.java.browse.BrowseSymbolDialog;
import oracle.jdevimpl.java.browse.JavaBrowseSupport2;

final class BrowseController
implements Controller,
ContextMenuListener,
HelpableProvider {
    private static final String canBrowseKey = BrowseController.class.getName();
    private IdeAction browseSymbolAction = IdeActions.getGoToDeclarationAction();
    private JMenuItem browseSymbolMenuItem;
    private IdeAction browseDocAction;
    private JMenuItem browseDocMenuItem;
    private IdeAction browseHierarchyAction;
    private JMenuItem browseHierarchyMenuItem;
    private IdeAction browseDialogAction;

    BrowseController() {
        this.browseSymbolAction.addController((Controller)this);
        this.browseSymbolMenuItem = Ide.getMenubar().createMenuItem((ToggleAction)this.browseSymbolAction, JDeveloperMenuConstants.WEIGHT_NAVIGATE_GO_TO_CLASS);
        String browseJavaDocName = JavaArb.getString(286);
        int browseJavaDocMnemonic = StringUtils.getMnemonicKeyCode((String)browseJavaDocName);
        this.browseDocAction = IdeAction.get((int)Ide.findOrCreateCmdID((String)"ojjb.BrowseJavaDoc"), null, (String)browseJavaDocName, (String)IdeMainWindow.ACTION_CATEGORY_NAVIGATE, (Integer)new Integer(browseJavaDocMnemonic), (ArrayResourceBundle)JavaArb.getInstance(), (int)218, null, (boolean)true);
        this.browseDocAction.addController((Controller)this);
        this.browseDocMenuItem = Ide.getMenubar().createMenuItem((ToggleAction)this.browseDocAction, JDeveloperMenuConstants.WEIGHT_NAVIGATE_GO_TO_JAVADOC);
        this.browseDialogAction = IdeActions.getNavigateGoToClassAction();
        this.browseDialogAction.addController((Controller)this);
        this.browseDialogAction.setEnabled(true);
        String browseDialogName = JavaArb.getString(105);
        int browseDialogMnemonic = StringUtils.getMnemonicKeyCode((String)browseDialogName);
        this.browseDialogAction.putValue("Name", (Object)StringUtils.stripMnemonic((String)browseDialogName));
        this.browseDialogAction.putValue("MnemonicKey", (Object)new Integer(browseDialogMnemonic));
        String browseHierarchyName = JavaArb.getString(238);
        int browseHierarchyMnemonic = StringUtils.getMnemonicKeyCode((String)browseHierarchyName);
        this.browseHierarchyAction = IdeAction.get((int)Ide.findOrCreateCmdID((String)"ojjb.BrowseHierarchy"), null, (String)browseHierarchyName, (String)IdeMainWindow.ACTION_CATEGORY_NAVIGATE, (Integer)new Integer(browseHierarchyMnemonic), (ArrayResourceBundle)JavaArb.getInstance(), (int)87, null, (boolean)true);
        this.browseHierarchyAction.addController((Controller)this);
        this.browseHierarchyMenuItem = Ide.getMenubar().createMenuItem((ToggleAction)this.browseHierarchyAction);
        KeyStrokeContextRegistry registry = Ide.getKeyStrokeContextRegistry();
        registry.addAcceleratorDefinitionFile(this.getClass().getClassLoader(), "oracle/jdevimpl/java/browse/accelerators.xml");
    }

    void shutdown() {
    }

    public boolean handleEvent(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (cmdId == this.browseSymbolAction.getCommandId() || cmdId == this.browseDocAction.getCommandId() || cmdId == this.browseHierarchyAction.getCommandId()) {
            CodeEditor codeEditor;
            Context editorContext;
            Node node;
            BrowseSupport browseSupport;
            View view = context.getView();
            if (view instanceof CodeEditor && (browseSupport = BrowseAddin.getSupport((node = (editorContext = (codeEditor = (CodeEditor)view).getContext()).getNode()).getClass())) != null && browseSupport.canBrowseAtCursor(codeEditor)) {
                if (cmdId == this.browseSymbolAction.getCommandId()) {
                    browseSupport.performBrowseSymbolAtCursor(codeEditor);
                } else if (cmdId == this.browseDocAction.getCommandId()) {
                    browseSupport.performBrowseDocAtCursor(codeEditor);
                } else {
                    browseSupport.performBrowseHierarchyAtCursor(codeEditor);
                }
            }
            return true;
        }
        if (cmdId == this.browseDialogAction.getCommandId()) {
            BrowseSymbolDialog.showDialog(context);
            return true;
        }
        return false;
    }

    public boolean update(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (cmdId == this.browseSymbolAction.getCommandId() || cmdId == this.browseDocAction.getCommandId() || cmdId == this.browseHierarchyAction.getCommandId()) {
            boolean enabled = false;
            if (context != null) {
                Boolean cached = (Boolean)context.getProperty(canBrowseKey);
                if (cached != null) {
                    enabled = cached;
                } else {
                    View view = context.getView();
                    Node node = context.getNode();
                    if (view instanceof CodeEditor && node != null) {
                        CodeEditor codeEditor = (CodeEditor)view;
                        BrowseSupport browseSupport = BrowseAddin.getSupport(node.getClass());
                        if (browseSupport != null && browseSupport.canBrowseAtCursor(codeEditor)) {
                            enabled = true;
                        }
                    }
                    Boolean toCache = enabled ? Boolean.TRUE : Boolean.FALSE;
                    context.setProperty(canBrowseKey, (Object)toCache);
                }
            }
            action.setEnabled(enabled);
            return true;
        }
        if (cmdId == this.browseDialogAction.getCommandId()) {
            action.setEnabled(true);
            return true;
        }
        return false;
    }

    public void menuWillShow(ContextMenu popup) {
        CodeEditor codeEditor;
        Context editorContext;
        Node node;
        BrowseSupport browseSupport;
        Context context = popup.getContext();
        View view = context.getView();
        if (view instanceof CodeEditor && (browseSupport = BrowseAddin.getSupport((node = (editorContext = (codeEditor = (CodeEditor)view).getContext()).getNode()).getClass())) != null) {
            float menuSection = CodeMenuConstants.SECTION_SOURCE_CTXT_MENU - 0.001f;
            popup.add((Component)this.browseSymbolMenuItem, menuSection);
            popup.add((Component)this.browseDocMenuItem, menuSection);
            if (JavaBrowseSupport2.canBrowseHierarchy()) {
                popup.add((Component)this.browseHierarchyMenuItem, menuSection);
            }
        }
    }

    public void menuWillHide(ContextMenu popup) {
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    public HelpInfo getHelpInfo(Helpable helpable) {
        CodeEditor codeEditor;
        Context editorContext;
        Node node;
        BrowseSupport browseSupport;
        if (helpable instanceof CodeEditor && (browseSupport = BrowseAddin.getSupport((node = (editorContext = (codeEditor = (CodeEditor)helpable).getContext()).getNode()).getClass())) != null && browseSupport.canBrowseAtCursor(codeEditor)) {
            return browseSupport.getHelpInfoAtCursor(codeEditor);
        }
        return null;
    }
}

