/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.browse;

import java.awt.Component;
import java.util.LinkedList;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Addin;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableFactory;
import oracle.ide.explorer.TreeExplorer;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ide.util.ModelUtil;
import oracle.javatools.icons.OracleIcons;
import oracle.jdeveloper.JDeveloperMenuConstants;
import oracle.jdevimpl.java.JavaArb;
import oracle.jdevimpl.java.browse.BrowseHierarchyDialog;
import oracle.jdevimpl.java.browse.BrowseHierarchyDockableFactory;
import oracle.jdevimpl.java.browse.BrowseHierarchyWindow;

public class BrowseHierarchyAddin
implements Addin,
Controller {
    private static final int VIEW_HIERARCHY_CMD_ID = Ide.findOrCreateCmdID((String)"ViewHierarchy");
    private static final int BROWSE_HIERARCHY_DIALOG_CMD_ID = Ide.findOrCreateCmdID((String)"BrowseHierarchyDialog");
    private static final int BROWSE_HIERARCHY_BACK_CMD_ID = Ide.findOrCreateCmdID((String)"BrowseHierarchy.Back");
    private static final int BROWSE_HIERARCHY_FORWARD_CMD_ID = Ide.findOrCreateCmdID((String)"BrowseHierarchy.Forward");
    private static final int BROWSE_HIERARCHY_SUPERTYPE_CMD_ID = Ide.findOrCreateCmdID((String)"BrowseHierarchy.Supertype");
    private static final int BROWSE_HIERARCHY_SUBTYPE_CMD_ID = Ide.findOrCreateCmdID((String)"BrowseHierarchy.Subtype");
    private static final String BROWSE_HIERARCHY_STYLE_GROUP = "BrowseHierarchy.StyleGroup";
    private static BrowseHierarchyAddin INSTANCE;
    private BrowseManager _browseManager;
    private JMenuItem _viewHierarchyMenuItem;
    private JMenuItem _browseHierarchyDialogMenuItem;

    public static void browseTypeHierarchy(Context context, String className) {
        INSTANCE.browseType(context, className);
    }

    public void initialize() {
        IdeAction deleteAction;
        INSTANCE = this;
        this._browseManager = new BrowseManager();
        IdeAction browseBackAction = IdeAction.get((int)BROWSE_HIERARCHY_BACK_CMD_ID, null, (String)IdeArb.getString((int)348), null, null, (Icon)OracleIcons.getIcon((String)"navigateBack.png"), null, (boolean)false);
        browseBackAction.addController((Controller)this);
        IdeAction browseForwardAction = IdeAction.get((int)BROWSE_HIERARCHY_FORWARD_CMD_ID, null, (String)IdeArb.getString((int)330), null, null, (Icon)OracleIcons.getIcon((String)"navigateForward.png"), null, (boolean)false);
        browseForwardAction.addController((Controller)this);
        IdeAction browseSupertypeAction = IdeAction.get((int)BROWSE_HIERARCHY_SUPERTYPE_CMD_ID, null, (String)JavaArb.getString(250), null, null, (ArrayResourceBundle)JavaArb.getInstance(), (int)57, null, (boolean)true);
        browseSupertypeAction.putValue("RadioGroupName", (Object)BROWSE_HIERARCHY_STYLE_GROUP);
        browseSupertypeAction.putValue("Radio", (Object)Boolean.TRUE);
        browseSupertypeAction.addController((Controller)this);
        browseSupertypeAction.setState(true);
        IdeAction browseSubtypeAction = IdeAction.get((int)BROWSE_HIERARCHY_SUBTYPE_CMD_ID, null, (String)JavaArb.getString(206), null, null, (ArrayResourceBundle)JavaArb.getInstance(), (int)93, null, (boolean)true);
        browseSubtypeAction.putValue("RadioGroupName", (Object)BROWSE_HIERARCHY_STYLE_GROUP);
        browseSubtypeAction.putValue("Radio", (Object)Boolean.TRUE);
        browseSubtypeAction.addController((Controller)this);
        String viewHierarchyName = JavaArb.getString(321);
        int viewHierarchyMnemonic = StringUtils.getMnemonicKeyCode((String)viewHierarchyName);
        IdeAction actionViewHierarchy = IdeAction.get((int)VIEW_HIERARCHY_CMD_ID, null, (String)viewHierarchyName, (String)IdeMainWindow.ACTION_CATEGORY_VIEW, (Integer)new Integer(viewHierarchyMnemonic), (ArrayResourceBundle)JavaArb.getInstance(), (int)162, null, (boolean)true);
        actionViewHierarchy.addController((Controller)this);
        String browseHierarchyDialogName = JavaArb.getString(85);
        int browseHierarchyDialogMnemonic = StringUtils.getMnemonicKeyCode((String)browseHierarchyDialogName);
        IdeAction browseHierarchyDialogAction = IdeAction.get((int)BROWSE_HIERARCHY_DIALOG_CMD_ID, null, (String)browseHierarchyDialogName, (String)IdeMainWindow.ACTION_CATEGORY_NAVIGATE, (Integer)new Integer(browseHierarchyDialogMnemonic), (ArrayResourceBundle)JavaArb.getInstance(), (int)231, null, (boolean)true);
        browseHierarchyDialogAction.addController((Controller)this);
        IdeAction refreshAction = IdeAction.find((int)51);
        if (refreshAction != null) {
            refreshAction.addController((Controller)this);
        }
        if ((deleteAction = IdeAction.find((int)20)) != null) {
            deleteAction.addController((Controller)this);
        }
        Menubar menubar = Ide.getMenubar();
        JMenu viewMenu = MenuManager.getJMenu((String)"View");
        JMenu navigateMenu = MenuManager.getJMenu((String)"Navigate");
        this._viewHierarchyMenuItem = menubar.createMenuItem((ToggleAction)actionViewHierarchy, MenuConstants.WEIGHT_VIEW_STRUCTURE);
        menubar.add((Component)this._viewHierarchyMenuItem, viewMenu, MenuConstants.SECTION_VIEW_SUPPORTING);
        this._browseHierarchyDialogMenuItem = menubar.createMenuItem((ToggleAction)browseHierarchyDialogAction);
        menubar.add((Component)this._browseHierarchyDialogMenuItem, navigateMenu, JDeveloperMenuConstants.SECTION_NAVIGATE_ADDINS);
        DockStation.getDockStation().registerDockableFactory("BrowseHierarchy", (DockableFactory)new BrowseHierarchyDockableFactory());
    }

    public boolean canShutdown() {
        return true;
    }

    public void shutdown() {
    }

    public boolean update(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (cmdId == VIEW_HIERARCHY_CMD_ID || cmdId == BROWSE_HIERARCHY_DIALOG_CMD_ID) {
            action.setEnabled(true);
            return true;
        }
        if (context.getView() instanceof BrowseHierarchyWindow) {
            if (cmdId == BROWSE_HIERARCHY_SUPERTYPE_CMD_ID || cmdId == BROWSE_HIERARCHY_SUBTYPE_CMD_ID) {
                action.setEnabled(true);
                return true;
            }
            if (cmdId == BROWSE_HIERARCHY_BACK_CMD_ID) {
                action.setEnabled(this._browseManager.canBrowseBackward());
                return true;
            }
            if (cmdId == BROWSE_HIERARCHY_FORWARD_CMD_ID) {
                action.setEnabled(this._browseManager.canBrowseForward());
                return true;
            }
            if (cmdId == 20) {
                action.setEnabled(this._browseManager.canBrowseDelete());
                return true;
            }
            if (cmdId == 51) {
                action.setEnabled(this._browseManager.canBrowseRefresh());
                return true;
            }
        }
        return false;
    }

    public boolean handleEvent(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (cmdId == VIEW_HIERARCHY_CMD_ID) {
            this._browseManager.showBrowseView(context);
            return true;
        }
        if (cmdId == BROWSE_HIERARCHY_DIALOG_CMD_ID) {
            this._browseManager.showBrowseDialog(context);
            return true;
        }
        if (context.getView() instanceof BrowseHierarchyWindow) {
            if (cmdId == BROWSE_HIERARCHY_SUPERTYPE_CMD_ID) {
                this._browseManager.setBrowseSupertypes();
                return true;
            }
            if (cmdId == BROWSE_HIERARCHY_SUBTYPE_CMD_ID) {
                this._browseManager.setBrowseSubtypes();
                return true;
            }
            if (cmdId == BROWSE_HIERARCHY_BACK_CMD_ID) {
                this._browseManager.browseBackward();
                return true;
            }
            if (cmdId == BROWSE_HIERARCHY_FORWARD_CMD_ID) {
                this._browseManager.browseForward();
                return true;
            }
            if (cmdId == 20) {
                this._browseManager.browseDelete();
                return true;
            }
            if (cmdId == 51) {
                this._browseManager.browseRefresh(context);
                return true;
            }
        }
        return false;
    }

    private void browseType(Context context, String className) {
        this._browseManager.browseType(context, className);
    }

    private static final class BrowseManager {
        private final LinkedList _backHistory;
        private final LinkedList _forwardHistory;
        private Object _browseStyle;

        private void $init$() {
            this._backHistory = new LinkedList();
            this._forwardHistory = new LinkedList();
        }

        BrowseManager() {
            this.$init$();
            this._browseStyle = BrowseHierarchyWindow.SUPERTYPE_HIERARCHY_STYLE;
        }

        boolean canBrowseBackward() {
            return this._backHistory.size() > 1;
        }

        boolean canBrowseForward() {
            return this._forwardHistory.isEmpty() ^ true;
        }

        boolean canBrowseDelete() {
            return this._backHistory.isEmpty() ^ true;
        }

        boolean canBrowseRefresh() {
            return this._backHistory.isEmpty() ^ true;
        }

        void showBrowseView(Context context) {
            this.browseType(context, null);
        }

        void showBrowseDialog(Context context) {
            BrowseHierarchyDialog.showDialog(context);
        }

        void setBrowseSupertypes() {
            this._browseStyle = BrowseHierarchyWindow.SUPERTYPE_HIERARCHY_STYLE;
            this.updateExplorer();
        }

        void setBrowseSubtypes() {
            this._browseStyle = BrowseHierarchyWindow.SUBTYPE_HIERARCHY_STYLE;
            this.updateExplorer();
        }

        void browseType(Context context, String className) {
            DockStation dockStation = DockStation.getDockStation();
            BrowseHierarchyWindow hierarchyBrowser = BrowseHierarchyWindow.getInstance();
            dockStation.activateDockable((Dockable)hierarchyBrowser);
            if (className != null) {
                HistoryEntry historyEntry = new HistoryEntry(context, className);
                if (this._backHistory.isEmpty() || !historyEntry.equals(this._backHistory.getLast())) {
                    this._backHistory.addLast(historyEntry);
                    this._forwardHistory.clear();
                }
                this.updateExplorer();
            }
        }

        void browseBackward() {
            if (!this.canBrowseBackward()) {
                return;
            }
            Object historyEntry = this._backHistory.removeLast();
            this._forwardHistory.addFirst(historyEntry);
            this.updateExplorer();
        }

        void browseForward() {
            if (!this.canBrowseForward()) {
                return;
            }
            Object historyEntry = this._forwardHistory.removeFirst();
            this._backHistory.addLast(historyEntry);
            this.updateExplorer();
        }

        void browseDelete() {
            if (!this.canBrowseDelete()) {
                return;
            }
            this._backHistory.removeLast();
            if (!this._forwardHistory.isEmpty()) {
                Object historyEntry = this._forwardHistory.removeFirst();
                this._backHistory.addLast(historyEntry);
            }
            this.updateExplorer();
        }

        void browseRefresh(Context context) {
            if (!this.canBrowseRefresh()) {
                return;
            }
            HistoryEntry historyEntry = (HistoryEntry)this._backHistory.removeLast();
            this.browseType(context, historyEntry.getClassName());
        }

        private void updateExplorer() {
            BrowseHierarchyWindow hierarchyBrowser = BrowseHierarchyWindow.getInstance();
            if (!this._backHistory.isEmpty()) {
                HistoryEntry historyEntry = (HistoryEntry)this._backHistory.getLast();
                hierarchyBrowser.setExplorer(historyEntry.getExplorer(this._browseStyle), historyEntry.getContext());
            } else {
                hierarchyBrowser.setExplorer(null, null);
            }
        }

        private static final class HistoryEntry {
            private final Context _context;
            private final String _className;
            private transient TreeExplorer _supertypeExplorer;
            private transient TreeExplorer _subtypeExplorer;

            public HistoryEntry(Context context, String className) {
                this._context = context;
                this._className = className;
            }

            public Context getContext() {
                return this._context;
            }

            public String getClassName() {
                return this._className;
            }

            public TreeExplorer getExplorer(Object browseStyle) {
                TreeExplorer explorer;
                boolean isSupertype = browseStyle == BrowseHierarchyWindow.SUPERTYPE_HIERARCHY_STYLE;
                TreeExplorer treeExplorer = explorer = isSupertype ? this._supertypeExplorer : this._subtypeExplorer;
                if (explorer == null) {
                    explorer = BrowseHierarchyWindow.getInstance().createExplorer(this._context, this._className, browseStyle);
                    if (isSupertype) {
                        this._supertypeExplorer = explorer;
                    } else {
                        this._subtypeExplorer = explorer;
                    }
                }
                return explorer;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof HistoryEntry)) {
                    return false;
                }
                HistoryEntry item = (HistoryEntry)o;
                return ModelUtil.areEqual((Object)this._className, (Object)item._className) && ModelUtil.areEqual((Object)this._context, (Object)item._context);
            }

            public int hashCode() {
                int result = 17;
                result = 37 * result + this._context.hashCode();
                result = 37 * result + this._className.hashCode();
                return result;
            }
        }
    }
}

