/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.browse;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableWindow;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.explorer.ExplorerContext;
import oracle.ide.explorer.TNode;
import oracle.ide.explorer.TreeExplorer;
import oracle.ide.help.HelpInfo;
import oracle.ide.index.IndexManager;
import oracle.ide.index.QueryCriteria;
import oracle.ide.model.DefaultElement;
import oracle.ide.model.Element;
import oracle.ide.model.Folder;
import oracle.ide.model.IdeSubject;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Observer;
import oracle.ide.model.Project;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.performance.PerformanceLogger;
import oracle.ide.resource.IdeIcons;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ide.util.Assert;
import oracle.ide.util.GraphicsUtils;
import oracle.ide.view.View;
import oracle.ideimpl.explorer.BaseTreeExplorer;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceName;
import oracle.javatools.util.Executors;
import oracle.javatools.util.Pair;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.library.Library;
import oracle.jdeveloper.model.DependencyCache;
import oracle.jdeveloper.model.JProjectLibraries;
import oracle.jdeveloper.usage.UsageManager;
import oracle.jdeveloper.usage.UsageQueryTask;
import oracle.jdeveloper.usage.event.ClassUsageEvent;
import oracle.jdeveloper.usage.event.ClassUsageListener;
import oracle.jdeveloper.usage.event.UsageEvent;
import oracle.jdevimpl.java.JavaArb;
import oracle.jdevimpl.java.browse.BrowseHierarchyAddin;

final class BrowseHierarchyWindow
extends DockableWindow {
    static final String HIERARCHY_BROWSER_WINDOW_ID = "BrowseHierarchy";
    static final Object SUPERTYPE_HIERARCHY_STYLE = new Integer(0);
    static final Object SUBTYPE_HIERARCHY_STYLE = new Integer(1);
    private static final String INTRO_CARD = "intro";
    private static final String EXPLORER_CARD = "explorer";
    private static final Rectangle EMPTY_RECT = new Rectangle();
    private static BrowseHierarchyWindow INSTANCE;
    private static final int DEFAULT_PROGRESS_INITIAL_DELAY = 1800;
    private static final int DEFAULT_PROGRESS_DELAY = 750;
    private JPanel _gui;
    private Toolbar _toolbar;
    private JPanel _centerPanel;
    private CardLayout _cardLayout;
    private TreeExplorer _explorer;
    private ExecutorService _scheduler;

    BrowseHierarchyWindow(String viewId) {
        super(viewId);
    }

    static BrowseHierarchyWindow getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new BrowseHierarchyWindow(HIERARCHY_BROWSER_WINDOW_ID);
        }
        return INSTANCE;
    }

    static void disposeHierarchyBrowser() {
        if (INSTANCE != null) {
            INSTANCE.dispose();
            INSTANCE = null;
        }
    }

    static Dockable getDockable() {
        return BrowseHierarchyWindow.getInstance();
    }

    TreeExplorer createExplorer(Context context, String className, Object browseStyle) {
        DefaultTypeFolder typeFolder;
        HierarchyTreeExplorer explorer = new HierarchyTreeExplorer();
        Project project = BrowseHierarchyWindow.getProjectFromContext(context);
        JavaManager javaManager = JavaManager.getJavaManager((Project)project);
        JavaClass javaClass = javaManager.getClass(className);
        if (browseStyle == SUPERTYPE_HIERARCHY_STYLE) {
            typeFolder = new SupertypeFolder(context, (JavaType)javaClass);
        } else if (browseStyle == SUBTYPE_HIERARCHY_STYLE) {
            typeFolder = new SubtypeFolder(context, (JavaType)javaClass);
        } else {
            throw new IllegalArgumentException("Invalid browse style");
        }
        RootElement rootElement = new RootElement(typeFolder);
        explorer.setRootElement((Element)rootElement);
        if (browseStyle == SUPERTYPE_HIERARCHY_STYLE) {
            TNode root = explorer.getRoot();
            explorer.expand(root, true);
        }
        return explorer;
    }

    void setExplorer(TreeExplorer explorer, Context context) {
        if (this._gui != null && this._explorer != null) {
            this._centerPanel.remove(this._explorer.getGUI());
        }
        this._explorer = explorer;
        if (this._gui != null) {
            this.updateGUI();
        }
    }

    public Component getGUI() {
        if (this._gui == null) {
            this._gui = new JPanel(new BorderLayout());
            this._toolbar = new Toolbar();
            BrowseHierarchyWindow.loadManifestToolbar((String)"BrowseHierarchy.Toolbar", (Toolbar)this._toolbar, (View)this);
            String introText = JavaArb.getString(348);
            LabelPanel introPanel = new LabelPanel(introText);
            this._cardLayout = new CardLayout();
            this._centerPanel = new JPanel(this._cardLayout);
            this._centerPanel.add((Component)introPanel, INTRO_CARD);
            this._gui.add((Component)this._toolbar, "North");
            this._gui.add((Component)this._centerPanel, "Center");
            this.updateGUI();
        }
        return this._gui;
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_jed_hierarchy_view_html");
    }

    public Toolbar getToolbar() {
        return this._toolbar;
    }

    public String getTitleName() {
        return JavaArb.getString(347);
    }

    public String getTabName() {
        return this.getTitleName();
    }

    public Icon getTabIcon() {
        return JavaArb.getIcon(162);
    }

    private void updateGUI() {
        if (this._scheduler != null) {
            Executors.shutdownNow((ExecutorService)this._scheduler);
            this._scheduler = null;
        }
        if (this._explorer != null) {
            this._scheduler = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new QueryThreadFactory(null), new ThreadPoolExecutor.DiscardPolicy());
            TNode root = this._explorer.getRoot();
            RootElement rootElement = (RootElement)root.getData();
            DefaultTypeFolder rootFolder = rootElement.getRootFolder();
            TNode rootTNode = this._explorer.searchTNode((Element)rootFolder, root);
            this._explorer.expand(rootTNode, false);
            this._explorer.setSelected(rootTNode);
            this._explorer.getJTree().scrollRectToVisible(EMPTY_RECT);
            this._centerPanel.add(this._explorer.getGUI(), EXPLORER_CARD);
            this._cardLayout.show(this._centerPanel, EXPLORER_CARD);
        } else {
            this._cardLayout.show(this._centerPanel, INTRO_CARD);
        }
        GraphicsUtils.focusComponentOrChild((Component)this._centerPanel, (boolean)true);
    }

    private void dispose() {
        if (this._explorer instanceof BaseTreeExplorer) {
            ((BaseTreeExplorer)this._explorer).dispose();
        }
        this._gui = null;
        this._toolbar = null;
        this._centerPanel = null;
        this._cardLayout = null;
        this._explorer = null;
    }

    private static Project getProjectFromContext(Context context) {
        Project project;
        Project project2 = project = context != null ? context.getProject() : null;
        if (project == null && (project = Ide.getActiveProject()) == null) {
            project = Ide.getDefaultProject();
        }
        return project;
    }

    static Project maS$getProjectFromContext(Context context) {
        return BrowseHierarchyWindow.getProjectFromContext(context);
    }

    static ExecutorService ra$_scheduler(BrowseHierarchyWindow browseHierarchyWindow) {
        return browseHierarchyWindow._scheduler;
    }

    private static final class HierarchyTreeExplorer
    extends BaseTreeExplorer
    implements Controller,
    ContextMenuListener {
        private ContextMenu _contextMenu;
        private boolean _menusBuilt;
        private IdeAction _gotoClassAction;
        private JMenuItem _gotoClassMenuItem;
        private IdeAction _browseHierarchyAction;
        private JMenuItem _browseHierarchyMenuItem;

        HierarchyTreeExplorer() {
            this.setContext(null);
            this.setComparator(TreeComparator.getInstance());
        }

        public boolean update(IdeAction action, Context context) {
            View view;
            View view2 = view = context != null ? context.getView() : null;
            if (!(view instanceof HierarchyTreeExplorer)) {
                return false;
            }
            if (action == this._gotoClassAction || action == this._browseHierarchyAction) {
                action.setEnabled(true);
                return true;
            }
            return false;
        }

        public boolean handleEvent(IdeAction action, Context context) {
            View view;
            View view2 = view = context != null ? context.getView() : null;
            if (!(view instanceof HierarchyTreeExplorer)) {
                return false;
            }
            if (action == this._gotoClassAction) {
                TypeElement type = this.getSelectedType(context);
                if (type != null) {
                    SourceFile sourceFile;
                    URL sourceURL;
                    String className = type.getClassName();
                    Project project = BrowseHierarchyWindow.maS$getProjectFromContext(type.getContext());
                    JavaManager javaManager = JavaManager.getJavaManager((Project)project);
                    SourceClass sourceClass = javaManager.getSourceClass(className);
                    if (sourceClass != null && (sourceURL = (sourceFile = sourceClass.getOwningSourceFile()).getURL()) != null) {
                        try {
                            Context editorContext = new Context(type.getContext());
                            editorContext.setNode(NodeFactory.findOrCreate((URL)sourceURL));
                            EditorManager editorManager = EditorManager.getEditorManager();
                            OpenEditorOptions openEditorOptions = new OpenEditorOptions(editorContext);
                            openEditorOptions.setFlags(8, true);
                            Editor editor = editorManager.openEditor(openEditorOptions);
                            if (editor instanceof CodeEditor) {
                                CodeEditor codeEditor = (CodeEditor)editor;
                                SourceName sourceName = sourceClass.getNameElement();
                                if (sourceName != null) {
                                    int start = sourceName.getStartOffset();
                                    int end = sourceName.getEndOffset();
                                    codeEditor.gotoOffset(start, end - start);
                                }
                            }
                        }
                        catch (Throwable t) {
                            Assert.printStackTrace((Throwable)t);
                        }
                    }
                }
                return true;
            }
            if (action == this._browseHierarchyAction) {
                TypeElement type = this.getSelectedType(context);
                if (type != null) {
                    BrowseHierarchyAddin.browseTypeHierarchy(context, type.getClassName());
                }
                return true;
            }
            return false;
        }

        public ContextMenu getContextMenu() {
            if (this._contextMenu == null) {
                this._contextMenu = new ContextMenu();
                this._contextMenu.addContextMenuListener((ContextMenuListener)this);
            }
            return this._contextMenu;
        }

        public void menuWillShow(ContextMenu popup) {
            TypeElement type;
            TypeElement type2;
            if (!this._menusBuilt) {
                this._menusBuilt = true;
                String gotoClass = JavaArb.getString(21);
                int gotoClassMnemonic = StringUtils.getMnemonicKeyCode((String)gotoClass);
                String gotoClassName = StringUtils.stripMnemonic((String)gotoClass);
                this._gotoClassAction = IdeAction.get((int)Ide.findOrCreateCmdID((String)"ojjb.GotoClass"), null, (String)gotoClassName, (String)IdeMainWindow.ACTION_CATEGORY_NAVIGATE, (Integer)new Integer(gotoClassMnemonic), (ArrayResourceBundle)JavaArb.getInstance(), (int)128, null, (boolean)false);
                this._gotoClassAction.addController((Controller)this);
                this._gotoClassMenuItem = Ide.getMenubar().createMenuItem((ToggleAction)this._gotoClassAction);
                String browseHierarchyName = JavaArb.getString(238);
                int browseHierarchyMnemonic = StringUtils.getMnemonicKeyCode((String)browseHierarchyName);
                this._browseHierarchyAction = IdeAction.get((int)Ide.findOrCreateCmdID((String)"ojjb.BrowseHierarchy"), null, (String)browseHierarchyName, (String)IdeMainWindow.ACTION_CATEGORY_NAVIGATE, (Integer)new Integer(browseHierarchyMnemonic), (ArrayResourceBundle)JavaArb.getInstance(), (int)87, null, (boolean)false);
                this._browseHierarchyAction.addController((Controller)this);
                this._browseHierarchyMenuItem = Ide.getMenubar().createMenuItem((ToggleAction)this._browseHierarchyAction);
            }
            if (this._gotoClassMenuItem != null && (type2 = this.getSelectedType(popup.getContext())) != null) {
                String gotoClassName = JavaArb.format(21, type2.getClassName());
                gotoClassName = StringUtils.stripMnemonic((String)gotoClassName);
                this._gotoClassAction.putValue("Name", (Object)gotoClassName);
                this._gotoClassAction.setEnabled(true);
                popup.add((Component)this._gotoClassMenuItem);
            }
            if (this._browseHierarchyMenuItem != null && (type = this.getSelectedType(popup.getContext())) != null) {
                this._browseHierarchyAction.setEnabled(true);
                popup.add((Component)this._browseHierarchyMenuItem);
            }
        }

        public void menuWillHide(ContextMenu popup) {
        }

        public boolean handleDefaultAction(Context context) {
            return this.handleEvent(this._gotoClassAction, context);
        }

        public void dispose() {
            super.dispose();
            if (this._contextMenu != null) {
                this._contextMenu.removeContextMenuListener((ContextMenuListener)this);
                this._contextMenu = null;
            }
        }

        private TypeElement getSelectedType(Context context) {
            Element element;
            TNode tnode = ExplorerContext.getSingleTNode((Context)context);
            if (tnode != null && (element = tnode.getData()) instanceof TypeElement) {
                return (TypeElement)element;
            }
            return null;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class TreeComparator
        implements Comparator {
            private static final TreeComparator INSTANCE = new TreeComparator();

            public static TreeComparator getInstance() {
                return INSTANCE;
            }

            private TreeComparator() {
            }

            public int compare(Object o1, Object o2) {
                Comparable c1 = TreeComparator.getComparableFromNode(o1);
                Comparable c2 = TreeComparator.getComparableFromNode(o2);
                return c1.compareTo(c2);
            }

            private static final Comparable getComparableFromNode(Object o) {
                TNode node = (TNode)o;
                Element element = node.getData();
                return (Comparable)element;
            }
        }
    }

    private static final class SupertypeFolder
    extends DefaultTypeFolder {
        private static final String JAVA_LANG_OBJECT = "java.lang.Object";

        public SupertypeFolder(Context context, JavaType javaType) {
            super(context, javaType);
            this.initializeChildren(javaType);
        }

        private void initializeChildren(JavaType javaType) {
            JavaType superType = javaType.getSuperclass();
            if (superType != null && !this.isJavaLangObject(superType)) {
                SupertypeFolder element = new SupertypeFolder(this._context, superType);
                this.add((Element)element);
            }
            Collection interfaceTypes = javaType.getInterfaces();
            for (JavaType interfaceType : interfaceTypes) {
                if (interfaceType == null) continue;
                SupertypeFolder element = new SupertypeFolder(this._context, interfaceType);
                this.add((Element)element);
            }
        }

        private boolean isJavaLangObject(JavaType javaType) {
            return javaType.getQualifiedName().equals(JAVA_LANG_OBJECT);
        }
    }

    private final class SubtypeFolder
    extends DefaultTypeFolder
    implements ActionListener,
    Subject,
    Runnable {
        private final boolean _isFinal;
        private LoadingElement _loadingChild;
        private Subject _subject;
        private volatile int progress;

        public SubtypeFolder(Context context, JavaType javaType) {
            super(context, javaType);
            this._isFinal = javaType.isFinal();
            if (!this._isFinal) {
                this._loadingChild = new LoadingElement();
                this.add((Element)this._loadingChild);
            }
        }

        public boolean mayHaveChildren() {
            return this.isFinal() ^ true;
        }

        public Iterator getChildren() {
            if (this._loadingChild != null) {
                BrowseHierarchyWindow.ra$_scheduler(BrowseHierarchyWindow.this).submit(this);
            }
            return super.getChildren();
        }

        public void actionPerformed(ActionEvent e) {
            this._loadingChild.setProgress(this.progress);
        }

        public void attach(Observer observer) {
            this.getSubject().attach(observer);
        }

        public void detach(Observer observer) {
            this.getSubject().detach(observer);
        }

        public void notifyObservers(Object observed, UpdateMessage change) {
            this.getSubject().notifyObservers(observed, change);
        }

        /*
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            this.progress = 0;
            progressTimer = new Timer(750, this);
            progressTimer.setInitialDelay(1800);
            progressTimer.start();
            numProjects = 0;
            numLibraries = 0;
            success = false;
            fqClassName = this.getClassName();
            PerformanceLogger.get().startTiming("BrowseHierarchyWindow.query");
            try {
                try {
                    block41: {
                        deps = DependencyCache.getInstance(this._context);
                        projects = deps.getProjectsUsing(this._context, new String[]{fqClassName});
                        numProjects = projects.size();
                        this.progress = 10;
                        sorted = new ArrayList<Project>(projects);
                        Collections.sort(sorted, new ProjectNameComparator(null));
                        indexManager = IndexManager.getIndexManager();
                        criteria = new QueryCriteria();
                        dot = fqClassName.lastIndexOf(46);
                        simpleName = dot == -1 ? fqClassName : fqClassName.substring(dot + 1);
                        criteria.put((Object)"java.extends.or.implements", (Object)simpleName);
                        results = new LinkedList<Pair>();
                        libraries = new HashMap<Object, Project>();
                        i = 0;
                        for (Project project : sorted) {
                            if (Thread.interrupted()) {
                                Thread.currentThread().interrupt();
                                return;
                            }
                            index = indexManager.getIndex(project);
                            try {
                                index.lock();
                                try {
                                    result = index.blockingQuery(criteria);
                                    if (result != null && result.length > 0) {
                                        results.add(new Pair((Object)project, (Object)result));
                                    }
                                }
                                finally {
                                    index.unlock();
                                }
                            }
                            finally {
                                index.release();
                            }
                            libs = JProjectLibraries.getInstance((PropertyStorage)project);
                            jdk = libs.getJDK();
                            if (!libraries.containsKey(jdk)) {
                                libraries.put(jdk, project);
                            }
                            var46_23 = libs.getLibraries();
                            var47_24 = 0;
                            while (var47_24 < var46_23.length) {
                                library = var46_23[var47_24];
                                if (!libraries.containsKey(library)) {
                                    libraries.put(library, project);
                                }
                                ++var47_24;
                            }
                            this.progress = 10 + 30 * ++i / numProjects;
                        }
                        i = 0;
                        numLibraries = libraries.size();
                        for (Map.Entry<K, V> entry : libraries.entrySet()) {
                            library = (Library)entry.getKey();
                            project = (Project)entry.getValue();
                            index = indexManager.getIndex(project, library.getSourcePath());
                            try {
                                index.lock();
                                try {
                                    result = index.blockingQuery(criteria);
                                    if (result != null && result.length > 0) {
                                        results.add(new Pair((Object)project, (Object)result));
                                    }
                                }
                                finally {
                                    index.unlock();
                                }
                            }
                            finally {
                                index.release();
                            }
                            this.progress = 40 + 30 * ++i / numLibraries;
                        }
                        subtypes = new ArrayList<SubtypeFolder>();
                        if (results.isEmpty()) break block41;
                        latch = new CountDownLatch(results.size());
                        tasks = new UsageQueryTask[results.size()];
                        i = 0;
                        for (Pair result : results) {
                            block42: {
                                if (!Thread.interrupted()) break block42;
                                j = 0;
                                if (true) ** GOTO lbl108
                            }
                            project = (Project)result.first;
                            urls = (URL[])result.second;
                            usageManager = new UsageManager(project);
                            listener = new UsageListener(latch, this._context, project, subtypes);
                            tasks[i++] = usageManager.findClassUsages(fqClassName, listener, urls);
                        }
                        try {
                            done = false;
                            if (true) ** GOTO lbl115
                            do {
                                tasks[j].cancel();
                                ++j;
lbl108:
                                // 2 sources

                            } while (j < i);
                            Thread.currentThread().interrupt();
                            return;
                            do {
                                done = latch.await(750L, TimeUnit.MILLISECONDS);
                                count = (int)latch.getCount();
                                this.progress = 100 - 30 * count / results.size();
lbl115:
                                // 2 sources

                            } while (!done);
                        }
                        catch (InterruptedException ie) {
                            var52_48 = tasks;
                            var53_49 = 0;
                            if (true) ** GOTO lbl139
                        }
                    }
                    SwingUtilities.invokeLater(new 1(this, subtypes));
                    success = true;
                    return;
                }
                finally {
                    if (!success) {
                        UpdateMessage.fireObjectClosed((Subject)this);
                        this._loadingChild.setShortLabel(JavaArb.getString(219));
                        UpdateMessage.fireObjectRenamed((Subject)this._loadingChild);
                    }
                    progressTimer.stop();
                    if (success) {
                        PerformanceLogger.get().stopTiming("BrowseHierarchyWindow.query", "Searched " + numProjects + " projects and " + numLibraries + " libraries for subtypes of " + fqClassName);
                        return;
                    }
                    PerformanceLogger.get().stopTiming("BrowseHierarchyWindow.query", null);
                }
                do {
                    task = var52_48[var53_49];
                    task.cancel();
                    ++var53_49;
lbl139:
                    // 2 sources

                } while (var53_49 < var52_48.length);
                Thread.currentThread().interrupt();
                return;
            }
            catch (RejectedExecutionException e) {
                return;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
            catch (Throwable t) {
                Logger.getLogger(BrowseHierarchyWindow.class.getName()).log(Level.SEVERE, "Unable to find subtypes", t);
                return;
            }
        }

        private Subject getSubject() {
            if (this._subject == null) {
                this._subject = new IdeSubject();
            }
            return this._subject;
        }

        private boolean isFinal() {
            return this._isFinal;
        }

        static LoadingElement ra$_loadingChild(SubtypeFolder subtypeFolder) {
            return subtypeFolder._loadingChild;
        }

        static void wa$_loadingChild(SubtypeFolder subtypeFolder, LoadingElement loadingElement) {
            subtypeFolder._loadingChild = loadingElement;
        }

        final class 1
        implements Runnable {
            private final /* synthetic */ ArrayList v$subtypes;
            final /* synthetic */ SubtypeFolder this$0;

            public void run() {
                this.this$0.remove((Element)SubtypeFolder.ra$_loadingChild(this.this$0));
                UpdateMessage.fireChildRemoved((Subject)this.this$0, (Element)SubtypeFolder.ra$_loadingChild(this.this$0));
                SubtypeFolder.wa$_loadingChild(this.this$0, null);
                if (!this.v$subtypes.isEmpty()) {
                    for (SubtypeFolder subtype : this.v$subtypes) {
                        this.this$0.add((Element)subtype);
                    }
                    UpdateMessage.fireChildrenAdded((Subject)this.this$0, (Collection)this.this$0._children);
                }
            }

            public 1(SubtypeFolder subtypeFolder, ArrayList arrayList) {
                this.v$subtypes = arrayList;
                this.this$0 = subtypeFolder;
            }
        }
    }

    private static class DefaultTypeFolder
    extends TypeElement
    implements Folder {
        protected final List _children;

        private void $init$() {
            this._children = new ArrayList();
        }

        protected DefaultTypeFolder(Context context, JavaType javaType) {
            super(context, javaType);
            this.$init$();
        }

        public boolean mayHaveChildren() {
            return true;
        }

        public Iterator getChildren() {
            return this._children.iterator();
        }

        public boolean canAdd(Element element) {
            return true;
        }

        public boolean add(Element child) {
            return this._children.add(child);
        }

        public boolean canRemove(Element element) {
            return true;
        }

        public boolean remove(Element child) {
            return this._children.remove(child);
        }

        public boolean containsChild(Element child) {
            return this._children.contains(child);
        }

        public int size() {
            return this._children.size();
        }

        public void removeAll() {
            this._children.clear();
        }
    }

    private static class TypeElement
    extends DefaultTreeElement {
        protected Context _context;
        private final boolean _isInterface;

        protected TypeElement(Context context, JavaType javaType) {
            super(javaType.getQualifiedName());
            this._context = context;
            this._isInterface = javaType.isInterface();
        }

        public Context getContext() {
            return this._context;
        }

        public String getClassName() {
            return this.getShortLabel();
        }

        public boolean isInterface() {
            return this._isInterface;
        }

        public Icon getIcon() {
            return OracleIcons.getIcon((String)(this._isInterface ? "interface.png" : "class.png"));
        }

        public int compareTo(Object o) {
            if (o instanceof TypeElement) {
                TypeElement otherType = (TypeElement)o;
                if (this._isInterface != otherType._isInterface) {
                    return this._isInterface ? 1 : -1;
                }
                return super.compareTo(o);
            }
            return -1;
        }
    }

    private static final class LoadingElement
    extends DefaultTreeElement
    implements Subject {
        private Subject _subject;

        public LoadingElement() {
            super(JavaArb.getString(219));
        }

        public void setProgress(int progress) {
            if ((progress = Math.max(Math.min(progress, 100), 0)) > 0) {
                this.setShortLabel(JavaArb.format(169, String.valueOf(progress)));
                UpdateMessage.fireObjectRenamed((Subject)this);
            }
        }

        public int compareTo(Object o) {
            return o != this ? 1 : 0;
        }

        public void attach(Observer observer) {
            this.getSubject().attach(observer);
        }

        public void detach(Observer observer) {
            this.getSubject().detach(observer);
        }

        public void notifyObservers(Object observed, UpdateMessage change) {
            this.getSubject().notifyObservers(observed, change);
        }

        private Subject getSubject() {
            if (this._subject == null) {
                this._subject = new IdeSubject();
            }
            return this._subject;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultTreeElement
    extends DefaultElement
    implements Comparable {
        private String _label;

        protected DefaultTreeElement(String label) {
            this.setShortLabel(label);
        }

        public String getShortLabel() {
            return this._label;
        }

        public Icon getIcon() {
            return IdeIcons.getIcon((int)23);
        }

        public int compareTo(Object o) {
            String myLabel = this.getShortLabel();
            String otherLabel = ((DefaultTreeElement)o).getShortLabel();
            return myLabel.compareTo(otherLabel);
        }

        protected void setShortLabel(String label) {
            this._label = label;
        }
    }

    private static final class RootElement
    extends DefaultElement {
        private final List _children;

        public RootElement(DefaultTypeFolder child) {
            this._children = Collections.singletonList(child);
        }

        public DefaultTypeFolder getRootFolder() {
            return (DefaultTypeFolder)this._children.get(0);
        }

        public boolean mayHaveChildren() {
            return true;
        }

        public Iterator getChildren() {
            return this._children.iterator();
        }
    }

    private static final class LabelPanel
    extends JPanel {
        LabelPanel(String text) {
            super(new BorderLayout());
            FocusableLabel textLabel = new FocusableLabel(text);
            JScrollPane scrollPane = new JScrollPane((Component)((Object)textLabel));
            scrollPane.setBorder(BorderFactory.createEmptyBorder());
            scrollPane.getViewport().setBackground(UIManager.getColor("Tree.background"));
            this.add((Component)scrollPane, "Center");
        }

        private static final class FocusableLabel
        extends JMultiLineLabel
        implements MouseListener {
            FocusableLabel(String text) {
                super(text);
                this.setBorder(BorderFactory.createEmptyBorder(2, 4, 2, 4));
                this.addMouseListener(this);
            }

            public boolean isFocusTraversable() {
                return true;
            }

            public void mousePressed(MouseEvent event) {
                if (this.isFocusTraversable()) {
                    this.requestFocus();
                    event.consume();
                }
            }

            public void mouseClicked(MouseEvent event) {
            }

            public void mouseReleased(MouseEvent event) {
            }

            public void mouseEntered(MouseEvent event) {
            }

            public void mouseExited(MouseEvent event) {
            }
        }
    }

    private static final class QueryThreadFactory
    implements ThreadFactory {
        public Thread newThread(Runnable r) {
            return new Thread(r, "Browse Hierarchy");
        }

        private QueryThreadFactory() {
        }

        QueryThreadFactory(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class UsageListener
    implements ClassUsageListener {
        private CountDownLatch _latch;
        private Context _context;
        private Project _project;
        private Collection<SubtypeFolder> _subtypes;
        private JavaManager _javaManager;

        public UsageListener(CountDownLatch latch, Context context, Project project, Collection<SubtypeFolder> subtypes) {
            this._latch = latch;
            this._context = context;
            this._project = project;
            this._subtypes = subtypes;
            this._javaManager = JavaManager.getJavaManager((Project)project);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void notifyClassUsage(ClassUsageEvent e) {
            SourceFile sourceFile;
            int usageCode = e.getUsageCode();
            if ((usageCode == 103 || usageCode == 104) && (sourceFile = this._javaManager.getSourceFile(e.getURL())) != null) {
                int offset = e.getStartOffset();
                SourceElement sourceElement = sourceFile.getElementAt(offset);
                while (sourceElement != null) {
                    if (sourceElement instanceof JavaType) {
                        Context newContext = new Context(this._context);
                        newContext.setProject(this._project);
                        SubtypeFolder subtype = new SubtypeFolder(newContext, (JavaType)sourceElement);
                        Collection<SubtypeFolder> collection = this._subtypes;
                        synchronized (collection) {
                            this._subtypes.add(subtype);
                        }
                        return;
                    }
                    sourceElement = sourceElement.getParent();
                }
            }
        }

        @Override
        public void notifySkipped(UsageEvent e) {
        }

        @Override
        public void notifyFinished(UsageEvent e) {
            this._latch.countDown();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ProjectNameComparator
    implements Comparator<Project> {
        @Override
        public int compare(Project o1, Project o2) {
            return o1.getShortLabel().compareTo(o2.getShortLabel());
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof ProjectNameComparator;
        }

        private ProjectNameComparator() {
        }

        ProjectNameComparator(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }
}

