/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.browse;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JWindow;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;
import oracle.ide.Ide;
import oracle.ide.model.Project;
import oracle.ide.util.ArraySortedSet;
import oracle.ide.util.Assert;
import oracle.javatools.editor.insight.CamelCaseInsightInputFilter;
import oracle.javatools.editor.insight.InsightData;
import oracle.javatools.editor.insight.ListDataItem;
import oracle.javatools.editor.insight.ListDataItemCellRenderer;
import oracle.javatools.editor.insight.ListInsightData;
import oracle.javatools.editor.insight.ListInsightView;
import oracle.javatools.editor.insight.ReadOnlyListModel;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.util.AsyncScheduler;
import oracle.javatools.parser.util.AsyncTask;
import oracle.javatools.util.CamelCaseFilter;
import oracle.jdeveloper.java.JavaClassLocator;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdevimpl.java.JavaArb;

final class BrowsePopupList
implements CaretListener,
MouseListener,
FocusListener,
KeyListener,
ListSelectionListener {
    private Project project;
    private JTextField browseField;
    private ActionListener clientListener;
    private JWindow popupWindow;
    private ListInsightView popupList;
    private BrowseTask browseTask;
    private PopulateTask populateTask;
    private Map brPackageMap;
    private Set brPackageSet;
    private JavaManager brJavaManager;
    private FoundItem lastDefaultItem;
    private boolean pendingLookup;
    private boolean inNavigation;
    private int lastLength;
    private boolean gotLonger;
    private AsyncScheduler brScheduler;
    private static final boolean CHECK_FOR_INTERFACE = false;
    private static final int MIN_PREFIX_LEN = 2;
    private static final int PACKAGE_ITEM = 1;
    private static final int UNQ_CLASS_ITEM = 2;
    private static final int UNQ_INTERFACE_ITEM = 4;
    private static final int FQ_CLASS_ITEM = 3;
    private static final int FQ_INTERFACE_ITEM = 5;

    BrowsePopupList(Project project, JTextField textField, ActionListener actionListener) {
        this.$init$();
        this.browseField = textField;
        Caret oldCaret = textField.getCaret();
        DefaultCaret newCaret = new DefaultCaret();
        newCaret.setBlinkRate(oldCaret.getBlinkRate());
        textField.setCaret(newCaret);
        this.project = project;
        this.brJavaManager = JavaManager.getJavaManager((Project)project);
        this.clientListener = actionListener;
        this.schedulePopulate();
        this.browseField.addCaretListener(this);
        this.browseField.addKeyListener(this);
        this.browseField.addFocusListener(this);
    }

    private void $init$() {
        this.pendingLookup = false;
        this.inNavigation = false;
        this.lastLength = 0;
        this.gotLonger = false;
        this.brScheduler = new AsyncScheduler("BrowseDialogBrowser", 10000);
    }

    public void dispose() {
        this.cancelLookup();
        this.cancelPopulate();
        if (this.popupList != null) {
            this.popupList.removeListSelectionListener((ListSelectionListener)this);
            this.popupList.removeMouseListener((MouseListener)this);
            this.popupList = null;
        }
        if (this.popupWindow != null) {
            this.popupWindow.setVisible(false);
            this.popupWindow.dispose();
            this.popupWindow = null;
        }
        if (this.browseField != null) {
            this.browseField.removeCaretListener(this);
            this.browseField.removeKeyListener(this);
            this.browseField.removeFocusListener(this);
            this.browseField = null;
        }
    }

    public String getSelectedClass() {
        return this.lastDefaultItem != null ? FoundItem.ra$name(this.lastDefaultItem) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleLookup(String prefixText) {
        if (!this.populateTask.isFinished()) {
            return;
        }
        BrowseTask task = new BrowseTask(prefixText, null);
        BrowsePopupList browsePopupList = this;
        synchronized (browsePopupList) {
            if (this.browseTask != null) {
                this.brScheduler.cancelTask((AsyncTask)this.browseTask);
            }
            this.browseTask = task;
        }
        this.brScheduler.scheduleTask((AsyncTask)task);
        this.pendingLookup = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelLookup() {
        BrowseTask pendingTask;
        BrowsePopupList browsePopupList = this;
        synchronized (browsePopupList) {
            pendingTask = this.browseTask;
            this.browseTask = null;
        }
        if (pendingTask != null) {
            this.brScheduler.cancelTask((AsyncTask)pendingTask);
        }
        this.pendingLookup = false;
    }

    private void schedulePopulate() {
        this.populateTask = new PopulateTask(null);
        this.brScheduler.scheduleTask((AsyncTask)this.populateTask);
    }

    private void cancelPopulate() {
        this.brScheduler.cancelTask((AsyncTask)this.populateTask);
    }

    private void updatePopup() {
        if (this.browseField == null || !this.browseField.isVisible()) {
            return;
        }
        int caretPosition = this.browseField.getCaretPosition();
        if (caretPosition >= 2) {
            String text = this.browseField.getText().substring(0, caretPosition);
            this.scheduleLookup(text);
        } else {
            this.hidePopup();
        }
    }

    private void hidePopup() {
        if (this.popupWindow != null) {
            this.popupWindow.setVisible(false);
        }
    }

    private void displayResults(FoundData data) {
        ListDataItem[] foundItems;
        if (this.browseField == null || !this.browseField.isVisible()) {
            return;
        }
        if (this.popupWindow == null) {
            this.popupList = new ListInsightView((ListCellRenderer)((Object)new FoundRenderer(null)));
            this.popupList.addListSelectionListener((ListSelectionListener)this);
            this.popupList.addMouseListener((MouseListener)this);
            this.popupList.setData((InsightData)data);
            JScrollPane scroller = new JScrollPane((Component)this.popupList);
            scroller.setHorizontalScrollBarPolicy(31);
            Window parentWindow = SwingUtilities.getWindowAncestor(this.browseField);
            this.popupWindow = new JWindow(parentWindow);
            this.popupWindow.getContentPane().add(scroller);
            this.popupWindow.setFocusableWindowState(false);
        } else {
            this.popupList.setData((InsightData)data);
        }
        if (!this.popupWindow.isVisible()) {
            Point location = this.browseField.getLocationOnScreen();
            location.y += this.browseField.getHeight() + 2;
            this.popupWindow.setLocation(location);
        }
        if ((foundItems = data.getData()).length == 0) {
            this.lastDefaultItem = null;
            this.popupWindow.setVisible(false);
        } else {
            String fieldText;
            String replaceText;
            this.inNavigation = true;
            this.popupList.selectDefault();
            this.inNavigation = false;
            this.lastDefaultItem = (FoundItem)((Object)data.getDefault());
            if (this.gotLonger && (replaceText = CamelCaseInsightInputFilter.INSTANCE.findCommonPrefix(foundItems, fieldText = this.browseField.getText())) != null) {
                this.inNavigation = true;
                int selectStart = Math.min(fieldText.length(), replaceText.length());
                int selectEnd = replaceText.length();
                this.browseField.setText(replaceText);
                this.browseField.setCaretPosition(selectEnd);
                this.browseField.moveCaretPosition(selectStart);
                this.inNavigation = false;
            }
            this.popupWindow.pack();
            this.popupWindow.setVisible(true);
        }
        this.pendingLookup = false;
    }

    private void populateFinished(Map packageMap, Set packageSet) {
        this.brPackageMap = packageMap;
        this.brPackageSet = packageSet;
        1 invokeTask = new 1();
        SwingUtilities.invokeLater(invokeTask);
    }

    public void mouseClicked(MouseEvent event) {
        if (event.getClickCount() > 1) {
            FoundItem clickedItem;
            if (this.popupList != null && (clickedItem = (FoundItem)((Object)this.popupList.getSelectedValue())) != null && FoundItem.ra$type(clickedItem) == 1) {
                String replaceText = this.lastDefaultItem.getName() + ".";
                this.browseField.setText(replaceText);
                return;
            }
            if (this.clientListener != null) {
                ActionEvent actionEvent = new ActionEvent(this, 1001, null);
                this.clientListener.actionPerformed(actionEvent);
            }
            event.consume();
        }
    }

    public void mousePressed(MouseEvent event) {
    }

    public void mouseReleased(MouseEvent event) {
    }

    public void mouseEntered(MouseEvent event) {
    }

    public void mouseExited(MouseEvent event) {
    }

    public void valueChanged(ListSelectionEvent event) {
        if (!this.inNavigation && this.popupList != null) {
            this.lastDefaultItem = (FoundItem)((Object)this.popupList.getSelectedValue());
            if (this.lastDefaultItem != null) {
                this.inNavigation = true;
                String replaceText = this.lastDefaultItem.getName();
                if (!this.browseField.getText().equals(replaceText)) {
                    this.browseField.setText(replaceText);
                }
                this.inNavigation = false;
            }
        }
    }

    public void focusGained(FocusEvent event) {
        if (this.popupWindow != null && !this.popupWindow.isVisible()) {
            this.updatePopup();
        }
    }

    public void focusLost(FocusEvent event) {
        if (!event.isTemporary()) {
            this.hidePopup();
        }
    }

    public void keyTyped(KeyEvent event) {
    }

    public void keyPressed(KeyEvent event) {
        int keycode = event.getKeyCode();
        if (!(this.pendingLookup || this.popupWindow != null && this.popupWindow.isVisible())) {
            return;
        }
        switch (keycode) {
            case 10: {
                if (this.pendingLookup) {
                    event.consume();
                }
                return;
            }
            default: {
                return;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 40: 
        }
        if (this.pendingLookup) {
            event.consume();
            return;
        }
        Assert.check((this.popupList != null ? 1 : 0) != 0, (String)"missing list");
        try {
            this.inNavigation = true;
            switch (keycode) {
                default: {
                    throw new IllegalStateException("unexpected key: " + keycode);
                }
                case 40: {
                    this.popupList.down();
                    break;
                }
                case 38: {
                    this.popupList.up();
                    break;
                }
                case 34: {
                    this.popupList.pageDown();
                    break;
                }
                case 33: {
                    this.popupList.pageUp();
                    break;
                }
                case 36: {
                    this.popupList.begin();
                    break;
                }
                case 35: {
                    this.popupList.end();
                    break;
                }
            }
        }
        finally {
            this.inNavigation = false;
        }
        this.lastDefaultItem = (FoundItem)((Object)this.popupList.getSelectedValue());
        this.inNavigation = true;
        String replaceText = this.lastDefaultItem.getName();
        this.browseField.setText(replaceText);
        this.inNavigation = false;
    }

    public void keyReleased(KeyEvent event) {
    }

    public void caretUpdate(CaretEvent event) {
        if (!this.inNavigation) {
            this.caretChanged();
        }
    }

    private void caretChanged() {
        if (this.browseField != null) {
            int newLength = this.browseField.getText().length();
            this.gotLonger = newLength > this.lastLength;
            this.lastLength = newLength;
            this.updatePopup();
        }
    }

    static Map ra$brPackageMap(BrowsePopupList browsePopupList) {
        return browsePopupList.brPackageMap;
    }

    static JavaManager ra$brJavaManager(BrowsePopupList browsePopupList) {
        return browsePopupList.brJavaManager;
    }

    static Set ra$brPackageSet(BrowsePopupList browsePopupList) {
        return browsePopupList.brPackageSet;
    }

    static void mav$populateFinished(BrowsePopupList browsePopupList, Map map, Set set) {
        browsePopupList.populateFinished(map, set);
    }

    static void mav$updatePopup(BrowsePopupList browsePopupList) {
        browsePopupList.updatePopup();
    }

    static void mav$displayResults(BrowsePopupList browsePopupList, FoundData foundData) {
        browsePopupList.displayResults(foundData);
    }

    final class 1
    implements Runnable {
        public void run() {
            try {
                Thread.sleep(25);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            BrowsePopupList.mav$updatePopup(BrowsePopupList.this);
        }
    }

    private final class BrowseTask
    extends AsyncTask {
        private String brText;
        private boolean brCancelled;

        private BrowseTask(String prefixText) {
            this.$init$();
            this.brText = prefixText;
        }

        private void $init$() {
            this.brCancelled = false;
        }

        protected void requestCancelImpl() {
            this.brCancelled = true;
        }

        protected boolean isCancelledImpl() {
            return this.brCancelled;
        }

        public Object runImpl() throws AsyncTask.CancelledException {
            boolean hasDot;
            if (this.brText == null || this.brText.length() == 0) {
                return null;
            }
            BrowseTask.sleep((int)10);
            this.bailIfCancelled();
            Map packageMap = BrowsePopupList.ra$brPackageMap(BrowsePopupList.this);
            if (packageMap == null) {
                return null;
            }
            ArrayList matchList = new ArrayList();
            boolean bl = hasDot = this.brText.indexOf(46) != -1;
            if (hasDot) {
                this.taskMatchAnyPackages(this.brText, matchList);
                this.taskMatchFQClasses(this.brText, matchList);
            } else {
                this.taskMatchTopPackages(this.brText, matchList);
                this.taskMatchUQClasses(this.brText, matchList);
            }
            int count = matchList.size();
            FoundItem[] items = matchList.toArray(new FoundItem[count]);
            FoundData data = new FoundData(items, this.brText, null);
            1 invokeTask = new 1(this, data);
            SwingUtilities.invokeLater(invokeTask);
            return data;
        }

        private void taskMatchTopPackages(String prefixText, List resultList) throws AsyncTask.CancelledException {
            int prefixLen = prefixText.length();
            Set packageSet = BrowsePopupList.ra$brPackageSet(BrowsePopupList.this);
            Iterator iterator = packageSet.iterator();
            while (iterator.hasNext()) {
                this.bailIfCancelled();
                String packagePrefix = iterator.next().toString();
                if (packagePrefix.indexOf(46) != -1 || !packagePrefix.regionMatches(true, 0, prefixText, 0, prefixLen)) continue;
                resultList.add(new FoundItem(packagePrefix, 1, null));
            }
        }

        private void taskMatchAnyPackages(String prefixText, List resultList) throws AsyncTask.CancelledException {
            int prefixLen = prefixText.length();
            Set packageSet = BrowsePopupList.ra$brPackageSet(BrowsePopupList.this);
            Iterator iterator = packageSet.iterator();
            while (iterator.hasNext()) {
                this.bailIfCancelled();
                String packagePrefix = iterator.next().toString();
                if (!packagePrefix.regionMatches(true, 0, prefixText, 0, prefixLen)) continue;
                resultList.add(new FoundItem(packagePrefix, 1, null));
            }
        }

        private void taskMatchUQClasses(String prefixText, List resultList) throws AsyncTask.CancelledException {
            Map packageMap = BrowsePopupList.ra$brPackageMap(BrowsePopupList.this);
            CamelCaseFilter filter = new CamelCaseFilter(prefixText);
            Set keySet = packageMap.keySet();
            Iterator keyIterator = keySet.iterator();
            while (keyIterator.hasNext()) {
                this.bailIfCancelled();
                String packagePrefix = keyIterator.next().toString();
                String[] classes = (String[])packageMap.get(packagePrefix);
                int numClasses = classes != null ? classes.length : 0;
                int i = 0;
                while (i < numClasses) {
                    this.bailIfCancelled();
                    String name = classes[i];
                    if (filter.matches(name)) {
                        String fqName = packagePrefix + "." + name;
                        int type = this.isInterface(fqName) ? 4 : 2;
                        resultList.add(new FoundItem(fqName, type, null));
                    }
                    ++i;
                }
            }
        }

        private boolean checkForInterface() {
            return false;
        }

        private boolean isInterface(String fqClassName) {
            if (!this.checkForInterface()) {
                return false;
            }
            JavaManager jm = BrowsePopupList.ra$brJavaManager(BrowsePopupList.this);
            JavaClass foundClass = jm.getClass(fqClassName);
            if (foundClass != null) {
                return foundClass.isInterface();
            }
            return false;
        }

        private void taskMatchFQClasses(String prefixText, List resultList) throws AsyncTask.CancelledException {
            Map packageMap = BrowsePopupList.ra$brPackageMap(BrowsePopupList.this);
            int dotPos = prefixText.lastIndexOf(46);
            if (dotPos != -1) {
                String packagePrefix = prefixText.substring(0, dotPos);
                String classPart = prefixText.substring(dotPos + 1);
                CamelCaseFilter filter = new CamelCaseFilter(classPart);
                String[] classes = (String[])packageMap.get(packagePrefix);
                int numClasses = classes != null ? classes.length : 0;
                int i = 0;
                while (i < numClasses) {
                    this.bailIfCancelled();
                    String name = classes[i];
                    if (filter.matches(name)) {
                        String fqName = packagePrefix + "." + name;
                        int type = this.isInterface(fqName) ? 5 : 3;
                        resultList.add(new FoundItem(fqName, type, null));
                    }
                    ++i;
                }
            }
        }

        BrowseTask(String string, 1 var3_3) {
            this(string);
        }

        static boolean ra$brCancelled(BrowseTask browseTask) {
            return browseTask.brCancelled;
        }

        final class 1
        implements Runnable {
            private final /* synthetic */ FoundData v$data;
            final /* synthetic */ BrowseTask this$0;

            public void run() {
                if (!BrowseTask.ra$brCancelled(this.this$0)) {
                    BrowsePopupList.mav$displayResults(this.this$0.BrowsePopupList.this, this.v$data);
                }
            }

            public 1(BrowseTask browseTask, FoundData foundData) {
                this.v$data = foundData;
                this.this$0 = browseTask;
            }
        }
    }

    private final class PopulateTask
    extends AsyncTask {
        private boolean popCancelled;

        private void $init$() {
            this.popCancelled = false;
        }

        protected void requestCancelImpl() {
            this.popCancelled = true;
        }

        protected boolean isCancelledImpl() {
            return this.popCancelled;
        }

        public Object runImpl() throws AsyncTask.CancelledException {
            JavaManager jm = BrowsePopupList.ra$brJavaManager(BrowsePopupList.this);
            String feedbackText = JavaArb.getString(269);
            Ide.getStatusBar().setText(feedbackText);
            try {
                long start = System.currentTimeMillis();
                JavaClassLocator locator = jm.getJavaClassLocator();
                Collection fqClasses = locator.getAllClasses();
                HashMap<String, Set> packageMap = new HashMap<String, Set>(500);
                Iterator classIterator = fqClasses.iterator();
                while (classIterator.hasNext()) {
                    String className;
                    this.bailIfCancelled();
                    String fqClassName = classIterator.next().toString();
                    int lastDot = fqClassName.lastIndexOf(46);
                    String packageName = lastDot == -1 ? "" : fqClassName.substring(0, lastDot);
                    String string = className = lastDot == -1 ? fqClassName : fqClassName.substring(lastDot + 1);
                    if (className.length() <= 0) continue;
                    Set classSet = (Set)packageMap.get(packageName);
                    if (classSet == null) {
                        classSet = new ArraySortedSet(100);
                        packageMap.put(packageName, classSet);
                    }
                    classSet.add(className);
                }
                HashMap<String, String[]> finalPackageMap = new HashMap<String, String[]>(packageMap.size());
                Iterator packageIterator = packageMap.keySet().iterator();
                while (packageIterator.hasNext()) {
                    int classCount;
                    String packageName = packageIterator.next().toString();
                    Set classSet = (Set)packageMap.get(packageName);
                    int n = classCount = classSet == null ? 0 : classSet.size();
                    if (classCount <= 0) continue;
                    String[] classes = classSet.toArray(new String[classCount]);
                    finalPackageMap.put(packageName, classes);
                }
                long total = System.currentTimeMillis() - start;
                Assert.printTiming((long)total, (String)"BrowseSymbolDialog, populated class map", null);
                BrowsePopupList.mav$populateFinished(BrowsePopupList.this, finalPackageMap, finalPackageMap.keySet());
                HashMap<String, String[]> hashMap = finalPackageMap;
                return hashMap;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                String currentText = Ide.getStatusBar().getText();
                if (currentText.equals(feedbackText)) {
                    Ide.getStatusBar().setText("");
                }
            }
        }

        private PopulateTask() {
            this.$init$();
        }

        PopulateTask(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FoundItem
    extends ListDataItem {
        private int type;
        private String name;
        private String display;

        private FoundItem(String name, int type) {
            this.type = type;
            this.name = name;
        }

        public Icon getIcon() {
            switch (this.type) {
                case 1: {
                    return OracleIcons.getIcon((String)"package.png");
                }
                case 2: 
                case 3: {
                    return OracleIcons.getIcon((String)"class.png");
                }
                case 4: 
                case 5: {
                    return OracleIcons.getIcon((String)"interface.png");
                }
            }
            return null;
        }

        public String getDisplayText() {
            switch (this.type) {
                default: {
                    return this.name;
                }
                case 2: 
                case 4: 
            }
            if (this.display == null) {
                String classPart;
                String packagePrefix;
                int dotPos = this.name.lastIndexOf(46);
                if (dotPos == -1) {
                    packagePrefix = "";
                    classPart = this.name;
                } else {
                    packagePrefix = this.name.substring(0, dotPos);
                    classPart = this.name.substring(dotPos + 1);
                }
                this.display = classPart + " (" + packagePrefix + ")";
            }
            return this.display;
        }

        public String getName() {
            switch (this.type) {
                default: {
                    return this.name;
                }
                case 2: 
                case 4: 
            }
            int dotPos = this.name.lastIndexOf(46);
            return dotPos != -1 ? this.name.substring(dotPos + 1) : this.name;
        }

        public int compareTo(Object object) {
            String name2;
            FoundItem item2 = (FoundItem)((Object)object);
            String name1 = this.getName();
            if (name1.equalsIgnoreCase(name2 = item2.getName())) {
                int type1 = this.type;
                int type2 = item2.type;
                if ((type1 == 1 || type2 == 1) && type1 != type2) {
                    return type1 - type2;
                }
            }
            String display1 = this.getDisplayText();
            String display2 = item2.getDisplayText();
            return FoundItem.compareInsensitive((String)display1, (String)display2);
        }

        static int ra$type(FoundItem foundItem) {
            return foundItem.type;
        }

        static String ra$name(FoundItem foundItem) {
            return foundItem.name;
        }

        FoundItem(String string, int n, 1 var3_3) {
            this(string, n);
        }

        public final class 1 {
        }
    }

    private static final class FoundData
    implements ListInsightData {
        private FoundItem[] items;
        private ReadOnlyListModel model;
        private String prefix;

        private FoundData(FoundItem[] items, String prefix) {
            CamelCaseInsightInputFilter.INSTANCE.sort((ListDataItem[])items, prefix);
            this.items = items;
            this.prefix = prefix;
        }

        public ListModel getListModel() {
            if (this.model == null) {
                this.model = new ReadOnlyListModel((Object[])this.items);
            }
            return this.model;
        }

        public FoundItem[] getData() {
            return this.items;
        }

        public FoundItem[] getMatchingData() {
            return this.items;
        }

        public int getMatchingDataCount() {
            return this.items.length;
        }

        public Object getDefault() {
            return CamelCaseInsightInputFilter.INSTANCE.findClosestDataItem((ListDataItem[])this.items, this.prefix);
        }

        public boolean complete(Object selectedObject) {
            return false;
        }

        public void partialComplete() {
        }

        FoundData(FoundItem[] foundItemArray, String string, 1 var3_3) {
            this(foundItemArray, string);
        }

        public final class 1 {
        }
    }

    private static final class FoundRenderer
    extends ListDataItemCellRenderer {
        public Dimension getPreferredSize() {
            Dimension size = super.getPreferredSize();
            Dimension newSize = new Dimension(Math.max(size.width, 200), size.height);
            return newSize;
        }

        private FoundRenderer() {
        }

        FoundRenderer(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }
}

