/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.browse;

import java.net.URL;
import java.util.Collection;
import oracle.ide.Context;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.util.Assert;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.parser.LexerToken;
import oracle.javatools.parser.java.v2.CallerContext;
import oracle.javatools.parser.java.v2.JavaConstants;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceError;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.doc.SourceDocReference;
import oracle.javatools.parser.java.v2.model.expression.CompiledInvokeExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.scanner.JavaLexer;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdevimpl.java.Context2ParserHelper;
import oracle.jdevimpl.java.JavaArb;
import oracle.jdevimpl.java.browse.BrowseSymbolDialog;
import oracle.jdevimpl.java.browse.JavaBrowseContext;
import oracle.jdevimpl.java.util.ExpressionFinder;
import oracle.jdevimpl.java.util.FoundSymbol;

public final class JavaBrowseHelper
extends Context2ParserHelper
implements JavaConstants {
    private final JavaBrowseContext browseContext;
    private int errorCode;
    private static final int kSearchBackwardsGuess = 500;
    private static final int ERROR_UNKNOWN = 0;
    private static final int ERROR_DECL = 1;
    private static final int ERROR_PARSE = 2;
    private static final int ERROR_RESOLVE = 3;

    public JavaBrowseHelper(JavaBrowseContext browseContext) {
        this.browseContext = browseContext;
    }

    public JavaBrowseContext getBrowseContext() {
        return this.browseContext;
    }

    public CodeEditor getCodeEditor() {
        return this.browseContext.getCodeEditor();
    }

    public Context getContext() {
        return this.browseContext.getContext();
    }

    public URL getURL() {
        return this.browseContext.getURL();
    }

    public JavaManager getProvider() {
        return this.browseContext.getJavaManager();
    }

    public void acquire() {
        this.browseContext.acquire();
    }

    public void release() {
        this.browseContext.release();
    }

    private static boolean isBrowseableToken(int token) {
        return token == 4 || token == 136 || token == 133;
    }

    protected boolean isBrowseable() {
        TextBuffer buffer = this.browseContext.getTextBuffer();
        if (buffer == null) {
            return false;
        }
        boolean isBrowseable = this.isJavaBrowseable(buffer);
        if (!isBrowseable) {
            isBrowseable = this.analyzeDoc(null) != null;
        }
        return isBrowseable;
    }

    private boolean isJavaBrowseable(TextBuffer buffer) {
        int tokenValue;
        int end;
        int start = this.browseContext.getSelectionStart();
        if (start != (end = this.browseContext.getSelectionEnd())) {
            char ch = buffer.getChar(start);
            return Character.isJavaIdentifierStart(ch) || ch == '(';
        }
        int target = start;
        int offset = start - 500;
        if (offset < 0) {
            offset = 0;
        }
        JavaLexer lexer = new JavaLexer();
        lexer.setTextBuffer((ReadTextBuffer)buffer);
        lexer.setPosition(offset);
        LexerToken lexerToken = lexer.createLexerToken();
        do {
            tokenValue = lexer.lex(lexerToken);
            int startOffset = lexerToken.getStartOffset();
            int endOffset = lexerToken.getEndOffset();
            if (startOffset <= target && target <= endOffset) {
                if (JavaBrowseHelper.isBrowseableToken(tokenValue)) {
                    return true;
                }
                int nextToken = lexer.lex(lexerToken);
                if (lexerToken.getStartOffset() != target) {
                    return false;
                }
                return JavaBrowseHelper.isBrowseableToken(nextToken);
            }
            if (target >= startOffset) continue;
            return false;
        } while (tokenValue != 0);
        return false;
    }

    private String analyzeTarget(FoundSymbol outSymbol) {
        int selectionEnd;
        int selectionStart;
        TextBuffer textBuffer = this.browseContext.getTextBuffer();
        if (textBuffer == null) {
            return null;
        }
        int start = this.browseContext.getSelectionStart();
        int end = this.browseContext.getSelectionEnd();
        if (start < 0 || end < 0 || end < start) {
            return null;
        }
        if (start != end) {
            selectionStart = start;
            selectionEnd = end;
        } else {
            ExpressionFinder finder = new ExpressionFinder((ReadTextBuffer)textBuffer, this.browseContext.getBraceProvider());
            FoundSymbol symbol = finder.determinePrimaryStart(end);
            if (symbol == null) {
                outSymbol.string = null;
                outSymbol.startOffset = -1;
                outSymbol.endOffset = -1;
                return null;
            }
            selectionStart = symbol.startOffset;
            selectionEnd = symbol.endOffset;
        }
        int length = selectionEnd - selectionStart;
        String target = textBuffer.getString(selectionStart, length);
        outSymbol.startOffset = selectionStart;
        outSymbol.endOffset = selectionEnd;
        outSymbol.string = target;
        return target;
    }

    private JavaHasType analyzeSearch(FoundSymbol symbol, boolean allowDecl) {
        try {
            CompiledInvokeExpression i;
            JavaMethod method;
            int startOffset = symbol.startOffset;
            SourceFile file = this.browseContext.getSourceFile();
            SourceElement elementAt = file.getElementAt(startOffset);
            SourceMethod declaration = JavaBrowseHelper.determineDeclaration(elementAt);
            if (declaration != null) {
                if (allowDecl) {
                    SourceMethod sourceMethod = declaration;
                    return sourceMethod;
                }
                this.errorCode = 1;
                JavaHasType javaHasType = null;
                return javaHasType;
            }
            if (!allowDecl && elementAt.getParent() != null) {
                switch (elementAt.getParent().getSymbolKind()) {
                    case 17: {
                        if (elementAt.getSymbolKind() != 20) break;
                    }
                    case 3: 
                    case 10: 
                    case 13: {
                        this.errorCode = 1;
                        JavaHasType javaHasType = null;
                        return javaHasType;
                    }
                }
            }
            int endOffset = symbol.endOffset;
            TextBuffer textBuffer = file.getTextBuffer();
            if (textBuffer == null) {
                JavaHasType javaHasType = null;
                return javaHasType;
            }
            String inputText = textBuffer.getString(startOffset, endOffset - startOffset);
            SourceFactory factory = file.getFactory();
            SourceExpression e = factory.createExpression(inputText);
            if (e == null) {
                this.errorCode = 2;
                JavaHasType javaHasType = null;
                return javaHasType;
            }
            if (this.selectionHasCompileErrors(file, startOffset, endOffset)) {
                this.errorCode = 3;
                JavaHasType javaHasType = null;
                return javaHasType;
            }
            SourceElement scope = elementAt;
            CallerContext context = CallerContext.createContext((SourceElement)scope, (boolean)true);
            e.setContext(context);
            JavaHasType result = e.getResolvedObject();
            if (result == null) {
                this.errorCode = 3;
                JavaHasType javaHasType = null;
                return javaHasType;
            }
            if (e instanceof CompiledInvokeExpression && (method = (i = (CompiledInvokeExpression)e).getResolvedMethod()) != null) {
                JavaMethod javaMethod = method;
                return javaMethod;
            }
            JavaHasType javaHasType = result;
            return javaHasType;
        }
        catch (Exception e) {
            Assert.printStackTrace((Throwable)e);
            this.errorCode = 0;
            JavaHasType javaHasType = null;
            return javaHasType;
        }
    }

    private JavaHasType analyzeDoc(FoundSymbol outSymbol) {
        SourceElement elementAt;
        int endOffset;
        TextBuffer textBuffer = this.browseContext.getTextBuffer();
        if (textBuffer == null) {
            return null;
        }
        int startOffset = this.browseContext.getSelectionStart();
        if (startOffset != (endOffset = this.browseContext.getSelectionEnd())) {
            return null;
        }
        SourceFile file = this.browseContext.getSourceFile();
        SourceElement sym = elementAt = file.getElementAt(startOffset);
        while (sym != null) {
            switch (sym.getSymbolKind()) {
                case 66: {
                    SourceDocReference ref = (SourceDocReference)sym;
                    return ref.getResolvedObject();
                }
            }
            sym = sym.getParent();
        }
        return null;
    }

    protected JavaHasType analyze(FoundSymbol outSymbol, boolean allowDecl, boolean reportErrors) {
        int endOffset;
        String target = this.analyzeTarget(outSymbol);
        if (target == null) {
            JavaHasType docResult = this.analyzeDoc(outSymbol);
            if (docResult != null) {
                return docResult;
            }
            if (reportErrors) {
                JavaBrowseHelper.reportError(138);
            }
            return null;
        }
        Assert.println((String)("[Browse] Target: " + target));
        if (target.indexOf(46) != -1 && target.indexOf(91) == -1 && target.indexOf(40) == -1 && target.indexOf(123) == -1) {
            long timeStart = System.currentTimeMillis();
            JavaClass javaClass = this.browseContext.getJavaManager().getClass(target);
            long timeEnd = System.currentTimeMillis();
            long diff = timeEnd - timeStart;
            Assert.println((String)("[Browse] Simple resolution [ " + diff + "ms]."));
            if (javaClass != null) {
                return javaClass;
            }
        }
        long timeStart = System.currentTimeMillis();
        JavaHasType item = this.analyzeSearch(outSymbol, allowDecl);
        long timeEnd = System.currentTimeMillis();
        long diff = timeEnd - timeStart;
        Assert.println((String)("[Browse] Full resolution [ " + diff + "ms]."));
        if (item != null) {
            return item;
        }
        int startOffset = this.browseContext.getSelectionStart();
        if (startOffset != (endOffset = this.browseContext.getSelectionEnd())) {
            this.browseContext.setSelection(endOffset, endOffset);
            return this.analyze(outSymbol, allowDecl, reportErrors);
        }
        if (reportErrors) {
            switch (this.errorCode) {
                case 1: {
                    JavaBrowseHelper.reportError(133);
                    break;
                }
                case 2: {
                    JavaBrowseHelper.reportError(359);
                    break;
                }
                default: {
                    Object srcError = null;
                    if (srcError == null) {
                        String errorMessage = JavaArb.format(257, target);
                        JavaBrowseHelper.reportError(errorMessage);
                        break;
                    }
                    String errorMessage = JavaArb.format(356, target, srcError);
                    JavaBrowseHelper.reportError(errorMessage);
                    break;
                }
            }
        }
        return null;
    }

    protected static SourceMethod determineDeclaration(SourceElement elementAt) {
        SourceElement sym = elementAt;
        while (sym != null) {
            switch (sym.getSymbolKind()) {
                case 6: 
                case 19: {
                    return (SourceMethod)sym;
                }
                case 12: 
                case 20: 
                case 24: {
                    break;
                }
                default: {
                    return null;
                }
            }
            sym = sym.getParent();
        }
        return null;
    }

    static void reportError(int errorKey) {
        String errorMessage = JavaArb.getString(errorKey);
        JavaBrowseHelper.reportError(errorMessage);
    }

    private static void reportError(String errorMessage) {
        Assert.println((String)("[Browse] Error: " + errorMessage));
        BrowseSymbolDialog.showErrorDialog(errorMessage);
    }

    private boolean selectionHasCompileErrors(SourceFile file, int startOffset, int endOffset) {
        SourceElement thing = file.getElementContaining(startOffset, endOffset);
        if (thing == null) {
            return false;
        }
        thing.compile();
        Collection errors = file.getErrors(3, 4);
        for (SourceError error : errors) {
            if (thing.getStartOffset() != error.getStartOffset() || thing.getEndOffset() != error.getEndOffset()) continue;
            return true;
        }
        return false;
    }
}

