/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.editing;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RejectedExecutionException;
import oracle.ide.index.Index;
import oracle.ide.index.IndexManager;
import oracle.ide.index.QueryCriteria;
import oracle.ide.model.Project;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceClassBody;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceHasName;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.model.SourceVariable;
import oracle.javatools.util.MultiMap;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.java.util.SourceElementAsList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ImplOverCache {
    private final URL _cachedForProject;
    private final URL _cachedForUrl;
    private final int _fileHash;
    private final MultiMap<String, String> _superHierachy;
    private final MultiMap<String, String> _subHierachy;
    private final MultiMap<String, String> _superMethods;
    private final MultiMap<String, String> _subMethods;

    private void $init$() {
        this._superHierachy = new MultiMap();
        this._subHierachy = new MultiMap();
        this._superMethods = new MultiMap();
        this._subMethods = new MultiMap();
    }

    public ImplOverCache(URL cacheForProject, URL cacheForUrl, SourceFile sourceFile) {
        this.$init$();
        this._cachedForProject = cacheForProject;
        this._cachedForUrl = cacheForUrl;
        this._fileHash = ImplOverCache.getHash((SourceElement)sourceFile);
    }

    public boolean isCacheFor(URL cacheForProject, URL cacheForUrl, SourceFile sourceFile) {
        return URLFileSystem.equals((URL)cacheForUrl, (URL)this._cachedForUrl) && URLFileSystem.equals((URL)cacheForProject, (URL)this._cachedForProject) && this._fileHash == ImplOverCache.getHash((SourceElement)sourceFile);
    }

    private static int getHash(SourceElement sourceElement) {
        switch (sourceElement.getSymbolKind()) {
            case 14: 
            case 21: {
                SourceHasName sourceHasName = (SourceHasName)sourceElement;
                String name = sourceHasName.getName();
                return name.hashCode();
            }
            case 3: {
                SourceClass sourceClass = (SourceClass)sourceElement;
                String className = sourceClass.getName();
                int hash = className.hashCode();
                hash = 31 * hash + sourceClass.getModifiers();
                SourceTypeReference sourceSuperclass = sourceClass.getSourceSuperclass();
                if (sourceSuperclass != null) {
                    String superName = sourceSuperclass.getName();
                    hash = 31 * hash + superName.hashCode();
                }
                List interfaces = sourceClass.getSourceInterfaces();
                int i = 0;
                while (i < interfaces.size()) {
                    SourceTypeReference sourceTypeReference = (SourceTypeReference)interfaces.get(i);
                    String name = sourceTypeReference.getName();
                    hash = 31 * hash + name.hashCode();
                    ++i;
                }
                SourceClassBody sourceBody = sourceClass.getSourceBody();
                if (sourceBody != null) {
                    hash = 31 * hash + ImplOverCache.getHash((SourceElement)sourceBody);
                }
                return hash;
            }
            case 19: {
                SourceMethod sourceMethod = (SourceMethod)sourceElement;
                String methodName = sourceMethod.getName();
                int hash = methodName.hashCode();
                hash = 31 * hash + sourceMethod.getModifiers();
                List sourceParameters = sourceMethod.getSourceParameters();
                int i = 0;
                while (i < sourceParameters.size()) {
                    SourceVariable sourceVariable = (SourceVariable)sourceParameters.get(i);
                    String text = sourceVariable.getText();
                    hash = hash * 31 + text.hashCode();
                    ++i;
                }
                return hash;
            }
        }
        int signature = 0;
        List children = sourceElement.getChildren();
        int i = 0;
        while (i < children.size()) {
            SourceElement childElement = (SourceElement)children.get(i);
            int classHash = ImplOverCache.getHash(childElement);
            if (classHash != 0) {
                signature = signature * 31 + classHash;
            }
            ++i;
        }
        return signature;
    }

    private ArrayList<JavaMethod> identifiersToMethods(JavaManager javaManager, List<String> identifiers) {
        ArrayList<JavaMethod> ret = new ArrayList<JavaMethod>(identifiers.size());
        int i = 0;
        while (i < identifiers.size()) {
            String identifier = identifiers.get(i);
            JavaElement javaElement = CommonUtilities.locateByUniqueIdentifier((String)identifier, (JavaProvider)javaManager);
            if (javaElement instanceof JavaMethod) {
                JavaMethod superMethod = (JavaMethod)javaElement;
                ret.add(superMethod);
            }
            ++i;
        }
        return ret;
    }

    public List<String> getSuperClassNames(JavaManager javaManager, String qualifiedName) {
        JavaClass javaClass = javaManager.getClass(qualifiedName);
        if (javaClass != null) {
            return this.getSuperClassNames(javaManager, javaClass);
        }
        return Collections.emptyList();
    }

    public List<String> getSuperClassNames(JavaManager javaManager, JavaClass javaClass) {
        ArrayList<String> ret = Collections.emptyList();
        String uniqueIdentifier = javaClass.toString();
        ArrayList<String> superHierarchy = (ArrayList<String>)this._superHierachy.get((Object)uniqueIdentifier);
        if (superHierarchy == null) {
            JavaClass superTypeErasure;
            JavaType superclass = javaClass.getSuperclass();
            Collection interfaces = javaClass.getInterfaces();
            ret = new ArrayList<String>(1 + interfaces.size());
            if (superclass != null && (superTypeErasure = superclass.getTypeErasure()) != null) {
                String superQualifiedName = superTypeErasure.getQualifiedName();
                ret.add(superQualifiedName);
            }
            for (JavaType interfaceType : interfaces) {
                JavaClass erasedInterface = interfaceType.getTypeErasure();
                String superQualifiedName = erasedInterface.getQualifiedName();
                ret.add(superQualifiedName);
            }
            this._superHierachy.put((Object)uniqueIdentifier, ret);
        } else {
            ret = superHierarchy;
        }
        return Collections.unmodifiableList(ret);
    }

    public List<String> getSubClassNames(Project project, JavaClass javaClass) {
        JavaClass typeErasure;
        String thisQualifiedName;
        ArrayList<String> ret = Collections.emptyList();
        if (javaClass != null && (thisQualifiedName = (typeErasure = javaClass.getTypeErasure()).getQualifiedName()) != null) {
            ArrayList<String> subHierachy = (ArrayList<String>)this._subHierachy.get((Object)thisQualifiedName);
            if (subHierachy == null) {
                String thisName = typeErasure.getName();
                if (thisName != null) {
                    IndexManager manager = IndexManager.getIndexManager();
                    Index index = manager.getIndex(project);
                    try {
                        QueryCriteria criteria = new QueryCriteria();
                        criteria.put((Object)"java.extends.or.implements", (Object)thisName);
                        try {
                            URL[] results = (URL[])index.query(criteria).get();
                            ret = new ArrayList<String>();
                            if (results.length > 0) {
                                JavaManager javaManager = JavaManager.getInstance((Project)project);
                                boolean isInterface = javaClass.isInterface();
                                int i = 0;
                                while (i < results.length) {
                                    URL result = results[i];
                                    SourceFile sourceFile = javaManager.getSourceFile(result);
                                    List sourceClasses = SourceElementAsList.asList((SourceElement)sourceFile, (int)3);
                                    int j = 0;
                                    while (j < sourceClasses.size()) {
                                        SourceClass sourceClass = (SourceClass)sourceClasses.get(j);
                                        if (isInterface) {
                                            List sourceInterfaces = sourceClass.getSourceInterfaces();
                                            int k = 0;
                                            while (k < sourceInterfaces.size()) {
                                                String qualifiedName;
                                                JavaClass erasedSuperType;
                                                JavaType resolvedType;
                                                SourceTypeReference sourceTypeReference = (SourceTypeReference)sourceInterfaces.get(k);
                                                String superInterfaceName = sourceTypeReference.getName();
                                                if (superInterfaceName != null && superInterfaceName.endsWith(thisName) && (resolvedType = sourceTypeReference.getResolvedType()) != null && (erasedSuperType = resolvedType.getTypeErasure()).equals((Object)typeErasure) && (qualifiedName = sourceClass.getTypeErasure().getQualifiedName()) != null) {
                                                    ret.add(qualifiedName);
                                                }
                                                ++k;
                                            }
                                        } else {
                                            String qualifiedName;
                                            JavaClass erasedSubType;
                                            JavaType resolvedType;
                                            String superClassName;
                                            SourceTypeReference sourceTypeReference = sourceClass.getSourceSuperclass();
                                            if (sourceTypeReference != null && (superClassName = sourceTypeReference.getName()) != null && superClassName.endsWith(thisName) && (resolvedType = sourceTypeReference.getResolvedType()) != null && (erasedSubType = resolvedType.getTypeErasure()).equals((Object)typeErasure) && (qualifiedName = sourceClass.getTypeErasure().getQualifiedName()) != null) {
                                                ret.add(qualifiedName);
                                            }
                                        }
                                        ++j;
                                    }
                                    ++i;
                                }
                            }
                            this._subHierachy.put((Object)thisQualifiedName, ret);
                        }
                        catch (RejectedExecutionException e) {
                        }
                        catch (ExecutionException e) {
                            e.printStackTrace();
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    finally {
                        index.release();
                    }
                }
            } else {
                ret = subHierachy;
            }
        }
        return Collections.unmodifiableList(ret);
    }

    public List<JavaMethod> getSuperMethods(JavaManager javaManager, JavaMethod javaMethod) {
        ArrayList<Object> ret;
        String uniqueIdentifier = javaMethod.toString();
        ArrayList<String> superIdentifiers = (ArrayList<String>)this._superMethods.get((Object)uniqueIdentifier);
        if (superIdentifiers == null) {
            JavaClass owningClass = javaMethod.getOwningClass();
            JavaClass typeErasure = owningClass.getTypeErasure();
            ret = new ArrayList(1);
            this.getSuperMethods(javaManager, javaMethod, typeErasure, ret);
            superIdentifiers = new ArrayList<String>(ret.size());
            int i = 0;
            while (i < ret.size()) {
                JavaMethod method = (JavaMethod)ret.get(i);
                String superUniqueIdentifier = method.getUniqueIdentifier();
                superIdentifiers.add(superUniqueIdentifier);
                ++i;
            }
            this._superMethods.put((Object)uniqueIdentifier, superIdentifiers);
        } else {
            ret = this.identifiersToMethods(javaManager, (List<String>)superIdentifiers);
        }
        return Collections.unmodifiableList(ret);
    }

    private void getSuperMethods(JavaManager javaManager, JavaMethod javaMethod, JavaClass javaClass, List<JavaMethod> superMethods) {
        LinkedList<String> superClassNames = new LinkedList<String>(this.getSuperClassNames(javaManager, javaClass));
        HashSet<String> alreadySeen = new HashSet<String>(superClassNames);
        while (!superClassNames.isEmpty()) {
            String superClassName = superClassNames.removeFirst();
            JavaClass superJavaClass = javaManager.getClass(superClassName);
            JavaMethod superMethod = this.getSuperMethod(javaMethod, superJavaClass);
            if (superMethod != null) {
                superMethods.add(superMethod);
                continue;
            }
            for (String newSuperClassName : this.getSuperClassNames(javaManager, superClassName)) {
                if (alreadySeen.contains(newSuperClassName)) continue;
                superClassNames.add(newSuperClassName);
                alreadySeen.add(newSuperClassName);
            }
        }
    }

    private JavaMethod getSuperMethod(JavaMethod javaMethod, JavaClass javaClass) {
        String methodName = javaMethod.getName();
        Collection declaredMethods = javaClass.getDeclaredMethods(methodName);
        for (JavaMethod declaredMethod : declaredMethods) {
            if (!ImplOverCache.isMatchingMethod(javaMethod, declaredMethod)) continue;
            return declaredMethod;
        }
        return null;
    }

    public List<JavaMethod> getSubMethods(Project project, JavaManager javaManager, JavaMethod javaMethod) {
        ArrayList<Object> ret;
        String uniqueIdentifier = javaMethod.getUniqueIdentifier();
        ArrayList<String> subIdentifiers = (ArrayList<String>)this._subMethods.get((Object)uniqueIdentifier);
        if (subIdentifiers == null) {
            JavaClass owningClass = javaMethod.getOwningClass();
            JavaClass typeErasure = owningClass.getTypeErasure();
            ret = new ArrayList(1);
            this.getSubMethods(project, javaManager, javaMethod, typeErasure, ret);
            subIdentifiers = new ArrayList<String>(ret.size());
            int i = 0;
            while (i < ret.size()) {
                JavaMethod method = (JavaMethod)ret.get(i);
                String subUniqueIdentifier = method.getUniqueIdentifier();
                subIdentifiers.add(subUniqueIdentifier);
                ++i;
            }
            this._subMethods.put((Object)uniqueIdentifier, subIdentifiers);
        } else {
            ret = this.identifiersToMethods(javaManager, (List<String>)subIdentifiers);
        }
        return Collections.unmodifiableList(ret);
    }

    private void getSubMethods(Project project, JavaManager javaManager, JavaMethod javaMethod, JavaClass javaClass, List<JavaMethod> subMethods) {
        ArrayList<String> subClassNames = new ArrayList<String>(this.getSubClassNames(project, javaClass));
        while (!subClassNames.isEmpty()) {
            int i = subClassNames.size() - 1;
            while (i >= 0) {
                String subClassName = (String)subClassNames.get(i);
                JavaClass subJavaClass = javaManager.getClass(subClassName);
                JavaMethod subMethod = this.getSubMethod(javaMethod, subJavaClass);
                if (subMethod != null) {
                    subMethods.add(subMethod);
                    subClassNames.remove(i);
                }
                --i;
            }
            ArrayList<String> newSubList = new ArrayList<String>(subClassNames.size());
            int i2 = 0;
            while (i2 < subClassNames.size()) {
                String subClassName = (String)subClassNames.get(i2);
                JavaClass subClass = javaManager.getClass(subClassName);
                ArrayList<String> newSubClassNames = new ArrayList<String>(this.getSubClassNames(project, subClass));
                newSubList.addAll(newSubClassNames);
                ++i2;
            }
            subClassNames = newSubList;
        }
    }

    private JavaMethod getSubMethod(JavaMethod javaMethod, JavaClass javaClass) {
        String methodName = javaMethod.getName();
        Collection declaredMethods = javaClass.getDeclaredMethods(methodName);
        for (JavaMethod declaredMethod : declaredMethods) {
            if (!ImplOverCache.isMatchingMethod(declaredMethod, javaMethod)) continue;
            return declaredMethod;
        }
        return null;
    }

    private static boolean isMatchingMethod(JavaMethod subMethod, JavaMethod superMethod) {
        return subMethod.hasSubsignatureOf(superMethod) && !superMethod.isFinal() && !subMethod.isPrivate() && !subMethod.isStatic() && !superMethod.isPrivate() && !superMethod.isStatic() && (!subMethod.isPackagePrivate() && !superMethod.isPackagePrivate() || ImplOverCache.packagesMatch(subMethod, superMethod));
    }

    private static boolean packagesMatch(JavaMethod method1, JavaMethod method2) {
        JavaClass class1 = method1.getOwningClass();
        JavaClass class2 = method2.getOwningClass();
        return class1.getPackageName().equals(class2.getPackageName());
    }
}

