/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.editing;

import java.awt.Font;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.UIManager;
import oracle.ide.Context;
import oracle.ide.model.Element;
import oracle.javatools.buffer.ExpiredTextBufferException;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFieldVariable;
import oracle.javatools.parser.java.v2.model.SourceLocalVariable;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.expression.SourceMethodCallExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceNewClassExpression;
import oracle.javatools.parser.java.v2.model.statement.SourceBlockStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceCatchClause;
import oracle.javatools.parser.java.v2.model.statement.SourceDoStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceElseClause;
import oracle.javatools.parser.java.v2.model.statement.SourceForStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceIfStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceSwitchLabel;
import oracle.javatools.parser.java.v2.model.statement.SourceSwitchStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceSynchStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceTryStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceWhileStatement;
import oracle.javatools.ui.breadcrumbs.Breadcrumb;
import oracle.javatools.ui.breadcrumbs.BreadcrumbsModel;
import oracle.javatools.ui.breadcrumbs.BreadcrumbsModelListener;
import oracle.javatools.ui.simplestyle.StyledTextAttribute;
import oracle.javatools.ui.simplestyle.StyledTextModel;
import oracle.jdevimpl.java.editing.JavaBreadcrumb;

final class JavaBreadcrumbsModel
implements BreadcrumbsModel {
    private LinkedList<BreadcrumbsModelListener> listeners;
    private ArrayList<Breadcrumb> crumbs;
    private static StyledTextAttribute normalAttr;
    private static StyledTextAttribute boldAttr;

    private void $init$() {
        this.listeners = new LinkedList();
        this.crumbs = new ArrayList();
    }

    public JavaBreadcrumbsModel() {
        this.$init$();
        Font font = UIManager.getFont("Label.font");
        normalAttr = new StyledTextAttribute(font, null);
        boldAttr = new StyledTextAttribute(font.deriveFont(1), null);
    }

    void updateModel(Context context) {
        this.crumbs.clear();
        try {
            Element e = context.getElement();
            if (e != null && e.getData() != null && e.getData() instanceof SourceElement) {
                SourceElement se = (SourceElement)e.getData();
                this.processSourceElement(se, se);
                this.fireBreadcrumbsUpdated();
            }
        }
        catch (ExpiredTextBufferException e) {
            this.crumbs.clear();
        }
    }

    private void processSourceElement(SourceElement se, SourceElement originalElement) throws ExpiredTextBufferException {
        SourceElement nextElement = se.getParent();
        switch (se.getSymbolKind()) {
            case 3: {
                SourceClass sourceClass = (SourceClass)se;
                if (sourceClass.getNameElement() == null) break;
                StyledTextModel shortModel = new StyledTextModel(sourceClass.getName(), boldAttr);
                int s = sourceClass.getDocComment() != null ? sourceClass.getDocComment().getEndOffset() + 1 : sourceClass.getStartOffset();
                int e = sourceClass.getSourceBody().getStartOffset() != -1 ? sourceClass.getSourceBody().getStartOffset() : sourceClass.getNameElement().getEndOffset();
                int off = sourceClass.getStartOffset();
                String peek = sourceClass.getText().substring(s - off, e - off);
                this.crumbs.add(0, new JavaBreadcrumb(shortModel, shortModel, se.getStartOffset(), peek, null));
                break;
            }
            case 55: {
                SourceNewClassExpression sourceNewClass = (SourceNewClassExpression)se;
                if (sourceNewClass.getSourceType() == null || sourceNewClass.getAnonymousClass() == null) break;
                int s = 0;
                int e = 0;
                String peek = "";
                StyledTextModel shortModel = new StyledTextModel(sourceNewClass.getSourceType().getName(), boldAttr);
                if (sourceNewClass.getParent() instanceof SourceLocalVariable || sourceNewClass.getParent() instanceof SourceFieldVariable) {
                    s = sourceNewClass.getParent().getStartOffset();
                    e = sourceNewClass.getAnonymousClass().getSourceBody().getStartOffset() != -1 ? sourceNewClass.getAnonymousClass().getSourceBody().getStartOffset() : sourceNewClass.getEndOffset();
                    peek = sourceNewClass.getParent().getText().substring(0, e - s);
                } else if (sourceNewClass.getParent().getParent() != null && sourceNewClass.getParent().getParent() instanceof SourceMethodCallExpression) {
                    s = sourceNewClass.getParent().getParent().getStartOffset();
                    e = sourceNewClass.getAnonymousClass().getSourceBody().getStartOffset() != -1 ? sourceNewClass.getAnonymousClass().getSourceBody().getStartOffset() : sourceNewClass.getEndOffset();
                    peek = sourceNewClass.getParent().getParent().getText().substring(0, e - s);
                } else {
                    s = sourceNewClass.getStartOffset();
                    e = sourceNewClass.getAnonymousClass().getSourceBody().getStartOffset() != -1 ? sourceNewClass.getAnonymousClass().getSourceBody().getStartOffset() : sourceNewClass.getEndOffset();
                    peek = sourceNewClass.getText().substring(0, e - s);
                }
                this.crumbs.add(0, new JavaBreadcrumb(shortModel, shortModel, se.getStartOffset(), peek, null));
                break;
            }
            case 6: 
            case 19: {
                SourceMethod sourceMethod = (SourceMethod)se;
                if (sourceMethod.getNameElement() == null) break;
                StyledTextModel shortModel = new StyledTextModel(sourceMethod.getName(), boldAttr);
                StyledTextModel longModel = JavaBreadcrumbsModel.getLongMethodName(sourceMethod);
                int s = sourceMethod.getDocComment() != null ? sourceMethod.getDocComment().getEndOffset() + 1 : sourceMethod.getStartOffset();
                int e = sourceMethod.getBlock() != null ? sourceMethod.getBlock().getStartOffset() : sourceMethod.getNameElement().getEndOffset();
                int off = sourceMethod.getStartOffset();
                String peek = sourceMethod.getText().substring(s - off, e - off);
                this.crumbs.add(0, new JavaBreadcrumb(shortModel, longModel, se.getStartOffset(), peek, null));
                break;
            }
            case 39: {
                SourceIfStatement sourceIf = (SourceIfStatement)se;
                StyledTextModel longModel = new StyledTextModel();
                StringBuffer peekSb = new StringBuffer();
                nextElement = this.addIfElses((SourceElement)sourceIf, longModel, peekSb);
                StyledTextModel shortModel = new StyledTextModel("if", boldAttr);
                this.crumbs.add(0, new JavaBreadcrumb(shortModel, longModel, se.getStartOffset(), peekSb.toString(), null));
                break;
            }
            case 34: {
                SourceElseClause sourceElse = (SourceElseClause)se;
                StyledTextModel shortModel = new StyledTextModel("else", boldAttr);
                StyledTextModel longModel = new StyledTextModel(" else", boldAttr);
                StringBuffer peekSb = new StringBuffer("else");
                nextElement = this.addIfElses((SourceElement)sourceElse.getOwningIf(), longModel, peekSb);
                this.crumbs.add(0, new JavaBreadcrumb(shortModel, longModel, se.getStartOffset(), peekSb.toString(), null));
                break;
            }
            case 45: {
                SourceWhileStatement sourceWhile = (SourceWhileStatement)se;
                StyledTextModel shortModel = new StyledTextModel("while", boldAttr);
                StyledTextModel longModel = new StyledTextModel("while", boldAttr);
                if (sourceWhile.getControlExpression() != null) {
                    longModel.addText(" " + this.removeNewlines(sourceWhile.getControlExpression().getText()), normalAttr);
                }
                String peek = sourceWhile.getControlExpression() != null ? "while " + sourceWhile.getControlExpression().getText() : "while";
                this.crumbs.add(0, new JavaBreadcrumb(shortModel, longModel, se.getStartOffset(), peek, null));
                break;
            }
            case 38: {
                SourceForStatement sourceFor = (SourceForStatement)se;
                StyledTextModel shortModel = new StyledTextModel("for", boldAttr);
                StyledTextModel longModel = new StyledTextModel("for", boldAttr);
                longModel.addText(this.removeNewlines(sourceFor.getText().substring(3, sourceFor.getText().length())), normalAttr);
                String peek = sourceFor.getText();
                if (sourceFor.getPrimaryClause() != null) {
                    int s = sourceFor.getStartOffset();
                    int e = sourceFor.getPrimaryClause().getStartOffset();
                    int off = s;
                    longModel = new StyledTextModel("for", boldAttr);
                    longModel.addText(this.removeNewlines(sourceFor.getText().substring(s - off + 3, e - off)), normalAttr);
                    peek = "for " + sourceFor.getText().substring(s - off + 3, e - off);
                }
                this.crumbs.add(0, new JavaBreadcrumb(shortModel, longModel, se.getStartOffset(), peek, null));
                break;
            }
            case 33: {
                SourceDoStatement sourceDo = (SourceDoStatement)se;
                StyledTextModel shortModel = new StyledTextModel("do", boldAttr);
                StyledTextModel longModel = new StyledTextModel("do", boldAttr);
                longModel.addText("...", normalAttr);
                longModel.addText("while ", boldAttr);
                if (sourceDo.getControlExpression() != null) {
                    longModel.addText(this.removeNewlines(sourceDo.getControlExpression().getText()), normalAttr);
                }
                String peek = sourceDo.getControlExpression() != null ? "do...while " + sourceDo.getControlExpression().getText() : "do...while";
                this.crumbs.add(0, new JavaBreadcrumb(shortModel, longModel, se.getStartOffset(), peek, null));
                break;
            }
            case 42: {
                SourceSynchStatement sourceSync = (SourceSynchStatement)se;
                StyledTextModel shortModel = new StyledTextModel("sync", boldAttr);
                StyledTextModel longModel = new StyledTextModel("synchronized", boldAttr);
                if (sourceSync.getControlExpression() != null) {
                    longModel.addText(" " + this.removeNewlines(sourceSync.getControlExpression().getText()), normalAttr);
                }
                String peek = sourceSync.getControlExpression() != null ? "synchronized " + sourceSync.getControlExpression().getText() : "synchronized";
                this.crumbs.add(0, new JavaBreadcrumb(shortModel, longModel, se.getStartOffset(), peek, null));
                break;
            }
            case 44: {
                SourceTryStatement sourceTry = (SourceTryStatement)se;
                StyledTextModel shortModel = new StyledTextModel("try", boldAttr);
                String peek = "try";
                List catches = sourceTry.getCatchClauses();
                ArrayList<JavaBreadcrumb.ChildData> children = null;
                if (catches.size() > 0) {
                    StringBuffer sb = new StringBuffer("try...\n");
                    children = new ArrayList<JavaBreadcrumb.ChildData>();
                    children.add(new JavaBreadcrumb.ChildData("try", sourceTry.getStartOffset()));
                    for (SourceCatchClause catchClause : catches) {
                        if (catchClause.getCatchVariable() == null) continue;
                        String catchText = "catch (" + catchClause.getCatchVariable().getText() + ")";
                        children.add(new JavaBreadcrumb.ChildData(catchText, catchClause.getStartOffset()));
                        sb.append(catchText);
                        sb.append("\n");
                    }
                    sb.deleteCharAt(sb.length() - 1);
                    peek = sb.toString();
                }
                this.crumbs.add(0, new JavaBreadcrumb(shortModel, shortModel, sourceTry.getStartOffset(), peek, null));
                break;
            }
            case 37: {
                StyledTextModel shortModel = new StyledTextModel("finally", boldAttr);
                this.crumbs.add(0, new JavaBreadcrumb(shortModel, shortModel, se.getStartOffset(), "finally", null));
                break;
            }
            case 5: {
                StyledTextModel shortModel = new StyledTextModel("<init>", boldAttr);
                this.crumbs.add(0, new JavaBreadcrumb(shortModel, shortModel, se.getStartOffset(), "static", null));
                break;
            }
            case 31: {
                SourceCatchClause sourceCatch = (SourceCatchClause)se;
                StyledTextModel shortModel = new StyledTextModel("catch", boldAttr);
                StyledTextModel longModel = new StyledTextModel("catch", boldAttr);
                if (sourceCatch.getCatchVariable() != null) {
                    longModel.addText(" (" + sourceCatch.getCatchVariable().getText() + ")", normalAttr);
                }
                String peek = sourceCatch.getCatchVariable() != null ? "catch (" + sourceCatch.getCatchVariable().getText() + ")\n" : "catch";
                this.crumbs.add(0, new JavaBreadcrumb(shortModel, longModel, se.getStartOffset(), peek, null));
                nextElement = sourceCatch.getParent().getParent();
                break;
            }
            case 41: {
                SourceSwitchStatement sourceSwitch = (SourceSwitchStatement)se;
                StyledTextModel shortModel = new StyledTextModel("switch", boldAttr);
                StyledTextModel longModel = new StyledTextModel("switch", boldAttr);
                if (sourceSwitch.getControlExpression() != null) {
                    longModel.addText(this.removeNewlines(sourceSwitch.getControlExpression().getText()), normalAttr);
                }
                String peek = sourceSwitch.getControlExpression() != null ? "switch " + sourceSwitch.getControlExpression().getText() : "switch";
                SourceSwitchLabel caretLabel = null;
                SourceElement[] switchElems = sourceSwitch.getContainedElements();
                ArrayList<JavaBreadcrumb.ChildData> children = new ArrayList<JavaBreadcrumb.ChildData>();
                if (switchElems != null && switchElems.length > 1 && switchElems[1] instanceof SourceBlockStatement) {
                    SourceElement[] blockElems;
                    SourceElement switchBlock = switchElems[1];
                    switchBlock = switchBlock.getContainedElements()[0];
                    SourceElement[] sourceElementArray = blockElems = switchBlock.getContainedElements();
                    int n = 0;
                    while (n < sourceElementArray.length) {
                        SourceElement blockElem = sourceElementArray[n];
                        if (blockElem instanceof SourceSwitchLabel) {
                            SourceSwitchLabel label = (SourceSwitchLabel)blockElem;
                            if (label.getExpression() != null) {
                                peek = peek + "\n  " + label.getExpression().getText();
                                children.add(new JavaBreadcrumb.ChildData("case " + label.getExpression().getText(), label.getExpression().getStartOffset()));
                            }
                            if (originalElement.getStartOffset() > blockElem.getStartOffset()) {
                                caretLabel = label;
                            }
                        }
                        ++n;
                    }
                }
                if (caretLabel != null) {
                    StyledTextModel shortCaseModel = new StyledTextModel("case", boldAttr);
                    StyledTextModel longCaseModel = new StyledTextModel("case", boldAttr);
                    if (caretLabel.getExpression() != null) {
                        longCaseModel.addText(" " + caretLabel.getExpression().getText(), normalAttr);
                    }
                    String casePeek = caretLabel.getExpression() != null ? "case " + caretLabel.getExpression().getText() : "default";
                    this.crumbs.add(0, new JavaBreadcrumb(shortCaseModel, longCaseModel, caretLabel.getStartOffset(), casePeek, null));
                }
                this.crumbs.add(0, new JavaBreadcrumb(shortModel, longModel, se.getStartOffset(), peek, children));
                break;
            }
        }
        if (nextElement != null) {
            this.processSourceElement(nextElement, originalElement);
        }
    }

    public static StyledTextModel getLongMethodName(SourceMethod sourceMethod) {
        StyledTextModel model = new StyledTextModel();
        if (sourceMethod.isConstructor()) {
            model.addText(sourceMethod.getEnclosingClass().getName(), boldAttr);
        } else {
            model.addText(sourceMethod.getName(), boldAttr);
        }
        JavaType[] pTypes = sourceMethod.getParameterTypes();
        StringBuffer sb = new StringBuffer("(");
        if (pTypes.length > 0) {
            int i = 0;
            while (i < pTypes.length) {
                if (pTypes[i] != null) {
                    sb.append(pTypes[i].getName());
                    if (i < pTypes.length - 1) {
                        sb.append(",");
                    }
                }
                ++i;
            }
        }
        sb.append(")");
        model.addText(sb.toString(), normalAttr);
        return model;
    }

    private SourceElement addIfElses(SourceElement se, StyledTextModel styleModel, StringBuffer sb) {
        if (se instanceof SourceElseClause) {
            sb.insert(0, "else\n");
            styleModel.prependText(" else ", boldAttr);
            if (se.getParent() != null) {
                return this.addIfElses(se.getParent(), styleModel, sb);
            }
        } else if (se instanceof SourceIfStatement) {
            SourceIfStatement seIf = (SourceIfStatement)se;
            sb.insert(0, "\n");
            if (seIf.getControlExpression() != null) {
                sb.insert(0, seIf.getControlExpression().getText());
                sb.insert(0, " ");
                styleModel.prependText(" " + seIf.getControlExpression().getText(), normalAttr);
            }
            styleModel.prependText("if", boldAttr);
            sb.insert(0, "if");
            if (se.getParent() != null) {
                return this.addIfElses(se.getParent(), styleModel, sb);
            }
        }
        return se;
    }

    private String removeNewlines(String s) {
        if (s.length() <= 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        StringTokenizer st = new StringTokenizer(s);
        while (st.hasMoreTokens()) {
            sb.append(" ");
            sb.append(st.nextToken().trim());
        }
        sb.deleteCharAt(0);
        return sb.toString();
    }

    public int getBreadcrumbCount() {
        return this.crumbs.size();
    }

    public Breadcrumb getBreadcrumb(int crumb) {
        return this.crumbs.get(crumb);
    }

    public void addBreadcrumbsModelListener(BreadcrumbsModelListener l) {
        if (!this.listeners.contains(l)) {
            this.listeners.add(l);
        }
    }

    public void removeBreadcrumbsModelListener(BreadcrumbsModelListener l) {
        if (this.listeners.contains(l)) {
            this.listeners.remove(l);
        }
    }

    private void fireBreadcrumbsUpdated() {
        for (BreadcrumbsModelListener l : this.listeners) {
            l.breadcrumbsUpdated();
        }
    }

    public boolean hasChildren(Breadcrumb breadcrumb) {
        JavaBreadcrumb jBreadcrumb = (JavaBreadcrumb)breadcrumb;
        return jBreadcrumb.getChildren() != null && jBreadcrumb.getChildren().size() > 0;
    }
}

