/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.editing;

import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import oracle.ide.Ide;
import oracle.ide.ceditor.BreadcrumbsPlugin;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.peek.CodePeek;
import oracle.ide.view.ViewSelectionEvent;
import oracle.ide.view.ViewSelectionListener;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.ui.breadcrumbs.Breadcrumb;
import oracle.javatools.ui.breadcrumbs.BreadcrumbsListener;
import oracle.javatools.ui.breadcrumbs.BreadcrumbsModel;
import oracle.javatools.ui.breadcrumbs.JBreadcrumbs;
import oracle.jdevimpl.java.editing.JavaBreadcrumb;
import oracle.jdevimpl.java.editing.JavaBreadcrumbsModel;
import oracle.jdevimpl.java.util.JavaCodePeek;

public final class JavaBreadcrumbsPlugin
extends BreadcrumbsPlugin {
    private JavaBreadcrumbsListener listener;
    private MyViewSelectionListener viewListener;
    private JavaBreadcrumbsModel breadcrumbsModel;

    public void install(BasicEditorPane editor) {
        super.install(editor);
        this.breadcrumbsModel = new JavaBreadcrumbsModel();
        this.breadcrumbs.setModel((BreadcrumbsModel)this.breadcrumbsModel);
        this.listener = new JavaBreadcrumbsListener(null);
        this.breadcrumbs.addBreadcrumbsListener((BreadcrumbsListener)this.listener);
        this.viewListener = new MyViewSelectionListener(null);
        CodeEditor.getCodeEditor((BasicEditorPane)editor).addViewSelectionListener((ViewSelectionListener)this.viewListener);
    }

    public void deinstall(BasicEditorPane editor) {
        CodeEditor.getCodeEditor((BasicEditorPane)editor).removeViewSelectionListener((ViewSelectionListener)this.viewListener);
        this.breadcrumbs.removeBreadcrumbsListener((BreadcrumbsListener)this.listener);
        super.deinstall(editor);
    }

    static JBreadcrumbs ra$breadcrumbs(JavaBreadcrumbsPlugin javaBreadcrumbsPlugin) {
        return javaBreadcrumbsPlugin.breadcrumbs;
    }

    static JavaBreadcrumbsModel ra$breadcrumbsModel(JavaBreadcrumbsPlugin javaBreadcrumbsPlugin) {
        return javaBreadcrumbsPlugin.breadcrumbsModel;
    }

    static BasicEditorPane ra$editor(JavaBreadcrumbsPlugin javaBreadcrumbsPlugin) {
        return javaBreadcrumbsPlugin.editor;
    }

    private class MyViewSelectionListener
    implements ViewSelectionListener {
        public void viewSelectionChanged(ViewSelectionEvent e) {
            if (!JavaBreadcrumbsPlugin.ra$breadcrumbs(JavaBreadcrumbsPlugin.this).isVisible()) {
                return;
            }
            JavaBreadcrumbsPlugin.ra$breadcrumbsModel(JavaBreadcrumbsPlugin.this).updateModel(e.getView().getContext());
        }

        private MyViewSelectionListener() {
        }

        MyViewSelectionListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class JavaBreadcrumbsListener
    implements BreadcrumbsListener {
        private CodePeek peek;
        private Breadcrumb peekCrumb;

        public void breadcrumbClicked(Breadcrumb crumb) {
            JavaBreadcrumbsPlugin.ra$editor(JavaBreadcrumbsPlugin.this).requestFocus();
            JavaBreadcrumbsPlugin.ra$editor(JavaBreadcrumbsPlugin.this).setCaretPosition(crumb.getStartOffset());
        }

        public void showBreadcrumbPeek(Breadcrumb crumb, Rectangle rect) {
            if (crumb == null) {
                if (this.peek != null) {
                    this.peek.hidePeek();
                }
                return;
            }
            if (crumb == this.peekCrumb && this.peek.isShowing()) {
                return;
            }
            this.peekCrumb = crumb;
            if (this.peek != null) {
                this.peek.hidePeek();
            }
            this.peek = JavaCodePeek.createCodePeek((JComponent)JavaBreadcrumbsPlugin.ra$breadcrumbs(JavaBreadcrumbsPlugin.this), CodeEditor.getCodeEditor((BasicEditorPane)JavaBreadcrumbsPlugin.ra$editor(JavaBreadcrumbsPlugin.this)).getContext().getNode().getURL().toExternalForm(), ((JavaBreadcrumb)crumb).getPeekText(), null, rect);
            this.peek.getGhostPointingPalette().setShowRectangle(false);
            this.peek.showPeek(Ide.getMainWindow().getLayeredPane());
        }

        public void separatorClicked(Breadcrumb crumb, Rectangle separatorBounds) {
        }

        public void breadcrumbContextClicked(Breadcrumb crumb, Point p) {
        }

        public void hideBreadcrumbPeek() {
            if (this.peek != null) {
                this.peek.hidePeek();
            }
        }

        private JavaBreadcrumbsListener() {
        }

        JavaBreadcrumbsListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

