/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.editing;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CancellationException;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.CodeEditorGutter;
import oracle.ide.ceditor.CodeMenuConstants;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.util.MultiMap;
import oracle.ide.view.ActiveViewEvent;
import oracle.ide.view.ActiveViewListener;
import oracle.ide.view.View;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.gutter.GutterColumn;
import oracle.javatools.editor.gutter.GutterColumnListener;
import oracle.javatools.editor.gutter.GutterMark;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceName;
import oracle.javatools.parser.util.AsyncScheduler;
import oracle.javatools.parser.util.AsyncTask;
import oracle.jdeveloper.java.CacheSupport;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.java.util.SourceElementAsList;
import oracle.jdeveloper.model.JavaSourceNode;
import oracle.jdevimpl.java.JavaArb;
import oracle.jdevimpl.java.JavaParserPlugin;
import oracle.jdevimpl.java.editing.ImplOverCache;
import oracle.jdevimpl.java.editing.NavigationEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JavaImplOverPlugin2
implements EditorPlugin,
JavaParserPlugin.HelperClient,
GutterColumnListener,
ActiveViewListener {
    private static final String PLUGIN_KEY = JavaImplOverPlugin2.class.getName();
    public static final String COLUMN_NAME = "implements-overrides-column2";
    private BasicEditorPane editor;
    private GutterColumn column;
    private UpdaterTask updTask;
    private ImplOverCache _cache;
    private static AsyncScheduler updScheduler = new AsyncScheduler("ImplementsOverrideGutterUpdater", 30000);
    private static final int NAVIGATE_HIERARCHY_CMD_ID = Ide.findOrCreateCmdID((String)"JavaImplOverPlugin2.NAVIGATE_HIERARCHY_CMD_ID");

    private void $init$() {
        this.updTask = null;
        this._cache = null;
    }

    static {
        String commandName = JavaArb.getString(110);
        IdeAction navigateAction = IdeAction.get((int)NAVIGATE_HIERARCHY_CMD_ID, null, (String)commandName, (String)CodeMenuConstants.CATEGORY_CODE_MENU, null, null, null, (boolean)true);
        JavaNavigationController controller = new JavaNavigationController(null);
        navigateAction.addController((Controller)controller);
        KeyStrokeContextRegistry registry = Ide.getKeyStrokeContextRegistry();
        registry.addAcceleratorDefinitionFile(JavaImplOverPlugin2.class.getClassLoader(), "oracle/jdevimpl/java/editing/accelerators.xml");
    }

    public JavaImplOverPlugin2() {
        this.$init$();
    }

    @Override
    public void notifyCompileScheduled() {
        this.cancelUpdater();
    }

    @Override
    public void notifyParseFinished(JavaManager javaManager, SourceFile sourceFile, int changeId, int elapsedDelay) {
    }

    @Override
    public void notifyCompileFinished(JavaManager javaManager, SourceFile sourceFile, int changeId, int elapsedDelay) {
        this.scheduleUpdater(javaManager, sourceFile);
    }

    public void install(BasicEditorPane editor) {
        this.editor = editor;
        editor.putProperty(PLUGIN_KEY, (Object)this);
        CodeEditorGutter gutter = CodeEditor.getCodeEditor((BasicEditorPane)editor).getGutter();
        this.column = gutter.createGutterColumn(COLUMN_NAME, (GutterColumnListener)this);
        Icon icon1 = JavaArb.getIcon(289);
        Icon icon2 = JavaArb.getIcon(81);
        Icon icon3 = JavaArb.getIcon(361);
        int width = Math.max(icon1.getIconWidth(), Math.max(icon2.getIconWidth(), icon3.getIconWidth()));
        this.column.setReservedWidth(width);
        this.column.setLayoutConstraint("breakpoint", 1);
        JavaParserPlugin.attachHelperClient(editor, this);
        IdeMainWindow mainWindow = Ide.getMainWindow();
        if (mainWindow != null) {
            mainWindow.addActiveViewListener((ActiveViewListener)this);
        }
    }

    public void deinstall(BasicEditorPane editor) {
        this.cancelUpdater();
        JavaParserPlugin.detachHelperClient(editor, this);
        CodeEditorGutter gutter = CodeEditor.getCodeEditor((BasicEditorPane)editor).getGutter();
        if (gutter != null) {
            gutter.removeGutterColumn(this.column);
        }
        this.column = null;
        editor.putProperty(PLUGIN_KEY, null);
        this.editor = null;
        IdeMainWindow mainWindow = Ide.getMainWindow();
        if (mainWindow != null) {
            mainWindow.removeActiveViewListener((ActiveViewListener)this);
        }
    }

    private void clearGutterColumns() {
        if (this.column != null) {
            this.column.removeAllGutterMarks();
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleUpdater(JavaManager javaManager, SourceFile sourceFile) {
        UpdaterTask task = new UpdaterTask(javaManager, sourceFile, null);
        JavaImplOverPlugin2 javaImplOverPlugin2 = this;
        synchronized (javaImplOverPlugin2) {
            if (this.updTask != null) {
                updScheduler.cancelTask((AsyncTask)this.updTask);
            }
            this.updTask = task;
        }
        updScheduler.scheduleTask((AsyncTask)task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelUpdater() {
        UpdaterTask pendingTask;
        JavaImplOverPlugin2 javaImplOverPlugin2 = this;
        synchronized (javaImplOverPlugin2) {
            pendingTask = this.updTask;
            this.updTask = null;
        }
        if (pendingTask != null) {
            updScheduler.cancelTask((AsyncTask)pendingTask);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishUpdater(UpdaterTask task) {
        JavaImplOverPlugin2 javaImplOverPlugin2 = this;
        synchronized (javaImplOverPlugin2) {
            if (this.updTask == task) {
                this.updTask = null;
            }
        }
    }

    private synchronized ImplOverCache getCache(Project project, SourceFile updSourceFile) {
        ImplOverCache ret;
        URL projectUrl = project.getURL();
        URL url = updSourceFile.getURL();
        ImplOverCache cache = this._cache;
        if (cache != null && cache.isCacheFor(projectUrl, url, updSourceFile)) {
            ret = cache;
        } else {
            this._cache = ret = new ImplOverCache(projectUrl, url, updSourceFile);
        }
        return ret;
    }

    private void clearCache() {
        this._cache = null;
    }

    public void activeViewChanged(ActiveViewEvent e) {
        this.clearCache();
    }

    public void markMoved(GutterMark gutterMark, int oldLine, int newLine) {
    }

    public void markRemoved(GutterMark gutterMark, int deletedLine) {
    }

    public void markClicked(GutterMark gutterMark, int clickedLine, MouseEvent event) {
        this._markClicked(gutterMark);
    }

    private void _markClicked(GutterMark gutterMark) {
        List navigationEntries = (List)gutterMark.getUserData();
        if (navigationEntries.size() == 1) {
            NavigationEntry navigationEntry = (NavigationEntry)navigationEntries.get(0);
            navigationEntry.navigate();
        }
    }

    public String getMarkToolTip(GutterMark gutterMark, MouseEvent event) {
        StringBuilder buffer = new StringBuilder("<html>");
        List navigationEntries = (List)gutterMark.getUserData();
        int i = 0;
        while (i < navigationEntries.size()) {
            NavigationEntry navigationEntry = (NavigationEntry)navigationEntries.get(i);
            String tooltip = navigationEntry.getTooltip();
            if (i > 0) {
                buffer.append("<br>");
            }
            buffer.append(tooltip);
            ++i;
        }
        return buffer.toString();
    }

    static MultiMap<Integer, NavigationEntry> testFile(Project project, JavaManager javaManager, SourceFile sourceFile) {
        JavaImplOverPlugin2 plugin;
        MultiMap ret = null;
        JavaImplOverPlugin2 javaImplOverPlugin2 = plugin = new JavaImplOverPlugin2();
        javaImplOverPlugin2.getClass();
        UpdaterTask updaterTask = javaImplOverPlugin2.new UpdaterTask(javaManager, sourceFile, null);
        try {
            ret = UpdaterTask.mav$processFile(updaterTask, project, sourceFile);
        }
        catch (AsyncTask.CancelledException e) {
            e.printStackTrace();
        }
        catch (CancellationException e) {
            e.printStackTrace();
        }
        return ret;
    }

    static ImplOverCache mav$getCache(JavaImplOverPlugin2 javaImplOverPlugin2, Project project, SourceFile sourceFile) {
        return javaImplOverPlugin2.getCache(project, sourceFile);
    }

    static BasicEditorPane ra$editor(JavaImplOverPlugin2 javaImplOverPlugin2) {
        return javaImplOverPlugin2.editor;
    }

    static void mav$finishUpdater(JavaImplOverPlugin2 javaImplOverPlugin2, UpdaterTask updaterTask) {
        javaImplOverPlugin2.finishUpdater(updaterTask);
    }

    static int ra$NAVIGATE_HIERARCHY_CMD_ID() {
        return NAVIGATE_HIERARCHY_CMD_ID;
    }

    static GutterColumn ra$column(JavaImplOverPlugin2 javaImplOverPlugin2) {
        return javaImplOverPlugin2.column;
    }

    static void mav$clearGutterColumns(JavaImplOverPlugin2 javaImplOverPlugin2) {
        javaImplOverPlugin2.clearGutterColumns();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class UpdaterTask
    extends AsyncTask {
        private boolean updCancelled = false;
        private JavaManager updJavaManager;
        private SourceFile updSourceFile;

        private UpdaterTask(JavaManager javaManager, SourceFile sourceFile) {
            this.updJavaManager = javaManager;
            this.updSourceFile = sourceFile;
        }

        protected void requestCancelImpl() {
            this.updCancelled = true;
        }

        protected boolean isCancelledImpl() {
            return this.updCancelled;
        }

        protected Object runImpl() throws AsyncTask.CancelledException {
            try {
                this.bailIfCancelled();
                Context context = CodeEditor.getContext((BasicEditorPane)JavaImplOverPlugin2.ra$editor(JavaImplOverPlugin2.this));
                if (context == null) {
                    Object var13_2 = null;
                    return var13_2;
                }
                Project project = context.getProject();
                if (project == null) {
                    Object var14_4 = null;
                    return var14_4;
                }
                Node node = context.getNode();
                if (node == null) {
                    Object var15_6 = null;
                    return var15_6;
                }
                MultiMap items = new MultiMap();
                CacheSupport cacheSupport = this.updJavaManager.getCacheSupport();
                try {
                    cacheSupport.beginCacheUse();
                    TextBuffer textBuffer = this.updSourceFile.getTextBuffer();
                    LineMap lineMap = textBuffer.getLineMap();
                    List sourceClasses = SourceElementAsList.asList((SourceElement)this.updSourceFile, (int)3);
                    ImplOverCache cache = JavaImplOverPlugin2.mav$getCache(JavaImplOverPlugin2.this, project, this.updSourceFile);
                    int i = 0;
                    while (i < sourceClasses.size()) {
                        this.bailIfCancelled();
                        SourceClass sourceClass = (SourceClass)sourceClasses.get(i);
                        this.processClass(cache, project, sourceClass, lineMap, (MultiMap<Integer, NavigationEntry>)items);
                        ++i;
                    }
                }
                finally {
                    cacheSupport.endCacheUse();
                }
                this.bailIfCancelled();
                1 gutterSetter = new 1(this, items);
                SwingUtilities.invokeLater(gutterSetter);
                Object var17_17 = null;
                return var17_17;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                JavaImplOverPlugin2.mav$finishUpdater(JavaImplOverPlugin2.this, this);
                this.updSourceFile = null;
            }
        }

        private void processClass(ImplOverCache cache, Project project, SourceClass sourceClass, LineMap lineMap, MultiMap<Integer, NavigationEntry> items) throws AsyncTask.CancelledException {
            boolean isInterface = sourceClass.isInterface();
            Collection declaredMethods = sourceClass.getDeclaredMethods();
            Iterator itDeclaredMethods = declaredMethods.iterator();
            while (itDeclaredMethods.hasNext()) {
                SourceMethod sourceMethod;
                this.bailIfCancelled();
                JavaMethod javaMethod = (JavaMethod)itDeclaredMethods.next();
                if (javaMethod.isPrivate() || javaMethod.isStatic() || (sourceMethod = (SourceMethod)javaMethod.getSourceElement()) == null) continue;
                SourceName name = sourceMethod.getNameElement();
                int startOffset = name != null ? name.getStartOffset() : sourceMethod.getStartOffset();
                int methodLine = lineMap.getLineFromOffset(startOffset);
                List<JavaMethod> superMethods = cache.getSuperMethods(this.updJavaManager, javaMethod);
                int i = 0;
                while (i < superMethods.size()) {
                    JavaMethod superMethod = superMethods.get(i);
                    JavaClass owningClass = superMethod.getOwningClass();
                    String superQualifiedName = owningClass.getQualifiedName();
                    int formatId = owningClass.isInterface() ? 86 : 46;
                    String tooltip = MessageFormat.format(JavaArb.getString(formatId), superQualifiedName);
                    SourceMethod sourceSuperMethod = (SourceMethod)superMethod.getSourceElement();
                    if (sourceSuperMethod != null) {
                        NavigationEntry navigationEntry = new NavigationEntry(NavigationEntry.NavigationType.OVERRIDES_METHOD, tooltip, project, (SourceElement)sourceSuperMethod);
                        items.add((Object)methodLine, (Object)navigationEntry);
                    }
                    ++i;
                }
                List<JavaMethod> subMethods = cache.getSubMethods(project, this.updJavaManager, javaMethod);
                int i2 = 0;
                while (i2 < subMethods.size()) {
                    JavaMethod subMethod = subMethods.get(i2);
                    JavaClass owningClass = subMethod.getOwningClass();
                    SourceElement subSourceMethod = subMethod.getSourceElement();
                    if (subSourceMethod != null) {
                        String subQualifiedName = owningClass.getQualifiedName();
                        int formatId = isInterface ? 291 : 199;
                        String tooltip = MessageFormat.format(JavaArb.getString(formatId), subQualifiedName);
                        NavigationEntry navigationEntry = new NavigationEntry(NavigationEntry.NavigationType.OVERRIDDEN_METHOD, tooltip, project, subSourceMethod);
                        items.add((Object)methodLine, (Object)navigationEntry);
                    }
                    ++i2;
                }
            }
            SourceName nameElement = sourceClass.getNameElement();
            int line = -1;
            List<String> subClassNames = cache.getSubClassNames(project, (JavaClass)sourceClass);
            for (String subClassName : subClassNames) {
                this.bailIfCancelled();
                SourceClass subSourceClass = this.updJavaManager.getSourceClass(subClassName);
                if (subSourceClass == null) continue;
                SourceName subNameElement = subSourceClass.getNameElement();
                int formatId = isInterface && !subSourceClass.isInterface() ? 135 : 134;
                String format = JavaArb.getString(formatId);
                String tooltip = MessageFormat.format(format, subSourceClass.getQualifiedName());
                NavigationEntry navigationEntry = new NavigationEntry(NavigationEntry.NavigationType.EXTENDING_CLASS, tooltip, project, (SourceElement)subNameElement);
                if (line == -1) {
                    int startOffset = nameElement == null ? sourceClass.getStartOffset() : nameElement.getStartOffset();
                    line = lineMap.getLineFromOffset(startOffset);
                }
                items.add((Object)line, (Object)navigationEntry);
            }
            List<String> superClassNames = cache.getSuperClassNames(this.updJavaManager, (JavaClass)sourceClass);
            for (String superClassName : superClassNames) {
                SourceClass superSourceClass;
                if ("java.lang.Object".equals(superClassName) && (!sourceClass.isAnonymous() || superClassNames.size() != 1) || (superSourceClass = this.updJavaManager.getSourceClass(superClassName)) == null) continue;
                SourceName superNameElement = superSourceClass.getNameElement();
                int formatId = superSourceClass.isInterface() ? 114 : 260;
                String format = JavaArb.getString(formatId);
                String tooltip = MessageFormat.format(format, superSourceClass.getQualifiedName());
                NavigationEntry navigationEntry = new NavigationEntry(NavigationEntry.NavigationType.EXTENDS_CLASS, tooltip, project, (SourceElement)superNameElement);
                if (line == -1) {
                    int startOffset = nameElement == null ? sourceClass.getStartOffset() : nameElement.getStartOffset();
                    line = lineMap.getLineFromOffset(startOffset);
                }
                items.add((Object)line, (Object)navigationEntry);
            }
        }

        private MultiMap<Integer, NavigationEntry> processFile(Project project, SourceFile sourceFile) throws AsyncTask.CancelledException {
            List sourceClasses = SourceElementAsList.asList((SourceElement)sourceFile, (int)3);
            ImplOverCache cache = JavaImplOverPlugin2.mav$getCache(JavaImplOverPlugin2.this, project, this.updSourceFile);
            TextBuffer textBuffer = sourceFile.getTextBuffer();
            LineMap lineMap = textBuffer.getLineMap();
            MultiMap entries = new MultiMap();
            for (SourceClass sourceClass : sourceClasses) {
                this.bailIfCancelled();
                this.processClass(cache, project, sourceClass, lineMap, (MultiMap<Integer, NavigationEntry>)entries);
            }
            return entries;
        }

        UpdaterTask(JavaManager javaManager, SourceFile sourceFile, 1 var4_4) {
            this(javaManager, sourceFile);
        }

        static MultiMap mav$processFile(UpdaterTask updaterTask, Project project, SourceFile sourceFile) {
            return updaterTask.processFile(project, sourceFile);
        }

        final class oracle.jdevimpl.java.editing.JavaImplOverPlugin2$UpdaterTask$1
        implements Runnable {
            private final /* synthetic */ MultiMap v$items;
            final /* synthetic */ UpdaterTask this$0;

            public void run() {
                if (this.this$0.isCancelledImpl() || JavaImplOverPlugin2.ra$column(this.this$0.JavaImplOverPlugin2.this) == null) {
                    return;
                }
                JavaImplOverPlugin2.mav$clearGutterColumns(this.this$0.JavaImplOverPlugin2.this);
                Set lines = this.v$items.keySet();
                for (Integer line : lines) {
                    List navigationEntries = this.v$items.get((Object)line);
                    int options = 1;
                    if (navigationEntries.size() > 1) {
                        options |= 0x10000;
                    }
                    boolean goesUp = false;
                    boolean goesDown = false;
                    for (NavigationEntry navigationEntry : navigationEntries) {
                        switch (1.$sm$oracle$jdevimpl$java$editing$NavigationEntry$NavigationType[navigationEntry.getNavigationType().ordinal()]) {
                            case 1: 
                            case 2: {
                                goesDown = true;
                                break;
                            }
                            case 3: 
                            case 4: {
                                goesUp = true;
                            }
                        }
                    }
                    int iconId = goesUp ? (goesDown ? 361 : 289) : 81;
                    Icon icon = JavaArb.getIcon(iconId);
                    GutterMark mark = JavaImplOverPlugin2.ra$column(this.this$0.JavaImplOverPlugin2.this).addGutterMark(line + 1, icon, null, 3000, options);
                    mark.setUserData((Object)navigationEntries);
                }
            }

            public oracle.jdevimpl.java.editing.JavaImplOverPlugin2$UpdaterTask$1(UpdaterTask updaterTask, MultiMap multiMap) {
                this.v$items = multiMap;
                this.this$0 = updaterTask;
            }

            static class 1 {
                static final /* synthetic */ int[] $sm$oracle$jdevimpl$java$editing$NavigationEntry$NavigationType;

                static {
                    int[] nArray = new int[NavigationEntry.NavigationType.values().length];
                    $sm$oracle$jdevimpl$java$editing$NavigationEntry$NavigationType = nArray;
                    try {
                        nArray[NavigationEntry.NavigationType.EXTENDING_CLASS.ordinal()] = 1;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {}
                    try {
                        1.$sm$oracle$jdevimpl$java$editing$NavigationEntry$NavigationType[NavigationEntry.NavigationType.OVERRIDDEN_METHOD.ordinal()] = 2;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {}
                    try {
                        1.$sm$oracle$jdevimpl$java$editing$NavigationEntry$NavigationType[NavigationEntry.NavigationType.EXTENDS_CLASS.ordinal()] = 3;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {}
                    try {
                        1.$sm$oracle$jdevimpl$java$editing$NavigationEntry$NavigationType[NavigationEntry.NavigationType.OVERRIDES_METHOD.ordinal()] = 4;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {}
                }
            }
        }
    }

    private static final class JavaNavigationController
    implements Controller {
        public boolean update(IdeAction action, Context context) {
            return action.getCommandId() == JavaImplOverPlugin2.ra$NAVIGATE_HIERARCHY_CMD_ID();
        }

        public boolean handleEvent(IdeAction action, Context context) {
            if (!(context.getNode() instanceof JavaSourceNode)) {
                return false;
            }
            int cmdId = action.getCommandId();
            if (cmdId == JavaImplOverPlugin2.ra$NAVIGATE_HIERARCHY_CMD_ID()) {
                this.navigate(context);
                return true;
            }
            return false;
        }

        private void navigate(Context context) {
            int line;
            CodeEditor editor;
            GutterColumn column;
            GutterMark[] marks;
            View view;
            if (context != null && (view = context.getView()) instanceof CodeEditor && (marks = (column = (editor = (CodeEditor)view).getGutter().lookupGutterColumn(JavaImplOverPlugin2.COLUMN_NAME)).lookupGutterMarks(line = editor.getCaretLine())) != null && marks.length > 0) {
                List navigationEntries = (List)marks[0].getUserData();
                if (navigationEntries.size() == 1) {
                    ((NavigationEntry)navigationEntries.get(0)).navigate();
                } else if (navigationEntries.size() > 1) {
                    MouseEvent eventToUse = new MouseEvent((Component)editor.getGutter(), 1, System.currentTimeMillis(), 0, 0, 0, 1, true, 1);
                    editor.getGutter().showMarkDropdownMenu(eventToUse, marks[0], line);
                }
            }
        }

        private JavaNavigationController() {
        }

        JavaNavigationController(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }
}

