/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.editing;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.ide.controls.ItemSelectableTracker;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.ApplyListener;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.editor.EditorProperties;
import oracle.jdevimpl.java.JavaArb;
import oracle.jdevimpl.java.editing.JavaOptions;

public final class JavaOptionsPanel
extends DefaultTraversablePanel
implements ApplyListener {
    private JCheckBox checkbox_autoAsterisk;
    private JCheckBox checkbox_autoCommentEnd;
    private JCheckBox checkbox_autoGenDocComments;
    private JCheckBox checkbox_autoSplitSingleLineComment;
    private JCheckBox checkbox_autoQuoteEnd;
    private JCheckBox checkbox_autoQuoteExtend;
    private JCheckBox checkbox_autoParenEnd;
    private JCheckBox checkbox_autoBraceEnd;
    private JCheckBox checkbox_moveOpenBrace;
    private JCheckBox checkbox_alignCloseBrace;

    public JavaOptionsPanel() {
        this.setHelpID("f1_idedidesetjava_html");
        this.setLayout(new GridBagLayout());
        this.initializeComponent();
    }

    public void onEntry(TraversableContext tc) {
        JavaOptions options = this.findOptions(tc);
        this.loadSettingsFrom(options);
    }

    public void onExit(TraversableContext tc) throws TraversalException {
        JavaOptions options = this.findOptions(tc);
        this.saveSettingsTo(options);
    }

    private JavaOptions findOptions(TraversableContext tc) {
        JavaOptions options = (JavaOptions)tc.find("JavaEditingOptions");
        return options;
    }

    public void apply(ApplyEvent event) {
        TraversableContext tc = (TraversableContext)event.getSource();
        JavaOptions options = this.findOptions(tc);
        JavaOptionsPanel.applyOptions(options);
    }

    public void cancel(ApplyEvent e) {
    }

    public static void applyOptions(JavaOptions options) {
        EditorProperties properties = EditorProperties.getProperties();
        boolean autoAsterisk = options.getAutoAsterisk();
        properties.putBooleanProperty("java-auto-asterisk", autoAsterisk);
        boolean autoCommentEnd = options.getAutoCommentEnd();
        properties.putBooleanProperty("java-auto-comment-end", autoCommentEnd);
        boolean autoGenDocComments = options.getAutoGenDocComments();
        properties.putBooleanProperty("java-auto-gen-doc-comments", autoGenDocComments);
        boolean autoSplitSingleLineComment = options.getAutoSplitSingleLineComment();
        properties.putBooleanProperty("auto-split-single-line-comment", autoSplitSingleLineComment);
        boolean autoBraceEnd = options.getAutoBraceEnd();
        properties.putBooleanProperty("java-auto-brace-end", autoBraceEnd);
        boolean moveOpenBrace = options.getMoveOpenBrace();
        properties.putBooleanProperty("java-move-open-brace", moveOpenBrace);
        boolean alignCloseBrace = options.getAlignCloseBrace();
        properties.putBooleanProperty("java-align-close-brace", alignCloseBrace);
        boolean autoQuoteEnd = options.getAutoQuoteEnd();
        properties.putBooleanProperty("java-auto-quote-end", autoQuoteEnd);
        boolean autoQuoteExtend = options.getAutoQuoteExtend();
        properties.putBooleanProperty("java-auto-quote-extend", autoQuoteExtend);
        boolean autoParenEnd = options.getAutoParenEnd();
        properties.putBooleanProperty("java-auto-paren-end", autoParenEnd);
    }

    void loadSettingsFrom(JavaOptions options) {
        boolean autoAsterisk = options.getAutoAsterisk();
        boolean autoCommentEnd = options.getAutoCommentEnd();
        boolean autoGenDocComments = options.getAutoGenDocComments();
        boolean autoSplitSingleLineComment = options.getAutoSplitSingleLineComment();
        boolean autoBraceEnd = options.getAutoBraceEnd();
        boolean moveOpenBrace = options.getMoveOpenBrace();
        boolean alignCloseBrace = options.getAlignCloseBrace();
        boolean autoQuoteEnd = options.getAutoQuoteEnd();
        boolean autoQuoteExtend = options.getAutoQuoteExtend();
        boolean autoParenEnd = options.getAutoParenEnd();
        this.checkbox_autoAsterisk.setSelected(autoAsterisk);
        this.checkbox_autoCommentEnd.setSelected(autoCommentEnd);
        this.checkbox_autoGenDocComments.setSelected(autoGenDocComments);
        this.checkbox_autoGenDocComments.setEnabled(autoCommentEnd);
        this.checkbox_autoSplitSingleLineComment.setSelected(autoSplitSingleLineComment);
        this.checkbox_autoBraceEnd.setSelected(autoBraceEnd);
        this.checkbox_moveOpenBrace.setSelected(moveOpenBrace);
        this.checkbox_alignCloseBrace.setSelected(alignCloseBrace);
        this.checkbox_autoQuoteEnd.setSelected(autoQuoteEnd);
        this.checkbox_autoQuoteExtend.setSelected(autoQuoteExtend);
        this.checkbox_autoParenEnd.setSelected(autoParenEnd);
    }

    void saveSettingsTo(JavaOptions options) throws TraversalException {
        boolean autoAsterisk = this.checkbox_autoAsterisk.isSelected();
        boolean autoCommentEnd = this.checkbox_autoCommentEnd.isSelected();
        boolean autoGenDocComments = autoCommentEnd && this.checkbox_autoGenDocComments.isSelected();
        boolean autoSplitSingleLineComment = this.checkbox_autoSplitSingleLineComment.isSelected();
        boolean autoBraceEnd = this.checkbox_autoBraceEnd.isSelected();
        boolean moveOpenBrace = this.checkbox_moveOpenBrace.isSelected();
        boolean alignCloseBrace = this.checkbox_alignCloseBrace.isSelected();
        boolean autoQuoteEnd = this.checkbox_autoQuoteEnd.isSelected();
        boolean autoQuoteExtend = this.checkbox_autoQuoteExtend.isSelected();
        boolean autoParenEnd = this.checkbox_autoParenEnd.isSelected();
        options.setAutoAsterisk(autoAsterisk);
        options.setAutoCommentEnd(autoCommentEnd);
        options.setAutoGenDocComments(autoGenDocComments);
        options.setAutoSplitSingleLineComment(autoSplitSingleLineComment);
        options.setAutoBraceEnd(autoBraceEnd);
        options.setMoveOpenBrace(moveOpenBrace);
        options.setAlignCloseBrace(alignCloseBrace);
        options.setAutoQuoteEnd(autoQuoteEnd);
        options.setAutoQuoteExtend(autoQuoteExtend);
        options.setAutoParenEnd(autoParenEnd);
    }

    private void initializeComponent() {
        String autoAsteriskText = JavaArb.getString(140);
        this.checkbox_autoAsterisk = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_autoAsterisk, (String)autoAsteriskText);
        String autoCommentEndText = JavaArb.getString(167);
        this.checkbox_autoCommentEnd = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_autoCommentEnd, (String)autoCommentEndText);
        String autoGenDocComments = JavaArb.getString(54);
        this.checkbox_autoGenDocComments = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_autoGenDocComments, (String)autoGenDocComments);
        Component[] dependents = new Component[]{this.checkbox_autoGenDocComments};
        ItemSelectableTracker tracker = new ItemSelectableTracker((ItemSelectable)this.checkbox_autoCommentEnd, dependents);
        String autoSplitSingleLineComments = JavaArb.getString(353);
        this.checkbox_autoSplitSingleLineComment = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_autoSplitSingleLineComment, (String)autoSplitSingleLineComments);
        String autoQuoteEnd = JavaArb.getString(141);
        this.checkbox_autoQuoteEnd = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_autoQuoteEnd, (String)autoQuoteEnd);
        String autoQuoteExtend = JavaArb.getString(126);
        this.checkbox_autoQuoteExtend = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_autoQuoteExtend, (String)autoQuoteExtend);
        String autoParenEnd = JavaArb.getString(181);
        this.checkbox_autoParenEnd = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_autoParenEnd, (String)autoParenEnd);
        String newOpenBraceText = JavaArb.getString(335);
        String autoBraceEndText = JavaArb.getString(345);
        JLabel label_newOpenBrace = new JLabel(newOpenBraceText);
        this.checkbox_autoBraceEnd = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_autoBraceEnd, (String)autoBraceEndText);
        String moveOpenBraceText = JavaArb.getString(258);
        this.checkbox_moveOpenBrace = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_moveOpenBrace, (String)moveOpenBraceText);
        String alignCloseBraceText = JavaArb.getString(216);
        this.checkbox_alignCloseBrace = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_alignCloseBrace, (String)alignCloseBraceText);
        Insets defaultInsets = new Insets(2, 5, 2, 5);
        Insets indentedInsets = new Insets(0, 30, 2, 5);
        Insets emptyInsets = new Insets(0, 0, 0, 0);
        JPanel panel_comment = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, defaultInsets, 0, 0);
        panel_comment.add((Component)this.checkbox_autoAsterisk, constraints);
        constraints = new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, defaultInsets, 0, 0);
        panel_comment.add((Component)this.checkbox_autoCommentEnd, constraints);
        constraints = new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 0, indentedInsets, 0, 0);
        panel_comment.add((Component)this.checkbox_autoGenDocComments, constraints);
        constraints = new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 0, indentedInsets, 0, 0);
        panel_comment.add((Component)this.checkbox_autoSplitSingleLineComment, constraints);
        JPanel panel_quote = new JPanel(new GridBagLayout());
        constraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, defaultInsets, 0, 0);
        panel_quote.add((Component)this.checkbox_autoParenEnd, constraints);
        constraints = new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, defaultInsets, 0, 0);
        panel_quote.add((Component)this.checkbox_autoQuoteEnd, constraints);
        constraints = new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 0, defaultInsets, 0, 0);
        panel_quote.add((Component)this.checkbox_autoQuoteExtend, constraints);
        JPanel panel_brace = new JPanel(new GridBagLayout());
        constraints = new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 17, 0, defaultInsets, 0, 0);
        panel_brace.add((Component)label_newOpenBrace, constraints);
        constraints = new GridBagConstraints(0, 5, 1, 1, 1.0, 0.0, 17, 0, indentedInsets, 0, 0);
        panel_brace.add((Component)this.checkbox_autoBraceEnd, constraints);
        constraints = new GridBagConstraints(0, 6, 1, 1, 1.0, 0.0, 17, 0, indentedInsets, 0, 0);
        panel_brace.add((Component)this.checkbox_moveOpenBrace, constraints);
        constraints = new GridBagConstraints(0, 7, 1, 1, 1.0, 0.0, 17, 0, defaultInsets, 0, 0);
        panel_brace.add(Box.createVerticalStrut(5), constraints);
        constraints = new GridBagConstraints(0, 8, 1, 1, 1.0, 0.0, 17, 0, defaultInsets, 0, 0);
        panel_brace.add((Component)this.checkbox_alignCloseBrace, constraints);
        constraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 1, defaultInsets, 0, 0);
        this.add(panel_comment, constraints);
        constraints = new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 1, defaultInsets, 0, 0);
        this.add(Box.createVerticalStrut(5), constraints);
        constraints = new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 1, defaultInsets, 0, 0);
        this.add(panel_quote, constraints);
        constraints = new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 1, defaultInsets, 0, 0);
        this.add(Box.createVerticalStrut(5), constraints);
        constraints = new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 17, 1, defaultInsets, 0, 0);
        this.add(panel_brace, constraints);
        constraints = new GridBagConstraints(0, 5, 1, 1, 1.0, 1.0, 17, 1, emptyInsets, 0, 0);
        this.add(Box.createGlue(), constraints);
    }
}

