/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.editing;

import java.awt.Color;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.UIManager;
import oracle.ide.ceditor.ScrollTipPlugin;
import oracle.ide.ceditor.ScrollTipRenderer;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.folding.CodeExpansionEvent;
import oracle.javatools.editor.folding.CodeExpansionListener;
import oracle.javatools.editor.folding.CodeFoldingMargin;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.ui.simplestyle.StyledLabel;
import oracle.javatools.ui.simplestyle.StyledTextAttribute;
import oracle.javatools.ui.simplestyle.StyledTextModel;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdevimpl.java.JavaParserPlugin;

public class JavaScrollTipPlugin
extends ScrollTipPlugin
implements CodeExpansionListener,
JavaParserPlugin.HelperClient {
    private List<ScrollInfo> infoList;
    private CodeFoldingMargin foldingMargin;
    private volatile NameFetcherThread nameFetcherThread;
    private static StyledTextAttribute BOLD_ATTR = new StyledTextAttribute(UIManager.getFont("Label.font").deriveFont(1), null);
    private static StyledTextAttribute NORMAL_ATTR = new StyledTextAttribute(UIManager.getFont("Label.font"), null);

    private void $init$() {
        this.infoList = new LinkedList<ScrollInfo>();
    }

    public void install(BasicEditorPane editor) {
        super.install(editor);
        this.setRenderer(new JavaScrollTipRenderer());
        JavaParserPlugin.attachHelperClient(editor, this);
        Object obj = editor.getProperty("code-folding-margin");
        if (obj != null) {
            this.foldingMargin = (CodeFoldingMargin)obj;
            this.foldingMargin.addCodeExpansionListener((CodeExpansionListener)this);
        }
    }

    public void deinstall(BasicEditorPane editor) {
        super.deinstall(editor);
        JavaParserPlugin.detachHelperClient(editor, this);
        if (this.foldingMargin != null) {
            this.foldingMargin.removeCodeExpansionListener((CodeExpansionListener)this);
        }
    }

    public void notifyCompileScheduled() {
        this.infoList.clear();
    }

    public void notifyParseFinished(JavaManager javaManager, SourceFile sourceFile, int changeId, int elapsedDelay) {
    }

    public void addClassMethods(SourceClass sourceClass, String indent) throws InterruptedException {
        for (JavaMethod method : sourceClass.getDeclaredConstructors()) {
            SourceMethod sourceMethod = (SourceMethod)method.getSourceElement();
            if (sourceMethod == null) continue;
            StyledTextModel model = new StyledTextModel(indent + JavaScrollTipPlugin.getMethodName((JavaMethod)sourceMethod), BOLD_ATTR);
            model.addText(JavaScrollTipPlugin.getParams((JavaMethod)sourceMethod) + JavaScrollTipPlugin.getReturn((JavaMethod)sourceMethod), NORMAL_ATTR);
            ScrollInfo info = new ScrollInfo(model, sourceMethod.getStartOffset(), sourceMethod.getEndOffset());
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
            this.infoList.add(info);
        }
        for (JavaMethod method : sourceClass.getDeclaredMethods()) {
            SourceMethod sourceMethod = (SourceMethod)method.getSourceElement();
            if (sourceMethod == null) continue;
            StyledTextModel model = new StyledTextModel(indent + JavaScrollTipPlugin.getMethodName((JavaMethod)sourceMethod), BOLD_ATTR);
            model.addText(JavaScrollTipPlugin.getParams((JavaMethod)sourceMethod) + JavaScrollTipPlugin.getReturn((JavaMethod)sourceMethod), NORMAL_ATTR);
            ScrollInfo info = new ScrollInfo(model, sourceMethod.getStartOffset(), sourceMethod.getEndOffset());
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
            this.infoList.add(info);
        }
        List classes = sourceClass.getSourceClasses();
        for (SourceClass aClass : (Collection)classes) {
            StyledTextModel model = new StyledTextModel(indent + "class ", NORMAL_ATTR);
            model.addText(aClass.getName(), BOLD_ATTR);
            ScrollInfo info = new ScrollInfo(model, aClass.getSourceBody().getStartOffset(), aClass.getSourceBody().getEndOffset());
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
            this.infoList.add(info);
            this.addClassMethods(aClass, indent + "    ");
        }
    }

    public void notifyCompileFinished(JavaManager javaManager, SourceFile sourceFile, int changeId, int elapsedDelay) {
        if (this.nameFetcherThread != null) {
            this.tryFetchInterrupt();
        } else {
            this.startFetcherThread(sourceFile);
        }
    }

    private void tryFetchInterrupt() {
        try {
            this.nameFetcherThread.interrupt();
        }
        catch (NullPointerException npe) {
            this.updateInfoVisibility();
        }
    }

    private synchronized void startFetcherThread(SourceFile sourceFile) {
        if (this.nameFetcherThread != null) {
            return;
        }
        this.infoList.clear();
        this.nameFetcherThread = new NameFetcherThread(sourceFile);
        this.nameFetcherThread.start();
    }

    public static String getMethodName(JavaMethod javaMethod) {
        return javaMethod.isConstructor() ? javaMethod.getOwningClass().getName() : javaMethod.getName();
    }

    public static String getParams(JavaMethod javaMethod) {
        StringBuffer sb = new StringBuffer("(");
        if (javaMethod.getParameterTypes().length > 0) {
            JavaType[] javaTypeArray = javaMethod.getParameterTypes();
            int n = 0;
            while (n < javaTypeArray.length) {
                JavaType paramType = javaTypeArray[n];
                if (paramType != null) {
                    sb.append(paramType.getName());
                    sb.append(", ");
                }
                ++n;
            }
            if (sb.length() > 5) {
                sb.delete(sb.length() - 2, sb.length());
            }
        }
        sb.append(")");
        return sb.toString();
    }

    public static String getReturn(JavaMethod javaMethod) {
        return javaMethod.getReturnType() != null ? " : " + javaMethod.getReturnType().getName() : " : void";
    }

    private void updateInfoVisibility() {
        if (this.foldingMargin != null) {
            try {
                for (ScrollInfo info : this.infoList) {
                    boolean bl = this.foldingMargin.getModel() == null ? true : (info.visible = this.foldingMargin.getLargestCollapsedBlock(this.foldingMargin.getModel(), this.foldingMargin.getModel().getRoot(), info.startOffset) == null);
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                // empty catch block
            }
        }
    }

    public void codeExpanded(CodeExpansionEvent event) {
        if (this.nameFetcherThread == null) {
            this.updateInfoVisibility();
        } else {
            this.tryFetchInterrupt();
        }
    }

    public void codeCollapsed(CodeExpansionEvent event) {
        if (this.nameFetcherThread == null) {
            this.updateInfoVisibility();
        } else {
            this.tryFetchInterrupt();
        }
    }

    public JavaScrollTipPlugin() {
        this.$init$();
    }

    static List ra$infoList(JavaScrollTipPlugin javaScrollTipPlugin) {
        return javaScrollTipPlugin.infoList;
    }

    static void mav$updateInfoVisibility(JavaScrollTipPlugin javaScrollTipPlugin) {
        javaScrollTipPlugin.updateInfoVisibility();
    }

    static void wa$nameFetcherThread(JavaScrollTipPlugin javaScrollTipPlugin, NameFetcherThread nameFetcherThread) {
        javaScrollTipPlugin.nameFetcherThread = nameFetcherThread;
    }

    static void mav$startFetcherThread(JavaScrollTipPlugin javaScrollTipPlugin, SourceFile sourceFile) {
        javaScrollTipPlugin.startFetcherThread(sourceFile);
    }

    private class JavaScrollTipRenderer
    extends JList
    implements ScrollTipRenderer {
        private StyledLabel label;

        private void $init$() {
            this.label = new StyledLabel();
        }

        public JavaScrollTipRenderer() {
            this.$init$();
            this.setBackground(Color.WHITE);
            this.setBorder(BorderFactory.createLineBorder(Color.DARK_GRAY, 1));
            this.setOpaque(true);
        }

        public JComponent getRenderer(BasicEditorPane editor, int startOffset, int endOffset) {
            StyledTextModel styleModel = new StyledTextModel();
            boolean firstMethod = true;
            int i = 0;
            int j = 0;
            while (j < JavaScrollTipPlugin.ra$infoList(JavaScrollTipPlugin.this).size()) {
                try {
                    ScrollInfo info = (ScrollInfo)JavaScrollTipPlugin.ra$infoList(JavaScrollTipPlugin.this).get(j);
                    if (info.visible && info.endOffset >= startOffset && info.startOffset <= endOffset) {
                        ++i;
                        if (!firstMethod) {
                            styleModel.addLineBreak();
                        }
                        firstMethod = false;
                        styleModel.append(info.model);
                    }
                }
                catch (IndexOutOfBoundsException e) {
                    JComponent jComponent = null;
                    return jComponent;
                }
                ++j;
            }
            if (firstMethod) {
                return null;
            }
            this.label.setStyleModel(styleModel);
            return this.label;
        }
    }

    private class ScrollInfo {
        StyledTextModel model;
        int startOffset;
        int endOffset;
        boolean visible;

        ScrollInfo(StyledTextModel model, int sOff, int eOff) {
            this.$init$();
            this.model = model;
            this.startOffset = sOff;
            this.endOffset = eOff;
        }

        private void $init$() {
            this.visible = true;
        }
    }

    private class NameFetcherThread
    extends Thread {
        private SourceFile sourceFile;

        public NameFetcherThread(SourceFile sourceFile) {
            super("Scroll-Name-fetcher");
            this.sourceFile = sourceFile;
        }

        public void run() {
            try {
                SourceClass sourceClass = this.sourceFile.getSourcePrimaryClass();
                if (sourceClass != null) {
                    JavaScrollTipPlugin.this.addClassMethods(sourceClass, "");
                }
                JavaScrollTipPlugin.mav$updateInfoVisibility(JavaScrollTipPlugin.this);
            }
            catch (InterruptedException e) {
                JavaScrollTipPlugin.wa$nameFetcherThread(JavaScrollTipPlugin.this, null);
                JavaScrollTipPlugin.mav$startFetcherThread(JavaScrollTipPlugin.this, this.sourceFile);
                return;
            }
            JavaScrollTipPlugin.wa$nameFetcherThread(JavaScrollTipPlugin.this, null);
        }
    }
}

