/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.editing;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.text.BadLocationException;
import javax.swing.undo.UndoableEdit;
import oracle.ide.Context;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.options.EditorOptions;
import oracle.ide.config.Preferences;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.model.Project;
import oracle.ide.util.Assert;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.OffsetMark;
import oracle.javatools.buffer.ReadOnlyException;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.clipboard.ClipboardStack;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.editor.BasicCaret;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditDescriptor;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.EditorSelectionWrap;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceImport;
import oracle.javatools.parser.java.v2.model.SourceLexicalComment;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceLiteralExpression;
import oracle.javatools.parser.java.v2.util.Formatting;
import oracle.javatools.parser.java.v2.write.SourceSavepoint;
import oracle.javatools.parser.java.v2.write.SourceTransaction;
import oracle.javatools.resource.BundleHelper;
import oracle.jdeveloper.audit.transform.UndoableEditCommand;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdevimpl.audit.java.JavaHelper;
import oracle.jdevimpl.java.Context2ParserHelper;
import oracle.jdevimpl.refactoring.util.RichBuffer;
import oracle.jdevimpl.refactoring.util.SourceFormatUtilities;

final class JavaSmartClipboard {
    private static final EditDescriptor cutDescriptor;
    private static final int LOC_OUTSIDE_COMMENT = 0;
    private static final int LOC_IN_LINE_COMMENT = 1;
    private static final int LOC_IN_REGULAR_COMMENT = 2;

    static {
        BundleHelper resources = EditorProperties.getEditorBundle();
        String cutName = resources.getString("UNDO_CUT");
        cutDescriptor = new EditDescriptor(cutName);
    }

    static boolean invokeAction(BasicEditorPane editor, String actionKey) {
        if (editor != null && (actionKey.equals("copy-to-clipboard") || actionKey.equals("cut-to-clipboard") || actionKey.equals("extended-paste-from-clipboard") || actionKey.equals("paste-from-clipboard"))) {
            if (editor.getCaret() instanceof BasicCaret && !(((BasicCaret)editor.getCaret()).getEditorSelection() instanceof EditorSelectionWrap)) {
                return false;
            }
            BasicDocument document = (BasicDocument)editor.getDocument();
            try {
                if (actionKey.equals("cut-to-clipboard")) {
                    document.writeLock();
                    try {
                        if (editor.makeEditable()) {
                            JavaSmartClipboard.cut(editor, document);
                        } else {
                            JavaSmartClipboard.beep(editor);
                        }
                        boolean bl = true;
                        return bl;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        document.writeUnlock();
                    }
                }
                if (actionKey.equals("copy-to-clipboard")) {
                    JavaSmartClipboard.copy(editor, document);
                    boolean bl = true;
                    return bl;
                }
                if (actionKey.equals("paste-from-clipboard")) {
                    document.writeLock();
                    try {
                        if (editor.makeEditable()) {
                            JavaSmartClipboard.paste(editor, document);
                        } else {
                            JavaSmartClipboard.beep(editor);
                        }
                        boolean bl = true;
                        return bl;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        document.writeUnlock();
                    }
                }
                if (actionKey.equals("extended-paste-from-clipboard")) {
                    document.writeLock();
                    try {
                        if (ClipboardStack.adjustCurrentClipboard()) {
                            if (editor.makeEditable()) {
                                JavaSmartClipboard.paste(editor, document);
                            } else {
                                JavaSmartClipboard.beep(editor);
                            }
                        }
                        boolean bl = true;
                        return bl;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        document.writeUnlock();
                    }
                }
                boolean bl = false;
                return bl;
            }
            catch (ReadOnlyException readOnlyException) {
            }
            catch (RuntimeException e) {
                System.out.println("Warning, runtime exception caught: " + e);
                e.printStackTrace();
            }
        }
        return false;
    }

    private static void beep(BasicEditorPane editor) {
        Toolkit toolkit = editor.getToolkit();
        toolkit.beep();
    }

    private static boolean isCutCopyLineEnabled(BasicEditorPane editor) {
        return editor.getBooleanProperty("cut-copy-line");
    }

    private static boolean isImportsEnabled(BasicEditorPane editor) {
        return editor.getBooleanProperty("smart-copy-paste");
    }

    private static boolean isIndentEnabled(BasicEditorPane editor) {
        return editor.getBooleanProperty("autoindent-copy-paste");
    }

    private static boolean isEscapeStringEnabled(BasicEditorPane editor) {
        return editor.getBooleanProperty("escape-string-paste");
    }

    private static SourceFile getSourceFile(BasicEditorPane editor) {
        Context context = CodeEditor.getContext((BasicEditorPane)editor);
        Context2ParserHelper helper = Context2ParserHelper.createHelper(context);
        return helper.getSourceFile();
    }

    private static void copy(BasicEditorPane editor, BasicDocument document) {
        document.readLock();
        try {
            boolean alreadyHasSelection;
            int start = editor.getSelectionStart();
            int end = editor.getSelectionEnd();
            boolean bl = alreadyHasSelection = start != end;
            if (start == end && JavaSmartClipboard.isCutCopyLineEnabled(editor)) {
                int offset = editor.getCaretPosition();
                LineMap lineMap = document.getLineMap();
                int currentLine = lineMap.getLineFromOffset(offset);
                start = lineMap.getLineStartOffset(currentLine);
                end = lineMap.getLineEndOffset(currentLine);
            }
            if (start != end) {
                JavaSmartClipboard.fillClipboard(editor, document, start, end);
                if (!alreadyHasSelection) {
                    editor.setCaretPosition(end);
                    editor.moveCaretPosition(start);
                }
            }
        }
        finally {
            document.readUnlock();
        }
    }

    private static void fillClipboard(BasicEditorPane editor, BasicDocument document, int start, int end) {
        SourceFile sourceFile;
        if (JavaSmartClipboard.isIndentEnabled(editor)) {
            String ctext = "";
            try {
                ctext = document.getText(start, end - start);
                if (ctext.indexOf(10) != -1) {
                    String oldIdent = SourceFormatUtilities.getIndentation(editor, start);
                    start -= oldIdent.length();
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        boolean inString = JavaSmartClipboard.isEscapeStringEnabled(editor) && JavaSmartClipboard.isInStringLiteral(editor, start, end, true);
        boolean notDone = true;
        if (JavaSmartClipboard.isImportsEnabled(editor) && (sourceFile = JavaSmartClipboard.getSourceFile(editor)) != null) {
            RichBuffer data = RichBuffer.createJotRichBuffer(sourceFile, start, end);
            if (inString) {
                data.setText(JavaSmartClipboard.unEscapeString(data.getText()));
            }
            JavaSmartClipboard.setClipboardContents(editor, data);
            notDone = false;
        }
        if (notDone) {
            String data = "";
            try {
                data = document.getText(start, end - start);
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (inString) {
                data = JavaSmartClipboard.unEscapeString(data);
            }
            StringSelection contents = new StringSelection(data);
            JavaSmartClipboard.setClipboardContents(editor, contents);
        }
    }

    private static void cut(BasicEditorPane editor, BasicDocument document) {
        Toolkit toolkit = editor.getToolkit();
        if (editor.isEditable() && editor.isEnabled()) {
            try {
                int start = editor.getSelectionStart();
                int end = editor.getSelectionEnd();
                if (start == end && JavaSmartClipboard.isCutCopyLineEnabled(editor)) {
                    int offset = editor.getCaretPosition();
                    LineMap lineMap = document.getLineMap();
                    int currentLine = lineMap.getLineFromOffset(offset);
                    start = lineMap.getLineStartOffset(currentLine);
                    end = lineMap.getLineEndOffset(currentLine);
                }
                if (start != end) {
                    JavaSmartClipboard.fillClipboard(editor, document, start, end);
                    editor.beginEdit(cutDescriptor);
                    document.remove(start, end - start);
                    editor.endEdit();
                }
            }
            catch (BadLocationException e) {}
        } else {
            toolkit.beep();
        }
    }

    private static SourceElement findDeepestChild(int pos, SourceElement el, boolean isStrict) {
        if (isStrict ? pos < el.getStartOffset() || pos > el.getEndOffset() : pos <= el.getStartOffset() || pos >= el.getEndOffset()) {
            return null;
        }
        SourceElement res = el;
        Iterator it = el.getChildren(196608).iterator();
        while (it.hasNext()) {
            SourceElement rchild = JavaSmartClipboard.findDeepestChild(pos, (SourceElement)it.next(), isStrict);
            if (rchild == null) continue;
            res = rchild;
            break;
        }
        return res;
    }

    private static SourceElement findDeepestChild(int pos, SourceElement el) {
        return JavaSmartClipboard.findDeepestChild(pos, el, false);
    }

    private static boolean isStringLiteral(SourceElement el) {
        SourceLiteralExpression sle;
        return el != null && el.getSymbolKind() == 52 && (sle = (SourceLiteralExpression)el).getTokenValue() == 14;
    }

    private static boolean isInStringLiteral(BasicEditorPane editor, int start, int end, boolean sameString) {
        SourceFile sourceFile = JavaSmartClipboard.getSourceFile(editor);
        if (sourceFile != null) {
            SourceElement elStart = JavaSmartClipboard.findDeepestChild(start, (SourceElement)sourceFile);
            SourceElement elEnd = JavaSmartClipboard.findDeepestChild(end, (SourceElement)sourceFile);
            if (JavaSmartClipboard.isStringLiteral(elStart) && JavaSmartClipboard.isStringLiteral(elEnd)) {
                if (elStart == elEnd) {
                    return true;
                }
                if (!sameString) {
                    SourceExpression sexp;
                    SourceElement parent = elStart.getParent();
                    if (elEnd.getParent() == parent && parent.getSymbolKind() == 50 && (sexp = (SourceExpression)parent).getOperatorCode() == 1) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private static int isInComment(BasicEditorPane editor, int start) {
        SourceElement elStart;
        SourceFile sourceFile = JavaSmartClipboard.getSourceFile(editor);
        int res = 0;
        if (sourceFile != null && (elStart = JavaSmartClipboard.findDeepestChild(start, (SourceElement)sourceFile, true)) != null && elStart.getSymbolKind() == 69) {
            SourceLexicalComment comment = (SourceLexicalComment)elStart;
            switch (comment.getTokenValue()) {
                case 24: {
                    if (start < comment.getStartOffset() + 2) break;
                    res = 1;
                    break;
                }
                case 25: {
                    if (start < comment.getStartOffset() + 2 || start > comment.getEndOffset() - 2) break;
                    res = 2;
                    break;
                }
            }
        }
        return res;
    }

    private static String escapeString(String s, String indent) {
        StringBuffer sb = new StringBuffer(s.length() * 2);
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            switch (c) {
                case '\\': {
                    if (!JavaSmartClipboard.isUnicodeCharacterNext(s.substring(i))) {
                        sb.append("\\\\");
                        break;
                    }
                    sb.append(c);
                    break;
                }
                case '\"': {
                    sb.append("\\\"");
                    break;
                }
                case '\r': {
                    sb.append("\\\r");
                    break;
                }
                case '\n': {
                    sb.append("\\n");
                    if (i == s.length() - 1) break;
                    sb.append("\" + \n");
                    sb.append(indent);
                    sb.append("\"");
                    break;
                }
                default: {
                    sb.append(c);
                }
            }
            ++i;
        }
        return sb.toString();
    }

    private static boolean isUnicodeCharacterNext(String s) {
        if (s.length() < 6) {
            return false;
        }
        if (s.charAt(0) != '\\') {
            return false;
        }
        if (s.charAt(1) != 'u') {
            return false;
        }
        int i = 2;
        while (i < 6) {
            if (!"0123456789abcdefABCDEF".contains("" + s.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static String unEscapeString(String s) {
        boolean inEscape = false;
        StringBuffer sb = new StringBuffer(s.length() * 2);
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (inEscape) {
                switch (c) {
                    case '\\': {
                        sb.append('\\');
                        break;
                    }
                    case '\"': {
                        sb.append('\"');
                        break;
                    }
                    case 'r': {
                        sb.append('\r');
                        break;
                    }
                    case 'n': {
                        sb.append('\n');
                        break;
                    }
                    default: {
                        sb.append('\\');
                        sb.append(c);
                    }
                }
                inEscape = false;
            } else if (c == '\\') {
                inEscape = true;
            } else {
                sb.append(c);
            }
            ++i;
        }
        return sb.toString();
    }

    private static String singleLineComment(String src, String oldIndent, String indent) {
        int oldIdLen = oldIndent.length();
        StringBuffer res = new StringBuffer();
        StringTokenizer st = new StringTokenizer(src, "\n\r", true);
        boolean firstLine = true;
        while (st.hasMoreTokens()) {
            String line = st.nextToken();
            if (line.equals("\n") || line.equals("\r")) {
                res.append(line);
            } else {
                if (!firstLine) {
                    res.append(indent);
                    res.append("// ");
                }
                if (line.startsWith(oldIndent)) {
                    res.append(line.substring(oldIdLen));
                } else {
                    res.append(line.trim());
                }
            }
            firstLine = false;
        }
        return res.toString();
    }

    private static void paste(BasicEditorPane editor, BasicDocument document) {
        int start = editor.getSelectionStart();
        int end = editor.getSelectionEnd();
        Toolkit toolkit = editor.getToolkit();
        if (editor.isEditable() && editor.isEnabled()) {
            Clipboard clipboard = toolkit.getSystemClipboard();
            Transferable transferable = clipboard.getContents(editor);
            if (transferable != null) {
                try {
                    Object data = transferable.getTransferData(DataFlavor.stringFlavor);
                    String stringData = (String)data;
                    int inComment = JavaSmartClipboard.isInComment(editor, start);
                    boolean isInString = JavaSmartClipboard.isEscapeStringEnabled(editor) && JavaSmartClipboard.isInStringLiteral(editor, start, end, false);
                    int nlPos = stringData.indexOf(10);
                    boolean smartIndent = JavaSmartClipboard.isIndentEnabled(editor);
                    if (smartIndent && nlPos == -1) {
                        TextBuffer tb = document.getTextBuffer();
                        int tlen = document.getLength();
                        int cpo = end;
                        while (smartIndent && cpo < tlen) {
                            char c = tb.getChar(cpo);
                            if (c == '\n') break;
                            if (!Character.isSpaceChar(c)) {
                                smartIndent = false;
                            }
                            ++cpo;
                        }
                    }
                    BundleHelper resources = EditorProperties.getEditorBundle();
                    UndoableEditCommand command = new UndoableEditCommand(resources.getString("UNDO_PASTE"), CodeEditor.getContext((BasicEditorPane)editor));
                    TextBuffer textBuffer = document.getTextBuffer();
                    textBuffer.writeLock();
                    try {
                        EditorOptions editorOptions;
                        UndoableEdit edit;
                        String newIndent;
                        if (inComment == 0 && !isInString && JavaSmartClipboard.isImportsEnabled(editor)) {
                            String[] conflictedImports = new String[1];
                            start = JavaSmartClipboard.checkAddImports(editor, document, start, end, transferable, command, conflictedImports);
                            if (conflictedImports[0] != null) {
                                stringData = conflictedImports[0];
                            }
                        }
                        if (smartIndent && (newIndent = SourceFormatUtilities.getSmartIndentation(JavaSmartClipboard.getSourceFile(editor), editor, start)).length() != 0) {
                            String oldIndent = JavaSmartClipboard.getOldIndent(editor, stringData);
                            start = editor.getLineStartOffset(editor.getLineFromOffset(start));
                            stringData = SourceFormatUtilities.reIndent(editor, stringData, oldIndent, newIndent);
                            editor.setSelectionStart(start);
                        }
                        if (inComment == 1) {
                            int startline = editor.getLineStartOffset(editor.getLineFromOffset(start));
                            String res = document.getText(startline, start - startline);
                            int i = 0;
                            while (Character.isSpaceChar(res.charAt(i))) {
                                ++i;
                            }
                            int firstChar = 0;
                            while (firstChar < stringData.length() && stringData.charAt(firstChar) == ' ') {
                                ++firstChar;
                            }
                            String oldIndent = stringData.substring(0, firstChar);
                            stringData = JavaSmartClipboard.singleLineComment(stringData, oldIndent, res.substring(0, i));
                        }
                        if (isInString) {
                            stringData = JavaSmartClipboard.escapeString(stringData, SourceFormatUtilities.getIdentFromOffset(editor, start));
                        }
                        start = editor.getSelectionStart();
                        end = editor.getSelectionEnd();
                        if (end > start && (edit = textBuffer.remove(start, end - start)) != null) {
                            command.addEdit(edit);
                        }
                        if ((edit = textBuffer.insert(start, stringData.toCharArray())) != null) {
                            command.addEdit(edit);
                        }
                        if ((editorOptions = EditorOptions.getInstance((PropertyStorage)Preferences.getPreferences())).getReformatCopyPaste()) {
                            int newEnd = start + stringData.length();
                            JavaManager javaManager = JavaManager.getJavaManager((Project)command.getContext().getProject());
                            SourceFile file = javaManager.getSourceFile(textBuffer);
                            if (file.getErrors(3, 2).size() == 0) {
                                SourceTransaction rtrans = file.beginTransaction();
                                SourceSavepoint rpnt = rtrans.savepoint();
                                try {
                                    Formatting.Selection selection = Formatting.reformatRegion((SourceFile)file, (int)start, (int)newEnd);
                                    if (selection == null) {
                                        throw new Exception();
                                    }
                                    UndoableEdit redit = rtrans.commit();
                                    if (redit == null) {
                                        throw new Exception();
                                    }
                                    command.addEdit(redit);
                                }
                                catch (Exception e) {
                                    Assert.println((String)"Aborting edit transaction for reformatting...");
                                    rtrans.rollback(rpnt);
                                }
                            }
                        }
                    }
                    finally {
                        textBuffer.writeUnlock();
                    }
                    if (command.hasEdits()) {
                        CommandProcessor commandProcessor = CommandProcessor.getInstance();
                        commandProcessor.invoke((Command)command);
                    }
                }
                catch (Exception e) {
                    toolkit.beep();
                }
            }
        } else {
            toolkit.beep();
        }
    }

    private static String getOldIndent(BasicEditorPane editor, String stringData) {
        int lineStart = 0;
        int cpo = 0;
        while (cpo < stringData.length() && (stringData.charAt(cpo) == ' ' || stringData.charAt(cpo) == '\t' || stringData.charAt(cpo) == '\n')) {
            if (stringData.charAt(cpo) == '\n') {
                lineStart = ++cpo;
                continue;
            }
            ++cpo;
        }
        int firstChar = lineStart;
        while (firstChar < stringData.length() && (stringData.charAt(firstChar) == ' ' || stringData.charAt(firstChar) == '\t')) {
            ++firstChar;
        }
        int tabSize = (Integer)editor.getProperty("tab-size");
        String oldIndent = SourceFormatUtilities.tabToSpace(stringData.substring(lineStart, firstChar), tabSize);
        return oldIndent;
    }

    private static int checkAddImports(BasicEditorPane editor, BasicDocument document, int start, int end, Transferable transferable, UndoableEditCommand command, String[] adjustedText) {
        block15: {
            try {
                SourceFile sourceFile;
                RichBuffer rbuff = (RichBuffer)transferable.getTransferData(RichBuffer.FLAVOR);
                String[] needImports = rbuff.getFQClassNames();
                if (needImports.length == 0 || JavaSmartClipboard.isInImportRegion(sourceFile = JavaSmartClipboard.getSourceFile(editor), start)) break block15;
                HashSet toImport = new HashSet();
                HashSet conflictImport = new HashSet();
                RichBuffer.getAddedImports(document, needImports, sourceFile, toImport, conflictImport);
                if (conflictImport.size() != 0) {
                    String[] cimport = conflictImport.toArray(new String[conflictImport.size()]);
                    adjustedText[0] = rbuff.getFqText(cimport);
                }
                if (toImport.size() <= 0) break block15;
                TextBuffer textBuffer = sourceFile.getTextBuffer();
                int regionSize = end - start;
                OffsetMark startPos = textBuffer.addOffsetMark(start);
                OffsetMark endPos = textBuffer.addOffsetMark(end);
                boolean success = false;
                SourceTransaction transaction = sourceFile.beginTransaction();
                try {
                    for (String importString : toImport) {
                        JavaHelper.addImport(sourceFile, importString);
                    }
                    success = true;
                }
                finally {
                    if (success) {
                        UndoableEdit edit = transaction.commit();
                        if (edit != null) {
                            command.addEdit(edit);
                        }
                    } else {
                        transaction.abort();
                    }
                }
                start = startPos.getOffset();
                end = endPos.getOffset();
                textBuffer.removeOffsetMark(startPos);
                textBuffer.removeOffsetMark(endPos);
                List imports = sourceFile.getSourceImports();
                if (imports != null && imports.size() > 0) {
                    int importStartOffset = ((SourceImport)imports.get(0)).getStartOffset();
                    int importEndOffset = ((SourceImport)imports.get(imports.size() - 1)).getEndOffset();
                    if (end >= importStartOffset && end < importEndOffset) {
                        start = importEndOffset + 1;
                        end = start + regionSize;
                    } else if (start >= importStartOffset && start < importEndOffset) {
                        start = end - regionSize;
                    }
                }
                editor.setSelectionStart(start);
                editor.setSelectionEnd(end);
            }
            catch (UnsupportedFlavorException ufe) {
            }
            catch (IOException ie) {
                Assert.printStackTrace((Throwable)ie);
            }
        }
        return start;
    }

    private static boolean isInImportRegion(SourceFile sourceFile, int pos) {
        List imports = sourceFile.getSourceImports();
        if (imports == null || imports.size() == 0) {
            return false;
        }
        SourceImport first = (SourceImport)imports.get(0);
        SourceImport last = (SourceImport)imports.get(imports.size() - 1);
        int start = first.getStartOffset();
        int end = last.getEndOffset();
        return pos >= start && pos < end;
    }

    private static void setClipboardContents(BasicEditorPane editor, Transferable contents) {
        Toolkit toolkit = editor.getToolkit();
        Clipboard clipboard = toolkit.getSystemClipboard();
        ClipboardStack.pushCurrentClipboard();
        int i = 0;
        while (i < 5) {
            try {
                clipboard.setContents(contents, null);
                return;
            }
            catch (IllegalStateException e) {
                try {
                    Thread.sleep(50);
                }
                catch (InterruptedException e2) {
                    // empty catch block
                }
                ++i;
            }
        }
    }

    JavaSmartClipboard() {
    }
}

