/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.editing;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.text.NumberFormat;
import java.util.Hashtable;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.ide.controls.CustomColorChoice;
import oracle.ide.controls.ItemSelectableTracker;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.ApplyListener;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.editor.EditorProperties;
import oracle.jdevimpl.java.JavaArb;
import oracle.jdevimpl.java.editing.JavaUnderlinesOptions;

public final class JavaUnderlinesOptionsPanel
extends DefaultTraversablePanel
implements ApplyListener,
ChangeListener {
    private JCheckBox checkbox_underlineErrors;
    private CustomColorChoice colorChoice_syntaxErrors;
    private JCheckBox checkbox_underlineSemantic;
    private CustomColorChoice colorChoice_semanticErrors;
    private JCheckBox checkbox_classSeparators;
    private CustomColorChoice colorChoice_classSeparators;
    private JCheckBox checkbox_memberSeparators;
    private CustomColorChoice colorChoice_memberSeparators;
    private JCheckBox checkbox_exceptAdjacentFields;
    private JSlider slider_smallFileDelay;
    private JLabel label_smallFileDelayFeedback;
    private JSlider slider_largeFileDelay;
    private JLabel label_largeFileDelayFeedback;
    private NumberFormat numberFormatter;

    public JavaUnderlinesOptionsPanel() {
        this.setHelpID("f1_idedidesetunderlines_html");
        this.setLayout(new GridBagLayout());
        this.initializeComponent();
    }

    public void onEntry(TraversableContext tc) {
        JavaUnderlinesOptions options = this.findOptions(tc);
        this.loadSettingsFrom(options);
    }

    public void onExit(TraversableContext tc) throws TraversalException {
        JavaUnderlinesOptions options = this.findOptions(tc);
        this.saveSettingsTo(options);
    }

    private JavaUnderlinesOptions findOptions(TraversableContext tc) {
        JavaUnderlinesOptions options = (JavaUnderlinesOptions)tc.find("JavaUnderlinesOptions");
        return options;
    }

    public void apply(ApplyEvent event) {
        TraversableContext tc = (TraversableContext)event.getSource();
        JavaUnderlinesOptions options = this.findOptions(tc);
        JavaUnderlinesOptionsPanel.applyOptions(options);
    }

    public void cancel(ApplyEvent e) {
    }

    public static void applyOptions(JavaUnderlinesOptions options) {
        EditorProperties properties = EditorProperties.getProperties();
        int errorColor = options.getSyntaxErrorColor();
        int semanticColor = options.getSemanticErrorColor();
        int classColor = options.getClassSeparatorColor();
        int memberColor = options.getMemberSeparatorColor();
    }

    void loadSettingsFrom(JavaUnderlinesOptions options) {
        boolean showErrors = options.getUnderlineErrors();
        int errorColor = options.getSyntaxErrorColor();
        boolean showSemantic = options.getUnderlineSemantic();
        int semanticColor = options.getSemanticErrorColor();
        boolean showClassSeparators = options.getShowClassSeparators();
        int classColor = options.getClassSeparatorColor();
        boolean showMemberSeparators = options.getShowMemberSeparators();
        int memberColor = options.getMemberSeparatorColor();
        boolean excludeAdjacent = options.getSkipAdjacentFields();
        int smallDelay = options.getSmallFileUpdateDelay();
        int largeDelay = options.getLargeFileUpdateDelay();
        this.checkbox_underlineErrors.setSelected(showErrors);
        this.colorChoice_syntaxErrors.setClosestSelectedColor(new Color(errorColor));
        this.checkbox_underlineSemantic.setSelected(showSemantic);
        this.colorChoice_semanticErrors.setClosestSelectedColor(new Color(semanticColor));
        this.checkbox_classSeparators.setSelected(showClassSeparators);
        this.colorChoice_classSeparators.setClosestSelectedColor(new Color(classColor));
        this.checkbox_memberSeparators.setSelected(showMemberSeparators);
        this.colorChoice_memberSeparators.setClosestSelectedColor(new Color(memberColor));
        this.checkbox_exceptAdjacentFields.setSelected(excludeAdjacent);
        int delay = Math.min(Math.max(smallDelay / 100, 1), 50);
        this.slider_smallFileDelay.setValue(delay);
        delay = Math.min(Math.max(largeDelay / 100, 1), 50);
        this.slider_largeFileDelay.setValue(delay);
    }

    void saveSettingsTo(JavaUnderlinesOptions options) throws TraversalException {
        boolean showErrors = this.checkbox_underlineErrors.isSelected();
        int errorColor = this.colorChoice_syntaxErrors.getSelectedColor().getRGB();
        boolean showSemantic = this.checkbox_underlineSemantic.isSelected();
        int semanticColor = this.colorChoice_semanticErrors.getSelectedColor().getRGB();
        boolean showClassSeparators = this.checkbox_classSeparators.isSelected();
        int classColor = this.colorChoice_classSeparators.getSelectedColor().getRGB();
        boolean showMemberSeparators = this.checkbox_memberSeparators.isSelected();
        int memberColor = this.colorChoice_memberSeparators.getSelectedColor().getRGB();
        boolean excludeAdjacent = this.checkbox_exceptAdjacentFields.isSelected();
        int smallDelay = this.slider_smallFileDelay.getValue() * 100;
        int largeDelay = this.slider_largeFileDelay.getValue() * 100;
        options.setUnderlineErrors(showErrors);
        options.setSyntaxErrorColor(errorColor);
        options.setUnderlineSemantic(showSemantic);
        options.setSemanticErrorColor(semanticColor);
        options.setShowClassSeparators(showClassSeparators);
        options.setClassSeparatorColor(classColor);
        options.setShowMemberSeparators(showMemberSeparators);
        options.setMemberSeparatorColor(memberColor);
        options.setSkipAdjacentFields(excludeAdjacent);
        options.setSmallFileUpdateDelay(smallDelay);
        options.setLargeFileUpdateDelay(largeDelay);
    }

    private void initializeComponent() {
        this.numberFormatter = NumberFormat.getNumberInstance();
        this.numberFormatter.setMinimumFractionDigits(1);
        this.numberFormatter.setMaximumFractionDigits(1);
        String resText = JavaArb.getString(164);
        this.checkbox_underlineErrors = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_underlineErrors, (String)resText);
        resText = JavaArb.getString(351);
        JLabel label_syntaxErrors = new JLabel();
        this.colorChoice_syntaxErrors = new CustomColorChoice();
        ResourceUtils.resLabel((JLabel)label_syntaxErrors, (Component)this.colorChoice_syntaxErrors, (String)resText);
        Component[] dependents = new Component[]{label_syntaxErrors, this.colorChoice_syntaxErrors};
        ItemSelectableTracker tracker = new ItemSelectableTracker((ItemSelectable)this.checkbox_underlineErrors, dependents);
        resText = JavaArb.getString(251);
        this.checkbox_underlineSemantic = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_underlineSemantic, (String)resText);
        resText = JavaArb.getString(331);
        JLabel label_semanticErrors = new JLabel();
        this.colorChoice_semanticErrors = new CustomColorChoice();
        ResourceUtils.resLabel((JLabel)label_semanticErrors, (Component)this.colorChoice_semanticErrors, (String)resText);
        dependents = new Component[]{label_semanticErrors, this.colorChoice_semanticErrors};
        tracker = new ItemSelectableTracker((ItemSelectable)this.checkbox_underlineSemantic, dependents);
        resText = JavaArb.getString(237);
        JLabel label_separatorInfo = new JLabel(resText);
        resText = JavaArb.getString(179);
        this.checkbox_classSeparators = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_classSeparators, (String)resText);
        resText = JavaArb.getString(292);
        JLabel label_classSeparators = new JLabel();
        this.colorChoice_classSeparators = new CustomColorChoice();
        ResourceUtils.resLabel((JLabel)label_classSeparators, (Component)this.colorChoice_classSeparators, (String)resText);
        resText = JavaArb.getString(249);
        this.checkbox_memberSeparators = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_memberSeparators, (String)resText);
        resText = JavaArb.getString(31);
        JLabel label_memberSeparators = new JLabel();
        this.colorChoice_memberSeparators = new CustomColorChoice();
        ResourceUtils.resLabel((JLabel)label_memberSeparators, (Component)this.colorChoice_memberSeparators, (String)resText);
        resText = JavaArb.getString(61);
        this.checkbox_exceptAdjacentFields = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_exceptAdjacentFields, (String)resText);
        dependents = new Component[]{label_classSeparators, this.colorChoice_classSeparators};
        tracker = new ItemSelectableTracker((ItemSelectable)this.checkbox_classSeparators, dependents);
        dependents = new Component[]{label_memberSeparators, this.colorChoice_memberSeparators, this.checkbox_exceptAdjacentFields};
        tracker = new ItemSelectableTracker((ItemSelectable)this.checkbox_memberSeparators, dependents);
        resText = JavaArb.getString(42);
        JLabel label_delayInfo = new JLabel(resText);
        resText = JavaArb.getString(95);
        JLabel label_smallFileDelay = new JLabel();
        this.slider_smallFileDelay = new JSlider(1, 50, 1);
        ResourceUtils.resLabel((JLabel)label_smallFileDelay, (Component)this.slider_smallFileDelay, (String)resText);
        this.label_smallFileDelayFeedback = new JLabel();
        this.slider_smallFileDelay.addChangeListener(this);
        resText = JavaArb.getString(80);
        JLabel label_largeFileDelay = new JLabel();
        this.slider_largeFileDelay = new JSlider(1, 50, 1);
        ResourceUtils.resLabel((JLabel)label_largeFileDelay, (Component)this.slider_largeFileDelay, (String)resText);
        this.label_largeFileDelayFeedback = new JLabel();
        this.slider_largeFileDelay.addChangeListener(this);
        String minValue = this.numberFormatter.format(0.1);
        String maxValue = this.numberFormatter.format(5.0);
        JLabel label_minValue = new JLabel(minValue);
        JLabel label_maxValue = new JLabel(maxValue);
        Hashtable<Integer, JLabel> table_labels = new Hashtable<Integer, JLabel>(5);
        table_labels.put(new Integer(1), label_minValue);
        table_labels.put(new Integer(50), label_maxValue);
        this.slider_largeFileDelay.setLabelTable(table_labels);
        this.slider_largeFileDelay.setPaintLabels(true);
        this.slider_largeFileDelay.setPaintTicks(true);
        this.slider_largeFileDelay.setMajorTickSpacing(10);
        this.slider_largeFileDelay.setMinorTickSpacing(1);
        this.slider_largeFileDelay.setSnapToTicks(true);
        label_minValue = new JLabel(minValue);
        label_maxValue = new JLabel(maxValue);
        table_labels = new Hashtable(5);
        table_labels.put(new Integer(1), label_minValue);
        table_labels.put(new Integer(50), label_maxValue);
        this.slider_smallFileDelay.setLabelTable(table_labels);
        this.slider_smallFileDelay.setPaintLabels(true);
        this.slider_smallFileDelay.setPaintTicks(true);
        this.slider_smallFileDelay.setMajorTickSpacing(10);
        this.slider_smallFileDelay.setMinorTickSpacing(1);
        this.slider_smallFileDelay.setSnapToTicks(true);
        this.slider_smallFileDelay.setValue(10);
        this.slider_largeFileDelay.setValue(10);
        Insets defaultInsets = new Insets(2, 5, 2, 5);
        Insets indentedInsets = new Insets(2, 30, 2, 5);
        Insets doubledInsets = new Insets(2, 55, 2, 5);
        Insets emptyInsets = new Insets(0, 0, 0, 0);
        JPanel panel_error = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 17, 0, defaultInsets, 0, 0);
        panel_error.add((Component)this.checkbox_underlineErrors, constraints);
        constraints = new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, indentedInsets, 0, 0);
        panel_error.add((Component)label_syntaxErrors, constraints);
        constraints = new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, defaultInsets, 0, 0);
        panel_error.add((Component)this.colorChoice_syntaxErrors, constraints);
        constraints = new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 17, 2, emptyInsets, 0, 0);
        panel_error.add(Box.createGlue(), constraints);
        constraints = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, defaultInsets, 0, 0);
        panel_error.add((Component)this.checkbox_underlineSemantic, constraints);
        constraints = new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, indentedInsets, 0, 0);
        panel_error.add((Component)label_semanticErrors, constraints);
        constraints = new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, defaultInsets, 0, 0);
        panel_error.add((Component)this.colorChoice_semanticErrors, constraints);
        JPanel panel_separator = new JPanel(new GridBagLayout());
        constraints = new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 17, 0, defaultInsets, 0, 0);
        panel_separator.add((Component)label_separatorInfo, constraints);
        constraints = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, indentedInsets, 0, 0);
        panel_separator.add((Component)this.checkbox_classSeparators, constraints);
        constraints = new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, indentedInsets, 0, 0);
        panel_separator.add((Component)label_classSeparators, constraints);
        constraints = new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, defaultInsets, 0, 0);
        panel_separator.add((Component)this.colorChoice_classSeparators, constraints);
        constraints = new GridBagConstraints(3, 1, 1, 2, 1.0, 0.0, 17, 0, defaultInsets, 0, 0);
        panel_separator.add(Box.createGlue(), constraints);
        constraints = new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, indentedInsets, 0, 0);
        panel_separator.add((Component)this.checkbox_memberSeparators, constraints);
        constraints = new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, indentedInsets, 0, 0);
        panel_separator.add((Component)label_memberSeparators, constraints);
        constraints = new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 0, defaultInsets, 0, 0);
        panel_separator.add((Component)this.colorChoice_memberSeparators, constraints);
        constraints = new GridBagConstraints(0, 3, 3, 1, 1.0, 0.0, 17, 0, doubledInsets, 0, 0);
        panel_separator.add((Component)this.checkbox_exceptAdjacentFields, constraints);
        JPanel panel_sliders = new JPanel(new GridBagLayout());
        constraints = new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 1, defaultInsets, 0, 0);
        panel_sliders.add((Component)label_delayInfo, constraints);
        constraints = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, indentedInsets, 0, 0);
        panel_sliders.add((Component)label_smallFileDelay, constraints);
        constraints = new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, doubledInsets, 0, 0);
        panel_sliders.add((Component)this.label_smallFileDelayFeedback, constraints);
        constraints = new GridBagConstraints(1, 1, 1, 2, 1.0, 0.0, 17, 2, defaultInsets, 0, 0);
        panel_sliders.add((Component)this.slider_smallFileDelay, constraints);
        constraints = new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, indentedInsets, 0, 0);
        panel_sliders.add((Component)label_largeFileDelay, constraints);
        constraints = new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, doubledInsets, 0, 0);
        panel_sliders.add((Component)this.label_largeFileDelayFeedback, constraints);
        constraints = new GridBagConstraints(1, 3, 1, 2, 1.0, 0.0, 17, 2, defaultInsets, 0, 0);
        panel_sliders.add((Component)this.slider_largeFileDelay, constraints);
        constraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 1, emptyInsets, 0, 0);
        this.add(panel_error, constraints);
        constraints = new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 1, emptyInsets, 0, 0);
        this.add(Box.createVerticalStrut(10), constraints);
        constraints = new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 1, emptyInsets, 0, 0);
        this.add(panel_separator, constraints);
        constraints = new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 1, emptyInsets, 0, 0);
        this.add(Box.createVerticalStrut(10), constraints);
        constraints = new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 17, 1, emptyInsets, 0, 0);
        this.add(panel_sliders, constraints);
        constraints = new GridBagConstraints(0, 5, 1, 1, 1.0, 1.0, 17, 1, emptyInsets, 0, 0);
        this.add(Box.createGlue(), constraints);
    }

    public void stateChanged(ChangeEvent event) {
        JLabel label;
        JSlider slider;
        Object source = event.getSource();
        if (source == this.slider_smallFileDelay) {
            slider = this.slider_smallFileDelay;
            label = this.label_smallFileDelayFeedback;
        } else if (source == this.slider_largeFileDelay) {
            slider = this.slider_largeFileDelay;
            label = this.label_largeFileDelayFeedback;
        } else {
            throw new IllegalStateException("unknown source");
        }
        float value = (float)slider.getValue() / 10.0f;
        String valueStr = JavaArb.format(13, this.numberFormatter.format(value));
        label.setText(valueStr);
        slider.setToolTipText(valueStr);
    }
}

