/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.editing;

import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.util.Arrays;
import java.util.Comparator;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.config.ClientSetting;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.highlight.HighlightLayer;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.parser.java.v2.JavaConstants;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFieldDeclaration;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceMember;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdevimpl.java.JavaArb;
import oracle.jdevimpl.java.JavaParserPlugin;
import oracle.jdevimpl.java.editing.JavaUnderlinesOptions;

public final class JavaUnderlinesPlugin
implements EditorPlugin,
JavaConstants,
JavaParserPlugin.HelperClient {
    private BasicEditorPane editor;
    private HighlightLayer highlightLayer;
    protected static final String PROPERTY_UNDERLINES = "java-underlines";
    protected static final String CLASS_SEPARATOR_STYLE = "java-class-separator-style";
    protected static final String MEMBER_SEPARATOR_STYLE = "java-member-separator-style";
    private static HighlightStyle classStyle;
    private static HighlightStyle memberStyle;
    private static final Comparator MEMBER_SYMBOL_COMPARATOR;

    public void notifyCompileScheduled() {
    }

    public void notifyParseFinished(JavaManager javaManager, SourceFile sourceFile, int changeId, int elapsedDelay) {
    }

    public void notifyCompileFinished(JavaManager javaManager, SourceFile sourceFile, int changeId, int elapsedDelay) {
        this.performHighlights(changeId, sourceFile);
    }

    public void install(BasicEditorPane editor) {
        this.editor = editor;
        JavaParserPlugin.attachHelperClient(editor, this);
    }

    public void deinstall(BasicEditorPane editor) {
        JavaParserPlugin.detachHelperClient(editor, this);
        if (this.highlightLayer != null) {
            editor.destroyHighlightLayer(this.highlightLayer);
            this.highlightLayer = null;
        }
        this.editor = null;
    }

    public void propertyChange(PropertyChangeEvent event) {
        String propertyName = event.getPropertyName();
        if (propertyName.equals("highlight-registry") || propertyName.equals("highlight-changed")) {
            // empty if block
        }
    }

    private TextBuffer getTextBuffer() {
        return this.getDocument().getTextBuffer();
    }

    private BasicDocument getDocument() {
        return (BasicDocument)this.editor.getDocument();
    }

    public static JavaUnderlinesOptions getOptions() {
        ClientSetting settings = ClientSetting.findOrCreate((String)"oracle.jdeveloper");
        JavaUnderlinesOptions options = (JavaUnderlinesOptions)settings.getData("JavaUnderlinesOptions");
        return options;
    }

    private void performHighlights(int changeId, SourceFile sourceFile) {
        TextBuffer textBuffer = this.getTextBuffer();
        textBuffer.readLock();
        try {
            int bufferId = textBuffer.getChangeId();
            if (changeId != bufferId) {
                return;
            }
            this.clearHighlights();
            this.addSeparators(sourceFile);
        }
        finally {
            textBuffer.readUnlock();
        }
    }

    private void clearHighlights() {
        if (this.highlightLayer != null) {
            this.highlightLayer.removeAllHighlights();
        }
    }

    private HighlightLayer getHighlightLayer() {
        if (this.highlightLayer == null) {
            this.highlightLayer = this.editor.createHighlightLayer();
        }
        return this.highlightLayer;
    }

    private void addSeparators(SourceFile sourceFile) {
        boolean useClassSeparators = JavaUnderlinesPlugin.getOptions().getShowClassSeparators();
        boolean useMemberSeparators = JavaUnderlinesPlugin.getOptions().getShowMemberSeparators();
        if (!useClassSeparators && !useMemberSeparators) {
            return;
        }
        if (sourceFile != null) {
            HighlightLayer layer = this.getHighlightLayer();
            SourceClass[] classes = sourceFile.getSourceClasses().toArray(SourceClass.EMPTY_ARRAY);
            int numClasses = classes != null ? classes.length : 0;
            int[] classOffsets = new int[numClasses];
            int i = 0;
            while (i < numClasses) {
                SourceClass classSymbol = classes[i];
                if (useMemberSeparators && classSymbol != null) {
                    this.addSeparators(classSymbol);
                }
                classOffsets[i] = JavaUnderlinesPlugin.getStartOffset((SourceElement)classSymbol);
                ++i;
            }
            if (!useClassSeparators) {
                return;
            }
            Arrays.sort(classOffsets);
            TextBuffer textBuffer = this.getTextBuffer();
            LineMap lineMap = textBuffer.getLineMap();
            boolean isFirst = true;
            int lastOffset = -1;
            int i2 = 0;
            while (i2 < numClasses) {
                if (classOffsets[i2] != -1) {
                    if (isFirst) {
                        isFirst = false;
                    } else if (lastOffset != classOffsets[i2]) {
                        lastOffset = classOffsets[i2];
                        int startOffset = classOffsets[i2];
                        int line = lineMap.getLineFromOffset(startOffset) - 1;
                        if (line > 0) {
                            layer.addLineHighlight(classStyle, line);
                        }
                    }
                }
                ++i2;
            }
        }
    }

    private void addSeparators(SourceClass classSymbol) {
        boolean skipAdjacent = JavaUnderlinesPlugin.getOptions().getSkipAdjacentFields();
        if (classSymbol != null) {
            HighlightLayer layer = this.getHighlightLayer();
            SourceMember[] members = classSymbol.getSourceMembers().toArray(SourceMember.EMPTY_ARRAY);
            int numMembers = members.length;
            int i = 0;
            while (i < numMembers) {
                SourceMember memberSymbol = members[i];
                if (memberSymbol != null && memberSymbol.getSymbolKind() == 3) {
                    this.addSeparators((SourceClass)memberSymbol);
                }
                ++i;
            }
            Arrays.sort(members, MEMBER_SYMBOL_COMPARATOR);
            TextBuffer textBuffer = this.getTextBuffer();
            LineMap lineMap = textBuffer.getLineMap();
            boolean isFirst = true;
            SourceMember lastMember = null;
            int i2 = 0;
            while (i2 < numMembers) {
                int currentOffset;
                SourceMember member = members[i2];
                if (member != null && (currentOffset = JavaUnderlinesPlugin.getStartOffset((SourceElement)member)) != -1) {
                    if (isFirst) {
                        isFirst = false;
                        lastMember = member;
                    } else if (member instanceof SourceFieldDeclaration && lastMember instanceof SourceFieldDeclaration && skipAdjacent) {
                        lastMember = member;
                    } else {
                        int line = lineMap.getLineFromOffset(currentOffset) - 1;
                        if (line > 0) {
                            layer.addLineHighlight(memberStyle, line);
                        }
                        lastMember = member;
                    }
                }
                ++i2;
            }
        }
    }

    private static int getStartOffset(SourceElement symbol) {
        if (symbol != null) {
            return symbol.getStartOffset();
        }
        return -1;
    }

    static {
        MEMBER_SYMBOL_COMPARATOR = new 1();
        JavaUnderlinesPlugin.registerHighlights();
    }

    public static void registerHighlights() {
        String name = JavaArb.getString(45);
        classStyle = CodeEditor.createHighlightStyle((String)CLASS_SEPARATOR_STYLE, (String)name, (int)50, null, null, (int)0, (int)5, (Color)Color.LIGHT_GRAY);
        name = JavaArb.getString(177);
        memberStyle = CodeEditor.createHighlightStyle((String)MEMBER_SEPARATOR_STYLE, (String)name, (int)50, null, null, (int)0, (int)9, (Color)Color.LIGHT_GRAY);
    }

    static int maS$getStartOffset(SourceElement sourceElement) {
        return JavaUnderlinesPlugin.getStartOffset(sourceElement);
    }

    static final class 1
    implements Comparator {
        public int compare(Object o1, Object o2) {
            SourceMember m1 = (SourceMember)o1;
            SourceMember m2 = (SourceMember)o2;
            int offset1 = JavaUnderlinesPlugin.maS$getStartOffset((SourceElement)m1);
            int offset2 = JavaUnderlinesPlugin.maS$getStartOffset((SourceElement)m2);
            return offset1 - offset2;
        }

        public boolean equals(Object obj) {
            return false;
        }
    }
}

