/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.editing;

import java.awt.event.ActionEvent;
import java.net.URL;
import javax.swing.Icon;
import oracle.ide.Context;
import oracle.ide.ceditor.OffsetNavigationPoint;
import oracle.ide.controls.ToggleAction;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.navigation.NavigationManager;
import oracle.ide.navigation.NavigationPoint;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceHasName;
import oracle.javatools.parser.java.v2.model.SourceName;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdevimpl.java.JavaArb;

public class NavigationEntry {
    private NavigationType _navigationType;
    private String _tooltip;
    private Project _project;
    private URL _goToUrl;
    private int _goToOffset;

    NavigationEntry(NavigationType navigationType, URL goToUrl, int goToOffset, String tooltip) {
        this._navigationType = navigationType;
        this._tooltip = tooltip;
        this._goToUrl = goToUrl;
        this._goToOffset = goToOffset;
    }

    public NavigationEntry(NavigationType navigationType, String tooltip, Project project, SourceElement destinationElement) {
        this._navigationType = navigationType;
        this._tooltip = tooltip;
        this._project = project;
        if (destinationElement != null) {
            SourceHasName sourceHasName;
            SourceName nameElement;
            SourceFile owningSourceFile = destinationElement.getOwningSourceFile();
            this._goToUrl = owningSourceFile.getURL();
            this._goToOffset = destinationElement.getStartOffset();
            if (destinationElement instanceof SourceHasName && (nameElement = (sourceHasName = (SourceHasName)destinationElement).getNameElement()) != null) {
                this._goToOffset = nameElement.getStartOffset();
            }
        } else {
            this._goToUrl = null;
            this._goToOffset = -1;
        }
    }

    public NavigationType getNavigationType() {
        return this._navigationType;
    }

    public String getTooltip() {
        return this._tooltip;
    }

    public URL getGoToUrl() {
        return this._goToUrl;
    }

    public int getGoToOffset() {
        return this._goToOffset;
    }

    public String toString() {
        return this._tooltip + " -> " + String.valueOf(this._goToUrl) + ":" + this._goToOffset;
    }

    public Icon getIcon() {
        switch (2.$sm$oracle$jdevimpl$java$editing$NavigationEntry$NavigationType[this._navigationType.ordinal()]) {
            case 1: {
                return JavaArb.getIcon(81);
            }
            case 2: {
                return JavaArb.getIcon(289);
            }
            case 3: {
                return JavaArb.getIcon(81);
            }
            case 4: {
                return JavaArb.getIcon(289);
            }
        }
        return null;
    }

    public void navigate() {
        NavigationManager navigator = NavigationManager.getNavigationManager();
        Node destNode = NodeFactory.find((URL)this._goToUrl);
        if (destNode != null) {
            try {
                Context context = Context.newIdeContext((Node)destNode);
                context.setProject(this._project);
                Project definingProject = JavaManager.getDefiningProject((Context)context, (URL)this._goToUrl);
                if (definingProject != null) {
                    context.setProject(definingProject);
                }
                OffsetNavigationPoint point = new OffsetNavigationPoint(context, this._goToOffset, 0);
                if (navigator != null) {
                    navigator.navigateTo((NavigationPoint)point);
                } else {
                    point.navigate();
                }
            }
            catch (Exception e) {
                FeedbackManager.reportException((Throwable)e);
            }
        }
    }

    public ToggleAction createGotoSourceAction() {
        1 action = new 1(this.getTooltip(), this.getIcon());
        return action;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof NavigationEntry) {
            NavigationEntry that = (NavigationEntry)o;
            if (this._navigationType == that._navigationType && this._tooltip.equals(that._tooltip) && this._goToOffset == that._goToOffset && ModelUtil.areEqual((Object)this._goToUrl, (Object)that._goToUrl)) {
                return true;
            }
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class NavigationType
    extends Enum<NavigationType> {
        private static final /* synthetic */ NavigationType[] $v;
        public static final /* enum */ NavigationType OVERRIDES_METHOD;
        public static final /* enum */ NavigationType EXTENDS_CLASS;
        public static final /* enum */ NavigationType OVERRIDDEN_METHOD;
        public static final /* enum */ NavigationType EXTENDING_CLASS;

        public static NavigationType valueOf(String string) {
            return Enum.valueOf(NavigationType.class, string);
        }

        public static final NavigationType[] values() {
            return (NavigationType[])$v.clone();
        }

        static {
            NavigationType[] navigationTypeArray = new NavigationType[4];
            navigationTypeArray[3] = EXTENDING_CLASS = new NavigationType("EXTENDING_CLASS", 3);
            navigationTypeArray[2] = OVERRIDDEN_METHOD = new NavigationType("OVERRIDDEN_METHOD", 2);
            navigationTypeArray[1] = EXTENDS_CLASS = new NavigationType("EXTENDS_CLASS", 1);
            navigationTypeArray[0] = OVERRIDES_METHOD = new NavigationType("OVERRIDES_METHOD", 0);
            $v = navigationTypeArray;
        }

        private NavigationType(String string2, int n2) {
        }
    }

    final class 1
    extends ToggleAction {
        public void actionPerformed(ActionEvent e) {
            NavigationEntry.this.navigate();
        }

        public 1(String string, Icon icon) {
            super(string, icon);
        }
    }

    static class 2 {
        static final /* synthetic */ int[] $sm$oracle$jdevimpl$java$editing$NavigationEntry$NavigationType;

        static {
            int[] nArray = new int[NavigationType.values().length];
            $sm$oracle$jdevimpl$java$editing$NavigationEntry$NavigationType = nArray;
            try {
                nArray[NavigationType.EXTENDING_CLASS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                2.$sm$oracle$jdevimpl$java$editing$NavigationEntry$NavigationType[NavigationType.EXTENDS_CLASS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                2.$sm$oracle$jdevimpl$java$editing$NavigationEntry$NavigationType[NavigationType.OVERRIDDEN_METHOD.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                2.$sm$oracle$jdevimpl$java$editing$NavigationEntry$NavigationType[NavigationType.OVERRIDES_METHOD.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
        }
    }
}

