/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.explorer;

import java.io.PrintWriter;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import oracle.ide.util.FastStringWriter;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceEnumConstant;
import oracle.javatools.parser.java.v2.model.SourceFieldDeclaration;
import oracle.javatools.parser.java.v2.model.SourceFieldVariable;
import oracle.javatools.parser.java.v2.model.SourceHasModifiers;
import oracle.javatools.parser.java.v2.model.SourceHasName;
import oracle.javatools.parser.java.v2.model.SourceMember;
import oracle.javatools.parser.java.v2.model.SourceMemberVariable;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.jdevimpl.java.JavaArb;
import oracle.jdevimpl.java.explorer.AccessComparator;
import oracle.jdevimpl.java.explorer.ConstructorElement;
import oracle.jdevimpl.java.explorer.ElementTypeComparator;
import oracle.jdevimpl.java.explorer.ExtendsElement;
import oracle.jdevimpl.java.explorer.FieldElement;
import oracle.jdevimpl.java.explorer.FolderElement;
import oracle.jdevimpl.java.explorer.GroupFolder;
import oracle.jdevimpl.java.explorer.ImplementsElement;
import oracle.jdevimpl.java.explorer.JavaCodeElement;
import oracle.jdevimpl.java.explorer.JavaExplorerOptions;
import oracle.jdevimpl.java.explorer.LeafElement;
import oracle.jdevimpl.java.explorer.LeafElementComparator;
import oracle.jdevimpl.java.explorer.MethodElement;
import oracle.jdevimpl.java.explorer.ModifierElement;
import oracle.jdevimpl.java.explorer.PeekProvider;

public class ClassElement
extends ModifierElement
implements PeekProvider {
    private String packageName;
    private int peekStartOffset;
    private int peekEndOffset;

    public ClassElement(SourceClass classSymbol, JavaExplorerOptions options) {
        super((SourceHasModifiers)classSymbol, options);
        this.$init$();
        LeafElement[] childElements = this.buildChildren(classSymbol, options);
        this.setChildren(childElements);
        if (classSymbol.isMemberClass()) {
            int expansionOptions = options.getExpandedFolders();
            boolean expandedByDefault = (expansionOptions & 0x10) != 0;
            this.setExpandedDefault(expandedByDefault);
        } else {
            int modifiers = this.getModifiers();
            boolean isPublic = Modifier.isPublic(modifiers);
            int expansionOptions = options.getExpandedFolders();
            int flag = isPublic ? 4 : 8;
            boolean expandedByDefault = (expansionOptions & flag) != 0;
            this.setExpandedDefault(expandedByDefault);
        }
        this.peekStartOffset = classSymbol.getStartOffset();
        this.peekEndOffset = classSymbol.getEndOffset();
    }

    public String getPackageName() {
        ClassElement outerClass = this.getEnclosingClass();
        if (outerClass != null) {
            return outerClass.getPackageName();
        }
        return this.packageName;
    }

    private void $init$() {
        this.packageName = null;
    }

    protected void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    protected LeafElement[] buildChildren(SourceClass classSymbol, JavaExplorerOptions options) {
        int showOptions = options.getShowFilter();
        boolean showExtendsImplements = ClassElement.isBitSet(showOptions, 8);
        boolean showConstructors = ClassElement.isBitSet(showOptions, 32);
        boolean showMethods = ClassElement.isBitSet(showOptions, 128);
        boolean showFields = ClassElement.isBitSet(showOptions, 64);
        boolean showInnerClasses = ClassElement.isBitSet(showOptions, 256);
        int hideOptions = options.getHideFilter();
        boolean hidePublic = ClassElement.isBitSet(hideOptions, 1);
        boolean hideProtected = ClassElement.isBitSet(hideOptions, 2);
        boolean hidePrivate = ClassElement.isBitSet(hideOptions, 4);
        boolean hidePackage = ClassElement.isBitSet(hideOptions, 8);
        boolean hideFinal = ClassElement.isBitSet(hideOptions, 16);
        boolean hideInstance = ClassElement.isBitSet(hideOptions, 32);
        boolean hideStatic = ClassElement.isBitSet(hideOptions, 64);
        ArrayList<ModifierElement> childList = new ArrayList<ModifierElement>();
        try {
            block11: for (SourceMember memberSymbol : classSymbol.getSourceMembers()) {
                if (memberSymbol == null || memberSymbol instanceof SourceHasName && ClassElement.getName((SourceHasName)memberSymbol).equals("")) continue;
                int modifiers = ClassElement.getModifiers((SourceHasModifiers)memberSymbol);
                if (hidePublic && Modifier.isPublic(modifiers) || hideProtected && Modifier.isProtected(modifiers) || hidePrivate && Modifier.isPrivate(modifiers) || hideFinal && Modifier.isFinal(modifiers) || hideStatic && Modifier.isStatic(modifiers) || hidePackage && !Modifier.isPublic(modifiers) && !Modifier.isProtected(modifiers) && !Modifier.isPrivate(modifiers) || hideInstance && !Modifier.isStatic(modifiers)) continue;
                int memberType = memberSymbol.getSymbolKind();
                try {
                    switch (memberType) {
                        case 6: {
                            if (!showConstructors) continue block11;
                            childList.add(new ConstructorElement((SourceMethod)memberSymbol, options));
                            break;
                        }
                        case 19: {
                            if (!showMethods) continue block11;
                            childList.add(new MethodElement((SourceMethod)memberSymbol, options));
                            break;
                        }
                        case 7: {
                            if (!showFields) continue block11;
                            childList.add(new FieldElement((SourceMemberVariable)((SourceEnumConstant)memberSymbol), options));
                            break;
                        }
                        case 9: {
                            if (!showFields) continue block11;
                            for (SourceFieldVariable variableSymbol : ((SourceFieldDeclaration)memberSymbol).getVariables()) {
                                if (variableSymbol == null || ClassElement.getName((SourceHasName)variableSymbol).equals("")) continue;
                                childList.add(new FieldElement((SourceMemberVariable)variableSymbol, options));
                            }
                            continue block11;
                        }
                        case 3: {
                            if (!showInnerClasses) continue block11;
                            childList.add(new ClassElement((SourceClass)memberSymbol, options));
                            break;
                        }
                    }
                }
                catch (RuntimeException e) {
                    // empty catch block
                }
            }
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        for (Object e : childList) {
            if (!(e instanceof JavaCodeElement)) continue;
            ((JavaCodeElement)e).setEnclosingClass(this);
        }
        Comparator comparatorToUse = ClassElement.getSorter(options);
        if (comparatorToUse != null) {
            Collections.sort(childList, comparatorToUse);
        }
        List groupedList = this.buildGroups(childList, options);
        ArrayList<JavaCodeElement> baseList = new ArrayList<JavaCodeElement>();
        if (showExtendsImplements) {
            if (classSymbol.isClass()) {
                SourceTypeReference baseClass = classSymbol.getSourceSuperclass();
                if (baseClass != null) {
                    ExtendsElement extendsElement = new ExtendsElement(baseClass);
                    extendsElement.setEnclosingClass(this);
                    baseList.add(extendsElement);
                }
                for (SourceTypeReference nameSymbol : classSymbol.getSourceInterfaces()) {
                    if (nameSymbol == null) continue;
                    ImplementsElement implementsElement = new ImplementsElement(nameSymbol);
                    implementsElement.setEnclosingClass(this);
                    baseList.add(implementsElement);
                }
            } else {
                for (SourceTypeReference nameSymbol : classSymbol.getSourceInterfaces()) {
                    if (nameSymbol == null) continue;
                    ExtendsElement extendsElement = new ExtendsElement(nameSymbol);
                    extendsElement.setEnclosingClass(this);
                    baseList.add(extendsElement);
                }
            }
            if (options.getSortOrder() != 0) {
                Collections.sort(baseList, new LeafElementComparator());
            }
        }
        baseList.addAll(groupedList);
        int numChildren = baseList.size();
        return baseList.toArray(new LeafElement[numChildren]);
    }

    private List buildGroups(List childList, JavaExplorerOptions options) {
        return this.buildGroups(childList, options, options.getGroupOrder(), 0);
    }

    private List buildGroups(List childList, JavaExplorerOptions options, int[] groups, int groupIndex) {
        int numGroups;
        int n = numGroups = groups != null ? groups.length : 0;
        if (numGroups == 0 || groupIndex >= numGroups) {
            return childList;
        }
        int group = groups[groupIndex];
        int nextGroupIndex = groupIndex + 1;
        List groupedList = childList;
        switch (group) {
            case 1: {
                groupedList = this.buildStaticInstanceGroups(childList, options);
                break;
            }
            case 2: {
                groupedList = this.buildTypeGroups(childList, options);
                break;
            }
            case 3: {
                groupedList = this.buildAccessGroups(childList, options);
                break;
            }
            default: {
                return this.buildGroups(childList, options, groups, nextGroupIndex);
            }
        }
        int numChildGroups = groupedList.size();
        int i = 0;
        while (i < numChildGroups) {
            FolderElement childGroup = (FolderElement)groupedList.get(i);
            LeafElement[] children = childGroup.getChildrenArray();
            List<LeafElement> childrenList = Arrays.asList(children);
            List groupedChildrenList = this.buildGroups(childrenList, options, groups, nextGroupIndex);
            int numGroupedChildren = groupedChildrenList.size();
            LeafElement[] newChildren = groupedChildrenList.toArray(new LeafElement[numGroupedChildren]);
            childGroup.setChildren(newChildren);
            ++i;
        }
        return groupedList;
    }

    private List buildStaticInstanceGroups(List childList, JavaExplorerOptions options) {
        ArrayList<ModifierElement> staticList = new ArrayList<ModifierElement>();
        ArrayList<ModifierElement> instanceList = new ArrayList<ModifierElement>();
        int numChildren = childList.size();
        int i = 0;
        while (i < numChildren) {
            ModifierElement child = (ModifierElement)childList.get(i);
            int modifiers = child.getModifiers();
            if (Modifier.isStatic(modifiers)) {
                staticList.add(child);
            } else {
                instanceList.add(child);
            }
            ++i;
        }
        GroupFolder staticGroup = this.buildGroupFolder(243, staticList, options, 1);
        GroupFolder instanceGroup = this.buildGroupFolder(34, instanceList, options, 2);
        staticList.clear();
        this.addIfNotNull(instanceGroup, staticList);
        this.addIfNotNull(staticGroup, staticList);
        return staticList;
    }

    private List buildTypeGroups(List childList, JavaExplorerOptions options) {
        ArrayList<ModifierElement> constructorList = new ArrayList<ModifierElement>();
        ArrayList<ModifierElement> methodList = new ArrayList<ModifierElement>();
        ArrayList<ModifierElement> fieldList = new ArrayList<ModifierElement>();
        ArrayList<ModifierElement> classList = new ArrayList<ModifierElement>();
        int numChildren = childList.size();
        int i = 0;
        while (i < numChildren) {
            ModifierElement child = (ModifierElement)childList.get(i);
            if (child instanceof ConstructorElement) {
                constructorList.add(child);
            } else if (child instanceof MethodElement) {
                methodList.add(child);
            } else if (child instanceof FieldElement) {
                fieldList.add(child);
            } else if (child instanceof ClassElement) {
                classList.add(child);
            }
            ++i;
        }
        GroupFolder constructorGroup = this.buildGroupFolder(182, constructorList, options, 256);
        GroupFolder methodGroup = this.buildGroupFolder(82, methodList, options, 512);
        GroupFolder fieldGroup = this.buildGroupFolder(66, fieldList, options, 1024);
        GroupFolder classGroup = this.buildGroupFolder(73, classList, options, 2048);
        constructorList.clear();
        this.addIfNotNull(constructorGroup, constructorList);
        this.addIfNotNull(methodGroup, constructorList);
        this.addIfNotNull(fieldGroup, constructorList);
        this.addIfNotNull(classGroup, constructorList);
        return constructorList;
    }

    private List buildAccessGroups(List childList, JavaExplorerOptions options) {
        ArrayList<ModifierElement> publicList = new ArrayList<ModifierElement>();
        ArrayList<ModifierElement> protectedList = new ArrayList<ModifierElement>();
        ArrayList<ModifierElement> privateList = new ArrayList<ModifierElement>();
        ArrayList<ModifierElement> packageList = new ArrayList<ModifierElement>();
        int numChildren = childList.size();
        int i = 0;
        while (i < numChildren) {
            ModifierElement child = (ModifierElement)childList.get(i);
            int modifiers = child.getModifiers();
            if (Modifier.isPublic(modifiers)) {
                publicList.add(child);
            } else if (Modifier.isProtected(modifiers)) {
                protectedList.add(child);
            } else if (Modifier.isPrivate(modifiers)) {
                privateList.add(child);
            } else {
                packageList.add(child);
            }
            ++i;
        }
        GroupFolder publicGroup = this.buildGroupFolder(262, publicList, options, 16);
        GroupFolder protectedGroup = this.buildGroupFolder(223, protectedList, options, 32);
        GroupFolder privateGroup = this.buildGroupFolder(62, privateList, options, 64);
        GroupFolder packageGroup = this.buildGroupFolder(195, packageList, options, 128);
        packageList.clear();
        this.addIfNotNull(publicGroup, packageList);
        this.addIfNotNull(protectedGroup, packageList);
        this.addIfNotNull(packageGroup, packageList);
        this.addIfNotNull(privateGroup, packageList);
        return packageList;
    }

    private void addIfNotNull(Object object, List list) {
        if (object != null) {
            list.add(object);
        }
    }

    private GroupFolder buildGroupFolder(int nameIndex, List childList, JavaExplorerOptions options, int groupFlag) {
        int numChildren = childList.size();
        if (numChildren == 0) {
            return null;
        }
        LeafElement[] children = childList.toArray(new LeafElement[numChildren]);
        boolean expandedDefault = ClassElement.isBitSet(options.getExpandedGroups(), groupFlag);
        String name = JavaArb.getString(nameIndex);
        GroupFolder folder = new GroupFolder(name, name, null, children, expandedDefault);
        return folder;
    }

    private static Comparator getSorter(JavaExplorerOptions options) {
        int sortOrder = options.getSortOrder();
        switch (sortOrder) {
            case 0: {
                return null;
            }
            case 1: {
                return new LeafElementComparator();
            }
            case 3: {
                return new AccessComparator();
            }
        }
        return new ElementTypeComparator();
    }

    protected String getDisplayText(SourceElement symbol) {
        FastStringWriter buffer = ClassElement.allocFastStringBuffer();
        symbol.print((PrintWriter)buffer, 1);
        String result = buffer.toString();
        ClassElement.freeFastStringBuffer(buffer);
        return result;
    }

    protected String getTooltipText(SourceElement symbol) {
        FastStringWriter buffer = ClassElement.allocFastStringBuffer();
        symbol.print((PrintWriter)buffer, 2);
        String result = buffer.toString();
        ClassElement.freeFastStringBuffer(buffer);
        return result;
    }

    protected Icon getIcon(SourceElement symbol) {
        SourceClass classSymbol = (SourceClass)symbol;
        return OracleIcons.getIcon((String)(classSymbol.isClass() ? "class.png" : "interface.png"));
    }

    public boolean mayHaveChildren() {
        return true;
    }

    public int getPeekStartOffset() {
        return this.peekStartOffset;
    }

    public int getPeekEndOffset() {
        return this.peekEndOffset;
    }
}

